/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.CompositeEngineExecutionListener;
import org.junit.platform.launcher.core.CompositeTestExecutionListener;
import org.junit.platform.launcher.listeners.discovery.LauncherDiscoveryListeners;
import org.junit.platform.launcher.listeners.session.LauncherSessionListeners;

class ListenerRegistry<T> {
    private final Function<List<T>, T> compositeListenerFactory;
    private final ArrayList<T> listeners = new ArrayList();

    static ListenerRegistry<LauncherSessionListener> forLauncherSessionListeners() {
        return ListenerRegistry.create(LauncherSessionListeners::composite);
    }

    static ListenerRegistry<LauncherDiscoveryListener> forLauncherDiscoveryListeners() {
        return ListenerRegistry.create(LauncherDiscoveryListeners::composite);
    }

    static ListenerRegistry<TestExecutionListener> forTestExecutionListeners() {
        return ListenerRegistry.create(CompositeTestExecutionListener::new);
    }

    static ListenerRegistry<EngineExecutionListener> forEngineExecutionListeners() {
        return ListenerRegistry.create(CompositeEngineExecutionListener::new);
    }

    static <T> ListenerRegistry<T> create(Function<List<T>, T> compositeListenerFactory) {
        return new ListenerRegistry<T>(compositeListenerFactory);
    }

    static <T> ListenerRegistry<T> copyOf(ListenerRegistry<T> source2) {
        ListenerRegistry<T> registry = new ListenerRegistry<T>(source2.compositeListenerFactory);
        if (!source2.listeners.isEmpty()) {
            registry.addAll((Collection<T>)source2.listeners);
        }
        return registry;
    }

    private ListenerRegistry(Function<List<T>, T> compositeListenerFactory) {
        this.compositeListenerFactory = compositeListenerFactory;
    }

    ListenerRegistry<T> add(T listener) {
        Preconditions.notNull(listener, "listener must not be null");
        this.listeners.add(listener);
        return this;
    }

    @SafeVarargs
    final ListenerRegistry<T> addAll(T ... listeners) {
        Preconditions.notEmpty(listeners, "listeners array must not be null or empty");
        return this.addAll((Collection<? extends T>)Arrays.asList(listeners));
    }

    ListenerRegistry<T> addAll(Collection<? extends T> listeners) {
        Preconditions.notEmpty(listeners, "listeners collection must not be null or empty");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.listeners.addAll(listeners);
        return this;
    }

    T getCompositeListener() {
        this.listeners.trimToSize();
        return this.compositeListenerFactory.apply(this.listeners);
    }

    List<T> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

