/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ServiceLoaderUtils;

class ServiceLoaderRegistry {
    ServiceLoaderRegistry() {
    }

    static <T> Iterable<T> load(Class<T> type2) {
        return ServiceLoaderRegistry.load(type2, __ -> true, instances -> ServiceLoaderRegistry.logLoadedInstances(type2, instances, null));
    }

    static <T> Iterable<T> load(Class<T> type2, Predicate<String> classNameFilter) {
        ArrayList exclusions = new ArrayList();
        Predicate<String> collectingClassNameFilter = className -> {
            boolean included = classNameFilter.test((String)className);
            if (!included) {
                exclusions.add(className);
            }
            return included;
        };
        return ServiceLoaderRegistry.load(type2, collectingClassNameFilter, instances -> ServiceLoaderRegistry.logLoadedInstances(type2, instances, exclusions));
    }

    private static <T> String logLoadedInstances(Class<T> type2, List<T> instances, List<String> exclusions) {
        String typeName2 = type2.getSimpleName();
        if (exclusions == null) {
            return String.format("Loaded %s instances: %s", typeName2, instances);
        }
        return String.format("Loaded %s instances: %s (excluded classes: %s)", typeName2, instances, exclusions);
    }

    private static <T> List<T> load(Class<T> type2, Predicate<String> classNameFilter, Function<List<T>, String> logMessageSupplier) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type2, ClassLoaderUtils.getDefaultClassLoader());
        Predicate<Class> providerPredicate = clazz -> classNameFilter.test(clazz.getName());
        List instances = ServiceLoaderUtils.filter(serviceLoader, providerPredicate).collect(Collectors.toList());
        ServiceLoaderRegistry.getLogger().config(() -> (String)logMessageSupplier.apply(instances));
        return instances;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ServiceLoaderRegistry.class);
    }
}

