/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherInterceptor;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.DefaultLauncherSession;
import org.junit.platform.launcher.core.LauncherListenerRegistry;

class SessionPerRequestLauncher
implements Launcher {
    private final LauncherListenerRegistry listenerRegistry = new LauncherListenerRegistry();
    private final Function<NamespacedHierarchicalStore<Namespace>, Launcher> launcherFactory;
    private final Supplier<LauncherSessionListener> sessionListenerSupplier;
    private final Supplier<List<LauncherInterceptor>> interceptorFactory;

    SessionPerRequestLauncher(Function<NamespacedHierarchicalStore<Namespace>, Launcher> launcherFactory, Supplier<LauncherSessionListener> sessionListenerSupplier, Supplier<List<LauncherInterceptor>> interceptorFactory) {
        this.launcherFactory = launcherFactory;
        this.sessionListenerSupplier = sessionListenerSupplier;
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
        this.listenerRegistry.launcherDiscoveryListeners.addAll((LauncherDiscoveryListener[])listeners);
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        this.listenerRegistry.testExecutionListeners.addAll((TestExecutionListener[])listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest launcherDiscoveryRequest) {
        try (LauncherSession session2 = this.createSession();){
            TestPlan testPlan = session2.getLauncher().discover(launcherDiscoveryRequest);
            return testPlan;
        }
    }

    @Override
    public void execute(LauncherDiscoveryRequest launcherDiscoveryRequest, TestExecutionListener ... listeners) {
        try (LauncherSession session2 = this.createSession();){
            session2.getLauncher().execute(launcherDiscoveryRequest, listeners);
        }
    }

    @Override
    public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
        try (LauncherSession session2 = this.createSession();){
            session2.getLauncher().execute(testPlan, listeners);
        }
    }

    private LauncherSession createSession() {
        DefaultLauncherSession session2 = new DefaultLauncherSession(this.interceptorFactory.get(), this.sessionListenerSupplier, this.launcherFactory);
        Launcher launcher = session2.getLauncher();
        this.listenerRegistry.launcherDiscoveryListeners.getListeners().forEach(xva$0 -> launcher.registerLauncherDiscoveryListeners((LauncherDiscoveryListener)xva$0));
        this.listenerRegistry.testExecutionListeners.getListeners().forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        return session2;
    }
}

