/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.core.DelegatingEngineExecutionListener;

class StackTracePruningEngineExecutionListener
extends DelegatingEngineExecutionListener {
    StackTracePruningEngineExecutionListener(EngineExecutionListener delegate) {
        super(delegate);
    }

    @Override
    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        List<String> testClassNames = StackTracePruningEngineExecutionListener.getTestClassNames(testDescriptor);
        if (testExecutionResult.getThrowable().isPresent()) {
            Throwable throwable = testExecutionResult.getThrowable().get();
            ExceptionUtils.findNestedThrowables(throwable).forEach(t2 -> ExceptionUtils.pruneStackTrace(t2, testClassNames));
        }
        super.executionFinished(testDescriptor, testExecutionResult);
    }

    private static List<String> getTestClassNames(TestDescriptor testDescriptor) {
        return testDescriptor.getAncestors().stream().map(TestDescriptor::getSource).filter(Optional::isPresent).map(Optional::get).map(source2 -> {
            if (source2 instanceof ClassSource) {
                return ((ClassSource)source2).getClassName();
            }
            if (source2 instanceof MethodSource) {
                return ((MethodSource)source2).getClassName();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

