/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;

class StreamInterceptor
extends PrintStream {
    private final Deque<RewindableByteArrayOutputStream> mostRecentOutputs = new ConcurrentLinkedDeque<RewindableByteArrayOutputStream>();
    private final PrintStream originalStream;
    private final Consumer<PrintStream> unregisterAction;
    private final int maxNumberOfBytesPerThread;
    private final ThreadLocal<RewindableByteArrayOutputStream> output = ThreadLocal.withInitial(RewindableByteArrayOutputStream::new);

    static Optional<StreamInterceptor> registerStdout(int maxNumberOfBytesPerThread) {
        return StreamInterceptor.register(System.out, System::setOut, maxNumberOfBytesPerThread);
    }

    static Optional<StreamInterceptor> registerStderr(int maxNumberOfBytesPerThread) {
        return StreamInterceptor.register(System.err, System::setErr, maxNumberOfBytesPerThread);
    }

    static Optional<StreamInterceptor> register(PrintStream originalStream, Consumer<PrintStream> streamSetter, int maxNumberOfBytesPerThread) {
        if (originalStream instanceof StreamInterceptor) {
            return Optional.empty();
        }
        StreamInterceptor interceptor = new StreamInterceptor(originalStream, streamSetter, maxNumberOfBytesPerThread);
        streamSetter.accept(interceptor);
        return Optional.of(interceptor);
    }

    private StreamInterceptor(PrintStream originalStream, Consumer<PrintStream> unregisterAction, int maxNumberOfBytesPerThread) {
        super(originalStream);
        this.originalStream = originalStream;
        this.unregisterAction = unregisterAction;
        this.maxNumberOfBytesPerThread = maxNumberOfBytesPerThread;
    }

    void capture() {
        RewindableByteArrayOutputStream out2 = this.output.get();
        out2.mark();
        this.pushToTop(out2);
    }

    String consume() {
        RewindableByteArrayOutputStream out2 = this.output.get();
        String result2 = out2.rewind();
        if (!out2.isMarked()) {
            this.mostRecentOutputs.remove(out2);
        }
        return result2;
    }

    void unregister() {
        this.unregisterAction.accept(this.originalStream);
    }

    @Override
    public void write(int b2) {
        RewindableByteArrayOutputStream out2 = this.getOutput();
        if (out2 != null && out2.size() < this.maxNumberOfBytesPerThread) {
            this.pushToTop(out2);
            out2.write(b2);
        }
        super.write(b2);
    }

    @Override
    public void write(byte[] b2) {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] buf, int off, int len2) {
        int actualLength;
        RewindableByteArrayOutputStream out2 = this.getOutput();
        if (out2 != null && (actualLength = Math.max(0, Math.min(len2, this.maxNumberOfBytesPerThread - out2.size()))) > 0) {
            this.pushToTop(out2);
            out2.write(buf, off, actualLength);
        }
        super.write(buf, off, len2);
    }

    private void pushToTop(RewindableByteArrayOutputStream out2) {
        if (!out2.equals(this.mostRecentOutputs.peek())) {
            this.mostRecentOutputs.remove(out2);
            this.mostRecentOutputs.push(out2);
        }
    }

    private RewindableByteArrayOutputStream getOutput() {
        RewindableByteArrayOutputStream out2 = this.output.get();
        return out2.isMarked() ? out2 : this.mostRecentOutputs.peek();
    }

    static class RewindableByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final Deque<Integer> markedPositions = new ArrayDeque<Integer>();

        RewindableByteArrayOutputStream() {
        }

        boolean isMarked() {
            return !this.markedPositions.isEmpty();
        }

        void mark() {
            this.markedPositions.addFirst(this.count);
        }

        String rewind() {
            Integer position = this.markedPositions.pollFirst();
            if (position == null || position == this.count) {
                return "";
            }
            int length = this.count - position;
            this.count -= length;
            return new String(this.buf, (int)position, length);
        }
    }
}

