/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.TestEngine;

class TestEngineFormatter {
    private TestEngineFormatter() {
    }

    static String format(String title, Iterable<TestEngine> testEngines) {
        return TestEngineFormatter.format(title, CollectionUtils.toStream(testEngines));
    }

    private static String format(String title, Stream<TestEngine> testEngines) {
        String details = testEngines.map(engine2 -> String.format("- %s (%s)", engine2.getId(), String.join((CharSequence)", ", TestEngineFormatter.computeAttributes(engine2)))).collect(Collectors.joining("\n"));
        return title + ":" + (details.isEmpty() ? " <none>" : "\n" + details);
    }

    private static List<String> computeAttributes(TestEngine engine2) {
        ArrayList<String> attributes2 = new ArrayList<String>(4);
        engine2.getGroupId().ifPresent(groupId -> attributes2.add("group ID: " + groupId));
        engine2.getArtifactId().ifPresent(artifactId -> attributes2.add("artifact ID: " + artifactId));
        engine2.getVersion().ifPresent(version2 -> attributes2.add("version: " + version2));
        ClassLoaderUtils.getLocation(engine2).ifPresent(location -> attributes2.add("location: " + location));
        return attributes2;
    }
}

