/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@API(status=API.Status.MAINTAINED, since="1.0")
public class LoggingListener
implements TestExecutionListener {
    private final BiConsumer<Throwable, Supplier<String>> logger;

    public static LoggingListener forJavaUtilLogging() {
        return LoggingListener.forJavaUtilLogging(Level.FINE);
    }

    public static LoggingListener forJavaUtilLogging(Level logLevel) {
        Preconditions.notNull(logLevel, "logLevel must not be null");
        Logger logger = Logger.getLogger(LoggingListener.class.getName());
        return new LoggingListener((t2, messageSupplier) -> logger.log(logLevel, (Throwable)t2, (Supplier<String>)messageSupplier));
    }

    public static LoggingListener forBiConsumer(BiConsumer<Throwable, Supplier<String>> logger) {
        return new LoggingListener(logger);
    }

    private LoggingListener(BiConsumer<Throwable, Supplier<String>> logger) {
        this.logger = Preconditions.notNull(logger, "logger must not be null");
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.log("TestPlan Execution Started: %s", testPlan);
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.log("TestPlan Execution Finished: %s", testPlan);
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.log("Dynamic Test Registered: %s - %s", testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        this.log("Execution Started: %s - %s", testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.log("Execution Skipped: %s - %s - %s", testIdentifier.getDisplayName(), testIdentifier.getUniqueId(), reason);
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.logWithThrowable("Execution Finished: %s - %s - %s", testExecutionResult.getThrowable().orElse(null), testIdentifier.getDisplayName(), testIdentifier.getUniqueId(), testExecutionResult);
    }

    private void log(String message, Object ... args2) {
        this.logWithThrowable(message, null, args2);
    }

    private void logWithThrowable(String message, Throwable t2, Object ... args2) {
        this.logger.accept(t2, () -> String.format(message, args2));
    }
}

