/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.tagexpression;

import java.util.function.Supplier;
import org.junit.platform.launcher.tagexpression.TagExpression;
import org.junit.platform.launcher.tagexpression.Token;
import org.junit.platform.launcher.tagexpression.TokenWith;

class ParseStatus {
    final String errorMessage;

    static ParseStatus success() {
        return ParseStatus.error(null);
    }

    static ParseStatus problemParsing(Token token2, String representation) {
        return ParseStatus.errorAt(token2, representation, "problem parsing");
    }

    static ParseStatus missingOpeningParenthesis(Token token2, String representation) {
        return ParseStatus.errorAt(token2, representation, "missing opening parenthesis");
    }

    static ParseStatus missingClosingParenthesis(Token token2, String representation) {
        return ParseStatus.errorAt(token2, representation, "missing closing parenthesis");
    }

    static ParseStatus missingRhsOperand(Token token2, String representation) {
        return ParseStatus.errorAt(token2, representation, "missing rhs operand");
    }

    static ParseStatus errorAt(Token token2, String operatorRepresentation, String message) {
        return ParseStatus.error(message + " for '" + operatorRepresentation + "' at index " + ParseStatus.format(token2.trimmedTokenStartIndex()));
    }

    static ParseStatus missingOperatorBetween(TokenWith<TagExpression> lhs, TokenWith<TagExpression> rhs) {
        String lhsString = "'" + ((TagExpression)lhs.element).toString() + "' at index " + ParseStatus.format(lhs.token.lastCharacterIndex());
        String rhsString = "'" + ((TagExpression)rhs.element).toString() + "' at index " + ParseStatus.format(rhs.token.trimmedTokenStartIndex());
        return ParseStatus.error("missing operator between " + lhsString + " and " + rhsString);
    }

    static ParseStatus emptyTagExpression() {
        return ParseStatus.error("empty tag expression");
    }

    private static String format(int indexInTagExpression) {
        return "<" + indexInTagExpression + ">";
    }

    private static ParseStatus error(String errorMessage) {
        return new ParseStatus(errorMessage);
    }

    private ParseStatus(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ParseStatus process(Supplier<ParseStatus> step) {
        if (this.isSuccess()) {
            return step.get();
        }
        return this;
    }

    public boolean isError() {
        return !this.isSuccess();
    }

    private boolean isSuccess() {
        return this.errorMessage == null;
    }
}

