/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.tagexpression;

import java.util.List;
import org.junit.platform.launcher.tagexpression.DequeStack;
import org.junit.platform.launcher.tagexpression.Operator;
import org.junit.platform.launcher.tagexpression.Operators;
import org.junit.platform.launcher.tagexpression.ParseResult;
import org.junit.platform.launcher.tagexpression.ParseResults;
import org.junit.platform.launcher.tagexpression.ParseStatus;
import org.junit.platform.launcher.tagexpression.Stack;
import org.junit.platform.launcher.tagexpression.TagExpression;
import org.junit.platform.launcher.tagexpression.TagExpressions;
import org.junit.platform.launcher.tagexpression.Token;
import org.junit.platform.launcher.tagexpression.TokenWith;

class ShuntingYard {
    private static final Operator RightParenthesis = Operator.nullaryOperator(")", -1);
    private static final Operator LeftParenthesis = Operator.nullaryOperator("(", -2);
    private static final Operator Sentinel = Operator.nullaryOperator("sentinel", Integer.MIN_VALUE);
    private static final Token SentinelToken = new Token(-1, "");
    private final Operators validOperators = new Operators();
    private final Stack<TokenWith<TagExpression>> expressions = new DequeStack<TokenWith<TagExpression>>();
    private final Stack<TokenWith<Operator>> operators = new DequeStack<TokenWith<Operator>>();
    private final List<Token> tokens;

    ShuntingYard(List<Token> tokens) {
        this.tokens = tokens;
        this.pushOperatorAt(SentinelToken, Sentinel);
    }

    public ParseResult execute() {
        ParseStatus parseStatus = this.processTokens().process(this::consumeRemainingOperators).process(this::ensureOnlySingleExpressionRemains);
        if (parseStatus.isError()) {
            return ParseResults.error(parseStatus.errorMessage);
        }
        return ParseResults.success((TagExpression)this.expressions.pop().element);
    }

    private ParseStatus processTokens() {
        ParseStatus parseStatus = ParseStatus.success();
        for (Token token2 : this.tokens) {
            parseStatus = parseStatus.process(() -> this.process(token2));
        }
        return parseStatus;
    }

    private ParseStatus process(Token token2) {
        String trimmed = token2.string();
        if (LeftParenthesis.represents(trimmed)) {
            this.pushOperatorAt(token2, LeftParenthesis);
            return ParseStatus.success();
        }
        if (RightParenthesis.represents(trimmed)) {
            return this.findMatchingLeftParenthesis(token2);
        }
        if (this.validOperators.isOperator(trimmed)) {
            Operator operator = this.validOperators.operatorFor(trimmed);
            return this.findOperands(token2, operator);
        }
        this.pushExpressionAt(token2, this.convertLeafTokenToExpression(trimmed));
        return ParseStatus.success();
    }

    private TagExpression convertLeafTokenToExpression(String trimmed) {
        if ("any()".equalsIgnoreCase(trimmed)) {
            return TagExpressions.any();
        }
        if ("none()".equalsIgnoreCase(trimmed)) {
            return TagExpressions.none();
        }
        return TagExpressions.tag(trimmed);
    }

    private ParseStatus findMatchingLeftParenthesis(Token token2) {
        while (!this.operators.isEmpty()) {
            TokenWith<Operator> tokenWithWithOperator = this.operators.pop();
            Operator operator = (Operator)tokenWithWithOperator.element;
            if (LeftParenthesis.equals(operator)) {
                return ParseStatus.success();
            }
            ParseStatus parseStatus = operator.createAndAddExpressionTo(this.expressions, tokenWithWithOperator.token);
            if (!parseStatus.isError()) continue;
            return parseStatus;
        }
        return ParseStatus.missingOpeningParenthesis(token2, RightParenthesis.representation());
    }

    private ParseStatus findOperands(Token token2, Operator currentOperator) {
        while (currentOperator.hasLowerPrecedenceThan(this.previousOperator()) || currentOperator.hasSamePrecedenceAs(this.previousOperator()) && currentOperator.isLeftAssociative()) {
            TokenWith<Operator> tokenWithWithOperator = this.operators.pop();
            ParseStatus parseStatus = ((Operator)tokenWithWithOperator.element).createAndAddExpressionTo(this.expressions, tokenWithWithOperator.token);
            if (!parseStatus.isError()) continue;
            return parseStatus;
        }
        this.pushOperatorAt(token2, currentOperator);
        return ParseStatus.success();
    }

    private Operator previousOperator() {
        return (Operator)this.operators.peek().element;
    }

    private void pushExpressionAt(Token token2, TagExpression tagExpression) {
        this.expressions.push(new TokenWith<TagExpression>(token2, tagExpression));
    }

    private void pushOperatorAt(Token token2, Operator operator) {
        this.operators.push(new TokenWith<Operator>(token2, operator));
    }

    private ParseStatus consumeRemainingOperators() {
        while (!this.operators.isEmpty()) {
            TokenWith<Operator> tokenWithWithOperator = this.operators.pop();
            Operator operator = (Operator)tokenWithWithOperator.element;
            if (LeftParenthesis.equals(operator)) {
                return ParseStatus.missingClosingParenthesis(tokenWithWithOperator.token, operator.representation());
            }
            ParseStatus parseStatus = operator.createAndAddExpressionTo(this.expressions, tokenWithWithOperator.token);
            if (!parseStatus.isError()) continue;
            return parseStatus;
        }
        return ParseStatus.success();
    }

    private ParseStatus ensureOnlySingleExpressionRemains() {
        if (this.expressions.size() == 1) {
            return ParseStatus.success();
        }
        if (this.expressions.isEmpty()) {
            return ParseStatus.emptyTagExpression();
        }
        TokenWith<TagExpression> rhs = this.expressions.pop();
        TokenWith<TagExpression> lhs = this.expressions.pop();
        return ParseStatus.missingOperatorBetween(lhs, rhs);
    }
}

