/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.lang.ref.WeakReference;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Metatable;

public class WeakTable
implements Metatable {
    private boolean weakkeys;
    private boolean weakvalues;
    private LuaValue backing;

    public static LuaTable make(boolean bl, boolean bl2) {
        LuaString luaString;
        if (bl && bl2) {
            luaString = LuaString.valueOf("kv");
        } else if (bl) {
            luaString = LuaString.valueOf("k");
        } else if (bl2) {
            luaString = LuaString.valueOf("v");
        } else {
            return LuaTable.tableOf();
        }
        LuaTable luaTable = LuaTable.tableOf();
        LuaTable luaTable2 = LuaTable.tableOf(new LuaValue[]{LuaValue.MODE, luaString});
        luaTable.setmetatable(luaTable2);
        return luaTable;
    }

    public WeakTable(boolean bl, boolean bl2, LuaValue luaValue) {
        this.weakkeys = bl;
        this.weakvalues = bl2;
        this.backing = luaValue;
    }

    public boolean useWeakKeys() {
        return this.weakkeys;
    }

    public boolean useWeakValues() {
        return this.weakvalues;
    }

    public LuaValue toLuaValue() {
        return this.backing;
    }

    public LuaTable.Slot entry(LuaValue luaValue, LuaValue luaValue2) {
        if ((luaValue2 = luaValue2.strongvalue()) == null) {
            return null;
        }
        if (this.weakkeys && !luaValue.isnumber() && !luaValue.isstring() && !luaValue.isboolean()) {
            if (this.weakvalues && !luaValue2.isnumber() && !luaValue2.isstring() && !luaValue2.isboolean()) {
                return new WeakKeyAndValueSlot(luaValue, luaValue2, null);
            }
            return new WeakKeySlot(luaValue, luaValue2, null);
        }
        if (this.weakvalues && !luaValue2.isnumber() && !luaValue2.isstring() && !luaValue2.isboolean()) {
            return new WeakValueSlot(luaValue, luaValue2, null);
        }
        return LuaTable.defaultEntry(luaValue, luaValue2);
    }

    protected static LuaValue weaken(LuaValue luaValue) {
        switch (luaValue.type()) {
            case 5: 
            case 6: 
            case 8: {
                return new WeakValue(luaValue);
            }
            case 7: {
                return new WeakUserdata(luaValue);
            }
        }
        return luaValue;
    }

    protected static LuaValue strengthen(Object object) {
        if (object instanceof WeakReference) {
            object = ((WeakReference)object).get();
        }
        if (object instanceof WeakValue) {
            return ((WeakValue)object).strongvalue();
        }
        return (LuaValue)object;
    }

    public LuaValue wrap(LuaValue luaValue) {
        return this.weakvalues ? WeakTable.weaken(luaValue) : luaValue;
    }

    public LuaValue arrayget(LuaValue[] luaValueArray, int n) {
        LuaValue luaValue = luaValueArray[n];
        if (luaValue != null && (luaValue = WeakTable.strengthen(luaValue)) == null) {
            luaValueArray[n] = null;
        }
        return luaValue;
    }

    static final class WeakUserdata
    extends WeakValue {
        private final WeakReference ob;
        private final LuaValue mt;

        private WeakUserdata(LuaValue luaValue) {
            super(luaValue);
            this.ob = new WeakReference<Object>(luaValue.touserdata());
            this.mt = luaValue.getmetatable();
        }

        public LuaValue strongvalue() {
            Object t2 = this.ref.get();
            if (t2 != null) {
                return (LuaValue)t2;
            }
            Object t3 = this.ob.get();
            if (t3 != null) {
                LuaUserdata luaUserdata = LuaValue.userdataOf(t3, this.mt);
                this.ref = new WeakReference<LuaUserdata>(luaUserdata);
                return luaUserdata;
            }
            return null;
        }
    }

    static class WeakValue
    extends LuaValue {
        WeakReference ref;

        protected WeakValue(LuaValue luaValue) {
            this.ref = new WeakReference<LuaValue>(luaValue);
        }

        public int type() {
            this.illegal("type", "weak value");
            return 0;
        }

        public String typename() {
            this.illegal("typename", "weak value");
            return null;
        }

        public String toString() {
            return "weak<" + this.ref.get() + ">";
        }

        public LuaValue strongvalue() {
            Object t2 = this.ref.get();
            return (LuaValue)t2;
        }

        public boolean raweq(LuaValue luaValue) {
            Object t2 = this.ref.get();
            return t2 != null && luaValue.raweq((LuaValue)t2);
        }
    }

    static class WeakKeyAndValueSlot
    extends WeakSlot {
        private final int keyhash;

        protected WeakKeyAndValueSlot(LuaValue luaValue, LuaValue luaValue2, LuaTable.Slot slot) {
            super(WeakTable.weaken(luaValue), WeakTable.weaken(luaValue2), slot);
            this.keyhash = luaValue.hashCode();
        }

        protected WeakKeyAndValueSlot(WeakKeyAndValueSlot weakKeyAndValueSlot, LuaTable.Slot slot) {
            super(weakKeyAndValueSlot.key, weakKeyAndValueSlot.value, slot);
            this.keyhash = weakKeyAndValueSlot.keyhash;
        }

        public int keyindex(int n) {
            return LuaTable.hashmod(this.keyhash, n);
        }

        public LuaTable.Slot set(LuaValue luaValue) {
            this.value = WeakTable.weaken(luaValue);
            return this;
        }

        public LuaValue strongkey() {
            return WeakTable.strengthen(this.key);
        }

        public LuaValue strongvalue() {
            return WeakTable.strengthen(this.value);
        }

        protected WeakSlot copy(LuaTable.Slot slot) {
            return new WeakKeyAndValueSlot(this, slot);
        }
    }

    static class WeakValueSlot
    extends WeakSlot {
        protected WeakValueSlot(LuaValue luaValue, LuaValue luaValue2, LuaTable.Slot slot) {
            super(luaValue, WeakTable.weaken(luaValue2), slot);
        }

        protected WeakValueSlot(WeakValueSlot weakValueSlot, LuaTable.Slot slot) {
            super(weakValueSlot.key, weakValueSlot.value, slot);
        }

        public int keyindex(int n) {
            return LuaTable.hashSlot(this.strongkey(), n);
        }

        public LuaTable.Slot set(LuaValue luaValue) {
            this.value = WeakTable.weaken(luaValue);
            return this;
        }

        public LuaValue strongvalue() {
            return WeakTable.strengthen(this.value);
        }

        protected WeakSlot copy(LuaTable.Slot slot) {
            return new WeakValueSlot(this, slot);
        }
    }

    static class WeakKeySlot
    extends WeakSlot {
        private final int keyhash;

        protected WeakKeySlot(LuaValue luaValue, LuaValue luaValue2, LuaTable.Slot slot) {
            super(WeakTable.weaken(luaValue), luaValue2, slot);
            this.keyhash = luaValue.hashCode();
        }

        protected WeakKeySlot(WeakKeySlot weakKeySlot, LuaTable.Slot slot) {
            super(weakKeySlot.key, weakKeySlot.value, slot);
            this.keyhash = weakKeySlot.keyhash;
        }

        public int keyindex(int n) {
            return LuaTable.hashmod(this.keyhash, n);
        }

        public LuaTable.Slot set(LuaValue luaValue) {
            this.value = luaValue;
            return this;
        }

        public LuaValue strongkey() {
            return WeakTable.strengthen(this.key);
        }

        protected WeakSlot copy(LuaTable.Slot slot) {
            return new WeakKeySlot(this, slot);
        }
    }

    public static abstract class WeakSlot
    implements LuaTable.Slot {
        protected Object key;
        protected Object value;
        protected LuaTable.Slot next;

        protected WeakSlot(Object object, Object object2, LuaTable.Slot slot) {
            this.key = object;
            this.value = object2;
            this.next = slot;
        }

        public abstract int keyindex(int var1);

        public abstract LuaTable.Slot set(LuaValue var1);

        public LuaTable.StrongSlot first() {
            LuaValue luaValue = this.strongkey();
            LuaValue luaValue2 = this.strongvalue();
            if (luaValue != null && luaValue2 != null) {
                return new LuaTable.NormalEntry(luaValue, luaValue2);
            }
            this.key = null;
            this.value = null;
            return null;
        }

        public LuaTable.StrongSlot find(LuaValue luaValue) {
            LuaTable.StrongSlot strongSlot = this.first();
            return strongSlot != null ? strongSlot.find(luaValue) : null;
        }

        public boolean keyeq(LuaValue luaValue) {
            LuaTable.StrongSlot strongSlot = this.first();
            return strongSlot != null && strongSlot.keyeq(luaValue);
        }

        public LuaTable.Slot rest() {
            return this.next;
        }

        public int arraykey(int n) {
            return 0;
        }

        public LuaTable.Slot set(LuaTable.StrongSlot strongSlot, LuaValue luaValue) {
            LuaValue luaValue2 = this.strongkey();
            if (luaValue2 != null && strongSlot.find(luaValue2) != null) {
                return this.set(luaValue);
            }
            if (luaValue2 != null) {
                this.next = this.next.set(strongSlot, luaValue);
                return this;
            }
            return this.next.set(strongSlot, luaValue);
        }

        public LuaTable.Slot add(LuaTable.Slot slot) {
            LuaTable.Slot slot2 = this.next = this.next != null ? this.next.add(slot) : slot;
            if (this.strongkey() != null && this.strongvalue() != null) {
                return this;
            }
            return this.next;
        }

        public LuaTable.Slot remove(LuaTable.StrongSlot strongSlot) {
            LuaValue luaValue = this.strongkey();
            if (luaValue == null) {
                return this.next.remove(strongSlot);
            }
            if (strongSlot.keyeq(luaValue)) {
                this.value = null;
                return this;
            }
            this.next = this.next.remove(strongSlot);
            return this;
        }

        public LuaTable.Slot relink(LuaTable.Slot slot) {
            if (this.strongkey() != null && this.strongvalue() != null) {
                if (slot == null && this.next == null) {
                    return this;
                }
                return this.copy(slot);
            }
            return slot;
        }

        public LuaValue strongkey() {
            return (LuaValue)this.key;
        }

        public LuaValue strongvalue() {
            return (LuaValue)this.value;
        }

        protected abstract WeakSlot copy(LuaTable.Slot var1);
    }
}

