/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import org.luaj.vm2.LuaValue;
import org.luaj.vm2.ast.FuncArgs;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.SyntaxElement;
import org.luaj.vm2.ast.TableConstructor;
import org.luaj.vm2.ast.Visitor;

public abstract class Exp
extends SyntaxElement {
    public abstract void accept(Visitor var1);

    public static Exp constant(LuaValue luaValue) {
        return new Constant(luaValue);
    }

    public static Exp numberconstant(String string) {
        return new Constant(LuaValue.valueOf(string).tonumber());
    }

    public static Exp varargs() {
        return new VarargsExp();
    }

    public static Exp tableconstructor(TableConstructor tableConstructor) {
        return tableConstructor;
    }

    public static Exp unaryexp(int n, Exp exp2) {
        if (exp2 instanceof BinopExp) {
            BinopExp binopExp = (BinopExp)exp2;
            if (Exp.precedence(n) > Exp.precedence(binopExp.op)) {
                return Exp.binaryexp(Exp.unaryexp(n, binopExp.lhs), binopExp.op, binopExp.rhs);
            }
        }
        return new UnopExp(n, exp2);
    }

    public static Exp binaryexp(Exp exp2, int n, Exp exp3) {
        Exp exp4;
        if (exp2 instanceof UnopExp) {
            exp4 = (UnopExp)exp2;
            if (Exp.precedence(n) > Exp.precedence(exp4.op)) {
                return Exp.unaryexp(exp4.op, Exp.binaryexp(exp4.rhs, n, exp3));
            }
        }
        if (exp2 instanceof BinopExp) {
            exp4 = (BinopExp)exp2;
            if (Exp.precedence(n) > Exp.precedence(((BinopExp)exp4).op) || Exp.precedence(n) == Exp.precedence(((BinopExp)exp4).op) && Exp.isrightassoc(n)) {
                return Exp.binaryexp(((BinopExp)exp4).lhs, ((BinopExp)exp4).op, Exp.binaryexp(((BinopExp)exp4).rhs, n, exp3));
            }
        }
        if (exp3 instanceof BinopExp) {
            exp4 = (BinopExp)exp3;
            if (Exp.precedence(n) > Exp.precedence(((BinopExp)exp4).op) || Exp.precedence(n) == Exp.precedence(((BinopExp)exp4).op) && !Exp.isrightassoc(n)) {
                return Exp.binaryexp(Exp.binaryexp(exp2, n, ((BinopExp)exp4).lhs), ((BinopExp)exp4).op, ((BinopExp)exp4).rhs);
            }
        }
        return new BinopExp(exp2, n, exp3);
    }

    static boolean isrightassoc(int n) {
        switch (n) {
            case 18: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    static int precedence(int n) {
        switch (n) {
            case 59: {
                return 0;
            }
            case 60: {
                return 1;
            }
            case 24: 
            case 25: 
            case 26: 
            case 61: 
            case 62: 
            case 63: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 13: 
            case 14: {
                return 4;
            }
            case 15: 
            case 16: 
            case 17: {
                return 5;
            }
            case 19: 
            case 20: 
            case 21: {
                return 6;
            }
            case 18: {
                return 7;
            }
        }
        throw new IllegalStateException("precedence of bad op " + n);
    }

    public static Exp anonymousfunction(FuncBody funcBody) {
        return new AnonFuncDef(funcBody);
    }

    public static NameExp nameprefix(String string) {
        return new NameExp(string);
    }

    public static ParensExp parensprefix(Exp exp2) {
        return new ParensExp(exp2);
    }

    public static IndexExp indexop(PrimaryExp primaryExp, Exp exp2) {
        return new IndexExp(primaryExp, exp2);
    }

    public static FieldExp fieldop(PrimaryExp primaryExp, String string) {
        return new FieldExp(primaryExp, string);
    }

    public static FuncCall functionop(PrimaryExp primaryExp, FuncArgs funcArgs) {
        return new FuncCall(primaryExp, funcArgs);
    }

    public static MethodCall methodop(PrimaryExp primaryExp, String string, FuncArgs funcArgs) {
        return new MethodCall(primaryExp, string, funcArgs);
    }

    public boolean isvarexp() {
        return false;
    }

    public boolean isfunccall() {
        return false;
    }

    public boolean isvarargexp() {
        return false;
    }

    public static class AnonFuncDef
    extends Exp {
        public final FuncBody body;

        public AnonFuncDef(FuncBody funcBody) {
            this.body = funcBody;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class BinopExp
    extends Exp {
        public final Exp lhs;
        public final Exp rhs;
        public final int op;

        public BinopExp(Exp exp2, int n, Exp exp3) {
            this.lhs = exp2;
            this.op = n;
            this.rhs = exp3;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class UnopExp
    extends Exp {
        public final int op;
        public final Exp rhs;

        public UnopExp(int n, Exp exp2) {
            this.op = n;
            this.rhs = exp2;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class VarargsExp
    extends Exp {
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }

        public boolean isvarargexp() {
            return true;
        }
    }

    public static class Constant
    extends Exp {
        public final LuaValue value;

        public Constant(LuaValue luaValue) {
            this.value = luaValue;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class MethodCall
    extends FuncCall {
        public final String name;

        public MethodCall(PrimaryExp primaryExp, String string, FuncArgs funcArgs) {
            super(primaryExp, funcArgs);
            this.name = new String(string);
        }

        public boolean isfunccall() {
            return true;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class FuncCall
    extends PrimaryExp {
        public final PrimaryExp lhs;
        public final FuncArgs args;

        public FuncCall(PrimaryExp primaryExp, FuncArgs funcArgs) {
            this.lhs = primaryExp;
            this.args = funcArgs;
        }

        public boolean isfunccall() {
            return true;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }

        public boolean isvarargexp() {
            return true;
        }
    }

    public static class IndexExp
    extends VarExp {
        public final PrimaryExp lhs;
        public final Exp exp;

        public IndexExp(PrimaryExp primaryExp, Exp exp2) {
            this.lhs = primaryExp;
            this.exp = exp2;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class FieldExp
    extends VarExp {
        public final PrimaryExp lhs;
        public final Name name;

        public FieldExp(PrimaryExp primaryExp, String string) {
            this.lhs = primaryExp;
            this.name = new Name(string);
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class ParensExp
    extends PrimaryExp {
        public final Exp exp;

        public ParensExp(Exp exp2) {
            this.exp = exp2;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class NameExp
    extends VarExp {
        public final Name name;

        public NameExp(String string) {
            this.name = new Name(string);
        }

        public void markHasAssignment() {
            this.name.variable.hasassignments = true;
        }

        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static abstract class VarExp
    extends PrimaryExp {
        public boolean isvarexp() {
            return true;
        }

        public void markHasAssignment() {
        }
    }

    public static abstract class PrimaryExp
    extends Exp {
        public boolean isvarexp() {
            return false;
        }

        public boolean isfunccall() {
            return false;
        }
    }
}

