/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.util.List;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Chunk;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncArgs;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.NameScope;
import org.luaj.vm2.ast.ParList;
import org.luaj.vm2.ast.Stat;
import org.luaj.vm2.ast.TableConstructor;
import org.luaj.vm2.ast.TableField;

public abstract class Visitor {
    public void visit(Chunk chunk) {
        chunk.block.accept(this);
    }

    public void visit(Block block2) {
        this.visit(block2.scope);
        if (block2.stats != null) {
            int n = block2.stats.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((Stat)block2.stats.get(i2)).accept(this);
            }
        }
    }

    public void visit(Stat.Assign assign) {
        this.visitVars(assign.vars);
        this.visitExps(assign.exps);
    }

    public void visit(Stat.Break break_) {
    }

    public void visit(Stat.FuncCallStat funcCallStat) {
        funcCallStat.funccall.accept(this);
    }

    public void visit(Stat.FuncDef funcDef) {
        funcDef.body.accept(this);
    }

    public void visit(Stat.GenericFor genericFor) {
        this.visit(genericFor.scope);
        this.visitNames(genericFor.names);
        this.visitExps(genericFor.exps);
        genericFor.block.accept(this);
    }

    public void visit(Stat.IfThenElse ifThenElse) {
        ifThenElse.ifexp.accept(this);
        ifThenElse.ifblock.accept(this);
        if (ifThenElse.elseifblocks != null) {
            int n = ifThenElse.elseifblocks.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((Exp)ifThenElse.elseifexps.get(i2)).accept(this);
                ((Block)ifThenElse.elseifblocks.get(i2)).accept(this);
            }
        }
        if (ifThenElse.elseblock != null) {
            this.visit(ifThenElse.elseblock);
        }
    }

    public void visit(Stat.LocalAssign localAssign) {
        this.visitNames(localAssign.names);
        this.visitExps(localAssign.values);
    }

    public void visit(Stat.LocalFuncDef localFuncDef) {
        this.visit(localFuncDef.name);
        localFuncDef.body.accept(this);
    }

    public void visit(Stat.NumericFor numericFor) {
        this.visit(numericFor.scope);
        this.visit(numericFor.name);
        numericFor.initial.accept(this);
        numericFor.limit.accept(this);
        if (numericFor.step != null) {
            numericFor.step.accept(this);
        }
        numericFor.block.accept(this);
    }

    public void visit(Stat.RepeatUntil repeatUntil) {
        repeatUntil.block.accept(this);
        repeatUntil.exp.accept(this);
    }

    public void visit(Stat.Return return_) {
        this.visitExps(return_.values);
    }

    public void visit(Stat.WhileDo whileDo) {
        whileDo.exp.accept(this);
        whileDo.block.accept(this);
    }

    public void visit(FuncBody funcBody) {
        this.visit(funcBody.scope);
        funcBody.parlist.accept(this);
        funcBody.block.accept(this);
    }

    public void visit(FuncArgs funcArgs) {
        this.visitExps(funcArgs.exps);
    }

    public void visit(TableField tableField) {
        if (tableField.name != null) {
            // empty if block
        }
        this.visit(tableField.name);
        if (tableField.index != null) {
            tableField.index.accept(this);
        }
        tableField.rhs.accept(this);
    }

    public void visit(Exp.AnonFuncDef anonFuncDef) {
        anonFuncDef.body.accept(this);
    }

    public void visit(Exp.BinopExp binopExp) {
        binopExp.lhs.accept(this);
        binopExp.rhs.accept(this);
    }

    public void visit(Exp.Constant constant) {
    }

    public void visit(Exp.FieldExp fieldExp) {
        fieldExp.lhs.accept(this);
        this.visit(fieldExp.name);
    }

    public void visit(Exp.FuncCall funcCall) {
        funcCall.lhs.accept(this);
        funcCall.args.accept(this);
    }

    public void visit(Exp.IndexExp indexExp) {
        indexExp.lhs.accept(this);
        indexExp.exp.accept(this);
    }

    public void visit(Exp.MethodCall methodCall) {
        methodCall.lhs.accept(this);
        this.visit(methodCall.name);
        methodCall.args.accept(this);
    }

    public void visit(Exp.NameExp nameExp) {
        this.visit(nameExp.name);
    }

    public void visit(Exp.ParensExp parensExp) {
        parensExp.exp.accept(this);
    }

    public void visit(Exp.UnopExp unopExp) {
        unopExp.rhs.accept(this);
    }

    public void visit(Exp.VarargsExp varargsExp) {
    }

    public void visit(ParList parList) {
        this.visitNames(parList.names);
    }

    public void visit(TableConstructor tableConstructor) {
        if (tableConstructor.fields != null) {
            int n = tableConstructor.fields.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((TableField)tableConstructor.fields.get(i2)).accept(this);
            }
        }
    }

    public void visitVars(List list) {
        if (list != null) {
            int n = list.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((Exp.VarExp)list.get(i2)).accept(this);
            }
        }
    }

    public void visitExps(List list) {
        if (list != null) {
            int n = list.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((Exp)list.get(i2)).accept(this);
            }
        }
    }

    public void visitNames(List list) {
        if (list != null) {
            int n = list.size();
            for (int i2 = 0; i2 < n; ++i2) {
                this.visit((Name)list.get(i2));
            }
        }
    }

    public void visit(Name name) {
    }

    public void visit(String string) {
    }

    public void visit(NameScope nameScope) {
    }

    public void visit(Stat.Goto goto_) {
    }

    public void visit(Stat.Label label) {
    }
}

