/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.Constants;
import org.luaj.vm2.compiler.FuncState;
import org.luaj.vm2.compiler.LexState;

public class LuaC
extends Constants
implements Globals.Compiler,
Globals.Loader {
    public static final LuaC instance = new LuaC();

    public static void install(Globals globals) {
        globals.compiler = instance;
        globals.loader = instance;
    }

    protected LuaC() {
    }

    public Prototype compile(InputStream inputStream2, String string) throws IOException {
        return new CompileState().luaY_parser(inputStream2, string);
    }

    public LuaFunction load(Prototype prototype, String string, LuaValue luaValue) throws IOException {
        return new LuaClosure(prototype, luaValue);
    }

    public LuaValue load(InputStream inputStream2, String string, Globals globals) throws IOException {
        return new LuaClosure(this.compile(inputStream2, string), globals);
    }

    static class CompileState {
        int nCcalls = 0;
        private Hashtable strings = new Hashtable();

        protected CompileState() {
        }

        private Prototype luaY_parser(InputStream inputStream2, String string) throws IOException {
            FuncState funcState;
            LexState lexState = new LexState(this, inputStream2);
            lexState.fs = funcState = new FuncState();
            lexState.setinput(this, inputStream2.read(), inputStream2, LuaValue.valueOf(string));
            funcState.f = new Prototype();
            funcState.f.source = LuaValue.valueOf(string);
            lexState.mainfunc(funcState);
            LuaC._assert(funcState.prev == null);
            LuaC._assert(lexState.dyd == null || lexState.dyd.n_actvar == 0 && lexState.dyd.n_gt == 0 && lexState.dyd.n_label == 0);
            return funcState.f;
        }

        public LuaString newTString(String string) {
            return this.cachedLuaString(LuaString.valueOf(string));
        }

        public LuaString newTString(LuaString luaString) {
            return this.cachedLuaString(luaString);
        }

        public LuaString cachedLuaString(LuaString luaString) {
            LuaString luaString2 = (LuaString)this.strings.get(luaString);
            if (luaString2 != null) {
                return luaString2;
            }
            this.strings.put(luaString, luaString);
            return luaString;
        }

        public String pushfstring(String string) {
            return string;
        }
    }
}

