/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JseProcess {
    final Process process;
    final Thread input;
    final Thread output;
    final Thread error;

    public JseProcess(String[] stringArray, InputStream inputStream2, OutputStream outputStream2, OutputStream outputStream3) throws IOException {
        this(Runtime.getRuntime().exec(stringArray), inputStream2, outputStream2, outputStream3);
    }

    public JseProcess(String string, InputStream inputStream2, OutputStream outputStream2, OutputStream outputStream3) throws IOException {
        this(Runtime.getRuntime().exec(string), inputStream2, outputStream2, outputStream3);
    }

    private JseProcess(Process process2, InputStream inputStream2, OutputStream outputStream2, OutputStream outputStream3) {
        this.process = process2;
        this.input = inputStream2 == null ? null : this.copyBytes(inputStream2, process2.getOutputStream(), null, process2.getOutputStream());
        this.output = outputStream2 == null ? null : this.copyBytes(process2.getInputStream(), outputStream2, process2.getInputStream(), null);
        this.error = outputStream3 == null ? null : this.copyBytes(process2.getErrorStream(), outputStream3, process2.getErrorStream(), null);
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public int waitFor() throws InterruptedException {
        int n = this.process.waitFor();
        if (this.input != null) {
            this.input.join();
        }
        if (this.output != null) {
            this.output.join();
        }
        if (this.error != null) {
            this.error.join();
        }
        this.process.destroy();
        return n;
    }

    private Thread copyBytes(InputStream inputStream2, OutputStream outputStream2, InputStream inputStream3, OutputStream outputStream3) {
        CopyThread copyThread = new CopyThread(outputStream2, outputStream3, inputStream3, inputStream2);
        copyThread.start();
        return copyThread;
    }

    private static final class CopyThread
    extends Thread {
        private final OutputStream output;
        private final OutputStream ownedOutput;
        private final InputStream ownedInput;
        private final InputStream input;

        private CopyThread(OutputStream outputStream2, OutputStream outputStream3, InputStream inputStream2, InputStream inputStream3) {
            this.output = outputStream2;
            this.ownedOutput = outputStream3;
            this.ownedInput = inputStream2;
            this.input = inputStream3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] byArray = new byte[1024];
                try {
                    int n;
                    while ((n = this.input.read(byArray)) >= 0) {
                        this.output.write(byArray, 0, n);
                    }
                }
                finally {
                    if (this.ownedInput != null) {
                        this.ownedInput.close();
                    }
                    if (this.ownedOutput != null) {
                        this.ownedOutput.close();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

