/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.luajc.JavaGen;
import org.luaj.vm2.luajc.JavaLoader;

public class LuaJC
implements Globals.Loader {
    public static final LuaJC instance = new LuaJC();

    public static final void install(Globals globals) {
        globals.loader = instance;
    }

    protected LuaJC() {
    }

    public Hashtable compileAll(InputStream inputStream2, String string, String string2, Globals globals, boolean bl) throws IOException {
        String string3 = LuaJC.toStandardJavaClassName(string);
        Prototype prototype = globals.loadPrototype(inputStream2, string3, "bt");
        return this.compileProtoAndSubProtos(prototype, string3, string2, bl);
    }

    public Hashtable compileAll(Reader reader2, String string, String string2, Globals globals, boolean bl) throws IOException {
        String string3 = LuaJC.toStandardJavaClassName(string);
        Prototype prototype = globals.compilePrototype(reader2, string3);
        return this.compileProtoAndSubProtos(prototype, string3, string2, bl);
    }

    private Hashtable compileProtoAndSubProtos(Prototype prototype, String string, String string2, boolean bl) throws IOException {
        String string3 = LuaJC.toStandardLuaFileName(string2);
        Hashtable hashtable = new Hashtable();
        JavaGen javaGen = new JavaGen(prototype, string, string3, bl);
        this.insert(hashtable, javaGen);
        return hashtable;
    }

    private void insert(Hashtable hashtable, JavaGen javaGen) {
        int n;
        hashtable.put(javaGen.classname, javaGen.bytecode);
        int n2 = n = javaGen.inners != null ? javaGen.inners.length : 0;
        for (int i2 = 0; i2 < n; ++i2) {
            this.insert(hashtable, javaGen.inners[i2]);
        }
    }

    public LuaFunction load(Prototype prototype, String string, LuaValue luaValue) throws IOException {
        String string2 = LuaJC.toStandardLuaFileName(string);
        String string3 = LuaJC.toStandardJavaClassName(string2);
        JavaLoader javaLoader = new JavaLoader();
        return javaLoader.load(prototype, string3, string2, luaValue);
    }

    private static String toStandardJavaClassName(String string) {
        String string2 = LuaJC.toStub(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = string2.charAt(i2);
            stringBuffer.append(i2 == 0 && Character.isJavaIdentifierStart(c2) || i2 > 0 && Character.isJavaIdentifierPart(c2) ? (char)c2 : (char)'_');
        }
        return stringBuffer.toString();
    }

    private static String toStandardLuaFileName(String string) {
        String string2 = LuaJC.toStub(string);
        String string3 = string2.replace('.', '/') + ".lua";
        return string3.startsWith("@") ? string3.substring(1) : string3;
    }

    private static String toStub(String string) {
        String string2 = string.endsWith(".lua") ? string.substring(0, string.length() - 4) : string;
        return string2;
    }
}

