/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.UpvalInfo;
import org.luaj.vm2.luajc.VarInfo;

public class ProtoInfo {
    public final String name;
    public final Prototype prototype;
    public final ProtoInfo[] subprotos;
    public final BasicBlock[] blocks;
    public final BasicBlock[] blocklist;
    public final VarInfo[] params;
    public final VarInfo[][] vars;
    public final UpvalInfo[] upvals;
    public final UpvalInfo[][] openups;

    public ProtoInfo(Prototype prototype, String string) {
        this(prototype, string, null);
    }

    private ProtoInfo(Prototype prototype, String string, UpvalInfo[] upvalInfoArray) {
        UpvalInfo[] upvalInfoArray2;
        this.name = string;
        this.prototype = prototype;
        if (upvalInfoArray != null) {
            upvalInfoArray2 = upvalInfoArray;
        } else {
            UpvalInfo[] upvalInfoArray3 = new UpvalInfo[1];
            upvalInfoArray2 = upvalInfoArray3;
            upvalInfoArray3[0] = new UpvalInfo(this);
        }
        this.upvals = upvalInfoArray2;
        this.subprotos = prototype.p != null && prototype.p.length > 0 ? new ProtoInfo[prototype.p.length] : null;
        this.blocks = BasicBlock.findBasicBlocks(prototype);
        this.blocklist = BasicBlock.findLiveBlocks(this.blocks);
        this.params = new VarInfo[prototype.maxstacksize];
        for (int i2 = 0; i2 < prototype.maxstacksize; ++i2) {
            VarInfo varInfo;
            this.params[i2] = varInfo = VarInfo.PARAM(i2);
        }
        this.vars = this.findVariables();
        this.replaceTrivialPhiVariables();
        this.openups = new UpvalInfo[prototype.maxstacksize][];
        this.findUpvalues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("proto '" + this.name + "'\n");
        int n3 = n2 = this.upvals != null ? this.upvals.length : 0;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(" up[" + n + "]: " + this.upvals[n] + "\n");
        }
        for (n = 0; n < this.blocklist.length; ++n) {
            BasicBlock basicBlock = this.blocklist[n];
            int n4 = basicBlock.pc0;
            stringBuffer.append("  block " + basicBlock.toString());
            this.appendOpenUps(stringBuffer, -1);
            for (int i2 = n4; i2 <= basicBlock.pc1; ++i2) {
                Object object;
                this.appendOpenUps(stringBuffer, i2);
                stringBuffer.append("     ");
                for (int i3 = 0; i3 < this.prototype.maxstacksize; ++i3) {
                    object = this.vars[i3][i2];
                    String string = object == null ? "" : (((VarInfo)object).upvalue != null ? (!((VarInfo)object).upvalue.rw ? "[C] " : (((VarInfo)object).allocupvalue && ((VarInfo)object).pc == i2 ? "[*] " : "[]  ")) : "    ");
                    String string2 = object == null ? "null   " : String.valueOf(object);
                    stringBuffer.append(string2 + string);
                }
                stringBuffer.append("  ");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object = Print.ps;
                Print.ps = new PrintStream(byteArrayOutputStream);
                try {
                    Print.printOpCode(this.prototype, i2);
                }
                finally {
                    Print.ps.close();
                    Print.ps = object;
                }
                stringBuffer.append(byteArrayOutputStream.toString());
                stringBuffer.append("\n");
            }
        }
        int n5 = n2 = this.subprotos != null ? this.subprotos.length : 0;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.subprotos[n].toString());
        }
        return stringBuffer.toString();
    }

    private void appendOpenUps(StringBuffer stringBuffer, int n) {
        for (int i2 = 0; i2 < this.prototype.maxstacksize; ++i2) {
            VarInfo varInfo;
            VarInfo varInfo2 = varInfo = n < 0 ? this.params[i2] : this.vars[i2][n];
            if (varInfo == null || varInfo.pc != n || !varInfo.allocupvalue) continue;
            stringBuffer.append("    open: " + varInfo.upvalue + "\n");
        }
    }

    private VarInfo[][] findVariables() {
        int n;
        int n2 = this.prototype.code.length;
        int n3 = this.prototype.maxstacksize;
        VarInfo[][] varInfoArray = new VarInfo[n3][];
        for (n = 0; n < varInfoArray.length; ++n) {
            varInfoArray[n] = new VarInfo[n2];
        }
        for (n = 0; n < this.blocklist.length; ++n) {
            int n4;
            int n5;
            BasicBlock basicBlock = this.blocklist[n];
            int n6 = basicBlock.prev != null ? basicBlock.prev.length : 0;
            for (n5 = 0; n5 < n3; ++n5) {
                VarInfo varInfo = null;
                if (n6 == 0) {
                    varInfo = this.params[n5];
                } else if (n6 == 1) {
                    varInfo = varInfoArray[n5][basicBlock.prev[0].pc1];
                } else {
                    for (n4 = 0; n4 < n6; ++n4) {
                        BasicBlock basicBlock2 = basicBlock.prev[n4];
                        if (varInfoArray[n5][basicBlock2.pc1] != VarInfo.INVALID) continue;
                        varInfo = VarInfo.INVALID;
                    }
                }
                if (varInfo == null) {
                    varInfo = VarInfo.PHI(this, n5, basicBlock.pc0);
                }
                varInfoArray[n5][basicBlock.pc0] = varInfo;
            }
            block29: for (n5 = basicBlock.pc0; n5 <= basicBlock.pc1; ++n5) {
                if (n5 > basicBlock.pc0) {
                    ProtoInfo.propogateVars(varInfoArray, n5 - 1, n5);
                }
                int n7 = this.prototype.code[n5];
                int n8 = Lua.GET_OPCODE(n7);
                switch (n8) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 11: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 0: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 28: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 10: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block29;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block29;
                    }
                    case 8: {
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block29;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block29;
                    }
                    case 22: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        for (n4 = Lua.GETARG_B(n7); n4 <= n10; ++n4) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 33: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9 + 2][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 7: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 6: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 12: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        varInfoArray[n9 + 1][n5] = new VarInfo(n9 + 1, n5);
                        continue block29;
                    }
                    case 32: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9 + 2][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9 + 1][n5].isreferenced = true;
                        varInfoArray[n9 + 3][n5] = new VarInfo(n9 + 3, n5);
                        continue block29;
                    }
                    case 4: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        while (n4-- >= 0) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n9;
                        }
                        continue block29;
                    }
                    case 38: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n11 = 1;
                        while (n11 < n4) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n11;
                            ++n9;
                        }
                        if (n4 != 0) continue block29;
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    case 29: {
                        int n12;
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9][n5].isreferenced = true;
                        for (n12 = 1; n12 <= n4 - 1; ++n12) {
                            varInfoArray[n9 + n12][n5].isreferenced = true;
                        }
                        n12 = 0;
                        while (n12 <= n10 - 2) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n12;
                            ++n9;
                        }
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    case 34: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9++][n5].isreferenced = true;
                        varInfoArray[n9++][n5].isreferenced = true;
                        varInfoArray[n9++][n5].isreferenced = true;
                        int n13 = 0;
                        while (n13 < n10) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n13;
                            ++n9;
                        }
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    case 35: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9 + 1][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 30: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        for (int i2 = 1; i2 <= n4 - 1; ++i2) {
                            varInfoArray[n9 + i2][n5].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 31: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        for (int i3 = 0; i3 <= n4 - 2; ++i3) {
                            varInfoArray[n9 + i3][n5].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 37: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_Bx(n7);
                        Upvaldesc[] upvaldescArray = this.prototype.p[n4].upvalues;
                        int n14 = upvaldescArray.length;
                        for (int i4 = 0; i4 < n14; ++i4) {
                            if (!upvaldescArray[i4].instack) continue;
                            varInfoArray[upvaldescArray[i4].idx][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 36: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        for (int i5 = 1; i5 <= n4; ++i5) {
                            varInfoArray[n9 + i5][n5].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 9: 
                    case 27: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        continue block29;
                    }
                    case 24: 
                    case 25: 
                    case 26: {
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block29;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block29;
                    }
                    case 23: {
                        int n9 = Lua.GETARG_A(n7);
                        if (n9 <= 0) continue block29;
                        --n9;
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    default: {
                        throw new IllegalStateException("unhandled opcode: " + n7);
                    }
                }
            }
        }
        return varInfoArray;
    }

    private static void propogateVars(VarInfo[][] varInfoArray, int n, int n2) {
        int n3 = varInfoArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            varInfoArray[i2][n2] = varInfoArray[i2][n];
        }
    }

    private void replaceTrivialPhiVariables() {
        for (int i2 = 0; i2 < this.blocklist.length; ++i2) {
            BasicBlock basicBlock = this.blocklist[i2];
            for (int i3 = 0; i3 < this.prototype.maxstacksize; ++i3) {
                VarInfo varInfo = this.vars[i3][basicBlock.pc0];
                VarInfo varInfo2 = varInfo.resolvePhiVariableValues();
                if (varInfo2 == null) continue;
                this.substituteVariable(i3, varInfo, varInfo2);
            }
        }
    }

    private void substituteVariable(int n, VarInfo varInfo, VarInfo varInfo2) {
        int n2 = this.prototype.code.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.replaceAll(this.vars[n], this.vars[n].length, varInfo, varInfo2);
        }
    }

    private void replaceAll(VarInfo[] varInfoArray, int n, VarInfo varInfo, VarInfo varInfo2) {
        for (int i2 = 0; i2 < n; ++i2) {
            if (varInfoArray[i2] != varInfo) continue;
            varInfoArray[i2] = varInfo2;
        }
    }

    private void findUpvalues() {
        int n;
        int[] nArray = this.prototype.code;
        int n2 = nArray.length;
        String[] stringArray = this.findInnerprotoNames();
        for (n = 0; n < n2; ++n) {
            if (Lua.GET_OPCODE(nArray[n]) != 37) continue;
            int n3 = Lua.GETARG_Bx(nArray[n]);
            Prototype prototype = this.prototype.p[n3];
            UpvalInfo[] upvalInfoArray = new UpvalInfo[prototype.upvalues.length];
            String string = this.name + "$" + stringArray[n3];
            for (int i2 = 0; i2 < prototype.upvalues.length; ++i2) {
                Upvaldesc upvaldesc = prototype.upvalues[i2];
                upvalInfoArray[i2] = upvaldesc.instack ? this.findOpenUp(n, upvaldesc.idx) : this.upvals[upvaldesc.idx];
            }
            this.subprotos[n3] = new ProtoInfo(prototype, string, upvalInfoArray);
        }
        for (n = 0; n < n2; ++n) {
            if (Lua.GET_OPCODE(nArray[n]) != 9) continue;
            this.upvals[Lua.GETARG_B((int)nArray[n])].rw = true;
        }
    }

    private UpvalInfo findOpenUp(int n, int n2) {
        if (this.openups[n2] == null) {
            this.openups[n2] = new UpvalInfo[this.prototype.code.length];
        }
        if (this.openups[n2][n] != null) {
            return this.openups[n2][n];
        }
        UpvalInfo upvalInfo = new UpvalInfo(this, n, n2);
        int n3 = this.prototype.code.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.vars[n2][i2] == null || this.vars[n2][i2].upvalue != upvalInfo) continue;
            this.openups[n2][i2] = upvalInfo;
        }
        return upvalInfo;
    }

    public boolean isUpvalueAssign(int n, int n2) {
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw;
    }

    public boolean isUpvalueCreate(int n, int n2) {
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw && varInfo.allocupvalue && n == varInfo.pc;
    }

    public boolean isUpvalueRefer(int n, int n2) {
        if (n > 0 && this.vars[n2][n] != null && this.vars[n2][n].pc == n && this.vars[n2][n - 1] != null) {
            --n;
        }
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw;
    }

    public boolean isInitialValueUsed(int n) {
        VarInfo varInfo = this.params[n];
        return varInfo.isreferenced;
    }

    public boolean isReadWriteUpvalue(UpvalInfo upvalInfo) {
        return upvalInfo.rw;
    }

    private String[] findInnerprotoNames() {
        if (this.prototype.p.length <= 0) {
            return null;
        }
        String[] stringArray = new String[this.prototype.p.length];
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int[] nArray = this.prototype.code;
        int n = nArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (Lua.GET_OPCODE(nArray[i2]) != 37) continue;
            int n2 = Lua.GETARG_Bx(nArray[i2]);
            String string = null;
            int n3 = nArray[i2 + 1];
            switch (Lua.GET_OPCODE(n3)) {
                case 8: 
                case 10: {
                    int n4 = Lua.GETARG_B(n3);
                    if (!Lua.ISK(n4)) break;
                    string = this.prototype.k[n4 & 0xFF].tojstring();
                    break;
                }
                case 9: {
                    int n4 = Lua.GETARG_B(n3);
                    LuaString luaString = this.prototype.upvalues[n4].name;
                    if (luaString == null) break;
                    string = luaString.tojstring();
                    break;
                }
                default: {
                    int n4 = Lua.GETARG_A(nArray[i2]);
                    LuaString luaString = this.prototype.getlocalname(n4 + 1, i2 + 1);
                    if (luaString == null) break;
                    string = luaString.tojstring();
                }
            }
            String string2 = string = string != null ? ProtoInfo.toJavaClassPart(string) : String.valueOf(n2);
            if (hashtable.containsKey(string)) {
                String string3 = string;
                int n5 = 1;
                while (hashtable.containsKey(string = string3 + '$' + n5++)) {
                }
            }
            hashtable.put(string, Boolean.TRUE);
            stringArray[n2] = string;
        }
        return stringArray;
    }

    private static String toJavaClassPart(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(Character.isJavaIdentifierPart(string.charAt(i2)) ? string.charAt(i2) : (char)'_');
        }
        return stringBuffer.toString();
    }
}

