/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.ProtoInfo;
import org.luaj.vm2.luajc.UpvalInfo;

public class VarInfo {
    public static VarInfo INVALID = new VarInfo(-1, -1);
    public final int slot;
    public final int pc;
    public UpvalInfo upvalue;
    public boolean allocupvalue;
    public boolean isreferenced;

    public static VarInfo PARAM(int n) {
        return new ParamVarInfo(n, -1);
    }

    public static VarInfo NIL(int n) {
        return new NilVarInfo(n, -1);
    }

    public static VarInfo PHI(ProtoInfo protoInfo, int n, int n2) {
        return new PhiVarInfo(protoInfo, n, n2);
    }

    public VarInfo(int n, int n2) {
        this.slot = n;
        this.pc = n2;
    }

    public String toString() {
        return this.slot < 0 ? "x.x" : this.slot + "." + this.pc;
    }

    public VarInfo resolvePhiVariableValues() {
        return null;
    }

    protected void collectUniqueValues(Set set2, Set set3) {
        set3.add(this);
    }

    public boolean isPhiVar() {
        return false;
    }

    private static final class PhiVarInfo
    extends VarInfo {
        private final ProtoInfo pi;
        VarInfo[] values;

        private PhiVarInfo(ProtoInfo protoInfo, int n, int n2) {
            super(n, n2);
            this.pi = protoInfo;
        }

        public boolean isPhiVar() {
            return true;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("={");
            int n2 = n = this.values != null ? this.values.length : 0;
            for (int i2 = 0; i2 < n; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(String.valueOf(this.values[i2]));
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public VarInfo resolvePhiVariableValues() {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            this.collectUniqueValues(hashSet, hashSet2);
            if (hashSet2.contains(INVALID)) {
                return INVALID;
            }
            int n = hashSet2.size();
            Iterator iterator2 = hashSet2.iterator();
            if (n == 1) {
                VarInfo varInfo = (VarInfo)iterator2.next();
                varInfo.isreferenced |= this.isreferenced;
                return varInfo;
            }
            this.values = new VarInfo[n];
            for (int i2 = 0; i2 < n; ++i2) {
                this.values[i2] = (VarInfo)iterator2.next();
                this.values[i2].isreferenced |= this.isreferenced;
            }
            return null;
        }

        protected void collectUniqueValues(Set set2, Set set3) {
            int n;
            BasicBlock basicBlock = this.pi.blocks[this.pc];
            if (this.pc == 0) {
                set3.add(this.pi.params[this.slot]);
            }
            int n2 = n = basicBlock.prev != null ? basicBlock.prev.length : 0;
            for (int i2 = 0; i2 < n; ++i2) {
                BasicBlock basicBlock2 = basicBlock.prev[i2];
                if (set2.contains(basicBlock2)) continue;
                set2.add(basicBlock2);
                VarInfo varInfo = this.pi.vars[this.slot][basicBlock2.pc1];
                if (varInfo == null) continue;
                varInfo.collectUniqueValues(set2, set3);
            }
        }
    }

    private static final class NilVarInfo
    extends VarInfo {
        private NilVarInfo(int n, int n2) {
            super(n, n2);
        }

        public String toString() {
            return "nil";
        }
    }

    private static final class ParamVarInfo
    extends VarInfo {
        private ParamVarInfo(int n, int n2) {
            super(n, n2);
        }

        public String toString() {
            return this.slot + ".p";
        }
    }
}

