/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.luaj.vm2.Globals;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.luajc.LuaJC;

public class LuajContext
extends SimpleScriptContext
implements ScriptContext {
    public final Globals globals;
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public LuajContext() {
        this("true".equals(System.getProperty("org.luaj.debug")), "true".equals(System.getProperty("org.luaj.luajc")));
    }

    public LuajContext(boolean bl, boolean bl2) {
        Globals globals = this.globals = bl ? JsePlatform.debugGlobals() : JsePlatform.standardGlobals();
        if (bl2) {
            LuaJC.install(this.globals);
        }
        this.stdin = this.globals.STDIN;
        this.stdout = this.globals.STDOUT;
        this.stderr = this.globals.STDERR;
    }

    public void setErrorWriter(Writer writer) {
        this.globals.STDERR = writer != null ? new PrintStream(new WriterOutputStream(writer)) : this.stderr;
    }

    public void setReader(Reader reader2) {
        this.globals.STDIN = reader2 != null ? new ReaderInputStream(reader2) : this.stdin;
    }

    public void setWriter(Writer writer) {
        this.globals.STDOUT = writer != null ? new PrintStream(new WriterOutputStream(writer), true) : this.stdout;
    }

    static final class ReaderInputStream
    extends InputStream {
        final Reader r;

        ReaderInputStream(Reader reader2) {
            this.r = reader2;
        }

        public int read() throws IOException {
            return this.r.read();
        }
    }

    static final class WriterOutputStream
    extends OutputStream {
        final Writer w;

        WriterOutputStream(Writer writer) {
            this.w = writer;
        }

        public void write(int n) throws IOException {
            this.w.write(new String(new byte[]{(byte)n}));
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.w.write(new String(byArray, n, n2));
        }

        public void write(byte[] byArray) throws IOException {
            this.w.write(new String(byArray));
        }

        public void close() throws IOException {
            this.w.close();
        }

        public void flush() throws IOException {
            this.w.flush();
        }
    }
}

