/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.server.DefaultLauncher;
import org.luaj.vm2.server.Launcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuajClassLoader
extends ClassLoader {
    static final String luajPackageRoot = "org.luaj.vm2.";
    static final String launcherInterfaceRoot = Launcher.class.getName();
    Map<String, Class<?>> classes = new HashMap();

    public static Launcher NewLauncher() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return LuajClassLoader.NewLauncher(DefaultLauncher.class);
    }

    public static Launcher NewLauncher(Class<? extends Launcher> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LuajClassLoader luajClassLoader = new LuajClassLoader();
        Object obj = luajClassLoader.loadAsUserClass(clazz.getName()).newInstance();
        return (Launcher)obj;
    }

    public static boolean isUserClass(String string) {
        return string.startsWith(luajPackageRoot) && !string.startsWith(launcherInterfaceRoot);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        if (this.classes.containsKey(string)) {
            return this.classes.get(string);
        }
        if (!LuajClassLoader.isUserClass(string)) {
            return super.findSystemClass(string);
        }
        return this.loadAsUserClass(string);
    }

    private Class<?> loadAsUserClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/').concat(".class");
        InputStream inputStream2 = this.getResourceAsStream(string2);
        if (inputStream2 != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = inputStream2.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                Class<?> clazz = super.defineClass(string, byArray2, 0, byArray2.length);
                this.classes.put(string, clazz);
                return clazz;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Read failed: " + string + ": " + iOException);
            }
        }
        throw new ClassNotFoundException("Not found: " + string);
    }
}

