/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.TypeInfo;

final class SuperBlock {
    private int index;
    private int start;
    private int end;
    private int[] locals;
    private int[] stack;
    private boolean isInitialized;
    private boolean isInQueue;

    SuperBlock(int index, int start2, int end2, int[] initialLocals) {
        this.index = index;
        this.start = start2;
        this.end = end2;
        this.locals = new int[initialLocals.length];
        System.arraycopy(initialLocals, 0, this.locals, 0, initialLocals.length);
        this.stack = new int[0];
        this.isInitialized = false;
        this.isInQueue = false;
    }

    int getIndex() {
        return this.index;
    }

    int[] getLocals() {
        int[] copy2 = new int[this.locals.length];
        System.arraycopy(this.locals, 0, copy2, 0, this.locals.length);
        return copy2;
    }

    int[] getTrimmedLocals() {
        int last2;
        for (last2 = this.locals.length - 1; last2 >= 0 && this.locals[last2] == 0 && !TypeInfo.isTwoWords(this.locals[last2 - 1]); --last2) {
        }
        int size2 = ++last2;
        for (int i2 = 0; i2 < last2; ++i2) {
            if (!TypeInfo.isTwoWords(this.locals[i2])) continue;
            --size2;
        }
        int[] copy2 = new int[size2];
        int i3 = 0;
        int j2 = 0;
        while (i3 < size2) {
            copy2[i3] = this.locals[j2];
            if (TypeInfo.isTwoWords(this.locals[j2])) {
                ++j2;
            }
            ++i3;
            ++j2;
        }
        return copy2;
    }

    int[] getStack() {
        int[] copy2 = new int[this.stack.length];
        System.arraycopy(this.stack, 0, copy2, 0, this.stack.length);
        return copy2;
    }

    boolean merge(int[] locals, int localsTop, int[] stack, int stackTop, ConstantPool pool) {
        if (!this.isInitialized) {
            System.arraycopy(locals, 0, this.locals, 0, localsTop);
            this.stack = new int[stackTop];
            System.arraycopy(stack, 0, this.stack, 0, stackTop);
            this.isInitialized = true;
            return true;
        }
        if (this.locals.length == localsTop && this.stack.length == stackTop) {
            boolean localsChanged = this.mergeState(this.locals, locals, localsTop, pool);
            boolean stackChanged = this.mergeState(this.stack, stack, stackTop, pool);
            return localsChanged || stackChanged;
        }
        throw new IllegalArgumentException("bad merge attempt");
    }

    private boolean mergeState(int[] current, int[] incoming, int size2, ConstantPool pool) {
        boolean changed = false;
        for (int i2 = 0; i2 < size2; ++i2) {
            int currentType = current[i2];
            current[i2] = TypeInfo.merge(current[i2], incoming[i2], pool);
            if (currentType == current[i2]) continue;
            changed = true;
        }
        return changed;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    public String toString() {
        return "sb " + this.index;
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    void setInitialized(boolean b2) {
        this.isInitialized = b2;
    }

    boolean isInQueue() {
        return this.isInQueue;
    }

    void setInQueue(boolean b2) {
        this.isInQueue = b2;
    }
}

