/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public abstract class ES6Iterator
extends IdScriptableObject {
    protected boolean exhausted = false;
    private static final int Id_next = 1;
    private static final int Id_iterator = 2;
    private static final int Id_toStringTag = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    public static final String NEXT_METHOD = "next";
    public static final String DONE_PROPERTY = "done";
    public static final String VALUE_PROPERTY = "value";

    static void init(ScriptableObject scope, boolean sealed, IdScriptableObject prototype, String tag) {
        if (scope != null) {
            prototype.setParentScope(scope);
            prototype.setPrototype(ES6Iterator.getObjectPrototype(scope));
        }
        prototype.activatePrototypeMap(3);
        if (sealed) {
            prototype.sealObject();
        }
        if (scope != null) {
            scope.associateValue(tag, prototype);
        }
    }

    ES6Iterator() {
    }

    ES6Iterator(Scriptable scope) {
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        this.setParentScope(top);
        IdScriptableObject prototype = (IdScriptableObject)ScriptableObject.getTopScopeValue(top, this.getTag());
        this.setPrototype(prototype);
    }

    @Override
    protected void initPrototypeId(int id) {
        switch (id) {
            case 1: {
                this.initPrototypeMethod(this.getTag(), id, NEXT_METHOD, 0);
                return;
            }
            case 2: {
                this.initPrototypeMethod((Object)this.getTag(), id, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
                return;
            }
            case 3: {
                this.initPrototypeValue(3, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(this.getTag())) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        if (!(thisObj instanceof ES6Iterator)) {
            throw ES6Iterator.incompatibleCallError(f2);
        }
        ES6Iterator iterator2 = (ES6Iterator)thisObj;
        switch (id) {
            case 1: {
                return iterator2.next(cx, scope);
            }
            case 2: {
                return iterator2;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    protected int findPrototypeId(Symbol k2) {
        if (SymbolKey.ITERATOR.equals(k2)) {
            return 2;
        }
        if (SymbolKey.TO_STRING_TAG.equals(k2)) {
            return 3;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s2) {
        if (NEXT_METHOD.equals(s2)) {
            return 1;
        }
        return 0;
    }

    protected abstract boolean isDone(Context var1, Scriptable var2);

    protected abstract Object nextValue(Context var1, Scriptable var2);

    protected Object next(Context cx, Scriptable scope) {
        boolean done;
        Object value2 = Undefined.instance;
        boolean bl = done = this.isDone(cx, scope) || this.exhausted;
        if (!done) {
            value2 = this.nextValue(cx, scope);
        } else {
            this.exhausted = true;
        }
        return this.makeIteratorResult(cx, scope, done, value2);
    }

    protected abstract String getTag();

    private Scriptable makeIteratorResult(Context cx, Scriptable scope, boolean done, Object value2) {
        Scriptable iteratorResult = cx.newObject(scope);
        ScriptableObject.putProperty(iteratorResult, VALUE_PROPERTY, value2);
        ScriptableObject.putProperty(iteratorResult, DONE_PROPERTY, (Object)done);
        return iteratorResult;
    }
}

