/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class FunctionObject
extends BaseFunction {
    static final long serialVersionUID = -5332312783643935019L;
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    public static final int JAVA_UNSUPPORTED_TYPE = 0;
    public static final int JAVA_STRING_TYPE = 1;
    public static final int JAVA_INT_TYPE = 2;
    public static final int JAVA_BOOLEAN_TYPE = 3;
    public static final int JAVA_DOUBLE_TYPE = 4;
    public static final int JAVA_SCRIPTABLE_TYPE = 5;
    public static final int JAVA_OBJECT_TYPE = 6;
    MemberBox member;
    private String functionName;
    private transient byte[] typeTags;
    private int parmsLength;
    private transient boolean hasVoidReturn;
    private transient int returnTypeTag;
    private boolean isStatic;

    public FunctionObject(String name, Member methodOrConstructor, Scriptable scope) {
        if (methodOrConstructor instanceof Constructor) {
            this.member = new MemberBox((Constructor)methodOrConstructor);
            this.isStatic = true;
        } else {
            this.member = new MemberBox((Method)methodOrConstructor);
            this.isStatic = this.member.isStatic();
        }
        String methodName = this.member.getName();
        this.functionName = name;
        Class<?>[] types = this.member.argTypes;
        int arity = types.length;
        if (arity == 4 && (types[1].isArray() || types[2].isArray())) {
            if (types[1].isArray()) {
                if (!this.isStatic || types[0] != ScriptRuntime.ContextClass || types[1].getComponentType() != ScriptRuntime.ObjectClass || types[2] != ScriptRuntime.FunctionClass || types[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", methodName);
                }
                this.parmsLength = -2;
            } else {
                if (!this.isStatic || types[0] != ScriptRuntime.ContextClass || types[1] != ScriptRuntime.ScriptableClass || types[2].getComponentType() != ScriptRuntime.ObjectClass || types[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", methodName);
                }
                this.parmsLength = -1;
            }
        } else {
            this.parmsLength = arity;
            if (arity > 0) {
                this.typeTags = new byte[arity];
                for (int i2 = 0; i2 != arity; ++i2) {
                    int tag = FunctionObject.getTypeTag(types[i2]);
                    if (tag == 0) {
                        throw Context.reportRuntimeError2("msg.bad.parms", types[i2].getName(), methodName);
                    }
                    this.typeTags[i2] = (byte)tag;
                }
            }
        }
        if (this.member.isMethod()) {
            Method method2 = this.member.method();
            Class<?> returnType = method2.getReturnType();
            if (returnType == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(returnType);
            }
        } else {
            Class<?> ctorType = this.member.getDeclaringClass();
            if (!ScriptRuntime.ScriptableClass.isAssignableFrom(ctorType)) {
                throw Context.reportRuntimeError1("msg.bad.ctor.return", ctorType.getName());
            }
        }
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
    }

    public static int getTypeTag(Class<?> type2) {
        if (type2 == ScriptRuntime.StringClass) {
            return 1;
        }
        if (type2 == ScriptRuntime.IntegerClass || type2 == Integer.TYPE) {
            return 2;
        }
        if (type2 == ScriptRuntime.BooleanClass || type2 == Boolean.TYPE) {
            return 3;
        }
        if (type2 == ScriptRuntime.DoubleClass || type2 == Double.TYPE) {
            return 4;
        }
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(type2)) {
            return 5;
        }
        if (type2 == ScriptRuntime.ObjectClass) {
            return 6;
        }
        return 0;
    }

    public static Object convertArg(Context cx, Scriptable scope, Object arg, int typeTag) {
        switch (typeTag) {
            case 1: {
                if (arg instanceof String) {
                    return arg;
                }
                return ScriptRuntime.toString(arg);
            }
            case 2: {
                if (arg instanceof Integer) {
                    return arg;
                }
                return ScriptRuntime.toInt32(arg);
            }
            case 3: {
                if (arg instanceof Boolean) {
                    return arg;
                }
                return ScriptRuntime.toBoolean(arg) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                if (arg instanceof Double) {
                    return arg;
                }
                return new Double(ScriptRuntime.toNumber(arg));
            }
            case 5: {
                return ScriptRuntime.toObjectOrNull(cx, arg, scope);
            }
            case 6: {
                return arg;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getArity() {
        return this.parmsLength < 0 ? 1 : this.parmsLength;
    }

    @Override
    public int getLength() {
        return this.getArity();
    }

    @Override
    public String getFunctionName() {
        return this.functionName == null ? "" : this.functionName;
    }

    public Member getMethodOrConstructor() {
        if (this.member.isMethod()) {
            return this.member.method();
        }
        return this.member.ctor();
    }

    static Method findSingleMethod(Method[] methods2, String name) {
        Method found = null;
        int N2 = methods2.length;
        for (int i2 = 0; i2 != N2; ++i2) {
            Method method2 = methods2[i2];
            if (method2 == null || !name.equals(method2.getName())) continue;
            if (found != null) {
                throw Context.reportRuntimeError2("msg.no.overload", name, method2.getDeclaringClass().getName());
            }
            found = method2;
        }
        return found;
    }

    static Method[] getMethodList(Class<?> clazz) {
        Method[] methods2 = null;
        try {
            if (!sawSecurityException) {
                methods2 = clazz.getDeclaredMethods();
            }
        }
        catch (SecurityException e2) {
            sawSecurityException = true;
        }
        if (methods2 == null) {
            methods2 = clazz.getMethods();
        }
        int count2 = 0;
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            if (sawSecurityException ? methods2[i2].getDeclaringClass() != clazz : !Modifier.isPublic(methods2[i2].getModifiers())) {
                methods2[i2] = null;
                continue;
            }
            ++count2;
        }
        Method[] result2 = new Method[count2];
        int j2 = 0;
        for (int i3 = 0; i3 < methods2.length; ++i3) {
            if (methods2[i3] == null) continue;
            result2[j2++] = methods2[i3];
        }
        return result2;
    }

    public void addAsConstructor(Scriptable scope, Scriptable prototype) {
        this.initAsConstructor(scope, prototype);
        FunctionObject.defineProperty(scope, prototype.getClassName(), this, 2);
    }

    void initAsConstructor(Scriptable scope, Scriptable prototype) {
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
        this.setImmunePrototypeProperty(prototype);
        prototype.setParentScope(this);
        FunctionObject.defineProperty(prototype, "constructor", this, 7);
        this.setParentScope(scope);
    }

    @Deprecated
    public static Object convertArg(Context cx, Scriptable scope, Object arg, Class<?> desired) {
        int tag = FunctionObject.getTypeTag(desired);
        if (tag == 0) {
            throw Context.reportRuntimeError1("msg.cant.convert", desired.getName());
        }
        return FunctionObject.convertArg(cx, scope, arg, tag);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        Object result2;
        boolean checkMethodResult = false;
        int argsLength = args2.length;
        for (int i2 = 0; i2 < argsLength; ++i2) {
            if (!(args2[i2] instanceof ConsString)) continue;
            args2[i2] = args2[i2].toString();
        }
        if (this.parmsLength < 0) {
            if (this.parmsLength == -1) {
                Object[] invokeArgs = new Object[]{cx, thisObj, args2, this};
                result2 = this.member.invoke(null, invokeArgs);
                checkMethodResult = true;
            } else {
                boolean inNewExpr = thisObj == null;
                Boolean b2 = inNewExpr ? Boolean.TRUE : Boolean.FALSE;
                Object[] invokeArgs = new Object[]{cx, args2, this, b2};
                result2 = this.member.isCtor() ? this.member.newInstance(invokeArgs) : this.member.invoke(null, invokeArgs);
            }
        } else {
            Object arg;
            int i3;
            Object[] invokeArgs;
            Class<?> clazz;
            if (!this.isStatic && !(clazz = this.member.getDeclaringClass()).isInstance(thisObj)) {
                Scriptable parentScope;
                boolean compatible = false;
                if (thisObj == scope && scope != (parentScope = this.getParentScope()) && (compatible = clazz.isInstance(parentScope))) {
                    thisObj = parentScope;
                }
                if (!compatible) {
                    throw ScriptRuntime.typeError1("msg.incompat.call", this.functionName);
                }
            }
            if (this.parmsLength == argsLength) {
                invokeArgs = args2;
                for (i3 = 0; i3 != this.parmsLength; ++i3) {
                    arg = args2[i3];
                    Object converted = FunctionObject.convertArg(cx, scope, arg, this.typeTags[i3]);
                    if (arg == converted) continue;
                    if (invokeArgs == args2) {
                        invokeArgs = (Object[])args2.clone();
                    }
                    invokeArgs[i3] = converted;
                }
            } else if (this.parmsLength == 0) {
                invokeArgs = ScriptRuntime.emptyArgs;
            } else {
                invokeArgs = new Object[this.parmsLength];
                for (i3 = 0; i3 != this.parmsLength; ++i3) {
                    arg = i3 < argsLength ? args2[i3] : Undefined.instance;
                    invokeArgs[i3] = FunctionObject.convertArg(cx, scope, arg, this.typeTags[i3]);
                }
            }
            if (this.member.isMethod()) {
                result2 = this.member.invoke(thisObj, invokeArgs);
                checkMethodResult = true;
            } else {
                result2 = this.member.newInstance(invokeArgs);
            }
        }
        if (checkMethodResult) {
            if (this.hasVoidReturn) {
                result2 = Undefined.instance;
            } else if (this.returnTypeTag == 0) {
                result2 = cx.getWrapFactory().wrap(cx, scope, result2, null);
            }
        }
        return result2;
    }

    @Override
    public Scriptable createObject(Context cx, Scriptable scope) {
        Scriptable result2;
        if (this.member.isCtor() || this.parmsLength == -2) {
            return null;
        }
        try {
            result2 = (Scriptable)this.member.getDeclaringClass().newInstance();
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        result2.setPrototype(this.getClassPrototype());
        result2.setParentScope(this.getParentScope());
        return result2;
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.parmsLength > 0) {
            Class<?>[] types = this.member.argTypes;
            this.typeTags = new byte[this.parmsLength];
            for (int i2 = 0; i2 != this.parmsLength; ++i2) {
                this.typeTags[i2] = (byte)FunctionObject.getTypeTag(types[i2]);
            }
        }
        if (this.member.isMethod()) {
            Method method2 = this.member.method();
            Class<?> returnType = method2.getReturnType();
            if (returnType == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(returnType);
            }
        }
    }
}

