/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public final class JavaAdapter
implements IdFunctionCall {
    private static final Object FTAG = "JavaAdapter";
    private static final int Id_JavaAdapter = 1;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        JavaAdapter obj = new JavaAdapter();
        IdFunctionObject ctor = new IdFunctionObject(obj, FTAG, 1, "JavaAdapter", 1, scope);
        ctor.markAsConstructor(null);
        if (sealed) {
            ctor.sealObject();
        }
        ctor.exportAsScopeProperty();
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (f2.hasTag(FTAG) && f2.methodId() == 1) {
            return JavaAdapter.js_createAdapter(cx, scope, args2);
        }
        throw f2.unknown();
    }

    public static Object convertResult(Object result2, Class<?> c2) {
        if (result2 == Undefined.instance && c2 != ScriptRuntime.ObjectClass && c2 != ScriptRuntime.StringClass) {
            return null;
        }
        return Context.jsToJava(result2, c2);
    }

    public static Scriptable createAdapterWrapper(Scriptable obj, Object adapter) {
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        NativeJavaObject res = new NativeJavaObject(scope, adapter, null, true);
        res.setPrototype(obj);
        return res;
    }

    public static Object getAdapterSelf(Class<?> adapterClass, Object adapter) throws NoSuchFieldException, IllegalAccessException {
        Field self = adapterClass.getDeclaredField("self");
        return self.get(adapter);
    }

    static Object js_createAdapter(Context cx, Scriptable scope, Object[] args2) {
        Object arg;
        int classCount;
        int N2 = args2.length;
        if (N2 == 0) {
            throw ScriptRuntime.typeError0("msg.adapter.zero.args");
        }
        for (classCount = 0; classCount < N2 - 1 && !((arg = args2[classCount]) instanceof NativeObject); ++classCount) {
            if (arg instanceof NativeJavaClass) continue;
            throw ScriptRuntime.typeError2("msg.not.java.class.arg", String.valueOf(classCount), ScriptRuntime.toString(arg));
        }
        Class<?> superClass = null;
        Class[] intfs = new Class[classCount];
        int interfaceCount = 0;
        for (int i2 = 0; i2 < classCount; ++i2) {
            Class<?> c2 = ((NativeJavaClass)args2[i2]).getClassObject();
            if (!c2.isInterface()) {
                if (superClass != null) {
                    throw ScriptRuntime.typeError2("msg.only.one.super", superClass.getName(), c2.getName());
                }
                superClass = c2;
                continue;
            }
            intfs[interfaceCount++] = c2;
        }
        if (superClass == null) {
            superClass = ScriptRuntime.ObjectClass;
        }
        Class[] interfaces = new Class[interfaceCount];
        System.arraycopy(intfs, 0, interfaces, 0, interfaceCount);
        Scriptable obj = ScriptableObject.ensureScriptable(args2[classCount]);
        Class<?> adapterClass = JavaAdapter.getAdapterClass(scope, superClass, interfaces, obj);
        int argsCount = N2 - classCount - 1;
        try {
            Object unwrapped;
            Object adapter;
            if (argsCount > 0) {
                Object[] ctorArgs = new Object[argsCount + 2];
                ctorArgs[0] = obj;
                ctorArgs[1] = cx.getFactory();
                System.arraycopy(args2, classCount + 1, ctorArgs, 2, argsCount);
                NativeJavaClass classWrapper = new NativeJavaClass(scope, adapterClass, true);
                NativeJavaMethod ctors = classWrapper.members.ctors;
                int index = ctors.findCachedFunction(cx, ctorArgs);
                if (index < 0) {
                    String sig = NativeJavaMethod.scriptSignature(args2);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", adapterClass.getName(), sig);
                }
                adapter = NativeJavaClass.constructInternal(ctorArgs, ctors.methods[index]);
            } else {
                Class[] ctorParms = new Class[]{ScriptRuntime.ScriptableClass, ScriptRuntime.ContextFactoryClass};
                Object[] ctorArgs = new Object[]{obj, cx.getFactory()};
                adapter = adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
            }
            Object self = JavaAdapter.getAdapterSelf(adapterClass, adapter);
            if (self instanceof Wrapper && (unwrapped = ((Wrapper)self).unwrap()) instanceof Scriptable) {
                if (unwrapped instanceof ScriptableObject) {
                    ScriptRuntime.setObjectProtoAndParent((ScriptableObject)unwrapped, scope);
                }
                return unwrapped;
            }
            return self;
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    public static void writeAdapterObject(Object javaObject, ObjectOutputStream out2) throws IOException {
        Class<?> cl = javaObject.getClass();
        out2.writeObject(cl.getSuperclass().getName());
        Class<?>[] interfaces = cl.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            interfaceNames[i2] = interfaces[i2].getName();
        }
        out2.writeObject(interfaceNames);
        try {
            Object delegee = cl.getField("delegee").get(javaObject);
            out2.writeObject(delegee);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        throw new IOException();
    }

    public static Object readAdapterObject(Scriptable self, ObjectInputStream in) throws IOException, ClassNotFoundException {
        Context cx = Context.getCurrentContext();
        ContextFactory factory2 = cx != null ? cx.getFactory() : null;
        Class<?> superClass = Class.forName((String)in.readObject());
        String[] interfaceNames = (String[])in.readObject();
        Class[] interfaces = new Class[interfaceNames.length];
        for (int i2 = 0; i2 < interfaceNames.length; ++i2) {
            interfaces[i2] = Class.forName(interfaceNames[i2]);
        }
        Scriptable delegee = (Scriptable)in.readObject();
        Class<?> adapterClass = JavaAdapter.getAdapterClass(self, superClass, interfaces, delegee);
        Class[] ctorParms = new Class[]{ScriptRuntime.ContextFactoryClass, ScriptRuntime.ScriptableClass, ScriptRuntime.ScriptableClass};
        Object[] ctorArgs = new Object[]{factory2, delegee, self};
        try {
            return adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    private static ObjToIntMap getObjectFunctionNames(Scriptable obj) {
        Object[] ids = ScriptableObject.getPropertyIds(obj);
        ObjToIntMap map2 = new ObjToIntMap(ids.length);
        for (int i2 = 0; i2 != ids.length; ++i2) {
            String id;
            Object value2;
            if (!(ids[i2] instanceof String) || !((value2 = ScriptableObject.getProperty(obj, id = (String)ids[i2])) instanceof Function)) continue;
            Function f2 = (Function)value2;
            int length = ScriptRuntime.toInt32(ScriptableObject.getProperty((Scriptable)f2, "length"));
            if (length < 0) {
                length = 0;
            }
            map2.put(id, length);
        }
        return map2;
    }

    private static Class<?> getAdapterClass(Scriptable scope, Class<?> superClass, Class<?>[] interfaces, Scriptable obj) {
        ObjToIntMap names2;
        JavaAdapterSignature sig;
        ClassCache cache2 = ClassCache.get(scope);
        Map<JavaAdapterSignature, Class<?>> generated = cache2.getInterfaceAdapterCacheMap();
        Class<?> adapterClass = generated.get(sig = new JavaAdapterSignature(superClass, interfaces, names2 = JavaAdapter.getObjectFunctionNames(obj)));
        if (adapterClass == null) {
            String adapterName = "adapter" + cache2.newClassSerialNumber();
            byte[] code = JavaAdapter.createAdapterCode(names2, adapterName, superClass, interfaces, null);
            adapterClass = JavaAdapter.loadAdapterClass(adapterName, code);
            if (cache2.isCachingEnabled()) {
                generated.put(sig, adapterClass);
            }
        }
        return adapterClass;
    }

    public static byte[] createAdapterCode(ObjToIntMap functionNames, String adapterName, Class<?> superClass, Class<?>[] interfaces, String scriptClassName) {
        String methodKey;
        String methodSignature;
        Class<?>[] argTypes;
        String methodName;
        Constructor<?>[] ctors;
        ClassFileWriter cfw = new ClassFileWriter(adapterName, superClass.getName(), "<adapter>");
        cfw.addField("factory", "Lorg/mozilla/javascript/ContextFactory;", (short)17);
        cfw.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        cfw.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int interfacesCount = interfaces == null ? 0 : interfaces.length;
        for (int i2 = 0; i2 < interfacesCount; ++i2) {
            if (interfaces[i2] == null) continue;
            cfw.addInterface(interfaces[i2].getName());
        }
        String superName = superClass.getName().replace('.', '/');
        for (Constructor<?> ctor : ctors = superClass.getDeclaredConstructors()) {
            int mod = ctor.getModifiers();
            if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod)) continue;
            JavaAdapter.generateCtor(cfw, adapterName, superName, ctor);
        }
        JavaAdapter.generateSerialCtor(cfw, adapterName, superName);
        if (scriptClassName != null) {
            JavaAdapter.generateEmptyCtor(cfw, adapterName, superName, scriptClassName);
        }
        ObjToIntMap generatedOverrides = new ObjToIntMap();
        ObjToIntMap generatedMethods = new ObjToIntMap();
        for (int i3 = 0; i3 < interfacesCount; ++i3) {
            Method[] methods2 = interfaces[i3].getMethods();
            for (int j2 = 0; j2 < methods2.length; ++j2) {
                Method method2 = methods2[j2];
                int mods = method2.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
                methodName = method2.getName();
                argTypes = method2.getParameterTypes();
                if (!functionNames.has(methodName)) {
                    try {
                        superClass.getMethod(methodName, argTypes);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                methodSignature = JavaAdapter.getMethodSignature(method2, argTypes);
                methodKey = methodName + methodSignature;
                if (generatedOverrides.has(methodKey)) continue;
                JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method2.getReturnType(), true);
                generatedOverrides.put(methodKey, 0);
                generatedMethods.put(methodName, 0);
            }
        }
        Method[] methods3 = JavaAdapter.getOverridableMethods(superClass);
        for (int j3 = 0; j3 < methods3.length; ++j3) {
            Method method3 = methods3[j3];
            int mods = method3.getModifiers();
            boolean isAbstractMethod = Modifier.isAbstract(mods);
            methodName = method3.getName();
            if (!isAbstractMethod && !functionNames.has(methodName)) continue;
            argTypes = method3.getParameterTypes();
            methodSignature = JavaAdapter.getMethodSignature(method3, argTypes);
            methodKey = methodName + methodSignature;
            if (generatedOverrides.has(methodKey)) continue;
            JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method3.getReturnType(), true);
            generatedOverrides.put(methodKey, 0);
            generatedMethods.put(methodName, 0);
            if (isAbstractMethod) continue;
            JavaAdapter.generateSuper(cfw, adapterName, superName, methodName, methodSignature, argTypes, method3.getReturnType());
        }
        ObjToIntMap.Iterator iter = new ObjToIntMap.Iterator(functionNames);
        iter.start();
        while (!iter.done()) {
            String functionName = (String)iter.getKey();
            if (!generatedMethods.has(functionName)) {
                int length = iter.getValue();
                Class[] parms = new Class[length];
                for (int k2 = 0; k2 < length; ++k2) {
                    parms[k2] = ScriptRuntime.ObjectClass;
                }
                JavaAdapter.generateMethod(cfw, adapterName, functionName, parms, ScriptRuntime.ObjectClass, false);
            }
            iter.next();
        }
        return cfw.toByteArray();
    }

    static Method[] getOverridableMethods(Class<?> clazz) {
        Class<?> c2;
        ArrayList<Method> list = new ArrayList<Method>();
        HashSet<String> skip = new HashSet<String>();
        for (c2 = clazz; c2 != null; c2 = c2.getSuperclass()) {
            JavaAdapter.appendOverridableMethods(c2, list, skip);
        }
        for (c2 = clazz; c2 != null; c2 = c2.getSuperclass()) {
            for (Class<?> intf : c2.getInterfaces()) {
                JavaAdapter.appendOverridableMethods(intf, list, skip);
            }
        }
        return list.toArray(new Method[list.size()]);
    }

    private static void appendOverridableMethods(Class<?> c2, ArrayList<Method> list, HashSet<String> skip) {
        Method[] methods2 = c2.getDeclaredMethods();
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            int mods;
            String methodKey = methods2[i2].getName() + JavaAdapter.getMethodSignature(methods2[i2], methods2[i2].getParameterTypes());
            if (skip.contains(methodKey) || Modifier.isStatic(mods = methods2[i2].getModifiers())) continue;
            if (Modifier.isFinal(mods)) {
                skip.add(methodKey);
                continue;
            }
            if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods)) continue;
            list.add(methods2[i2]);
            skip.add(methodKey);
        }
    }

    static Class<?> loadAdapterClass(String className, byte[] classBytes) {
        Object staticDomain;
        Class<?> domainClass = SecurityController.getStaticSecurityDomainClass();
        if (domainClass == CodeSource.class || domainClass == ProtectionDomain.class) {
            ProtectionDomain protectionDomain = SecurityUtilities.getScriptProtectionDomain();
            if (protectionDomain == null) {
                protectionDomain = JavaAdapter.class.getProtectionDomain();
            }
            staticDomain = domainClass == CodeSource.class ? (protectionDomain == null ? null : protectionDomain.getCodeSource()) : protectionDomain;
        } else {
            staticDomain = null;
        }
        GeneratedClassLoader loader = SecurityController.createLoader(null, staticDomain);
        Class<?> result2 = loader.defineClass(className, classBytes);
        loader.linkClass(result2);
        return result2;
    }

    public static Function getFunction(Scriptable obj, String functionName) {
        Object x = ScriptableObject.getProperty(obj, functionName);
        if (x == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(x instanceof Function)) {
            throw ScriptRuntime.notFunctionError(x, functionName);
        }
        return (Function)x;
    }

    public static Object callMethod(ContextFactory factory2, final Scriptable thisObj, final Function f2, final Object[] args2, final long argsToWrap) {
        if (f2 == null) {
            return null;
        }
        if (factory2 == null) {
            factory2 = ContextFactory.getGlobal();
        }
        final Scriptable scope = f2.getParentScope();
        if (argsToWrap == 0L) {
            return Context.call(factory2, f2, scope, thisObj, args2);
        }
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return JavaAdapter.doCall(cx, scope, thisObj, f2, args2, argsToWrap);
        }
        return factory2.call(new ContextAction(){

            @Override
            public Object run(Context cx) {
                return JavaAdapter.doCall(cx, scope, thisObj, f2, args2, argsToWrap);
            }
        });
    }

    private static Object doCall(Context cx, Scriptable scope, Scriptable thisObj, Function f2, Object[] args2, long argsToWrap) {
        for (int i2 = 0; i2 != args2.length; ++i2) {
            Object arg;
            if (0L == (argsToWrap & (long)(1 << i2)) || (arg = args2[i2]) instanceof Scriptable) continue;
            args2[i2] = cx.getWrapFactory().wrap(cx, scope, arg, null);
        }
        return f2.call(cx, scope, thisObj, args2);
    }

    public static Scriptable runScript(final Script script) {
        return (Scriptable)ContextFactory.getGlobal().call(new ContextAction(){

            @Override
            public Object run(Context cx) {
                ScriptableObject global = ScriptRuntime.getGlobal(cx);
                script.exec(cx, global);
                return global;
            }
        });
    }

    private static void generateCtor(ClassFileWriter cfw, String adapterName, String superName, Constructor<?> superCtor) {
        short locals = 3;
        Class<?>[] parameters2 = superCtor.getParameterTypes();
        if (parameters2.length == 0) {
            cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/ContextFactory;)V", (short)1);
            cfw.add(42);
            cfw.addInvoke(183, superName, "<init>", "()V");
        } else {
            StringBuilder sig = new StringBuilder("(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/ContextFactory;");
            int marker = sig.length();
            for (Class<?> c2 : parameters2) {
                JavaAdapter.appendTypeString(sig, c2);
            }
            sig.append(")V");
            cfw.startMethod("<init>", sig.toString(), (short)1);
            cfw.add(42);
            short paramOffset = 3;
            for (Class<?> parameter : parameters2) {
                paramOffset = (short)(paramOffset + JavaAdapter.generatePushParam(cfw, paramOffset, parameter));
            }
            locals = paramOffset;
            sig.delete(1, marker);
            cfw.addInvoke(183, superName, "<init>", sig.toString());
        }
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(44);
        cfw.add(181, adapterName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(43);
        cfw.add(42);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add(181, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod(locals);
    }

    private static void generateSerialCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(44);
        cfw.add(181, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(45);
        cfw.add(181, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod((short)4);
    }

    private static void generateEmptyCtor(ClassFileWriter cfw, String adapterName, String superName, String scriptClassName) {
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.add(42);
        cfw.add(1);
        cfw.add(181, adapterName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(187, scriptClassName);
        cfw.add(89);
        cfw.addInvoke(183, scriptClassName, "<init>", "()V");
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "runScript", "(Lorg/mozilla/javascript/Script;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add(76);
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(43);
        cfw.add(42);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add(181, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod((short)2);
    }

    static void generatePushWrappedArgs(ClassFileWriter cfw, Class<?>[] argTypes, int arrayLength) {
        cfw.addPush(arrayLength);
        cfw.add(189, "java/lang/Object");
        int paramOffset = 1;
        for (int i2 = 0; i2 != argTypes.length; ++i2) {
            cfw.add(89);
            cfw.addPush(i2);
            paramOffset += JavaAdapter.generateWrapArg(cfw, paramOffset, argTypes[i2]);
            cfw.add(83);
        }
    }

    private static int generateWrapArg(ClassFileWriter cfw, int paramOffset, Class<?> argType) {
        int size2 = 1;
        if (!argType.isPrimitive()) {
            cfw.add(25, paramOffset);
        } else if (argType == Boolean.TYPE) {
            cfw.add(187, "java/lang/Boolean");
            cfw.add(89);
            cfw.add(21, paramOffset);
            cfw.addInvoke(183, "java/lang/Boolean", "<init>", "(Z)V");
        } else if (argType == Character.TYPE) {
            cfw.add(21, paramOffset);
            cfw.addInvoke(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
        } else {
            cfw.add(187, "java/lang/Double");
            cfw.add(89);
            String typeName2 = argType.getName();
            switch (typeName2.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add(21, paramOffset);
                    cfw.add(135);
                    break;
                }
                case 'l': {
                    cfw.add(22, paramOffset);
                    cfw.add(138);
                    size2 = 2;
                    break;
                }
                case 'f': {
                    cfw.add(23, paramOffset);
                    cfw.add(141);
                    break;
                }
                case 'd': {
                    cfw.add(24, paramOffset);
                    size2 = 2;
                }
            }
            cfw.addInvoke(183, "java/lang/Double", "<init>", "(D)V");
        }
        return size2;
    }

    static void generateReturnResult(ClassFileWriter cfw, Class<?> retType, boolean callConvertResult) {
        if (retType == Void.TYPE) {
            cfw.add(87);
            cfw.add(177);
        } else if (retType == Boolean.TYPE) {
            cfw.addInvoke(184, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)Z");
            cfw.add(172);
        } else if (retType == Character.TYPE) {
            cfw.addInvoke(184, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
            cfw.add(3);
            cfw.addInvoke(182, "java/lang/String", "charAt", "(I)C");
            cfw.add(172);
        } else if (retType.isPrimitive()) {
            cfw.addInvoke(184, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)D");
            String typeName2 = retType.getName();
            switch (typeName2.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add(142);
                    cfw.add(172);
                    break;
                }
                case 'l': {
                    cfw.add(143);
                    cfw.add(173);
                    break;
                }
                case 'f': {
                    cfw.add(144);
                    cfw.add(174);
                    break;
                }
                case 'd': {
                    cfw.add(175);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + retType.toString());
                }
            }
        } else {
            String retTypeStr = retType.getName();
            if (callConvertResult) {
                cfw.addLoadConstant(retTypeStr);
                cfw.addInvoke(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            }
            cfw.add(192, retTypeStr);
            cfw.add(176);
        }
    }

    private static void generateMethod(ClassFileWriter cfw, String genName, String methodName, Class<?>[] parms, Class<?> returnType, boolean convertResult) {
        StringBuilder sb = new StringBuilder();
        int paramsEnd = JavaAdapter.appendMethodSignature(parms, returnType, sb);
        String methodSignature = sb.toString();
        cfw.startMethod(methodName, methodSignature, (short)1);
        cfw.add(42);
        cfw.add(180, genName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(180, genName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(180, genName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.addPush(methodName);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "getFunction", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Function;");
        JavaAdapter.generatePushWrappedArgs(cfw, parms, parms.length);
        if (parms.length > 64) {
            throw Context.reportRuntimeError0("JavaAdapter can not subclass methods with more then 64 arguments.");
        }
        long convertionMask = 0L;
        for (int i2 = 0; i2 != parms.length; ++i2) {
            if (parms[i2].isPrimitive()) continue;
            convertionMask |= (long)(1 << i2);
        }
        cfw.addPush(convertionMask);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Function;[Ljava/lang/Object;J)Ljava/lang/Object;");
        JavaAdapter.generateReturnResult(cfw, returnType, convertResult);
        cfw.stopMethod((short)paramsEnd);
    }

    private static int generatePushParam(ClassFileWriter cfw, int paramOffset, Class<?> paramType) {
        if (!paramType.isPrimitive()) {
            cfw.addALoad(paramOffset);
            return 1;
        }
        String typeName2 = paramType.getName();
        switch (typeName2.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                cfw.addILoad(paramOffset);
                return 1;
            }
            case 'l': {
                cfw.addLLoad(paramOffset);
                return 2;
            }
            case 'f': {
                cfw.addFLoad(paramOffset);
                return 1;
            }
            case 'd': {
                cfw.addDLoad(paramOffset);
                return 2;
            }
        }
        throw Kit.codeBug();
    }

    private static void generatePopResult(ClassFileWriter cfw, Class<?> retType) {
        if (retType.isPrimitive()) {
            String typeName2 = retType.getName();
            switch (typeName2.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    cfw.add(172);
                    break;
                }
                case 'l': {
                    cfw.add(173);
                    break;
                }
                case 'f': {
                    cfw.add(174);
                    break;
                }
                case 'd': {
                    cfw.add(175);
                }
            }
        } else {
            cfw.add(176);
        }
    }

    private static void generateSuper(ClassFileWriter cfw, String genName, String superName, String methodName, String methodSignature, Class<?>[] parms, Class<?> returnType) {
        cfw.startMethod("super$" + methodName, methodSignature, (short)1);
        cfw.add(25, 0);
        int paramOffset = 1;
        for (Class<?> parm : parms) {
            paramOffset += JavaAdapter.generatePushParam(cfw, paramOffset, parm);
        }
        cfw.addInvoke(183, superName, methodName, methodSignature);
        Class<?> retType = returnType;
        if (!retType.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(cfw, retType);
        } else {
            cfw.add(177);
        }
        cfw.stopMethod((short)(paramOffset + 1));
    }

    private static String getMethodSignature(Method method2, Class<?>[] argTypes) {
        StringBuilder sb = new StringBuilder();
        JavaAdapter.appendMethodSignature(argTypes, method2.getReturnType(), sb);
        return sb.toString();
    }

    static int appendMethodSignature(Class<?>[] argTypes, Class<?> returnType, StringBuilder sb) {
        sb.append('(');
        int firstLocal = 1 + argTypes.length;
        for (Class<?> type2 : argTypes) {
            JavaAdapter.appendTypeString(sb, type2);
            if (type2 != Long.TYPE && type2 != Double.TYPE) continue;
            ++firstLocal;
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, returnType);
        return firstLocal;
    }

    private static StringBuilder appendTypeString(StringBuilder sb, Class<?> type2) {
        while (type2.isArray()) {
            sb.append('[');
            type2 = type2.getComponentType();
        }
        if (type2.isPrimitive()) {
            char typeLetter;
            if (type2 == Boolean.TYPE) {
                typeLetter = 'Z';
            } else if (type2 == Long.TYPE) {
                typeLetter = 'J';
            } else {
                String typeName2 = type2.getName();
                typeLetter = Character.toUpperCase(typeName2.charAt(0));
            }
            sb.append(typeLetter);
        } else {
            sb.append('L');
            sb.append(type2.getName().replace('.', '/'));
            sb.append(';');
        }
        return sb;
    }

    static int[] getArgsToConvert(Class<?>[] argTypes) {
        int count2 = 0;
        for (int i2 = 0; i2 != argTypes.length; ++i2) {
            if (argTypes[i2].isPrimitive()) continue;
            ++count2;
        }
        if (count2 == 0) {
            return null;
        }
        int[] array = new int[count2];
        count2 = 0;
        for (int i3 = 0; i3 != argTypes.length; ++i3) {
            if (argTypes[i3].isPrimitive()) continue;
            array[count2++] = i3;
        }
        return array;
    }

    static class JavaAdapterSignature {
        Class<?> superClass;
        Class<?>[] interfaces;
        ObjToIntMap names;

        JavaAdapterSignature(Class<?> superClass, Class<?>[] interfaces, ObjToIntMap names2) {
            this.superClass = superClass;
            this.interfaces = interfaces;
            this.names = names2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JavaAdapterSignature)) {
                return false;
            }
            JavaAdapterSignature sig = (JavaAdapterSignature)obj;
            if (this.superClass != sig.superClass) {
                return false;
            }
            if (this.interfaces != sig.interfaces) {
                if (this.interfaces.length != sig.interfaces.length) {
                    return false;
                }
                for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                    if (this.interfaces[i2] == sig.interfaces[i2]) continue;
                    return false;
                }
            }
            if (this.names.size() != sig.names.size()) {
                return false;
            }
            ObjToIntMap.Iterator iter = new ObjToIntMap.Iterator(this.names);
            iter.start();
            while (!iter.done()) {
                String name = (String)iter.getKey();
                int arity = iter.getValue();
                if (arity != sig.names.get(name, arity + 1)) {
                    return false;
                }
                iter.next();
            }
            return true;
        }

        public int hashCode() {
            return this.superClass.hashCode() + Arrays.hashCode(this.interfaces) ^ this.names.size();
        }
    }
}

