/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.VMBridge;

final class MemberBox
implements Serializable {
    static final long serialVersionUID = 6358550398665688245L;
    private transient Member memberObject;
    transient Class<?>[] argTypes;
    transient Object delegateTo;
    transient boolean vararg;
    private static final Class<?>[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    MemberBox(Method method2) {
        this.init(method2);
    }

    MemberBox(Constructor<?> constructor) {
        this.init(constructor);
    }

    private void init(Method method2) {
        this.memberObject = method2;
        this.argTypes = method2.getParameterTypes();
        this.vararg = VMBridge.instance.isVarArgs(method2);
    }

    private void init(Constructor<?> constructor) {
        this.memberObject = constructor;
        this.argTypes = constructor.getParameterTypes();
        this.vararg = VMBridge.instance.isVarArgs(constructor);
    }

    Method method() {
        return (Method)this.memberObject;
    }

    Constructor<?> ctor() {
        return (Constructor)this.memberObject;
    }

    Member member() {
        return this.memberObject;
    }

    boolean isMethod() {
        return this.memberObject instanceof Method;
    }

    boolean isCtor() {
        return this.memberObject instanceof Constructor;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.memberObject.getModifiers());
    }

    String getName() {
        return this.memberObject.getName();
    }

    Class<?> getDeclaringClass() {
        return this.memberObject.getDeclaringClass();
    }

    String toJavaDeclaration() {
        StringBuilder sb = new StringBuilder();
        if (this.isMethod()) {
            Method method2 = this.method();
            sb.append(method2.getReturnType());
            sb.append(' ');
            sb.append(method2.getName());
        } else {
            Constructor<?> ctor = this.ctor();
            String name = ctor.getDeclaringClass().getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0) {
                name = name.substring(lastDot + 1);
            }
            sb.append(name);
        }
        sb.append(JavaMembers.liveConnectSignature(this.argTypes));
        return sb.toString();
    }

    public String toString() {
        return this.memberObject.toString();
    }

    Object invoke(Object target, Object[] args2) {
        Method method2 = this.method();
        try {
            try {
                return method2.invoke(target, args2);
            }
            catch (IllegalAccessException ex) {
                Method accessible = MemberBox.searchAccessibleMethod(method2, this.argTypes);
                if (accessible != null) {
                    this.memberObject = accessible;
                    method2 = accessible;
                } else if (!VMBridge.instance.tryToMakeAccessible(method2)) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
                return method2.invoke(target, args2);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable e2 = ite;
            while ((e2 = e2.getTargetException()) instanceof InvocationTargetException) {
            }
            if (e2 instanceof ContinuationPending) {
                throw (ContinuationPending)e2;
            }
            throw Context.throwAsScriptRuntimeEx(e2);
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    Object newInstance(Object[] args2) {
        Constructor<?> ctor = this.ctor();
        try {
            try {
                return ctor.newInstance(args2);
            }
            catch (IllegalAccessException ex) {
                if (!VMBridge.instance.tryToMakeAccessible(ctor)) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
                return ctor.newInstance(args2);
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    private static Method searchAccessibleMethod(Method method2, Class<?>[] params) {
        Class<?> c2;
        int modifiers = method2.getModifiers();
        if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isPublic((c2 = method2.getDeclaringClass()).getModifiers())) {
            String name = method2.getName();
            Class<?>[] intfs = c2.getInterfaces();
            int N2 = intfs.length;
            for (int i2 = 0; i2 != N2; ++i2) {
                Class<?> intf = intfs[i2];
                if (!Modifier.isPublic(intf.getModifiers())) continue;
                try {
                    return intf.getMethod(name, params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            while ((c2 = c2.getSuperclass()) != null) {
                if (!Modifier.isPublic(c2.getModifiers())) continue;
                try {
                    Method m4 = c2.getMethod(name, params);
                    int mModifiers = m4.getModifiers();
                    if (!Modifier.isPublic(mModifiers) || Modifier.isStatic(mModifiers)) continue;
                    return m4;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Member member = MemberBox.readMember(in);
        if (member instanceof Method) {
            this.init((Method)member);
        } else {
            this.init((Constructor)member);
        }
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.defaultWriteObject();
        MemberBox.writeMember(out2, this.memberObject);
    }

    private static void writeMember(ObjectOutputStream out2, Member member) throws IOException {
        if (member == null) {
            out2.writeBoolean(false);
            return;
        }
        out2.writeBoolean(true);
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        out2.writeBoolean(member instanceof Method);
        out2.writeObject(member.getName());
        out2.writeObject(member.getDeclaringClass());
        if (member instanceof Method) {
            MemberBox.writeParameters(out2, ((Method)member).getParameterTypes());
        } else {
            MemberBox.writeParameters(out2, ((Constructor)member).getParameterTypes());
        }
    }

    private static Member readMember(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!in.readBoolean()) {
            return null;
        }
        boolean isMethod = in.readBoolean();
        String name = (String)in.readObject();
        Class declaring = (Class)in.readObject();
        Class<?>[] parms = MemberBox.readParameters(in);
        try {
            if (isMethod) {
                return declaring.getMethod(name, parms);
            }
            return declaring.getConstructor(parms);
        }
        catch (NoSuchMethodException e2) {
            throw new IOException("Cannot find member: " + e2);
        }
    }

    private static void writeParameters(ObjectOutputStream out2, Class<?>[] parms) throws IOException {
        out2.writeShort(parms.length);
        block0: for (int i2 = 0; i2 < parms.length; ++i2) {
            Class<?> parm = parms[i2];
            boolean primitive = parm.isPrimitive();
            out2.writeBoolean(primitive);
            if (!primitive) {
                out2.writeObject(parm);
                continue;
            }
            for (int j2 = 0; j2 < primitives.length; ++j2) {
                if (!parm.equals(primitives[j2])) continue;
                out2.writeByte(j2);
                continue block0;
            }
            throw new IllegalArgumentException("Primitive " + parm + " not found");
        }
    }

    private static Class<?>[] readParameters(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class[] result2 = new Class[in.readShort()];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = !in.readBoolean() ? (Class)in.readObject() : primitives[in.readByte()];
        }
        return result2;
    }
}

