/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Sorting;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.regexp.NativeRegExp;

public class NativeArray
extends IdScriptableObject
implements List {
    static final long serialVersionUID = 7331366857676127338L;
    private static final Object ARRAY_TAG = "Array";
    private static final Integer NEGATIVE_ONE = -1;
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final Comparator<Object> STRING_COMPARATOR = new StringLikeComparator();
    private static final Comparator<Object> DEFAULT_COMPARATOR = new ElementComparator();
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int Id_indexOf = 15;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_forEach = 19;
    private static final int Id_map = 20;
    private static final int Id_some = 21;
    private static final int Id_find = 22;
    private static final int Id_findIndex = 23;
    private static final int Id_reduce = 24;
    private static final int Id_reduceRight = 25;
    private static final int SymbolId_iterator = 26;
    private static final int MAX_PROTOTYPE_ID = 26;
    private static final int ConstructorId_join = -5;
    private static final int ConstructorId_reverse = -6;
    private static final int ConstructorId_sort = -7;
    private static final int ConstructorId_push = -8;
    private static final int ConstructorId_pop = -9;
    private static final int ConstructorId_shift = -10;
    private static final int ConstructorId_unshift = -11;
    private static final int ConstructorId_splice = -12;
    private static final int ConstructorId_concat = -13;
    private static final int ConstructorId_slice = -14;
    private static final int ConstructorId_indexOf = -15;
    private static final int ConstructorId_lastIndexOf = -16;
    private static final int ConstructorId_every = -17;
    private static final int ConstructorId_filter = -18;
    private static final int ConstructorId_forEach = -19;
    private static final int ConstructorId_map = -20;
    private static final int ConstructorId_some = -21;
    private static final int ConstructorId_find = -22;
    private static final int ConstructorId_findIndex = -23;
    private static final int ConstructorId_reduce = -24;
    private static final int ConstructorId_reduceRight = -25;
    private static final int ConstructorId_isArray = -26;
    private long length;
    private int lengthAttr = 6;
    private Object[] dense;
    private boolean denseOnly;
    private static int maximumInitialCapacity = 10000;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final double GROW_FACTOR = 1.5;
    private static final int MAX_PRE_GROW_SIZE = 0x55555554;

    static void init(Scriptable scope, boolean sealed) {
        NativeArray obj = new NativeArray(0L);
        obj.exportAsJSClass(26, scope, sealed);
    }

    static int getMaximumInitialCapacity() {
        return maximumInitialCapacity;
    }

    static void setMaximumInitialCapacity(int maximumInitialCapacity) {
        NativeArray.maximumInitialCapacity = maximumInitialCapacity;
    }

    public NativeArray(long lengthArg) {
        boolean bl = this.denseOnly = lengthArg <= (long)maximumInitialCapacity;
        if (this.denseOnly) {
            int intLength = (int)lengthArg;
            if (intLength < 10) {
                intLength = 10;
            }
            this.dense = new Object[intLength];
            Arrays.fill(this.dense, Scriptable.NOT_FOUND);
        }
        this.length = lengthArg;
    }

    public NativeArray(Object[] array) {
        this.denseOnly = true;
        this.dense = array;
        this.length = array.length;
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected void setInstanceIdAttributes(int id, int attr) {
        if (id == 1) {
            this.lengthAttr = attr;
        }
    }

    @Override
    protected int findInstanceIdInfo(String s2) {
        if (s2.equals("length")) {
            return NativeArray.instanceIdInfo(this.lengthAttr, 1);
        }
        return super.findInstanceIdInfo(s2);
    }

    @Override
    protected String getInstanceIdName(int id) {
        if (id == 1) {
            return "length";
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        if (id == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected void setInstanceIdValue(int id, Object value2) {
        if (id == 1) {
            this.setLength(value2);
            return;
        }
        super.setInstanceIdValue(id, value2);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -5, "join", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -6, "reverse", 0);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -7, "sort", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -8, "push", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -9, "pop", 0);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -10, "shift", 0);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -11, "unshift", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -12, "splice", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -13, "concat", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -14, "slice", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -15, "indexOf", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -16, "lastIndexOf", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -17, "every", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -18, "filter", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -19, "forEach", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -20, "map", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -21, "some", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -22, "find", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -23, "findIndex", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -24, "reduce", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -25, "reduceRight", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -26, "isArray", 1);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        if (id == 26) {
            this.initPrototypeMethod(ARRAY_TAG, id, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 1;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s2 = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s2 = "toLocaleString";
                break;
            }
            case 4: {
                arity = 0;
                s2 = "toSource";
                break;
            }
            case 5: {
                arity = 1;
                s2 = "join";
                break;
            }
            case 6: {
                arity = 0;
                s2 = "reverse";
                break;
            }
            case 7: {
                arity = 1;
                s2 = "sort";
                break;
            }
            case 8: {
                arity = 1;
                s2 = "push";
                break;
            }
            case 9: {
                arity = 0;
                s2 = "pop";
                break;
            }
            case 10: {
                arity = 0;
                s2 = "shift";
                break;
            }
            case 11: {
                arity = 1;
                s2 = "unshift";
                break;
            }
            case 12: {
                arity = 2;
                s2 = "splice";
                break;
            }
            case 13: {
                arity = 1;
                s2 = "concat";
                break;
            }
            case 14: {
                arity = 2;
                s2 = "slice";
                break;
            }
            case 15: {
                arity = 1;
                s2 = "indexOf";
                break;
            }
            case 16: {
                arity = 1;
                s2 = "lastIndexOf";
                break;
            }
            case 17: {
                arity = 1;
                s2 = "every";
                break;
            }
            case 18: {
                arity = 1;
                s2 = "filter";
                break;
            }
            case 19: {
                arity = 1;
                s2 = "forEach";
                break;
            }
            case 20: {
                arity = 1;
                s2 = "map";
                break;
            }
            case 21: {
                arity = 1;
                s2 = "some";
                break;
            }
            case 22: {
                arity = 1;
                s2 = "find";
                break;
            }
            case 23: {
                arity = 1;
                s2 = "findIndex";
                break;
            }
            case 24: {
                arity = 1;
                s2 = "reduce";
                break;
            }
            case 25: {
                arity = 1;
                s2 = "reduceRight";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, id, s2, fnName, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(ARRAY_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        block23: while (true) {
            switch (id) {
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    if (args2.length > 0) {
                        thisObj = ScriptRuntime.toObject(cx, scope, args2[0]);
                        Object[] newArgs = new Object[args2.length - 1];
                        for (int i2 = 0; i2 < newArgs.length; ++i2) {
                            newArgs[i2] = args2[i2 + 1];
                        }
                        args2 = newArgs;
                    }
                    id = -id;
                    continue block23;
                }
                case -26: {
                    return args2.length > 0 && NativeArray.js_isArray(args2[0]);
                }
                case 1: {
                    boolean inNewExpr;
                    boolean bl = inNewExpr = thisObj == null;
                    if (!inNewExpr) {
                        return f2.construct(cx, scope, args2);
                    }
                    return NativeArray.jsConstructor(cx, scope, args2);
                }
                case 2: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, cx.hasFeature(4), false);
                }
                case 3: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, false, true);
                }
                case 4: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, true, false);
                }
                case 5: {
                    return NativeArray.js_join(cx, thisObj, args2);
                }
                case 6: {
                    return NativeArray.js_reverse(cx, thisObj, args2);
                }
                case 7: {
                    return NativeArray.js_sort(cx, scope, thisObj, args2);
                }
                case 8: {
                    return NativeArray.js_push(cx, thisObj, args2);
                }
                case 9: {
                    return NativeArray.js_pop(cx, thisObj, args2);
                }
                case 10: {
                    return NativeArray.js_shift(cx, thisObj, args2);
                }
                case 11: {
                    return NativeArray.js_unshift(cx, thisObj, args2);
                }
                case 12: {
                    return NativeArray.js_splice(cx, scope, thisObj, args2);
                }
                case 13: {
                    return NativeArray.js_concat(cx, scope, thisObj, args2);
                }
                case 14: {
                    return this.js_slice(cx, thisObj, args2);
                }
                case 15: {
                    return NativeArray.js_indexOf(cx, thisObj, args2);
                }
                case 16: {
                    return NativeArray.js_lastIndexOf(cx, thisObj, args2);
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    return NativeArray.iterativeMethod(cx, f2, scope, thisObj, args2);
                }
                case 24: 
                case 25: {
                    return NativeArray.reduceMethod(cx, id, scope, thisObj, args2);
                }
                case 26: {
                    return new NativeArrayIterator(scope, thisObj);
                }
            }
            break;
        }
        throw new IllegalArgumentException("Array.prototype has no method: " + f2.getFunctionName());
    }

    @Override
    public Object get(int index, Scriptable start2) {
        if (!this.denseOnly && this.isGetterOrSetter(null, index, false)) {
            return super.get(index, start2);
        }
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index];
        }
        return super.get(index, start2);
    }

    @Override
    public boolean has(int index, Scriptable start2) {
        if (!this.denseOnly && this.isGetterOrSetter(null, index, false)) {
            return super.has(index, start2);
        }
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index] != NOT_FOUND;
        }
        return super.has(index, start2);
    }

    private static long toArrayIndex(Object id) {
        if (id instanceof String) {
            return NativeArray.toArrayIndex((String)id);
        }
        if (id instanceof Number) {
            return NativeArray.toArrayIndex(((Number)id).doubleValue());
        }
        return -1L;
    }

    private static long toArrayIndex(String id) {
        long index = NativeArray.toArrayIndex(ScriptRuntime.toNumber(id));
        if (Long.toString(index).equals(id)) {
            return index;
        }
        return -1L;
    }

    private static long toArrayIndex(double d2) {
        long index;
        if (d2 == d2 && (double)(index = ScriptRuntime.toUint32(d2)) == d2 && index != 0xFFFFFFFFL) {
            return index;
        }
        return -1L;
    }

    private static int toDenseIndex(Object id) {
        long index = NativeArray.toArrayIndex(id);
        return 0L <= index && index < Integer.MAX_VALUE ? (int)index : -1;
    }

    @Override
    public void put(String id, Scriptable start2, Object value2) {
        long index;
        super.put(id, start2, value2);
        if (start2 == this && (index = NativeArray.toArrayIndex(id)) >= this.length) {
            this.length = index + 1L;
            this.denseOnly = false;
        }
    }

    private boolean ensureCapacity(int capacity) {
        if (capacity > this.dense.length) {
            if (capacity > 0x55555554) {
                this.denseOnly = false;
                return false;
            }
            capacity = Math.max(capacity, (int)((double)this.dense.length * 1.5));
            Object[] newDense = new Object[capacity];
            System.arraycopy(this.dense, 0, newDense, 0, this.dense.length);
            Arrays.fill(newDense, this.dense.length, newDense.length, Scriptable.NOT_FOUND);
            this.dense = newDense;
        }
        return true;
    }

    @Override
    public void put(int index, Scriptable start2, Object value2) {
        if (!(start2 != this || this.isSealed() || this.dense == null || 0 > index || !this.denseOnly && this.isGetterOrSetter(null, index, true))) {
            if (!this.isExtensible() && this.length <= (long)index) {
                return;
            }
            if (index < this.dense.length) {
                this.dense[index] = value2;
                if (this.length <= (long)index) {
                    this.length = (long)index + 1L;
                }
                return;
            }
            if (this.denseOnly && (double)index < (double)this.dense.length * 1.5 && this.ensureCapacity(index + 1)) {
                this.dense[index] = value2;
                this.length = (long)index + 1L;
                return;
            }
            this.denseOnly = false;
        }
        super.put(index, start2, value2);
        if (start2 == this && (this.lengthAttr & 1) == 0 && this.length <= (long)index) {
            this.length = (long)index + 1L;
        }
    }

    @Override
    public void delete(int index) {
        if (!(this.dense == null || 0 > index || index >= this.dense.length || this.isSealed() || !this.denseOnly && this.isGetterOrSetter(null, index, true))) {
            this.dense[index] = NOT_FOUND;
        } else {
            super.delete(index);
        }
    }

    @Override
    public Object[] getIds(boolean nonEnumerable, boolean getSymbols) {
        Object[] superIds = super.getIds(nonEnumerable, getSymbols);
        if (this.dense == null) {
            return superIds;
        }
        int N2 = this.dense.length;
        long currentLength = this.length;
        if ((long)N2 > currentLength) {
            N2 = (int)currentLength;
        }
        if (N2 == 0) {
            return superIds;
        }
        int superLength = superIds.length;
        Object[] ids = new Object[N2 + superLength];
        int presentCount = 0;
        for (int i2 = 0; i2 != N2; ++i2) {
            if (this.dense[i2] == NOT_FOUND) continue;
            ids[presentCount] = i2;
            ++presentCount;
        }
        if (presentCount != N2) {
            Object[] tmp = new Object[presentCount + superLength];
            System.arraycopy(ids, 0, tmp, 0, presentCount);
            ids = tmp;
        }
        System.arraycopy(superIds, 0, ids, presentCount, superLength);
        return ids;
    }

    public Integer[] getIndexIds() {
        Object[] ids = this.getIds();
        ArrayList<Integer> indices = new ArrayList<Integer>(ids.length);
        for (Object id : ids) {
            int int32Id = ScriptRuntime.toInt32(id);
            if (int32Id < 0 || !ScriptRuntime.toString(int32Id).equals(ScriptRuntime.toString(id))) continue;
            indices.add(int32Id);
        }
        return indices.toArray(new Integer[indices.size()]);
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        Context cx;
        if (hint == ScriptRuntime.NumberClass && (cx = Context.getContext()).getLanguageVersion() == 120) {
            return this.length;
        }
        return super.getDefaultValue(hint);
    }

    private ScriptableObject defaultIndexPropertyDescriptor(Object value2) {
        Scriptable scope = this.getParentScope();
        if (scope == null) {
            scope = this;
        }
        NativeObject desc = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(desc, scope, TopLevel.Builtins.Object);
        desc.defineProperty("value", value2, 0);
        desc.defineProperty("writable", (Object)true, 0);
        desc.defineProperty("enumerable", (Object)true, 0);
        desc.defineProperty("configurable", (Object)true, 0);
        return desc;
    }

    @Override
    public int getAttributes(int index) {
        if (this.dense != null && index >= 0 && index < this.dense.length && this.dense[index] != NOT_FOUND) {
            return 0;
        }
        return super.getAttributes(index);
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        int index;
        if (this.dense != null && 0 <= (index = NativeArray.toDenseIndex(id)) && index < this.dense.length && this.dense[index] != NOT_FOUND) {
            Object value2 = this.dense[index];
            return this.defaultIndexPropertyDescriptor(value2);
        }
        return super.getOwnPropertyDescriptor(cx, id);
    }

    @Override
    protected void defineOwnProperty(Context cx, Object id, ScriptableObject desc, boolean checkValid) {
        long index;
        if (this.dense != null) {
            Object[] values2 = this.dense;
            this.dense = null;
            this.denseOnly = false;
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (values2[i2] == NOT_FOUND) continue;
                this.put(i2, (Scriptable)this, values2[i2]);
            }
        }
        if ((index = NativeArray.toArrayIndex(id)) >= this.length) {
            this.length = index + 1L;
        }
        super.defineOwnProperty(cx, id, desc, checkValid);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args2) {
        if (args2.length == 0) {
            return new NativeArray(0L);
        }
        if (cx.getLanguageVersion() == 120) {
            return new NativeArray(args2);
        }
        Object arg0 = args2[0];
        if (args2.length > 1 || !(arg0 instanceof Number)) {
            return new NativeArray(args2);
        }
        long len2 = ScriptRuntime.toUint32(arg0);
        if ((double)len2 != ((Number)arg0).doubleValue()) {
            String msg = ScriptRuntime.getMessage0("msg.arraylength.bad");
            throw ScriptRuntime.constructError("RangeError", msg);
        }
        return new NativeArray(len2);
    }

    public long getLength() {
        return this.length;
    }

    @Deprecated
    public long jsGet_length() {
        return this.getLength();
    }

    void setDenseOnly(boolean denseOnly) {
        if (denseOnly && !this.denseOnly) {
            throw new IllegalArgumentException();
        }
        this.denseOnly = denseOnly;
    }

    private void setLength(Object val) {
        if ((this.lengthAttr & 1) != 0) {
            return;
        }
        double d2 = ScriptRuntime.toNumber(val);
        long longVal = ScriptRuntime.toUint32(d2);
        if ((double)longVal != d2) {
            String msg = ScriptRuntime.getMessage0("msg.arraylength.bad");
            throw ScriptRuntime.constructError("RangeError", msg);
        }
        if (this.denseOnly) {
            if (longVal < this.length) {
                Arrays.fill(this.dense, (int)longVal, this.dense.length, NOT_FOUND);
                this.length = longVal;
                return;
            }
            if (longVal < 0x55555554L && (double)longVal < (double)this.length * 1.5 && this.ensureCapacity((int)longVal)) {
                this.length = longVal;
                return;
            }
            this.denseOnly = false;
        }
        if (longVal < this.length) {
            if (this.length - longVal > 4096L) {
                Object[] e2 = this.getIds();
                for (int i2 = 0; i2 < e2.length; ++i2) {
                    Object id = e2[i2];
                    if (id instanceof String) {
                        String strId = (String)id;
                        long index = NativeArray.toArrayIndex(strId);
                        if (index < longVal) continue;
                        this.delete(strId);
                        continue;
                    }
                    int index = (Integer)id;
                    if ((long)index < longVal) continue;
                    this.delete(index);
                }
            } else {
                for (long i3 = longVal; i3 < this.length; ++i3) {
                    NativeArray.deleteElem(this, i3);
                }
            }
        }
        this.length = longVal;
    }

    static long getLengthProperty(Context cx, Scriptable obj) {
        if (obj instanceof NativeString) {
            return ((NativeString)obj).getLength();
        }
        if (obj instanceof NativeArray) {
            return ((NativeArray)obj).getLength();
        }
        Object len2 = ScriptableObject.getProperty(obj, "length");
        if (len2 == Scriptable.NOT_FOUND) {
            return 0L;
        }
        return ScriptRuntime.toUint32(len2);
    }

    private static Object setLengthProperty(Context cx, Scriptable target, long length) {
        Number len2 = ScriptRuntime.wrapNumber(length);
        ScriptableObject.putProperty(target, "length", (Object)len2);
        return len2;
    }

    private static void deleteElem(Scriptable target, long index) {
        int i2 = (int)index;
        if ((long)i2 == index) {
            target.delete(i2);
        } else {
            target.delete(Long.toString(index));
        }
    }

    private static Object getElem(Context cx, Scriptable target, long index) {
        Object elem = NativeArray.getRawElem(target, index);
        return elem != Scriptable.NOT_FOUND ? elem : Undefined.instance;
    }

    private static Object getRawElem(Scriptable target, long index) {
        if (index > Integer.MAX_VALUE) {
            return ScriptableObject.getProperty(target, Long.toString(index));
        }
        return ScriptableObject.getProperty(target, (int)index);
    }

    private static void defineElem(Context cx, Scriptable target, long index, Object value2) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            target.put(id, target, value2);
        } else {
            target.put((int)index, target, value2);
        }
    }

    private static void setElem(Context cx, Scriptable target, long index, Object value2) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            ScriptableObject.putProperty(target, id, value2);
        } else {
            ScriptableObject.putProperty(target, (int)index, value2);
        }
    }

    private static void setRawElem(Context cx, Scriptable target, long index, Object value2) {
        if (value2 == NOT_FOUND) {
            NativeArray.deleteElem(target, index);
        } else {
            NativeArray.setElem(cx, target, index, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toStringHelper(Context cx, Scriptable scope, Scriptable thisObj, boolean toSource, boolean toLocale) {
        boolean iterating;
        boolean toplevel;
        String separator;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        StringBuilder result2 = new StringBuilder(256);
        if (toSource) {
            result2.append('[');
            separator = ", ";
        } else {
            separator = ",";
        }
        boolean haslast = false;
        long i2 = 0L;
        if (cx.iterating == null) {
            toplevel = true;
            iterating = false;
            cx.iterating = new ObjToIntMap(31);
        } else {
            toplevel = false;
            iterating = cx.iterating.has(thisObj);
        }
        try {
            if (!iterating) {
                cx.iterating.put(thisObj, 0);
                boolean skipUndefinedAndNull = !toSource || cx.getLanguageVersion() < 150;
                for (i2 = 0L; i2 < length; ++i2) {
                    Object elem;
                    if (i2 > 0L) {
                        result2.append(separator);
                    }
                    if ((elem = NativeArray.getRawElem(thisObj, i2)) == NOT_FOUND || skipUndefinedAndNull && (elem == null || elem == Undefined.instance)) {
                        haslast = false;
                        continue;
                    }
                    haslast = true;
                    if (toSource) {
                        result2.append(ScriptRuntime.uneval(cx, scope, elem));
                        continue;
                    }
                    if (elem instanceof String) {
                        String s2 = (String)elem;
                        if (toSource) {
                            result2.append('\"');
                            result2.append(ScriptRuntime.escapeString(s2));
                            result2.append('\"');
                            continue;
                        }
                        result2.append(s2);
                        continue;
                    }
                    if (toLocale) {
                        Callable fun = ScriptRuntime.getPropFunctionAndThis(elem, "toLocaleString", cx, scope);
                        Scriptable funThis = ScriptRuntime.lastStoredScriptable(cx);
                        elem = fun.call(cx, scope, funThis, ScriptRuntime.emptyArgs);
                    }
                    result2.append(ScriptRuntime.toString(elem));
                }
            }
        }
        finally {
            if (toplevel) {
                cx.iterating = null;
            }
        }
        if (toSource) {
            if (!haslast && i2 > 0L) {
                result2.append(", ]");
            } else {
                result2.append(']');
            }
        }
        return result2.toString();
    }

    private static String js_join(Context cx, Scriptable thisObj, Object[] args2) {
        String str;
        String separator;
        int length;
        long llength = NativeArray.getLengthProperty(cx, thisObj);
        if (llength != (long)(length = (int)llength)) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(llength));
        }
        String string = separator = args2.length < 1 || args2[0] == Undefined.instance ? "," : ScriptRuntime.toString(args2[0]);
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < length; ++i2) {
                    Object temp;
                    if (i2 != 0) {
                        sb.append(separator);
                    }
                    if (i2 >= na.dense.length || (temp = na.dense[i2]) == null || temp == Undefined.instance || temp == Scriptable.NOT_FOUND) continue;
                    sb.append(ScriptRuntime.toString(temp));
                }
                return sb.toString();
            }
        }
        if (length == 0) {
            return "";
        }
        String[] buf = new String[length];
        int total_size = 0;
        for (int i3 = 0; i3 != length; ++i3) {
            Object temp = NativeArray.getElem(cx, thisObj, i3);
            if (temp == null || temp == Undefined.instance) continue;
            str = ScriptRuntime.toString(temp);
            total_size += str.length();
            buf[i3] = str;
        }
        StringBuilder sb = new StringBuilder(total_size += (length - 1) * separator.length());
        for (int i4 = 0; i4 != length; ++i4) {
            if (i4 != 0) {
                sb.append(separator);
            }
            if ((str = buf[i4]) == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private static Scriptable js_reverse(Context cx, Scriptable thisObj, Object[] args2) {
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                int i2 = 0;
                for (int j2 = (int)na.length - 1; i2 < j2; ++i2, --j2) {
                    Object temp = na.dense[i2];
                    na.dense[i2] = na.dense[j2];
                    na.dense[j2] = temp;
                }
                return thisObj;
            }
        }
        long len2 = NativeArray.getLengthProperty(cx, thisObj);
        long half = len2 / 2L;
        for (long i3 = 0L; i3 < half; ++i3) {
            long j3 = len2 - i3 - 1L;
            Object temp1 = NativeArray.getRawElem(thisObj, i3);
            Object temp2 = NativeArray.getRawElem(thisObj, j3);
            NativeArray.setRawElem(cx, thisObj, i3, temp2);
            NativeArray.setRawElem(cx, thisObj, j3, temp1);
        }
        return thisObj;
    }

    private static Scriptable js_sort(final Context cx, final Scriptable scope, Scriptable thisObj, Object[] args2) {
        int i2;
        ElementComparator comparator;
        if (args2.length > 0 && Undefined.instance != args2[0]) {
            final Callable jsCompareFunction = ScriptRuntime.getValueFunctionAndThis(args2[0], cx);
            final Scriptable funThis = ScriptRuntime.lastStoredScriptable(cx);
            final Object[] cmpBuf = new Object[2];
            comparator = new ElementComparator(new Comparator<Object>(){

                @Override
                public int compare(Object x, Object y) {
                    cmpBuf[0] = x;
                    cmpBuf[1] = y;
                    Object ret = jsCompareFunction.call(cx, scope, funThis, cmpBuf);
                    double d2 = ScriptRuntime.toNumber(ret);
                    if (d2 < 0.0) {
                        return -1;
                    }
                    if (d2 > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            });
        } else {
            comparator = DEFAULT_COMPARATOR;
        }
        long llength = NativeArray.getLengthProperty(cx, thisObj);
        int length = (int)llength;
        if (llength != (long)length) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(llength));
        }
        Object[] working = new Object[length];
        for (i2 = 0; i2 != length; ++i2) {
            working[i2] = NativeArray.getRawElem(thisObj, i2);
        }
        Sorting.hybridSort(working, comparator);
        for (i2 = 0; i2 < length; ++i2) {
            NativeArray.setRawElem(cx, thisObj, i2, working[i2]);
        }
        return thisObj;
    }

    private static Object js_push(Context cx, Scriptable thisObj, Object[] args2) {
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.ensureCapacity((int)na.length + args2.length)) {
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    na.dense[(int)na.length++] = args2[i2];
                }
                return ScriptRuntime.wrapNumber(na.length);
            }
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        for (int i3 = 0; i3 < args2.length; ++i3) {
            NativeArray.setElem(cx, thisObj, length + (long)i3, args2[i3]);
        }
        Object lengthObj = NativeArray.setLengthProperty(cx, thisObj, length += (long)args2.length);
        if (cx.getLanguageVersion() == 120) {
            return args2.length == 0 ? Undefined.instance : args2[args2.length - 1];
        }
        return lengthObj;
    }

    private static Object js_pop(Context cx, Scriptable thisObj, Object[] args2) {
        Object result2;
        long length;
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.length > 0L) {
                --na.length;
                Object result3 = na.dense[(int)na.length];
                na.dense[(int)na.length] = NOT_FOUND;
                return result3;
            }
        }
        if ((length = NativeArray.getLengthProperty(cx, thisObj)) > 0L) {
            result2 = NativeArray.getElem(cx, thisObj, --length);
            NativeArray.deleteElem(thisObj, length);
        } else {
            result2 = Undefined.instance;
        }
        NativeArray.setLengthProperty(cx, thisObj, length);
        return result2;
    }

    private static Object js_shift(Context cx, Scriptable thisObj, Object[] args2) {
        Object result2;
        long length;
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.length > 0L) {
                --na.length;
                Object result3 = na.dense[0];
                System.arraycopy(na.dense, 1, na.dense, 0, (int)na.length);
                na.dense[(int)na.length] = NOT_FOUND;
                return result3 == NOT_FOUND ? Undefined.instance : result3;
            }
        }
        if ((length = NativeArray.getLengthProperty(cx, thisObj)) > 0L) {
            long i2 = 0L;
            result2 = NativeArray.getElem(cx, thisObj, i2);
            if (--length > 0L) {
                for (i2 = 1L; i2 <= length; ++i2) {
                    Object temp = NativeArray.getRawElem(thisObj, i2);
                    NativeArray.setRawElem(cx, thisObj, i2 - 1L, temp);
                }
            }
            NativeArray.deleteElem(thisObj, length);
        } else {
            result2 = Undefined.instance;
        }
        NativeArray.setLengthProperty(cx, thisObj, length);
        return result2;
    }

    private static Object js_unshift(Context cx, Scriptable thisObj, Object[] args2) {
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.ensureCapacity((int)na.length + args2.length)) {
                System.arraycopy(na.dense, 0, na.dense, args2.length, (int)na.length);
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    na.dense[i2] = args2[i2];
                }
                na.length += (long)args2.length;
                return ScriptRuntime.wrapNumber(na.length);
            }
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        int argc = args2.length;
        if (args2.length > 0) {
            if (length > 0L) {
                for (long last2 = length - 1L; last2 >= 0L; --last2) {
                    Object temp = NativeArray.getRawElem(thisObj, last2);
                    NativeArray.setRawElem(cx, thisObj, last2 + (long)argc, temp);
                }
            }
            for (int i3 = 0; i3 < args2.length; ++i3) {
                NativeArray.setElem(cx, thisObj, i3, args2[i3]);
            }
        }
        return NativeArray.setLengthProperty(cx, thisObj, length += (long)args2.length);
    }

    private static Object js_splice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        Object temp;
        long last2;
        Object result2;
        long count2;
        NativeArray na = null;
        boolean denseMode = false;
        if (thisObj instanceof NativeArray) {
            na = (NativeArray)thisObj;
            denseMode = na.denseOnly;
        }
        scope = NativeArray.getTopLevelScope(scope);
        int argc = args2.length;
        if (argc == 0) {
            return cx.newArray(scope, 0);
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        long begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args2[0]), length);
        --argc;
        if (args2.length == 1) {
            count2 = length - begin;
        } else {
            double dcount = ScriptRuntime.toInteger(args2[1]);
            count2 = dcount < 0.0 ? 0L : (dcount > (double)(length - begin) ? length - begin : (long)dcount);
            --argc;
        }
        long end2 = begin + count2;
        if (count2 != 0L) {
            if (count2 == 1L && cx.getLanguageVersion() == 120) {
                result2 = NativeArray.getElem(cx, thisObj, begin);
            } else if (denseMode) {
                int intLen = (int)(end2 - begin);
                Object[] copy2 = new Object[intLen];
                System.arraycopy(na.dense, (int)begin, copy2, 0, intLen);
                result2 = cx.newArray(scope, copy2);
            } else {
                Scriptable resultArray = cx.newArray(scope, 0);
                for (long last3 = begin; last3 != end2; ++last3) {
                    Object temp2 = NativeArray.getRawElem(thisObj, last3);
                    if (temp2 == NOT_FOUND) continue;
                    NativeArray.setElem(cx, resultArray, last3 - begin, temp2);
                }
                NativeArray.setLengthProperty(cx, resultArray, end2 - begin);
                result2 = resultArray;
            }
        } else {
            result2 = cx.getLanguageVersion() == 120 ? Undefined.instance : cx.newArray(scope, 0);
        }
        long delta = (long)argc - count2;
        if (denseMode && length + delta < Integer.MAX_VALUE && na.ensureCapacity((int)(length + delta))) {
            System.arraycopy(na.dense, (int)end2, na.dense, (int)(begin + (long)argc), (int)(length - end2));
            if (argc > 0) {
                System.arraycopy(args2, 2, na.dense, (int)begin, argc);
            }
            if (delta < 0L) {
                Arrays.fill(na.dense, (int)(length + delta), (int)length, NOT_FOUND);
            }
            na.length = length + delta;
            return result2;
        }
        if (delta > 0L) {
            for (last2 = length - 1L; last2 >= end2; --last2) {
                temp = NativeArray.getRawElem(thisObj, last2);
                NativeArray.setRawElem(cx, thisObj, last2 + delta, temp);
            }
        } else if (delta < 0L) {
            for (last2 = end2; last2 < length; ++last2) {
                temp = NativeArray.getRawElem(thisObj, last2);
                NativeArray.setRawElem(cx, thisObj, last2 + delta, temp);
            }
            for (long k2 = length + delta; k2 < length; ++k2) {
                NativeArray.deleteElem(thisObj, k2);
            }
        }
        int argoffset = args2.length - argc;
        for (int i2 = 0; i2 < argc; ++i2) {
            NativeArray.setElem(cx, thisObj, begin + (long)i2, args2[i2 + argoffset]);
        }
        NativeArray.setLengthProperty(cx, thisObj, length + delta);
        return result2;
    }

    private static Scriptable js_concat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        Scriptable arg;
        int i2;
        scope = NativeArray.getTopLevelScope(scope);
        Scriptable result2 = cx.newArray(scope, 0);
        if (thisObj instanceof NativeArray && result2 instanceof NativeArray) {
            NativeArray denseThis = (NativeArray)thisObj;
            NativeArray denseResult = (NativeArray)result2;
            if (denseThis.denseOnly && denseResult.denseOnly) {
                boolean canUseDense = true;
                int length = (int)denseThis.length;
                for (i2 = 0; i2 < args2.length && canUseDense; ++i2) {
                    if (args2[i2] instanceof NativeArray) {
                        arg = (NativeArray)args2[i2];
                        canUseDense = ((NativeArray)arg).denseOnly;
                        length = (int)((long)length + ((NativeArray)arg).length);
                        continue;
                    }
                    ++length;
                }
                if (canUseDense && denseResult.ensureCapacity(length)) {
                    System.arraycopy(denseThis.dense, 0, denseResult.dense, 0, (int)denseThis.length);
                    int cursor = (int)denseThis.length;
                    for (int i3 = 0; i3 < args2.length && canUseDense; ++i3) {
                        if (args2[i3] instanceof NativeArray) {
                            NativeArray arg2 = (NativeArray)args2[i3];
                            System.arraycopy(arg2.dense, 0, denseResult.dense, cursor, (int)arg2.length);
                            cursor += (int)arg2.length;
                            continue;
                        }
                        denseResult.dense[cursor++] = args2[i3];
                    }
                    denseResult.length = length;
                    return result2;
                }
            }
        }
        long slot = 0L;
        if (NativeArray.js_isArray(thisObj)) {
            long length = NativeArray.getLengthProperty(cx, thisObj);
            for (slot = 0L; slot < length; ++slot) {
                Object temp = NativeArray.getRawElem(thisObj, slot);
                if (temp == NOT_FOUND) continue;
                NativeArray.defineElem(cx, result2, slot, temp);
            }
        } else {
            NativeArray.defineElem(cx, result2, slot++, thisObj);
        }
        for (i2 = 0; i2 < args2.length; ++i2) {
            if (NativeArray.js_isArray(args2[i2])) {
                arg = (Scriptable)args2[i2];
                long length = NativeArray.getLengthProperty(cx, arg);
                long j2 = 0L;
                while (j2 < length) {
                    Object temp = NativeArray.getRawElem(arg, j2);
                    if (temp != NOT_FOUND) {
                        NativeArray.defineElem(cx, result2, slot, temp);
                    }
                    ++j2;
                    ++slot;
                }
                continue;
            }
            NativeArray.defineElem(cx, result2, slot++, args2[i2]);
        }
        NativeArray.setLengthProperty(cx, result2, slot);
        return result2;
    }

    private Scriptable js_slice(Context cx, Scriptable thisObj, Object[] args2) {
        long end2;
        long begin;
        Scriptable scope = NativeArray.getTopLevelScope(this);
        Scriptable result2 = cx.newArray(scope, 0);
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (args2.length == 0) {
            begin = 0L;
            end2 = length;
        } else {
            begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args2[0]), length);
            end2 = args2.length == 1 || args2[1] == Undefined.instance ? length : NativeArray.toSliceIndex(ScriptRuntime.toInteger(args2[1]), length);
        }
        for (long slot = begin; slot < end2; ++slot) {
            Object temp = NativeArray.getRawElem(thisObj, slot);
            if (temp == NOT_FOUND) continue;
            NativeArray.defineElem(cx, result2, slot - begin, temp);
        }
        NativeArray.setLengthProperty(cx, result2, Math.max(0L, end2 - begin));
        return result2;
    }

    private static long toSliceIndex(double value2, long length) {
        long result2 = value2 < 0.0 ? (value2 + (double)length < 0.0 ? 0L : (long)(value2 + (double)length)) : (value2 > (double)length ? length : (long)value2);
        return result2;
    }

    private static Object js_indexOf(Context cx, Scriptable thisObj, Object[] args2) {
        long start2;
        Object compareTo = args2.length > 0 ? args2[0] : Undefined.instance;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (args2.length < 2) {
            start2 = 0L;
        } else {
            start2 = (long)ScriptRuntime.toInteger(args2[1]);
            if (start2 < 0L && (start2 += length) < 0L) {
                start2 = 0L;
            }
            if (start2 > length - 1L) {
                return NEGATIVE_ONE;
            }
        }
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                Scriptable proto = na.getPrototype();
                int i2 = (int)start2;
                while ((long)i2 < length) {
                    Object val = na.dense[i2];
                    if (val == NOT_FOUND && proto != null) {
                        val = ScriptableObject.getProperty(proto, i2);
                    }
                    if (val != NOT_FOUND && ScriptRuntime.shallowEq(val, compareTo)) {
                        return (long)i2;
                    }
                    ++i2;
                }
                return NEGATIVE_ONE;
            }
        }
        for (long i3 = start2; i3 < length; ++i3) {
            Object val = NativeArray.getRawElem(thisObj, i3);
            if (val == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
            return i3;
        }
        return NEGATIVE_ONE;
    }

    private static Object js_lastIndexOf(Context cx, Scriptable thisObj, Object[] args2) {
        long start2;
        Object compareTo = args2.length > 0 ? args2[0] : Undefined.instance;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (args2.length < 2) {
            start2 = length - 1L;
        } else {
            start2 = (long)ScriptRuntime.toInteger(args2[1]);
            if (start2 >= length) {
                start2 = length - 1L;
            } else if (start2 < 0L) {
                start2 += length;
            }
            if (start2 < 0L) {
                return NEGATIVE_ONE;
            }
        }
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                Scriptable proto = na.getPrototype();
                for (int i2 = (int)start2; i2 >= 0; --i2) {
                    Object val = na.dense[i2];
                    if (val == NOT_FOUND && proto != null) {
                        val = ScriptableObject.getProperty(proto, i2);
                    }
                    if (val == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
                    return (long)i2;
                }
                return NEGATIVE_ONE;
            }
        }
        for (long i3 = start2; i3 >= 0L; --i3) {
            Object val = NativeArray.getRawElem(thisObj, i3);
            if (val == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
            return i3;
        }
        return NEGATIVE_ONE;
    }

    private static Object iterativeMethod(Context cx, IdFunctionObject idFunctionObject, Scriptable scope, Scriptable thisObj, Object[] args2) {
        Object callbackArg;
        int id = idFunctionObject.methodId();
        if (22 == id || 23 == id) {
            thisObj = ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, idFunctionObject);
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        Object object = callbackArg = args2.length > 0 ? args2[0] : Undefined.instance;
        if (callbackArg == null || !(callbackArg instanceof Function)) {
            throw ScriptRuntime.notFunctionError(callbackArg);
        }
        if (cx.getLanguageVersion() >= 200 && callbackArg instanceof NativeRegExp) {
            throw ScriptRuntime.notFunctionError(callbackArg);
        }
        Function f2 = (Function)callbackArg;
        Scriptable parent = ScriptableObject.getTopLevelScope(f2);
        Scriptable thisArg = args2.length < 2 || args2[1] == null || args2[1] == Undefined.instance ? parent : ScriptRuntime.toObject(cx, scope, args2[1]);
        Scriptable array = null;
        if (id == 18 || id == 20) {
            int resultLength = id == 20 ? (int)length : 0;
            array = cx.newArray(scope, resultLength);
        }
        long j2 = 0L;
        block15: for (long i2 = 0L; i2 < length; ++i2) {
            Object[] innerArgs = new Object[3];
            Object elem = NativeArray.getRawElem(thisObj, i2);
            if (elem == Scriptable.NOT_FOUND) {
                if (id != 22 && id != 23) continue;
                elem = Undefined.instance;
            }
            innerArgs[0] = elem;
            innerArgs[1] = i2;
            innerArgs[2] = thisObj;
            Object result2 = f2.call(cx, parent, thisArg, innerArgs);
            switch (id) {
                case 17: {
                    if (ScriptRuntime.toBoolean(result2)) continue block15;
                    return Boolean.FALSE;
                }
                case 18: {
                    if (!ScriptRuntime.toBoolean(result2)) continue block15;
                    NativeArray.defineElem(cx, array, j2++, innerArgs[0]);
                    continue block15;
                }
                case 19: {
                    continue block15;
                }
                case 20: {
                    NativeArray.defineElem(cx, array, i2, result2);
                    continue block15;
                }
                case 21: {
                    if (!ScriptRuntime.toBoolean(result2)) continue block15;
                    return Boolean.TRUE;
                }
                case 22: {
                    if (!ScriptRuntime.toBoolean(result2)) continue block15;
                    return elem;
                }
                case 23: {
                    if (!ScriptRuntime.toBoolean(result2)) continue block15;
                    return ScriptRuntime.wrapNumber(i2);
                }
            }
        }
        switch (id) {
            case 17: {
                return Boolean.TRUE;
            }
            case 18: 
            case 20: {
                return array;
            }
            case 21: {
                return Boolean.FALSE;
            }
            case 23: {
                return ScriptRuntime.wrapNumber(-1.0);
            }
        }
        return Undefined.instance;
    }

    private static Object reduceMethod(Context cx, int id, Scriptable scope, Scriptable thisObj, Object[] args2) {
        Object callbackArg;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        Object object = callbackArg = args2.length > 0 ? args2[0] : Undefined.instance;
        if (callbackArg == null || !(callbackArg instanceof Function)) {
            throw ScriptRuntime.notFunctionError(callbackArg);
        }
        Function f2 = (Function)callbackArg;
        Scriptable parent = ScriptableObject.getTopLevelScope(f2);
        boolean movingLeft = id == 24;
        Object value2 = args2.length > 1 ? args2[1] : Scriptable.NOT_FOUND;
        for (long i2 = 0L; i2 < length; ++i2) {
            long index = movingLeft ? i2 : length - 1L - i2;
            Object elem = NativeArray.getRawElem(thisObj, index);
            if (elem == Scriptable.NOT_FOUND) continue;
            if (value2 == Scriptable.NOT_FOUND) {
                value2 = elem;
                continue;
            }
            Object[] innerArgs = new Object[]{value2, elem, index, thisObj};
            value2 = f2.call(cx, parent, parent, innerArgs);
        }
        if (value2 == Scriptable.NOT_FOUND) {
            throw ScriptRuntime.typeError0("msg.empty.array.reduce");
        }
        return value2;
    }

    private static boolean js_isArray(Object o) {
        if (!(o instanceof Scriptable)) {
            return false;
        }
        return "Array".equals(((Scriptable)o).getClassName());
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) > -1;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(ScriptRuntime.emptyArgs);
    }

    @Override
    public Object[] toArray(Object[] a2) {
        long longLen = this.length;
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int len2 = (int)longLen;
        Object[] array = a2.length >= len2 ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), len2);
        for (int i2 = 0; i2 < len2; ++i2) {
            array[i2] = this.get(i2);
        }
        return array;
    }

    @Override
    public boolean containsAll(Collection c2) {
        for (Object aC : c2) {
            if (this.contains(aC)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        long longLen = this.length;
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        return (int)longLen;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0L;
    }

    public Object get(long index) {
        if (index < 0L || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        Object value2 = NativeArray.getRawElem(this, index);
        if (value2 == Scriptable.NOT_FOUND || value2 == Undefined.instance) {
            return null;
        }
        if (value2 instanceof Wrapper) {
            return ((Wrapper)value2).unwrap();
        }
        return value2;
    }

    public Object get(int index) {
        return this.get((long)index);
    }

    @Override
    public int indexOf(Object o) {
        long longLen = this.length;
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int len2 = (int)longLen;
        if (o == null) {
            for (int i2 = 0; i2 < len2; ++i2) {
                if (this.get(i2) != null) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < len2; ++i3) {
                if (!o.equals(this.get(i3))) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        long longLen = this.length;
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int len2 = (int)longLen;
        if (o == null) {
            for (int i2 = len2 - 1; i2 >= 0; --i2) {
                if (this.get(i2) != null) continue;
                return i2;
            }
        } else {
            for (int i3 = len2 - 1; i3 >= 0; --i3) {
                if (!o.equals(this.get(i3))) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int start2) {
        long longLen = this.length;
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        final int len2 = (int)longLen;
        if (start2 < 0 || start2 > len2) {
            throw new IndexOutOfBoundsException("Index: " + start2);
        }
        return new ListIterator(){
            int cursor;
            {
                this.cursor = start2;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < len2;
            }

            @Override
            public Object next() {
                if (this.cursor == len2) {
                    throw new NoSuchElementException();
                }
                return NativeArray.this.get(this.cursor++);
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            public Object previous() {
                if (this.cursor == 0) {
                    throw new NoSuchElementException();
                }
                return NativeArray.this.get(--this.cursor);
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c2) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int findPrototypeId(Symbol k2) {
        if (SymbolKey.ITERATOR.equals(k2)) {
            return 26;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String s2) {
        int id = 0;
        String X = null;
        block0 : switch (s2.length()) {
            case 3: {
                char c2 = s2.charAt(0);
                if (c2 == 'm') {
                    if (s2.charAt(2) != 'p' || s2.charAt(1) != 'a') break;
                    return 20;
                }
                if (c2 != 'p' || s2.charAt(2) != 'p' || s2.charAt(1) != 'o') break;
                return 9;
            }
            case 4: {
                switch (s2.charAt(2)) {
                    case 'i': {
                        X = "join";
                        id = 5;
                        break block0;
                    }
                    case 'm': {
                        X = "some";
                        id = 21;
                        break block0;
                    }
                    case 'n': {
                        X = "find";
                        id = 22;
                        break block0;
                    }
                    case 'r': {
                        X = "sort";
                        id = 7;
                        break block0;
                    }
                    case 's': {
                        X = "push";
                        id = 8;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c3 = s2.charAt(1);
                if (c3 == 'h') {
                    X = "shift";
                    id = 10;
                    break;
                }
                if (c3 == 'l') {
                    X = "slice";
                    id = 14;
                    break;
                }
                if (c3 != 'v') break;
                X = "every";
                id = 17;
                break;
            }
            case 6: {
                switch (s2.charAt(0)) {
                    case 'c': {
                        X = "concat";
                        id = 13;
                        break block0;
                    }
                    case 'f': {
                        X = "filter";
                        id = 18;
                        break block0;
                    }
                    case 'r': {
                        X = "reduce";
                        id = 24;
                        break block0;
                    }
                    case 's': {
                        X = "splice";
                        id = 12;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (s2.charAt(0)) {
                    case 'f': {
                        X = "forEach";
                        id = 19;
                        break block0;
                    }
                    case 'i': {
                        X = "indexOf";
                        id = 15;
                        break block0;
                    }
                    case 'r': {
                        X = "reverse";
                        id = 6;
                        break block0;
                    }
                    case 'u': {
                        X = "unshift";
                        id = 11;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c4 = s2.charAt(3);
                if (c4 == 'o') {
                    X = "toSource";
                    id = 4;
                    break;
                }
                if (c4 != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 9: {
                X = "findIndex";
                id = 23;
                break;
            }
            case 11: {
                char c5 = s2.charAt(0);
                if (c5 == 'c') {
                    X = "constructor";
                    id = 1;
                    break;
                }
                if (c5 == 'l') {
                    X = "lastIndexOf";
                    id = 16;
                    break;
                }
                if (c5 != 'r') break;
                X = "reduceRight";
                id = 25;
                break;
            }
            case 14: {
                X = "toLocaleString";
                id = 3;
            }
        }
        if (X == null) return id;
        if (X == s2) return id;
        if (X.equals(s2)) return id;
        return 0;
    }

    public static final class ElementComparator
    implements Comparator<Object> {
        private final Comparator<Object> child;

        public ElementComparator() {
            this.child = STRING_COMPARATOR;
        }

        public ElementComparator(Comparator<Object> c2) {
            this.child = c2;
        }

        @Override
        public int compare(Object x, Object y) {
            if (x == Undefined.instance) {
                if (y == Undefined.instance) {
                    return 0;
                }
                if (y == Scriptable.NOT_FOUND) {
                    return -1;
                }
                return 1;
            }
            if (x == Scriptable.NOT_FOUND) {
                return y == Scriptable.NOT_FOUND ? 0 : 1;
            }
            if (y == Scriptable.NOT_FOUND) {
                return -1;
            }
            if (y == Undefined.instance) {
                return -1;
            }
            return this.child.compare(x, y);
        }
    }

    public static final class StringLikeComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object x, Object y) {
            String a2 = ScriptRuntime.toString(x);
            String b2 = ScriptRuntime.toString(y);
            return a2.compareTo(b2);
        }
    }
}

