/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeArrayIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "ArrayIterator";
    private Scriptable arrayLike;
    private int index;

    static void init(ScriptableObject scope, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeArrayIterator(), ITERATOR_TAG);
    }

    private NativeArrayIterator() {
    }

    public NativeArrayIterator(Scriptable scope, Scriptable arrayLike) {
        super(scope);
        this.index = 0;
        this.arrayLike = arrayLike;
    }

    @Override
    public String getClassName() {
        return "Array Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return (long)this.index >= NativeArray.getLengthProperty(cx, this.arrayLike);
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        Object value2;
        if ((value2 = this.arrayLike.get(this.index++, this.arrayLike)) == ScriptableObject.NOT_FOUND) {
            value2 = Undefined.instance;
        }
        return value2;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }
}

