/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptableObject {
    static final long serialVersionUID = -7471457301304454454L;
    private static final Object CALL_TAG = "Call";
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    NativeFunction function;
    Object[] originalArgs;
    boolean isStrict;
    private Arguments arguments;
    transient NativeCall parentActivationCall;

    static void init(Scriptable scope, boolean sealed) {
        NativeCall obj = new NativeCall();
        obj.exportAsJSClass(1, scope, sealed);
    }

    NativeCall() {
    }

    NativeCall(NativeFunction function, Scriptable scope, Object[] args2, boolean isArrow, boolean isStrict) {
        String name;
        int i2;
        this.function = function;
        this.setParentScope(scope);
        this.originalArgs = args2 == null ? ScriptRuntime.emptyArgs : args2;
        this.isStrict = isStrict;
        int paramAndVarCount = function.getParamAndVarCount();
        int paramCount = function.getParamCount();
        if (paramAndVarCount != 0) {
            for (i2 = 0; i2 < paramCount; ++i2) {
                name = function.getParamOrVarName(i2);
                Object val = i2 < args2.length ? args2[i2] : Undefined.instance;
                this.defineProperty(name, val, 4);
            }
        }
        if (!super.has("arguments", (Scriptable)this) && !isArrow) {
            this.arguments = new Arguments(this);
            this.defineProperty("arguments", (Object)this.arguments, 4);
        }
        if (paramAndVarCount != 0) {
            for (i2 = paramCount; i2 < paramAndVarCount; ++i2) {
                name = function.getParamOrVarName(i2);
                if (super.has(name, (Scriptable)this)) continue;
                if (function.getParamOrVarConst(i2)) {
                    this.defineProperty(name, Undefined.instance, 13);
                    continue;
                }
                this.defineProperty(name, Undefined.instance, 4);
            }
        }
    }

    @Override
    public String getClassName() {
        return "Call";
    }

    @Override
    protected int findPrototypeId(String s2) {
        return s2.equals("constructor") ? 1 : 0;
    }

    @Override
    protected void initPrototypeId(int id) {
        if (id != 1) {
            throw new IllegalArgumentException(String.valueOf(id));
        }
        int arity = 1;
        String s2 = "constructor";
        this.initPrototypeMethod(CALL_TAG, id, s2, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(CALL_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        if (id == 1) {
            if (thisObj != null) {
                throw Context.reportRuntimeError1("msg.only.from.new", "Call");
            }
            ScriptRuntime.checkDeprecated(cx, "Call");
            NativeCall result2 = new NativeCall();
            result2.setPrototype(NativeCall.getObjectPrototype(scope));
            return result2;
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public void defineAttributesForArguments() {
        if (this.arguments != null) {
            this.arguments.defineAttributesForStrictMode();
        }
    }
}

