/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

final class NativeDate
extends IdScriptableObject {
    static final long serialVersionUID = -8307438915861678966L;
    private static final Object DATE_TAG = "Date";
    private static final String js_NaN_date_str = "Invalid Date";
    private static final double HalfTimeDomain = 8.64E15;
    private static final double HoursPerDay = 24.0;
    private static final double MinutesPerHour = 60.0;
    private static final double SecondsPerMinute = 60.0;
    private static final double msPerSecond = 1000.0;
    private static final double MinutesPerDay = 1440.0;
    private static final double SecondsPerDay = 86400.0;
    private static final double SecondsPerHour = 3600.0;
    private static final double msPerDay = 8.64E7;
    private static final double msPerHour = 3600000.0;
    private static final double msPerMinute = 60000.0;
    private static final int MAXARGS = 7;
    private static final int ConstructorId_now = -3;
    private static final int ConstructorId_parse = -2;
    private static final int ConstructorId_UTC = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toTimeString = 3;
    private static final int Id_toDateString = 4;
    private static final int Id_toLocaleString = 5;
    private static final int Id_toLocaleTimeString = 6;
    private static final int Id_toLocaleDateString = 7;
    private static final int Id_toUTCString = 8;
    private static final int Id_toSource = 9;
    private static final int Id_valueOf = 10;
    private static final int Id_getTime = 11;
    private static final int Id_getYear = 12;
    private static final int Id_getFullYear = 13;
    private static final int Id_getUTCFullYear = 14;
    private static final int Id_getMonth = 15;
    private static final int Id_getUTCMonth = 16;
    private static final int Id_getDate = 17;
    private static final int Id_getUTCDate = 18;
    private static final int Id_getDay = 19;
    private static final int Id_getUTCDay = 20;
    private static final int Id_getHours = 21;
    private static final int Id_getUTCHours = 22;
    private static final int Id_getMinutes = 23;
    private static final int Id_getUTCMinutes = 24;
    private static final int Id_getSeconds = 25;
    private static final int Id_getUTCSeconds = 26;
    private static final int Id_getMilliseconds = 27;
    private static final int Id_getUTCMilliseconds = 28;
    private static final int Id_getTimezoneOffset = 29;
    private static final int Id_setTime = 30;
    private static final int Id_setMilliseconds = 31;
    private static final int Id_setUTCMilliseconds = 32;
    private static final int Id_setSeconds = 33;
    private static final int Id_setUTCSeconds = 34;
    private static final int Id_setMinutes = 35;
    private static final int Id_setUTCMinutes = 36;
    private static final int Id_setHours = 37;
    private static final int Id_setUTCHours = 38;
    private static final int Id_setDate = 39;
    private static final int Id_setUTCDate = 40;
    private static final int Id_setMonth = 41;
    private static final int Id_setUTCMonth = 42;
    private static final int Id_setFullYear = 43;
    private static final int Id_setUTCFullYear = 44;
    private static final int Id_setYear = 45;
    private static final int Id_toISOString = 46;
    private static final int Id_toJSON = 47;
    private static final int MAX_PROTOTYPE_ID = 47;
    private static final int Id_toGMTString = 8;
    private static TimeZone thisTimeZone;
    private static double LocalTZA;
    private static DateFormat timeZoneFormatter;
    private static DateFormat localeDateTimeFormatter;
    private static DateFormat localeDateFormatter;
    private static DateFormat localeTimeFormatter;
    private double date;

    static void init(Scriptable scope, boolean sealed) {
        NativeDate obj = new NativeDate();
        obj.date = ScriptRuntime.NaN;
        obj.exportAsJSClass(47, scope, sealed);
    }

    private NativeDate() {
        if (thisTimeZone == null) {
            thisTimeZone = TimeZone.getDefault();
            LocalTZA = thisTimeZone.getRawOffset();
        }
    }

    @Override
    public String getClassName() {
        return "Date";
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        if (typeHint == null) {
            typeHint = ScriptRuntime.StringClass;
        }
        return super.getDefaultValue(typeHint);
    }

    double getJSTimeValue() {
        return this.date;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, DATE_TAG, -3, "now", 0);
        this.addIdFunctionProperty(ctor, DATE_TAG, -2, "parse", 1);
        this.addIdFunctionProperty(ctor, DATE_TAG, -1, "UTC", 7);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 7;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s2 = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s2 = "toTimeString";
                break;
            }
            case 4: {
                arity = 0;
                s2 = "toDateString";
                break;
            }
            case 5: {
                arity = 0;
                s2 = "toLocaleString";
                break;
            }
            case 6: {
                arity = 0;
                s2 = "toLocaleTimeString";
                break;
            }
            case 7: {
                arity = 0;
                s2 = "toLocaleDateString";
                break;
            }
            case 8: {
                arity = 0;
                s2 = "toUTCString";
                break;
            }
            case 9: {
                arity = 0;
                s2 = "toSource";
                break;
            }
            case 10: {
                arity = 0;
                s2 = "valueOf";
                break;
            }
            case 11: {
                arity = 0;
                s2 = "getTime";
                break;
            }
            case 12: {
                arity = 0;
                s2 = "getYear";
                break;
            }
            case 13: {
                arity = 0;
                s2 = "getFullYear";
                break;
            }
            case 14: {
                arity = 0;
                s2 = "getUTCFullYear";
                break;
            }
            case 15: {
                arity = 0;
                s2 = "getMonth";
                break;
            }
            case 16: {
                arity = 0;
                s2 = "getUTCMonth";
                break;
            }
            case 17: {
                arity = 0;
                s2 = "getDate";
                break;
            }
            case 18: {
                arity = 0;
                s2 = "getUTCDate";
                break;
            }
            case 19: {
                arity = 0;
                s2 = "getDay";
                break;
            }
            case 20: {
                arity = 0;
                s2 = "getUTCDay";
                break;
            }
            case 21: {
                arity = 0;
                s2 = "getHours";
                break;
            }
            case 22: {
                arity = 0;
                s2 = "getUTCHours";
                break;
            }
            case 23: {
                arity = 0;
                s2 = "getMinutes";
                break;
            }
            case 24: {
                arity = 0;
                s2 = "getUTCMinutes";
                break;
            }
            case 25: {
                arity = 0;
                s2 = "getSeconds";
                break;
            }
            case 26: {
                arity = 0;
                s2 = "getUTCSeconds";
                break;
            }
            case 27: {
                arity = 0;
                s2 = "getMilliseconds";
                break;
            }
            case 28: {
                arity = 0;
                s2 = "getUTCMilliseconds";
                break;
            }
            case 29: {
                arity = 0;
                s2 = "getTimezoneOffset";
                break;
            }
            case 30: {
                arity = 1;
                s2 = "setTime";
                break;
            }
            case 31: {
                arity = 1;
                s2 = "setMilliseconds";
                break;
            }
            case 32: {
                arity = 1;
                s2 = "setUTCMilliseconds";
                break;
            }
            case 33: {
                arity = 2;
                s2 = "setSeconds";
                break;
            }
            case 34: {
                arity = 2;
                s2 = "setUTCSeconds";
                break;
            }
            case 35: {
                arity = 3;
                s2 = "setMinutes";
                break;
            }
            case 36: {
                arity = 3;
                s2 = "setUTCMinutes";
                break;
            }
            case 37: {
                arity = 4;
                s2 = "setHours";
                break;
            }
            case 38: {
                arity = 4;
                s2 = "setUTCHours";
                break;
            }
            case 39: {
                arity = 1;
                s2 = "setDate";
                break;
            }
            case 40: {
                arity = 1;
                s2 = "setUTCDate";
                break;
            }
            case 41: {
                arity = 2;
                s2 = "setMonth";
                break;
            }
            case 42: {
                arity = 2;
                s2 = "setUTCMonth";
                break;
            }
            case 43: {
                arity = 3;
                s2 = "setFullYear";
                break;
            }
            case 44: {
                arity = 3;
                s2 = "setUTCFullYear";
                break;
            }
            case 45: {
                arity = 1;
                s2 = "setYear";
                break;
            }
            case 46: {
                arity = 0;
                s2 = "toISOString";
                break;
            }
            case 47: {
                arity = 1;
                s2 = "toJSON";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(DATE_TAG, id, s2, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(DATE_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case -3: {
                return ScriptRuntime.wrapNumber(NativeDate.now());
            }
            case -2: {
                String dataStr = ScriptRuntime.toString(args2, 0);
                return ScriptRuntime.wrapNumber(NativeDate.date_parseString(dataStr));
            }
            case -1: {
                return ScriptRuntime.wrapNumber(NativeDate.jsStaticFunction_UTC(args2));
            }
            case 1: {
                if (thisObj != null) {
                    return NativeDate.date_format(NativeDate.now(), 2);
                }
                return NativeDate.jsConstructor(args2);
            }
            case 47: {
                double d2;
                String toISOString = "toISOString";
                Scriptable o = ScriptRuntime.toObject(cx, scope, thisObj);
                Object tv = ScriptRuntime.toPrimitive(o, ScriptRuntime.NumberClass);
                if (tv instanceof Number && ((d2 = ((Number)tv).doubleValue()) != d2 || Double.isInfinite(d2))) {
                    return null;
                }
                Object toISO = ScriptableObject.getProperty(o, "toISOString");
                if (toISO == NOT_FOUND) {
                    throw ScriptRuntime.typeError2("msg.function.not.found.in", "toISOString", ScriptRuntime.toString(o));
                }
                if (!(toISO instanceof Callable)) {
                    throw ScriptRuntime.typeError3("msg.isnt.function.in", "toISOString", ScriptRuntime.toString(o), ScriptRuntime.toString(toISO));
                }
                Object result2 = ((Callable)toISO).call(cx, scope, o, ScriptRuntime.emptyArgs);
                if (!ScriptRuntime.isPrimitive(result2)) {
                    throw ScriptRuntime.typeError1("msg.toisostring.must.return.primitive", ScriptRuntime.toString(result2));
                }
                return result2;
            }
        }
        if (!(thisObj instanceof NativeDate)) {
            throw NativeDate.incompatibleCallError(f2);
        }
        NativeDate realThis = (NativeDate)thisObj;
        double t2 = realThis.date;
        switch (id) {
            case 2: 
            case 3: 
            case 4: {
                if (t2 == t2) {
                    return NativeDate.date_format(t2, id);
                }
                return js_NaN_date_str;
            }
            case 5: 
            case 6: 
            case 7: {
                if (t2 == t2) {
                    return NativeDate.toLocale_helper(t2, id);
                }
                return js_NaN_date_str;
            }
            case 8: {
                if (t2 == t2) {
                    return NativeDate.js_toUTCString(t2);
                }
                return js_NaN_date_str;
            }
            case 9: {
                return "(new Date(" + ScriptRuntime.toString(t2) + "))";
            }
            case 10: 
            case 11: {
                return ScriptRuntime.wrapNumber(t2);
            }
            case 12: 
            case 13: 
            case 14: {
                if (t2 == t2) {
                    if (id != 14) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.YearFromTime(t2);
                    if (id == 12) {
                        if (cx.hasFeature(1)) {
                            if (1900.0 <= t2 && t2 < 2000.0) {
                                t2 -= 1900.0;
                            }
                        } else {
                            t2 -= 1900.0;
                        }
                    }
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 15: 
            case 16: {
                if (t2 == t2) {
                    if (id == 15) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.MonthFromTime(t2);
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 17: 
            case 18: {
                if (t2 == t2) {
                    if (id == 17) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.DateFromTime(t2);
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 19: 
            case 20: {
                if (t2 == t2) {
                    if (id == 19) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.WeekDay(t2);
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 21: 
            case 22: {
                if (t2 == t2) {
                    if (id == 21) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.HourFromTime(t2);
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 23: 
            case 24: {
                if (t2 == t2) {
                    if (id == 23) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.MinFromTime(t2);
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 25: 
            case 26: {
                if (t2 == t2) {
                    if (id == 25) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.SecFromTime(t2);
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 27: 
            case 28: {
                if (t2 == t2) {
                    if (id == 27) {
                        t2 = NativeDate.LocalTime(t2);
                    }
                    t2 = NativeDate.msFromTime(t2);
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 29: {
                if (t2 == t2) {
                    t2 = (t2 - NativeDate.LocalTime(t2)) / 60000.0;
                }
                return ScriptRuntime.wrapNumber(t2);
            }
            case 30: {
                realThis.date = t2 = NativeDate.TimeClip(ScriptRuntime.toNumber(args2, 0));
                return ScriptRuntime.wrapNumber(t2);
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                realThis.date = t2 = NativeDate.makeTime(t2, args2, id);
                return ScriptRuntime.wrapNumber(t2);
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                realThis.date = t2 = NativeDate.makeDate(t2, args2, id);
                return ScriptRuntime.wrapNumber(t2);
            }
            case 45: {
                double year2 = ScriptRuntime.toNumber(args2, 0);
                if (year2 != year2 || Double.isInfinite(year2)) {
                    t2 = ScriptRuntime.NaN;
                } else {
                    t2 = t2 != t2 ? 0.0 : NativeDate.LocalTime(t2);
                    if (year2 >= 0.0 && year2 <= 99.0) {
                        year2 += 1900.0;
                    }
                    double day2 = NativeDate.MakeDay(year2, NativeDate.MonthFromTime(t2), NativeDate.DateFromTime(t2));
                    t2 = NativeDate.MakeDate(day2, NativeDate.TimeWithinDay(t2));
                    t2 = NativeDate.internalUTC(t2);
                    t2 = NativeDate.TimeClip(t2);
                }
                realThis.date = t2;
                return ScriptRuntime.wrapNumber(t2);
            }
            case 46: {
                if (t2 == t2) {
                    return NativeDate.js_toISOString(t2);
                }
                String msg = ScriptRuntime.getMessage0("msg.invalid.date");
                throw ScriptRuntime.constructError("RangeError", msg);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    private static double Day(double t2) {
        return Math.floor(t2 / 8.64E7);
    }

    private static double TimeWithinDay(double t2) {
        double result2 = t2 % 8.64E7;
        if (result2 < 0.0) {
            result2 += 8.64E7;
        }
        return result2;
    }

    private static boolean IsLeapYear(int year2) {
        return year2 % 4 == 0 && (year2 % 100 != 0 || year2 % 400 == 0);
    }

    private static double DayFromYear(double y) {
        return 365.0 * (y - 1970.0) + Math.floor((y - 1969.0) / 4.0) - Math.floor((y - 1901.0) / 100.0) + Math.floor((y - 1601.0) / 400.0);
    }

    private static double TimeFromYear(double y) {
        return NativeDate.DayFromYear(y) * 8.64E7;
    }

    private static int YearFromTime(double t2) {
        if (Double.isInfinite(t2) || Double.isNaN(t2)) {
            return 0;
        }
        double y = Math.floor(t2 / 3.1556952E10) + 1970.0;
        double t22 = NativeDate.TimeFromYear(y);
        if (t22 > t2) {
            y -= 1.0;
        } else if (t22 + 8.64E7 * NativeDate.DaysInYear(y) <= t2) {
            y += 1.0;
        }
        return (int)y;
    }

    private static double DayFromMonth(int m4, int year2) {
        int day2 = m4 * 30;
        day2 = m4 >= 7 ? (day2 += m4 / 2 - 1) : (m4 >= 2 ? (day2 += (m4 - 1) / 2 - 1) : (day2 += m4));
        if (m4 >= 2 && NativeDate.IsLeapYear(year2)) {
            ++day2;
        }
        return day2;
    }

    private static double DaysInYear(double year2) {
        if (Double.isInfinite(year2) || Double.isNaN(year2)) {
            return ScriptRuntime.NaN;
        }
        return NativeDate.IsLeapYear((int)year2) ? 366.0 : 365.0;
    }

    private static int DaysInMonth(int year2, int month) {
        if (month == 2) {
            return NativeDate.IsLeapYear(year2) ? 29 : 28;
        }
        return month >= 8 ? 31 - (month & 1) : 30 + (month & 1);
    }

    private static int MonthFromTime(double t2) {
        int mstart;
        int year2 = NativeDate.YearFromTime(t2);
        int d2 = (int)(NativeDate.Day(t2) - NativeDate.DayFromYear(year2));
        if ((d2 -= 59) < 0) {
            return d2 < -28 ? 0 : 1;
        }
        if (NativeDate.IsLeapYear(year2)) {
            if (d2 == 0) {
                return 1;
            }
            --d2;
        }
        int estimate = d2 / 30;
        switch (estimate) {
            case 0: {
                return 2;
            }
            case 1: {
                mstart = 31;
                break;
            }
            case 2: {
                mstart = 61;
                break;
            }
            case 3: {
                mstart = 92;
                break;
            }
            case 4: {
                mstart = 122;
                break;
            }
            case 5: {
                mstart = 153;
                break;
            }
            case 6: {
                mstart = 184;
                break;
            }
            case 7: {
                mstart = 214;
                break;
            }
            case 8: {
                mstart = 245;
                break;
            }
            case 9: {
                mstart = 275;
                break;
            }
            case 10: {
                return 11;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        return d2 >= mstart ? estimate + 2 : estimate + 1;
    }

    private static int DateFromTime(double t2) {
        int mstart;
        int mdays;
        int year2 = NativeDate.YearFromTime(t2);
        int d2 = (int)(NativeDate.Day(t2) - NativeDate.DayFromYear(year2));
        if ((d2 -= 59) < 0) {
            return d2 < -28 ? d2 + 31 + 28 + 1 : d2 + 28 + 1;
        }
        if (NativeDate.IsLeapYear(year2)) {
            if (d2 == 0) {
                return 29;
            }
            --d2;
        }
        switch (Math.round(d2 / 30)) {
            case 0: {
                return d2 + 1;
            }
            case 1: {
                mdays = 31;
                mstart = 31;
                break;
            }
            case 2: {
                mdays = 30;
                mstart = 61;
                break;
            }
            case 3: {
                mdays = 31;
                mstart = 92;
                break;
            }
            case 4: {
                mdays = 30;
                mstart = 122;
                break;
            }
            case 5: {
                mdays = 31;
                mstart = 153;
                break;
            }
            case 6: {
                mdays = 31;
                mstart = 184;
                break;
            }
            case 7: {
                mdays = 30;
                mstart = 214;
                break;
            }
            case 8: {
                mdays = 31;
                mstart = 245;
                break;
            }
            case 9: {
                mdays = 30;
                mstart = 275;
                break;
            }
            case 10: {
                return d2 - 275 + 1;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        if ((d2 -= mstart) < 0) {
            d2 += mdays;
        }
        return d2 + 1;
    }

    private static int WeekDay(double t2) {
        double result2 = NativeDate.Day(t2) + 4.0;
        if ((result2 %= 7.0) < 0.0) {
            result2 += 7.0;
        }
        return (int)result2;
    }

    private static double now() {
        return System.currentTimeMillis();
    }

    private static double DaylightSavingTA(double t2) {
        Date date;
        if (t2 < 0.0) {
            int year2 = NativeDate.EquivalentYear(NativeDate.YearFromTime(t2));
            double day2 = NativeDate.MakeDay(year2, NativeDate.MonthFromTime(t2), NativeDate.DateFromTime(t2));
            t2 = NativeDate.MakeDate(day2, NativeDate.TimeWithinDay(t2));
        }
        if (thisTimeZone.inDaylightTime(date = new Date((long)t2))) {
            return 3600000.0;
        }
        return 0.0;
    }

    private static int EquivalentYear(int year2) {
        int day2 = (int)NativeDate.DayFromYear(year2) + 4;
        if ((day2 %= 7) < 0) {
            day2 += 7;
        }
        if (NativeDate.IsLeapYear(year2)) {
            switch (day2) {
                case 0: {
                    return 1984;
                }
                case 1: {
                    return 1996;
                }
                case 2: {
                    return 1980;
                }
                case 3: {
                    return 1992;
                }
                case 4: {
                    return 1976;
                }
                case 5: {
                    return 1988;
                }
                case 6: {
                    return 1972;
                }
            }
        } else {
            switch (day2) {
                case 0: {
                    return 1978;
                }
                case 1: {
                    return 1973;
                }
                case 2: {
                    return 1985;
                }
                case 3: {
                    return 1986;
                }
                case 4: {
                    return 1981;
                }
                case 5: {
                    return 1971;
                }
                case 6: {
                    return 1977;
                }
            }
        }
        throw Kit.codeBug();
    }

    private static double LocalTime(double t2) {
        return t2 + LocalTZA + NativeDate.DaylightSavingTA(t2);
    }

    private static double internalUTC(double t2) {
        return t2 - LocalTZA - NativeDate.DaylightSavingTA(t2 - LocalTZA);
    }

    private static int HourFromTime(double t2) {
        double result2 = Math.floor(t2 / 3600000.0) % 24.0;
        if (result2 < 0.0) {
            result2 += 24.0;
        }
        return (int)result2;
    }

    private static int MinFromTime(double t2) {
        double result2 = Math.floor(t2 / 60000.0) % 60.0;
        if (result2 < 0.0) {
            result2 += 60.0;
        }
        return (int)result2;
    }

    private static int SecFromTime(double t2) {
        double result2 = Math.floor(t2 / 1000.0) % 60.0;
        if (result2 < 0.0) {
            result2 += 60.0;
        }
        return (int)result2;
    }

    private static int msFromTime(double t2) {
        double result2 = t2 % 1000.0;
        if (result2 < 0.0) {
            result2 += 1000.0;
        }
        return (int)result2;
    }

    private static double MakeTime(double hour2, double min2, double sec, double ms) {
        return ((hour2 * 60.0 + min2) * 60.0 + sec) * 1000.0 + ms;
    }

    private static double MakeDay(double year2, double month, double date) {
        year2 += Math.floor(month / 12.0);
        if ((month %= 12.0) < 0.0) {
            month += 12.0;
        }
        double yearday = Math.floor(NativeDate.TimeFromYear(year2) / 8.64E7);
        double monthday = NativeDate.DayFromMonth((int)month, (int)year2);
        return yearday + monthday + date - 1.0;
    }

    private static double MakeDate(double day2, double time) {
        return day2 * 8.64E7 + time;
    }

    private static double TimeClip(double d2) {
        if (d2 != d2 || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY || Math.abs(d2) > 8.64E15) {
            return ScriptRuntime.NaN;
        }
        if (d2 > 0.0) {
            return Math.floor(d2 + 0.0);
        }
        return Math.ceil(d2 + 0.0);
    }

    private static double date_msecFromDate(double year2, double mon, double mday, double hour2, double min2, double sec, double msec) {
        double day2 = NativeDate.MakeDay(year2, mon, mday);
        double time = NativeDate.MakeTime(hour2, min2, sec, msec);
        double result2 = NativeDate.MakeDate(day2, time);
        return result2;
    }

    private static double date_msecFromArgs(Object[] args2) {
        double[] array = new double[7];
        for (int loop2 = 0; loop2 < 7; ++loop2) {
            if (loop2 < args2.length) {
                double d2 = ScriptRuntime.toNumber(args2[loop2]);
                if (d2 != d2 || Double.isInfinite(d2)) {
                    return ScriptRuntime.NaN;
                }
                array[loop2] = ScriptRuntime.toInteger(args2[loop2]);
                continue;
            }
            array[loop2] = loop2 == 2 ? 1.0 : 0.0;
        }
        if (array[0] >= 0.0 && array[0] <= 99.0) {
            array[0] = array[0] + 1900.0;
        }
        return NativeDate.date_msecFromDate(array[0], array[1], array[2], array[3], array[4], array[5], array[6]);
    }

    private static double jsStaticFunction_UTC(Object[] args2) {
        return NativeDate.TimeClip(NativeDate.date_msecFromArgs(args2));
    }

    private static double parseISOString(String s2) {
        int ERROR = -1;
        boolean YEAR = false;
        boolean MONTH = true;
        int DAY = 2;
        int HOUR = 3;
        int MIN = 4;
        int SEC = 5;
        int MSEC = 6;
        int TZHOUR = 7;
        int TZMIN = 8;
        int state = 0;
        int[] values2 = new int[]{1970, 1, 1, 0, 0, 0, 0, -1, -1};
        int yearlen = 4;
        int yearmod = 1;
        int tzmod = 1;
        int i2 = 0;
        int len2 = s2.length();
        if (len2 != 0) {
            char c2 = s2.charAt(0);
            if (c2 == '+' || c2 == '-') {
                ++i2;
                yearlen = 6;
                yearmod = c2 == '-' ? -1 : 1;
            } else if (c2 == 'T') {
                ++i2;
                state = 3;
            }
        }
        block16: while (state != -1) {
            char c3;
            int m4 = i2 + (state == 0 ? yearlen : (state == 6 ? 3 : 2));
            if (m4 > len2) {
                state = -1;
                break;
            }
            int value2 = 0;
            while (i2 < m4) {
                c3 = s2.charAt(i2);
                if (c3 < '0' || c3 > '9') {
                    state = -1;
                    break block16;
                }
                value2 = 10 * value2 + (c3 - 48);
                ++i2;
            }
            values2[state] = value2;
            if (i2 == len2) {
                switch (state) {
                    case 3: 
                    case 7: {
                        state = -1;
                    }
                }
                break;
            }
            if ((c3 = s2.charAt(i2++)) == 'Z') {
                values2[7] = 0;
                values2[8] = 0;
                switch (state) {
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        state = -1;
                        break;
                    }
                }
                break;
            }
            switch (state) {
                case 0: 
                case 1: {
                    state = c3 == '-' ? state + 1 : (c3 == 'T' ? 3 : -1);
                    break;
                }
                case 2: {
                    state = c3 == 'T' ? 3 : -1;
                    break;
                }
                case 3: {
                    state = c3 == ':' ? 4 : -1;
                    break;
                }
                case 7: {
                    if (c3 != ':') {
                        --i2;
                    }
                    state = 8;
                    break;
                }
                case 4: {
                    state = c3 == ':' ? 5 : (c3 == '+' || c3 == '-' ? 7 : -1);
                    break;
                }
                case 5: {
                    state = c3 == '.' ? 6 : (c3 == '+' || c3 == '-' ? 7 : -1);
                    break;
                }
                case 6: {
                    state = c3 == '+' || c3 == '-' ? 7 : -1;
                    break;
                }
                case 8: {
                    state = -1;
                }
            }
            if (state != 7) continue;
            tzmod = c3 == '-' ? -1 : 1;
        }
        if (state != -1 && i2 == len2) {
            int year2 = values2[0];
            int month = values2[1];
            int day2 = values2[2];
            int hour2 = values2[3];
            int min2 = values2[4];
            int sec = values2[5];
            int msec = values2[6];
            int tzhour = values2[7];
            int tzmin = values2[8];
            if (year2 <= 275943 && month >= 1 && month <= 12 && day2 >= 1 && day2 <= NativeDate.DaysInMonth(year2, month) && hour2 <= 24 && (hour2 != 24 || min2 <= 0 && sec <= 0 && msec <= 0) && min2 <= 59 && sec <= 59 && tzhour <= 23 && tzmin <= 59) {
                double date = NativeDate.date_msecFromDate(year2 * yearmod, month - 1, day2, hour2, min2, sec, msec);
                if (tzhour != -1) {
                    date -= (double)(tzhour * 60 + tzmin) * 60000.0 * (double)tzmod;
                }
                if (!(date < -8.64E15) && !(date > 8.64E15)) {
                    return date;
                }
            }
        }
        return ScriptRuntime.NaN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double date_parseString(String s2) {
        double d2 = NativeDate.parseISOString(s2);
        if (d2 == d2) {
            return d2;
        }
        int year2 = -1;
        int mon = -1;
        int mday = -1;
        int hour2 = -1;
        int min2 = -1;
        int sec = -1;
        char c2 = '\u0000';
        char si = '\u0000';
        int i2 = 0;
        int n = -1;
        double tzoffset = -1.0;
        char prevc = '\u0000';
        int limit = 0;
        boolean seenplusminus = false;
        limit = s2.length();
        block13: while (i2 < limit) {
            c2 = s2.charAt(i2);
            ++i2;
            if (c2 <= ' ' || c2 == ',' || c2 == '-') {
                if (i2 >= limit) continue;
                si = s2.charAt(i2);
                if (c2 != '-' || '0' > si || si > '9') continue;
                prevc = c2;
                continue;
            }
            if (c2 == '(') {
                int depth = 1;
                while (i2 < limit) {
                    c2 = s2.charAt(i2);
                    ++i2;
                    if (c2 == '(') {
                        ++depth;
                        continue;
                    }
                    if (c2 != ')' || --depth > 0) continue;
                    continue block13;
                }
                continue;
            }
            if ('0' <= c2 && c2 <= '9') {
                n = c2 - 48;
                while (i2 < limit && '0' <= (c2 = s2.charAt(i2)) && c2 <= '9') {
                    n = n * 10 + c2 - 48;
                    ++i2;
                }
                if (prevc == '+' || prevc == '-') {
                    seenplusminus = true;
                    n = n < 24 ? (n *= 60) : n % 100 + n / 100 * 60;
                    if (prevc == '+') {
                        n = -n;
                    }
                    if (tzoffset != 0.0 && tzoffset != -1.0) {
                        return ScriptRuntime.NaN;
                    }
                    tzoffset = n;
                } else if (n >= 70 || prevc == '/' && mon >= 0 && mday >= 0 && year2 < 0) {
                    if (year2 >= 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (c2 > ' ' && c2 != ',' && c2 != '/' && i2 < limit) return ScriptRuntime.NaN;
                    year2 = n < 100 ? n + 1900 : n;
                } else if (c2 == ':') {
                    if (hour2 < 0) {
                        hour2 = n;
                    } else {
                        if (min2 >= 0) return ScriptRuntime.NaN;
                        min2 = n;
                    }
                } else if (c2 == '/') {
                    if (mon < 0) {
                        mon = n - 1;
                    } else {
                        if (mday >= 0) return ScriptRuntime.NaN;
                        mday = n;
                    }
                } else {
                    if (i2 < limit && c2 != ',' && c2 > ' ' && c2 != '-') {
                        return ScriptRuntime.NaN;
                    }
                    if (seenplusminus && n < 60) {
                        tzoffset = tzoffset < 0.0 ? (tzoffset -= (double)n) : (tzoffset += (double)n);
                    } else if (hour2 >= 0 && min2 < 0) {
                        min2 = n;
                    } else if (min2 >= 0 && sec < 0) {
                        sec = n;
                    } else {
                        if (mday >= 0) return ScriptRuntime.NaN;
                        mday = n;
                    }
                }
                prevc = '\u0000';
                continue;
            }
            if (c2 == '/' || c2 == ':' || c2 == '+' || c2 == '-') {
                prevc = c2;
                continue;
            }
            int st = i2 - 1;
            while (i2 < limit && ('A' <= (c2 = s2.charAt(i2)) && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z')) {
                ++i2;
            }
            int letterCount = i2 - st;
            if (letterCount < 2) {
                return ScriptRuntime.NaN;
            }
            String wtb = "am;pm;monday;tuesday;wednesday;thursday;friday;saturday;sunday;january;february;march;april;may;june;july;august;september;october;november;december;gmt;ut;utc;est;edt;cst;cdt;mst;mdt;pst;pdt;";
            int index = 0;
            int wtbOffset = 0;
            while (true) {
                int wtbNext;
                if ((wtbNext = wtb.indexOf(59, wtbOffset)) < 0) {
                    return ScriptRuntime.NaN;
                }
                if (wtb.regionMatches(true, wtbOffset, s2, st, letterCount)) break;
                wtbOffset = wtbNext + 1;
                ++index;
            }
            if (index < 2) {
                if (hour2 > 12 || hour2 < 0) {
                    return ScriptRuntime.NaN;
                }
                if (index == 0) {
                    if (hour2 != 12) continue;
                    hour2 = 0;
                    continue;
                }
                if (hour2 == 12) continue;
                hour2 += 12;
                continue;
            }
            if ((index -= 2) < 7) continue;
            if ((index -= 7) < 12) {
                if (mon >= 0) return ScriptRuntime.NaN;
                mon = index;
                continue;
            }
            switch (index -= 12) {
                case 0: {
                    tzoffset = 0.0;
                    continue block13;
                }
                case 1: {
                    tzoffset = 0.0;
                    continue block13;
                }
                case 2: {
                    tzoffset = 0.0;
                    continue block13;
                }
                case 3: {
                    tzoffset = 300.0;
                    continue block13;
                }
                case 4: {
                    tzoffset = 240.0;
                    continue block13;
                }
                case 5: {
                    tzoffset = 360.0;
                    continue block13;
                }
                case 6: {
                    tzoffset = 300.0;
                    continue block13;
                }
                case 7: {
                    tzoffset = 420.0;
                    continue block13;
                }
                case 8: {
                    tzoffset = 360.0;
                    continue block13;
                }
                case 9: {
                    tzoffset = 480.0;
                    continue block13;
                }
                case 10: {
                    tzoffset = 420.0;
                    continue block13;
                }
            }
            Kit.codeBug();
        }
        if (year2 < 0 || mon < 0 || mday < 0) {
            return ScriptRuntime.NaN;
        }
        if (sec < 0) {
            sec = 0;
        }
        if (min2 < 0) {
            min2 = 0;
        }
        if (hour2 < 0) {
            hour2 = 0;
        }
        double msec = NativeDate.date_msecFromDate(year2, mon, mday, hour2, min2, sec, 0.0);
        if (tzoffset != -1.0) return msec + tzoffset * 60000.0;
        return NativeDate.internalUTC(msec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String date_format(double t2, int methodId) {
        StringBuilder result2 = new StringBuilder(60);
        double local = NativeDate.LocalTime(t2);
        if (methodId != 3) {
            NativeDate.appendWeekDayName(result2, NativeDate.WeekDay(local));
            result2.append(' ');
            NativeDate.appendMonthName(result2, NativeDate.MonthFromTime(local));
            result2.append(' ');
            NativeDate.append0PaddedUint(result2, NativeDate.DateFromTime(local), 2);
            result2.append(' ');
            int year2 = NativeDate.YearFromTime(local);
            if (year2 < 0) {
                result2.append('-');
                year2 = -year2;
            }
            NativeDate.append0PaddedUint(result2, year2, 4);
            if (methodId != 4) {
                result2.append(' ');
            }
        }
        if (methodId != 4) {
            NativeDate.append0PaddedUint(result2, NativeDate.HourFromTime(local), 2);
            result2.append(':');
            NativeDate.append0PaddedUint(result2, NativeDate.MinFromTime(local), 2);
            result2.append(':');
            NativeDate.append0PaddedUint(result2, NativeDate.SecFromTime(local), 2);
            int minutes = (int)Math.floor((LocalTZA + NativeDate.DaylightSavingTA(t2)) / 60000.0);
            int offset = minutes / 60 * 100 + minutes % 60;
            if (offset > 0) {
                result2.append(" GMT+");
            } else {
                result2.append(" GMT-");
                offset = -offset;
            }
            NativeDate.append0PaddedUint(result2, offset, 4);
            if (timeZoneFormatter == null) {
                timeZoneFormatter = new SimpleDateFormat("zzz");
            }
            if (t2 < 0.0) {
                int equiv = NativeDate.EquivalentYear(NativeDate.YearFromTime(local));
                double day2 = NativeDate.MakeDay(equiv, NativeDate.MonthFromTime(t2), NativeDate.DateFromTime(t2));
                t2 = NativeDate.MakeDate(day2, NativeDate.TimeWithinDay(t2));
            }
            result2.append(" (");
            Date date = new Date((long)t2);
            DateFormat dateFormat = timeZoneFormatter;
            synchronized (dateFormat) {
                result2.append(timeZoneFormatter.format(date));
            }
            result2.append(')');
        }
        return result2.toString();
    }

    private static Object jsConstructor(Object[] args2) {
        NativeDate obj = new NativeDate();
        if (args2.length == 0) {
            obj.date = NativeDate.now();
            return obj;
        }
        if (args2.length == 1) {
            Object arg0 = args2[0];
            if (arg0 instanceof Scriptable) {
                arg0 = ((Scriptable)arg0).getDefaultValue(null);
            }
            double date = arg0 instanceof CharSequence ? NativeDate.date_parseString(arg0.toString()) : ScriptRuntime.toNumber(arg0);
            obj.date = NativeDate.TimeClip(date);
            return obj;
        }
        double time = NativeDate.date_msecFromArgs(args2);
        if (!Double.isNaN(time) && !Double.isInfinite(time)) {
            time = NativeDate.TimeClip(NativeDate.internalUTC(time));
        }
        obj.date = time;
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toLocale_helper(double t2, int methodId) {
        DateFormat formatter;
        switch (methodId) {
            case 5: {
                if (localeDateTimeFormatter == null) {
                    localeDateTimeFormatter = DateFormat.getDateTimeInstance(1, 1);
                }
                formatter = localeDateTimeFormatter;
                break;
            }
            case 6: {
                if (localeTimeFormatter == null) {
                    localeTimeFormatter = DateFormat.getTimeInstance(1);
                }
                formatter = localeTimeFormatter;
                break;
            }
            case 7: {
                if (localeDateFormatter == null) {
                    localeDateFormatter = DateFormat.getDateInstance(1);
                }
                formatter = localeDateFormatter;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        DateFormat dateFormat = formatter;
        synchronized (dateFormat) {
            return formatter.format(new Date((long)t2));
        }
    }

    private static String js_toUTCString(double date) {
        StringBuilder result2 = new StringBuilder(60);
        NativeDate.appendWeekDayName(result2, NativeDate.WeekDay(date));
        result2.append(", ");
        NativeDate.append0PaddedUint(result2, NativeDate.DateFromTime(date), 2);
        result2.append(' ');
        NativeDate.appendMonthName(result2, NativeDate.MonthFromTime(date));
        result2.append(' ');
        int year2 = NativeDate.YearFromTime(date);
        if (year2 < 0) {
            result2.append('-');
            year2 = -year2;
        }
        NativeDate.append0PaddedUint(result2, year2, 4);
        result2.append(' ');
        NativeDate.append0PaddedUint(result2, NativeDate.HourFromTime(date), 2);
        result2.append(':');
        NativeDate.append0PaddedUint(result2, NativeDate.MinFromTime(date), 2);
        result2.append(':');
        NativeDate.append0PaddedUint(result2, NativeDate.SecFromTime(date), 2);
        result2.append(" GMT");
        return result2.toString();
    }

    private static String js_toISOString(double t2) {
        StringBuilder result2 = new StringBuilder(27);
        int year2 = NativeDate.YearFromTime(t2);
        if (year2 < 0) {
            result2.append('-');
            NativeDate.append0PaddedUint(result2, -year2, 6);
        } else if (year2 > 9999) {
            NativeDate.append0PaddedUint(result2, year2, 6);
        } else {
            NativeDate.append0PaddedUint(result2, year2, 4);
        }
        result2.append('-');
        NativeDate.append0PaddedUint(result2, NativeDate.MonthFromTime(t2) + 1, 2);
        result2.append('-');
        NativeDate.append0PaddedUint(result2, NativeDate.DateFromTime(t2), 2);
        result2.append('T');
        NativeDate.append0PaddedUint(result2, NativeDate.HourFromTime(t2), 2);
        result2.append(':');
        NativeDate.append0PaddedUint(result2, NativeDate.MinFromTime(t2), 2);
        result2.append(':');
        NativeDate.append0PaddedUint(result2, NativeDate.SecFromTime(t2), 2);
        result2.append('.');
        NativeDate.append0PaddedUint(result2, NativeDate.msFromTime(t2), 3);
        result2.append('Z');
        return result2.toString();
    }

    private static void append0PaddedUint(StringBuilder sb, int i2, int minWidth) {
        if (i2 < 0) {
            Kit.codeBug();
        }
        int scale = 1;
        --minWidth;
        if (i2 >= 10) {
            if (i2 < 1000000000) {
                int newScale;
                while (i2 >= (newScale = scale * 10)) {
                    --minWidth;
                    scale = newScale;
                }
            } else {
                minWidth -= 9;
                scale = 1000000000;
            }
        }
        while (minWidth > 0) {
            sb.append('0');
            --minWidth;
        }
        while (scale != 1) {
            sb.append((char)(48 + i2 / scale));
            i2 %= scale;
            scale /= 10;
        }
        sb.append((char)(48 + i2));
    }

    private static void appendMonthName(StringBuilder sb, int index) {
        String months = "JanFebMarAprMayJunJulAugSepOctNovDec";
        index *= 3;
        for (int i2 = 0; i2 != 3; ++i2) {
            sb.append(months.charAt(index + i2));
        }
    }

    private static void appendWeekDayName(StringBuilder sb, int index) {
        String days = "SunMonTueWedThuFriSat";
        index *= 3;
        for (int i2 = 0; i2 != 3; ++i2) {
            sb.append(days.charAt(index + i2));
        }
    }

    private static double makeTime(double date, Object[] args2, int methodId) {
        int i2;
        int numNums;
        int maxargs;
        if (args2.length == 0) {
            return ScriptRuntime.NaN;
        }
        boolean local = true;
        switch (methodId) {
            case 32: {
                local = false;
            }
            case 31: {
                maxargs = 1;
                break;
            }
            case 34: {
                local = false;
            }
            case 33: {
                maxargs = 2;
                break;
            }
            case 36: {
                local = false;
            }
            case 35: {
                maxargs = 3;
                break;
            }
            case 38: {
                local = false;
            }
            case 37: {
                maxargs = 4;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        boolean hasNaN = false;
        int n = numNums = args2.length < maxargs ? args2.length : maxargs;
        assert (numNums <= 4);
        double[] nums = new double[4];
        for (i2 = 0; i2 < numNums; ++i2) {
            double d2 = ScriptRuntime.toNumber(args2[i2]);
            if (d2 != d2 || Double.isInfinite(d2)) {
                hasNaN = true;
                continue;
            }
            nums[i2] = ScriptRuntime.toInteger(d2);
        }
        if (hasNaN || date != date) {
            return ScriptRuntime.NaN;
        }
        i2 = 0;
        int stop = numNums;
        double lorutime = local ? NativeDate.LocalTime(date) : date;
        double hour2 = maxargs >= 4 && i2 < stop ? nums[i2++] : (double)NativeDate.HourFromTime(lorutime);
        double min2 = maxargs >= 3 && i2 < stop ? nums[i2++] : (double)NativeDate.MinFromTime(lorutime);
        double sec = maxargs >= 2 && i2 < stop ? nums[i2++] : (double)NativeDate.SecFromTime(lorutime);
        double msec = maxargs >= 1 && i2 < stop ? nums[i2++] : (double)NativeDate.msFromTime(lorutime);
        double time = NativeDate.MakeTime(hour2, min2, sec, msec);
        double result2 = NativeDate.MakeDate(NativeDate.Day(lorutime), time);
        if (local) {
            result2 = NativeDate.internalUTC(result2);
        }
        return NativeDate.TimeClip(result2);
    }

    private static double makeDate(double date, Object[] args2, int methodId) {
        double lorutime;
        int i2;
        int numNums;
        int maxargs;
        if (args2.length == 0) {
            return ScriptRuntime.NaN;
        }
        boolean local = true;
        switch (methodId) {
            case 40: {
                local = false;
            }
            case 39: {
                maxargs = 1;
                break;
            }
            case 42: {
                local = false;
            }
            case 41: {
                maxargs = 2;
                break;
            }
            case 44: {
                local = false;
            }
            case 43: {
                maxargs = 3;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        boolean hasNaN = false;
        int n = numNums = args2.length < maxargs ? args2.length : maxargs;
        assert (1 <= numNums && numNums <= 3);
        double[] nums = new double[3];
        for (i2 = 0; i2 < numNums; ++i2) {
            double d2 = ScriptRuntime.toNumber(args2[i2]);
            if (d2 != d2 || Double.isInfinite(d2)) {
                hasNaN = true;
                continue;
            }
            nums[i2] = ScriptRuntime.toInteger(d2);
        }
        if (hasNaN) {
            return ScriptRuntime.NaN;
        }
        i2 = 0;
        int stop = numNums;
        if (date != date) {
            if (maxargs < 3) {
                return ScriptRuntime.NaN;
            }
            lorutime = 0.0;
        } else {
            lorutime = local ? NativeDate.LocalTime(date) : date;
        }
        double year2 = maxargs >= 3 && i2 < stop ? nums[i2++] : (double)NativeDate.YearFromTime(lorutime);
        double month = maxargs >= 2 && i2 < stop ? nums[i2++] : (double)NativeDate.MonthFromTime(lorutime);
        double day2 = maxargs >= 1 && i2 < stop ? nums[i2++] : (double)NativeDate.DateFromTime(lorutime);
        day2 = NativeDate.MakeDay(year2, month, day2);
        double result2 = NativeDate.MakeDate(day2, NativeDate.TimeWithinDay(lorutime));
        if (local) {
            result2 = NativeDate.internalUTC(result2);
        }
        return NativeDate.TimeClip(result2);
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block59: {
            id = 0;
            String X = null;
            block0 : switch (s2.length()) {
                case 6: {
                    char c2 = s2.charAt(0);
                    if (c2 == 'g') {
                        X = "getDay";
                        id = 19;
                        break;
                    }
                    if (c2 != 't') break;
                    X = "toJSON";
                    id = 47;
                    break;
                }
                case 7: {
                    switch (s2.charAt(3)) {
                        case 'D': {
                            char c3 = s2.charAt(0);
                            if (c3 == 'g') {
                                X = "getDate";
                                id = 17;
                                break block0;
                            }
                            if (c3 != 's') break block0;
                            X = "setDate";
                            id = 39;
                            break block0;
                        }
                        case 'T': {
                            char c4 = s2.charAt(0);
                            if (c4 == 'g') {
                                X = "getTime";
                                id = 11;
                                break block0;
                            }
                            if (c4 != 's') break block0;
                            X = "setTime";
                            id = 30;
                            break block0;
                        }
                        case 'Y': {
                            char c5 = s2.charAt(0);
                            if (c5 == 'g') {
                                X = "getYear";
                                id = 12;
                                break block0;
                            }
                            if (c5 != 's') break block0;
                            X = "setYear";
                            id = 45;
                            break block0;
                        }
                        case 'u': {
                            X = "valueOf";
                            id = 10;
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (s2.charAt(3)) {
                        case 'H': {
                            char c6 = s2.charAt(0);
                            if (c6 == 'g') {
                                X = "getHours";
                                id = 21;
                                break block0;
                            }
                            if (c6 != 's') break block0;
                            X = "setHours";
                            id = 37;
                            break block0;
                        }
                        case 'M': {
                            char c7 = s2.charAt(0);
                            if (c7 == 'g') {
                                X = "getMonth";
                                id = 15;
                                break block0;
                            }
                            if (c7 != 's') break block0;
                            X = "setMonth";
                            id = 41;
                            break block0;
                        }
                        case 'o': {
                            X = "toSource";
                            id = 9;
                            break block0;
                        }
                        case 't': {
                            X = "toString";
                            id = 2;
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    X = "getUTCDay";
                    id = 20;
                    break;
                }
                case 10: {
                    char c8 = s2.charAt(3);
                    if (c8 == 'M') {
                        c8 = s2.charAt(0);
                        if (c8 == 'g') {
                            X = "getMinutes";
                            id = 23;
                            break;
                        }
                        if (c8 != 's') break;
                        X = "setMinutes";
                        id = 35;
                        break;
                    }
                    if (c8 == 'S') {
                        c8 = s2.charAt(0);
                        if (c8 == 'g') {
                            X = "getSeconds";
                            id = 25;
                            break;
                        }
                        if (c8 != 's') break;
                        X = "setSeconds";
                        id = 33;
                        break;
                    }
                    if (c8 != 'U') break;
                    c8 = s2.charAt(0);
                    if (c8 == 'g') {
                        X = "getUTCDate";
                        id = 18;
                        break;
                    }
                    if (c8 != 's') break;
                    X = "setUTCDate";
                    id = 40;
                    break;
                }
                case 11: {
                    switch (s2.charAt(3)) {
                        case 'F': {
                            char c9 = s2.charAt(0);
                            if (c9 == 'g') {
                                X = "getFullYear";
                                id = 13;
                                break block0;
                            }
                            if (c9 != 's') break block0;
                            X = "setFullYear";
                            id = 43;
                            break block0;
                        }
                        case 'M': {
                            X = "toGMTString";
                            id = 8;
                            break block0;
                        }
                        case 'S': {
                            X = "toISOString";
                            id = 46;
                            break block0;
                        }
                        case 'T': {
                            X = "toUTCString";
                            id = 8;
                            break block0;
                        }
                        case 'U': {
                            char c10 = s2.charAt(0);
                            if (c10 == 'g') {
                                c10 = s2.charAt(9);
                                if (c10 == 'r') {
                                    X = "getUTCHours";
                                    id = 22;
                                    break block0;
                                }
                                if (c10 != 't') break block0;
                                X = "getUTCMonth";
                                id = 16;
                                break block0;
                            }
                            if (c10 != 's') break block0;
                            c10 = s2.charAt(9);
                            if (c10 == 'r') {
                                X = "setUTCHours";
                                id = 38;
                                break block0;
                            }
                            if (c10 != 't') break block0;
                            X = "setUTCMonth";
                            id = 42;
                            break block0;
                        }
                        case 's': {
                            X = "constructor";
                            id = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case 12: {
                    char c11 = s2.charAt(2);
                    if (c11 == 'D') {
                        X = "toDateString";
                        id = 4;
                        break;
                    }
                    if (c11 != 'T') break;
                    X = "toTimeString";
                    id = 3;
                    break;
                }
                case 13: {
                    char c12 = s2.charAt(0);
                    if (c12 == 'g') {
                        c12 = s2.charAt(6);
                        if (c12 == 'M') {
                            X = "getUTCMinutes";
                            id = 24;
                            break;
                        }
                        if (c12 != 'S') break;
                        X = "getUTCSeconds";
                        id = 26;
                        break;
                    }
                    if (c12 != 's') break;
                    c12 = s2.charAt(6);
                    if (c12 == 'M') {
                        X = "setUTCMinutes";
                        id = 36;
                        break;
                    }
                    if (c12 != 'S') break;
                    X = "setUTCSeconds";
                    id = 34;
                    break;
                }
                case 14: {
                    char c13 = s2.charAt(0);
                    if (c13 == 'g') {
                        X = "getUTCFullYear";
                        id = 14;
                        break;
                    }
                    if (c13 == 's') {
                        X = "setUTCFullYear";
                        id = 44;
                        break;
                    }
                    if (c13 != 't') break;
                    X = "toLocaleString";
                    id = 5;
                    break;
                }
                case 15: {
                    char c14 = s2.charAt(0);
                    if (c14 == 'g') {
                        X = "getMilliseconds";
                        id = 27;
                        break;
                    }
                    if (c14 != 's') break;
                    X = "setMilliseconds";
                    id = 31;
                    break;
                }
                case 17: {
                    X = "getTimezoneOffset";
                    id = 29;
                    break;
                }
                case 18: {
                    char c15 = s2.charAt(0);
                    if (c15 == 'g') {
                        X = "getUTCMilliseconds";
                        id = 28;
                        break;
                    }
                    if (c15 == 's') {
                        X = "setUTCMilliseconds";
                        id = 32;
                        break;
                    }
                    if (c15 != 't') break;
                    c15 = s2.charAt(8);
                    if (c15 == 'D') {
                        X = "toLocaleDateString";
                        id = 7;
                        break;
                    }
                    if (c15 != 'T') break;
                    X = "toLocaleTimeString";
                    id = 6;
                    break;
                }
            }
            if (X == null || X == s2 || X.equals(s2)) break block59;
            id = 0;
        }
        return id;
    }
}

