/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.XMLLib;

public class NativeGlobal
implements Serializable,
IdFunctionCall {
    static final long serialVersionUID = 6080442165748707530L;
    private static final String URI_DECODE_RESERVED = ";/?:@&=+$,#";
    private static final int INVALID_UTF8 = Integer.MAX_VALUE;
    private static final Object FTAG = "Global";
    private static final int Id_decodeURI = 1;
    private static final int Id_decodeURIComponent = 2;
    private static final int Id_encodeURI = 3;
    private static final int Id_encodeURIComponent = 4;
    private static final int Id_escape = 5;
    private static final int Id_eval = 6;
    private static final int Id_isFinite = 7;
    private static final int Id_isNaN = 8;
    private static final int Id_isXMLName = 9;
    private static final int Id_parseFloat = 10;
    private static final int Id_parseInt = 11;
    private static final int Id_unescape = 12;
    private static final int Id_uneval = 13;
    private static final int LAST_SCOPE_FUNCTION_ID = 13;
    private static final int Id_new_CommonError = 14;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeGlobal obj = new NativeGlobal();
        for (int id = 1; id <= 13; ++id) {
            String name;
            int arity = 1;
            switch (id) {
                case 1: {
                    name = "decodeURI";
                    break;
                }
                case 2: {
                    name = "decodeURIComponent";
                    break;
                }
                case 3: {
                    name = "encodeURI";
                    break;
                }
                case 4: {
                    name = "encodeURIComponent";
                    break;
                }
                case 5: {
                    name = "escape";
                    break;
                }
                case 6: {
                    name = "eval";
                    break;
                }
                case 7: {
                    name = "isFinite";
                    break;
                }
                case 8: {
                    name = "isNaN";
                    break;
                }
                case 9: {
                    name = "isXMLName";
                    break;
                }
                case 10: {
                    name = "parseFloat";
                    break;
                }
                case 11: {
                    name = "parseInt";
                    arity = 2;
                    break;
                }
                case 12: {
                    name = "unescape";
                    break;
                }
                case 13: {
                    name = "uneval";
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            IdFunctionObject f2 = new IdFunctionObject(obj, FTAG, id, name, arity, scope);
            if (sealed) {
                f2.sealObject();
            }
            f2.exportAsScopeProperty();
        }
        ScriptableObject.defineProperty(scope, "NaN", ScriptRuntime.NaNobj, 7);
        ScriptableObject.defineProperty(scope, "Infinity", ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        ScriptableObject.defineProperty(scope, "undefined", Undefined.instance, 7);
        for (TopLevel.NativeErrors error2 : TopLevel.NativeErrors.values()) {
            if (error2 == TopLevel.NativeErrors.Error) continue;
            String name = error2.name();
            ScriptableObject errorProto = (ScriptableObject)ScriptRuntime.newBuiltinObject(cx, scope, TopLevel.Builtins.Error, ScriptRuntime.emptyArgs);
            errorProto.put("name", (Scriptable)errorProto, (Object)name);
            errorProto.put("message", (Scriptable)errorProto, (Object)"");
            IdFunctionObject ctor = new IdFunctionObject(obj, FTAG, 14, name, 1, scope);
            ctor.markAsConstructor(errorProto);
            errorProto.put("constructor", (Scriptable)errorProto, (Object)ctor);
            errorProto.setAttributes("constructor", 2);
            if (sealed) {
                errorProto.sealObject();
                ctor.sealObject();
            }
            ctor.exportAsScopeProperty();
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (f2.hasTag(FTAG)) {
            int methodId = f2.methodId();
            switch (methodId) {
                case 1: 
                case 2: {
                    String str = ScriptRuntime.toString(args2, 0);
                    return NativeGlobal.decode(str, methodId == 1);
                }
                case 3: 
                case 4: {
                    String str = ScriptRuntime.toString(args2, 0);
                    return NativeGlobal.encode(str, methodId == 3);
                }
                case 5: {
                    return this.js_escape(args2);
                }
                case 6: {
                    return this.js_eval(cx, scope, args2);
                }
                case 7: {
                    if (args2.length < 1) {
                        return Boolean.FALSE;
                    }
                    return NativeNumber.isFinite(args2[0]);
                }
                case 8: {
                    double d2;
                    boolean result2 = args2.length < 1 ? true : (d2 = ScriptRuntime.toNumber(args2[0])) != d2;
                    return ScriptRuntime.wrapBoolean(result2);
                }
                case 9: {
                    Object name = args2.length == 0 ? Undefined.instance : args2[0];
                    XMLLib xmlLib = XMLLib.extractFromScope(scope);
                    return ScriptRuntime.wrapBoolean(xmlLib.isXMLName(cx, name));
                }
                case 10: {
                    return NativeGlobal.js_parseFloat(args2);
                }
                case 11: {
                    return NativeGlobal.js_parseInt(args2);
                }
                case 12: {
                    return this.js_unescape(args2);
                }
                case 13: {
                    Object value2 = args2.length != 0 ? args2[0] : Undefined.instance;
                    return ScriptRuntime.uneval(cx, scope, value2);
                }
                case 14: {
                    return NativeError.make(cx, scope, f2, args2);
                }
            }
        }
        throw f2.unknown();
    }

    static Object js_parseInt(Object[] args2) {
        char c2;
        String s2 = ScriptRuntime.toString(args2, 0);
        int radix = ScriptRuntime.toInt32(args2, 1);
        int len2 = s2.length();
        if (len2 == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean negative = false;
        int start2 = 0;
        while (ScriptRuntime.isStrWhiteSpaceChar(c2 = s2.charAt(start2)) && ++start2 < len2) {
        }
        if (c2 == '+' || (negative = c2 == '-')) {
            ++start2;
        }
        int NO_RADIX = -1;
        if (radix == 0) {
            radix = -1;
        } else {
            if (radix < 2 || radix > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (radix == 16 && len2 - start2 > 1 && s2.charAt(start2) == '0' && ((c2 = s2.charAt(start2 + 1)) == 'x' || c2 == 'X')) {
                start2 += 2;
            }
        }
        if (radix == -1) {
            radix = 10;
            if (len2 - start2 > 1 && s2.charAt(start2) == '0') {
                c2 = s2.charAt(start2 + 1);
                if (c2 == 'x' || c2 == 'X') {
                    radix = 16;
                    start2 += 2;
                } else if ('0' <= c2 && c2 <= '9') {
                    radix = 8;
                    ++start2;
                }
            }
        }
        double d2 = ScriptRuntime.stringToNumber(s2, start2, radix);
        return ScriptRuntime.wrapNumber(negative ? -d2 : d2);
    }

    static Object js_parseFloat(Object[] args2) {
        char c2;
        if (args2.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String s2 = ScriptRuntime.toString(args2[0]);
        int len2 = s2.length();
        int start2 = 0;
        while (true) {
            if (start2 == len2) {
                return ScriptRuntime.NaNobj;
            }
            c2 = s2.charAt(start2);
            if (!ScriptRuntime.isStrWhiteSpaceChar(c2)) break;
            ++start2;
        }
        int i2 = start2;
        if (c2 == '+' || c2 == '-') {
            if (++i2 == len2) {
                return ScriptRuntime.NaNobj;
            }
            c2 = s2.charAt(i2);
        }
        if (c2 == 'I') {
            if (i2 + 8 <= len2 && s2.regionMatches(i2, "Infinity", 0, 8)) {
                double d2 = s2.charAt(start2) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                return ScriptRuntime.wrapNumber(d2);
            }
            return ScriptRuntime.NaNobj;
        }
        int decimal = -1;
        int exponent = -1;
        boolean exponentValid = false;
        block9: while (i2 < len2) {
            switch (s2.charAt(i2)) {
                case '.': {
                    if (decimal != -1) break block9;
                    decimal = i2;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (exponent != -1 || i2 == len2 - 1) break block9;
                    exponent = i2;
                    break;
                }
                case '+': 
                case '-': {
                    if (exponent != i2 - 1) break block9;
                    if (i2 != len2 - 1) break;
                    --i2;
                    break block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (exponent == -1) break;
                    exponentValid = true;
                    break;
                }
                default: {
                    break block9;
                }
            }
            ++i2;
        }
        if (exponent != -1 && !exponentValid) {
            i2 = exponent;
        }
        s2 = s2.substring(start2, i2);
        try {
            return Double.valueOf(s2);
        }
        catch (NumberFormatException ex) {
            return ScriptRuntime.NaNobj;
        }
    }

    private Object js_escape(Object[] args2) {
        double d2;
        boolean URL_XALPHAS = true;
        int URL_XPALPHAS = 2;
        int URL_PATH = 4;
        String s2 = ScriptRuntime.toString(args2, 0);
        int mask = 7;
        if (args2.length > 1 && ((d2 = ScriptRuntime.toNumber(args2[1])) != d2 || (double)(mask = (int)d2) != d2 || 0 != (mask & 0xFFFFFFF8))) {
            throw Context.reportRuntimeError0("msg.bad.esc.mask");
        }
        StringBuilder sb = null;
        int L = s2.length();
        for (int k2 = 0; k2 != L; ++k2) {
            int hexSize;
            char c2 = s2.charAt(k2);
            if (mask != 0 && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '@' || c2 == '*' || c2 == '_' || c2 == '-' || c2 == '.' || 0 != (mask & 4) && (c2 == '/' || c2 == '+'))) {
                if (sb == null) continue;
                sb.append(c2);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(L + 3);
                sb.append(s2);
                sb.setLength(k2);
            }
            if (c2 < '\u0100') {
                if (c2 == ' ' && mask == 2) {
                    sb.append('+');
                    continue;
                }
                sb.append('%');
                hexSize = 2;
            } else {
                sb.append('%');
                sb.append('u');
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c2 >> shift;
                int hc = digit < 10 ? 48 + digit : 55 + digit;
                sb.append((char)hc);
            }
        }
        return sb == null ? s2 : sb.toString();
    }

    private Object js_unescape(Object[] args2) {
        String s2 = ScriptRuntime.toString(args2, 0);
        int firstEscapePos = s2.indexOf(37);
        if (firstEscapePos >= 0) {
            int L = s2.length();
            char[] buf = s2.toCharArray();
            int destination = firstEscapePos;
            int k2 = firstEscapePos;
            while (k2 != L) {
                char c2 = buf[k2];
                if (c2 == '%' && ++k2 != L) {
                    int end2;
                    int start2;
                    if (buf[k2] == 'u') {
                        start2 = k2 + 1;
                        end2 = k2 + 5;
                    } else {
                        start2 = k2;
                        end2 = k2 + 2;
                    }
                    if (end2 <= L) {
                        int x = 0;
                        for (int i2 = start2; i2 != end2; ++i2) {
                            x = Kit.xDigitToInt(buf[i2], x);
                        }
                        if (x >= 0) {
                            c2 = (char)x;
                            k2 = end2;
                        }
                    }
                }
                buf[destination] = c2;
                ++destination;
            }
            s2 = new String(buf, 0, destination);
        }
        return s2;
    }

    private Object js_eval(Context cx, Scriptable scope, Object[] args2) {
        Scriptable global = ScriptableObject.getTopLevelScope(scope);
        return ScriptRuntime.evalSpecial(cx, global, global, args2, "eval code", 1);
    }

    static boolean isEvalFunction(Object functionObj) {
        IdFunctionObject function;
        return functionObj instanceof IdFunctionObject && (function = (IdFunctionObject)functionObj).hasTag(FTAG) && function.methodId() == 6;
    }

    @Deprecated
    public static EcmaError constructError(Context cx, String error2, String message, Scriptable scope) {
        return ScriptRuntime.constructError(error2, message);
    }

    @Deprecated
    public static EcmaError constructError(Context cx, String error2, String message, Scriptable scope, String sourceName, int lineNumber, int columnNumber, String lineSource) {
        return ScriptRuntime.constructError(error2, message, sourceName, lineNumber, lineSource, columnNumber);
    }

    private static String encode(String str, boolean fullUri) {
        byte[] utf8buf = null;
        StringBuilder sb = null;
        int length = str.length();
        for (int k2 = 0; k2 != length; ++k2) {
            int V;
            int C2 = str.charAt(k2);
            if (NativeGlobal.encodeUnescaped((char)C2, fullUri)) {
                if (sb == null) continue;
                sb.append((char)C2);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(length + 3);
                sb.append(str);
                sb.setLength(k2);
                utf8buf = new byte[6];
            }
            if (56320 <= C2 && C2 <= 57343) {
                throw NativeGlobal.uriError();
            }
            if (C2 < 55296 || 56319 < C2) {
                V = C2;
            } else {
                if (++k2 == length) {
                    throw NativeGlobal.uriError();
                }
                char C22 = str.charAt(k2);
                if ('\udc00' > C22 || C22 > '\udfff') {
                    throw NativeGlobal.uriError();
                }
                V = (C2 - 55296 << 10) + (C22 - 56320) + 65536;
            }
            int L = NativeGlobal.oneUcs4ToUtf8Char(utf8buf, V);
            for (int j2 = 0; j2 < L; ++j2) {
                int d2 = 0xFF & utf8buf[j2];
                sb.append('%');
                sb.append(NativeGlobal.toHexChar(d2 >>> 4));
                sb.append(NativeGlobal.toHexChar(d2 & 0xF));
            }
        }
        return sb == null ? str : sb.toString();
    }

    private static char toHexChar(int i2) {
        if (i2 >> 4 != 0) {
            Kit.codeBug();
        }
        return (char)(i2 < 10 ? i2 + 48 : i2 - 10 + 65);
    }

    private static int unHex(char c2) {
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        return -1;
    }

    private static int unHex(char c1, char c2) {
        int i1 = NativeGlobal.unHex(c1);
        int i2 = NativeGlobal.unHex(c2);
        if (i1 >= 0 && i2 >= 0) {
            return i1 << 4 | i2;
        }
        return -1;
    }

    private static String decode(String str, boolean fullUri) {
        char[] buf = null;
        int bufTop = 0;
        int k2 = 0;
        int length = str.length();
        while (k2 != length) {
            char C2 = str.charAt(k2);
            if (C2 != '%') {
                if (buf != null) {
                    buf[bufTop++] = C2;
                }
                ++k2;
                continue;
            }
            if (buf == null) {
                buf = new char[length];
                str.getChars(0, k2, buf, 0);
                bufTop = k2;
            }
            int start2 = k2;
            if (k2 + 3 > length) {
                throw NativeGlobal.uriError();
            }
            int B = NativeGlobal.unHex(str.charAt(k2 + 1), str.charAt(k2 + 2));
            if (B < 0) {
                throw NativeGlobal.uriError();
            }
            k2 += 3;
            if ((B & 0x80) == 0) {
                C2 = (char)B;
            } else {
                int minUcs4Char;
                int ucs4Char;
                int utf8Tail;
                if ((B & 0xC0) == 128) {
                    throw NativeGlobal.uriError();
                }
                if ((B & 0x20) == 0) {
                    utf8Tail = 1;
                    ucs4Char = B & 0x1F;
                    minUcs4Char = 128;
                } else if ((B & 0x10) == 0) {
                    utf8Tail = 2;
                    ucs4Char = B & 0xF;
                    minUcs4Char = 2048;
                } else if ((B & 8) == 0) {
                    utf8Tail = 3;
                    ucs4Char = B & 7;
                    minUcs4Char = 65536;
                } else if ((B & 4) == 0) {
                    utf8Tail = 4;
                    ucs4Char = B & 3;
                    minUcs4Char = 0x200000;
                } else if ((B & 2) == 0) {
                    utf8Tail = 5;
                    ucs4Char = B & 1;
                    minUcs4Char = 0x4000000;
                } else {
                    throw NativeGlobal.uriError();
                }
                if (k2 + 3 * utf8Tail > length) {
                    throw NativeGlobal.uriError();
                }
                for (int j2 = 0; j2 != utf8Tail; ++j2) {
                    if (str.charAt(k2) != '%') {
                        throw NativeGlobal.uriError();
                    }
                    B = NativeGlobal.unHex(str.charAt(k2 + 1), str.charAt(k2 + 2));
                    if (B < 0 || (B & 0xC0) != 128) {
                        throw NativeGlobal.uriError();
                    }
                    ucs4Char = ucs4Char << 6 | B & 0x3F;
                    k2 += 3;
                }
                if (ucs4Char < minUcs4Char || ucs4Char >= 55296 && ucs4Char <= 57343) {
                    ucs4Char = Integer.MAX_VALUE;
                } else if (ucs4Char == 65534 || ucs4Char == 65535) {
                    ucs4Char = 65533;
                }
                if (ucs4Char >= 65536) {
                    if ((ucs4Char -= 65536) > 1048575) {
                        throw NativeGlobal.uriError();
                    }
                    char H = (char)((ucs4Char >>> 10) + 55296);
                    C2 = (char)((ucs4Char & 0x3FF) + 56320);
                    buf[bufTop++] = H;
                } else {
                    C2 = (char)ucs4Char;
                }
            }
            if (fullUri && URI_DECODE_RESERVED.indexOf(C2) >= 0) {
                for (int x = start2; x != k2; ++x) {
                    buf[bufTop++] = str.charAt(x);
                }
                continue;
            }
            buf[bufTop++] = C2;
        }
        return buf == null ? str : new String(buf, 0, bufTop);
    }

    private static boolean encodeUnescaped(char c2, boolean fullUri) {
        if ('A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z' || '0' <= c2 && c2 <= '9') {
            return true;
        }
        if ("-_.!~*'()".indexOf(c2) >= 0) {
            return true;
        }
        if (fullUri) {
            return URI_DECODE_RESERVED.indexOf(c2) >= 0;
        }
        return false;
    }

    private static EcmaError uriError() {
        return ScriptRuntime.constructError("URIError", ScriptRuntime.getMessage0("msg.bad.uri"));
    }

    private static int oneUcs4ToUtf8Char(byte[] utf8Buffer, int ucs4Char) {
        int utf8Length = 1;
        if ((ucs4Char & 0xFFFFFF80) == 0) {
            utf8Buffer[0] = (byte)ucs4Char;
        } else {
            int a2 = ucs4Char >>> 11;
            utf8Length = 2;
            while (a2 != 0) {
                a2 >>>= 5;
                ++utf8Length;
            }
            int i2 = utf8Length;
            while (--i2 > 0) {
                utf8Buffer[i2] = (byte)(ucs4Char & 0x3F | 0x80);
                ucs4Char >>>= 6;
            }
            utf8Buffer[0] = (byte)(256 - (1 << 8 - utf8Length) + ucs4Char);
        }
        return utf8Length;
    }
}

