/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    static final long serialVersionUID = -6460763940409461664L;
    static final String javaClassPropertyName = "__javaObject__";
    private Map<String, FieldAndMethods> staticFieldAndMethods;

    public NativeJavaClass() {
    }

    public NativeJavaClass(Scriptable scope, Class<?> cl) {
        this(scope, cl, false);
    }

    public NativeJavaClass(Scriptable scope, Class<?> cl, boolean isAdapter) {
        super(scope, cl, null, isAdapter);
    }

    @Override
    protected void initMembers() {
        Class cl = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(this.parent, cl, cl, this.isAdapter);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, cl, true);
    }

    @Override
    public String getClassName() {
        return "JavaClass";
    }

    @Override
    public boolean has(String name, Scriptable start2) {
        return this.members.has(name, true) || javaClassPropertyName.equals(name);
    }

    @Override
    public Object get(String name, Scriptable start2) {
        FieldAndMethods result2;
        if (name.equals("prototype")) {
            return null;
        }
        if (this.staticFieldAndMethods != null && (result2 = this.staticFieldAndMethods.get(name)) != null) {
            return result2;
        }
        if (this.members.has(name, true)) {
            return this.members.get(this, name, this.javaObject, true);
        }
        Context cx = Context.getContext();
        Scriptable scope = ScriptableObject.getTopLevelScope(start2);
        WrapFactory wrapFactory = cx.getWrapFactory();
        if (javaClassPropertyName.equals(name)) {
            return wrapFactory.wrap(cx, scope, this.javaObject, ScriptRuntime.ClassClass);
        }
        Class<?> nestedClass = NativeJavaClass.findNestedClass(this.getClassObject(), name);
        if (nestedClass != null) {
            Scriptable nestedValue = wrapFactory.wrapJavaClass(cx, scope, nestedClass);
            nestedValue.setParentScope(this);
            return nestedValue;
        }
        throw this.members.reportMemberNotFound(name);
    }

    @Override
    public void put(String name, Scriptable start2, Object value2) {
        this.members.put(this, name, this.javaObject, value2, true);
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public Class<?> getClassObject() {
        return (Class)super.unwrap();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (args2.length == 1 && args2[0] instanceof Scriptable) {
            Class<?> c2 = this.getClassObject();
            Scriptable p = (Scriptable)args2[0];
            do {
                Object o;
                if (!(p instanceof Wrapper) || !c2.isInstance(o = ((Wrapper)((Object)p)).unwrap())) continue;
                return p;
            } while ((p = p.getPrototype()) != null);
        }
        return this.construct(cx, scope, args2);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args2) {
        String msg;
        Class<?> classObject;
        block7: {
            classObject = this.getClassObject();
            int modifiers = classObject.getModifiers();
            if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers)) {
                NativeJavaMethod ctors = this.members.ctors;
                int index = ctors.findCachedFunction(cx, args2);
                if (index < 0) {
                    String sig = NativeJavaMethod.scriptSignature(args2);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", classObject.getName(), sig);
                }
                return NativeJavaClass.constructSpecific(cx, scope, args2, ctors.methods[index]);
            }
            if (args2.length == 0) {
                throw Context.reportRuntimeError0("msg.adapter.zero.args");
            }
            Scriptable topLevel = ScriptableObject.getTopLevelScope(this);
            msg = "";
            try {
                if ("Dalvik".equals(System.getProperty("java.vm.name")) && classObject.isInterface()) {
                    Object obj = NativeJavaClass.createInterfaceAdapter(classObject, ScriptableObject.ensureScriptableObject(args2[0]));
                    return cx.getWrapFactory().wrapAsJavaObject(cx, scope, obj, null);
                }
                Object v = topLevel.get("JavaAdapter", topLevel);
                if (v != NOT_FOUND) {
                    Function f2 = (Function)v;
                    Object[] adapterArgs = new Object[]{this, args2[0]};
                    return f2.construct(cx, topLevel, adapterArgs);
                }
            }
            catch (Exception ex) {
                String m4 = ex.getMessage();
                if (m4 == null) break block7;
                msg = m4;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", msg, classObject.getName());
    }

    static Scriptable constructSpecific(Context cx, Scriptable scope, Object[] args2, MemberBox ctor) {
        Object instance = NativeJavaClass.constructInternal(args2, ctor);
        Scriptable topLevel = ScriptableObject.getTopLevelScope(scope);
        return cx.getWrapFactory().wrapNewObject(cx, topLevel, instance);
    }

    static Object constructInternal(Object[] args2, MemberBox ctor) {
        Class<?>[] argTypes = ctor.argTypes;
        if (ctor.vararg) {
            Object varArgs;
            Object[] newArgs = new Object[argTypes.length];
            for (int i2 = 0; i2 < argTypes.length - 1; ++i2) {
                newArgs[i2] = Context.jsToJava(args2[i2], argTypes[i2]);
            }
            if (args2.length == argTypes.length && (args2[args2.length - 1] == null || args2[args2.length - 1] instanceof NativeArray || args2[args2.length - 1] instanceof NativeJavaArray)) {
                varArgs = Context.jsToJava(args2[args2.length - 1], argTypes[argTypes.length - 1]);
            } else {
                Class<?> componentType = argTypes[argTypes.length - 1].getComponentType();
                varArgs = Array.newInstance(componentType, args2.length - argTypes.length + 1);
                for (int i3 = 0; i3 < Array.getLength(varArgs); ++i3) {
                    Object value2 = Context.jsToJava(args2[argTypes.length - 1 + i3], componentType);
                    Array.set(varArgs, i3, value2);
                }
            }
            newArgs[argTypes.length - 1] = varArgs;
            args2 = newArgs;
        } else {
            Object[] origArgs = args2;
            for (int i4 = 0; i4 < args2.length; ++i4) {
                Object arg = args2[i4];
                Object x = Context.jsToJava(arg, argTypes[i4]);
                if (x == arg) continue;
                if (args2 == origArgs) {
                    args2 = (Object[])origArgs.clone();
                }
                args2[i4] = x;
            }
        }
        return ctor.newInstance(args2);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    @Override
    public boolean hasInstance(Scriptable value2) {
        if (value2 instanceof Wrapper && !(value2 instanceof NativeJavaClass)) {
            Object instance = ((Wrapper)((Object)value2)).unwrap();
            return this.getClassObject().isInstance(instance);
        }
        return false;
    }

    private static Class<?> findNestedClass(Class<?> parentClass, String name) {
        String nestedClassName = parentClass.getName() + '$' + name;
        ClassLoader loader = parentClass.getClassLoader();
        if (loader == null) {
            return Kit.classOrNull(nestedClassName);
        }
        return Kit.classOrNull(loader, nestedClassName);
    }
}

