/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ResolvedOverload;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends BaseFunction {
    static final long serialVersionUID = -3440381785576412928L;
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;
    private String functionName;
    private transient CopyOnWriteArrayList<ResolvedOverload> overloadCache;

    NativeJavaMethod(MemberBox[] methods2) {
        this.functionName = methods2[0].getName();
        this.methods = methods2;
    }

    NativeJavaMethod(MemberBox[] methods2, String name) {
        this.functionName = name;
        this.methods = methods2;
    }

    NativeJavaMethod(MemberBox method2, String name) {
        this.functionName = name;
        this.methods = new MemberBox[]{method2};
    }

    public NativeJavaMethod(Method method2, String name) {
        this(new MemberBox(method2), name);
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    static String scriptSignature(Object[] values2) {
        StringBuilder sig = new StringBuilder();
        for (int i2 = 0; i2 != values2.length; ++i2) {
            String s2;
            Object value2 = values2[i2];
            if (value2 == null) {
                s2 = "null";
            } else if (value2 instanceof Boolean) {
                s2 = "boolean";
            } else if (value2 instanceof String) {
                s2 = "string";
            } else if (value2 instanceof Number) {
                s2 = "number";
            } else if (value2 instanceof Scriptable) {
                if (value2 instanceof Undefined) {
                    s2 = "undefined";
                } else if (value2 instanceof Wrapper) {
                    Object wrapped = ((Wrapper)value2).unwrap();
                    s2 = wrapped.getClass().getName();
                } else {
                    s2 = value2 instanceof Function ? "function" : "object";
                }
            } else {
                s2 = JavaMembers.javaSignature(value2.getClass());
            }
            if (i2 != 0) {
                sig.append(',');
            }
            sig.append(s2);
        }
        return sig.toString();
    }

    @Override
    String decompile(int indent, int flags) {
        boolean justbody;
        StringBuilder sb = new StringBuilder();
        boolean bl = justbody = 0 != (flags & 1);
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() {");
        }
        sb.append("/*\n");
        sb.append(this.toString());
        sb.append(justbody ? "*/\n" : "*/}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int N2 = this.methods.length;
        for (int i2 = 0; i2 != N2; ++i2) {
            if (this.methods[i2].isMethod()) {
                Method method2 = this.methods[i2].method();
                sb.append(JavaMembers.javaSignature(method2.getReturnType()));
                sb.append(' ');
                sb.append(method2.getName());
            } else {
                sb.append(this.methods[i2].getName());
            }
            sb.append(JavaMembers.liveConnectSignature(this.methods[i2].argTypes));
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        Object javaObject;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int index = this.findCachedFunction(cx, args2);
        if (index < 0) {
            Class<?> c2 = this.methods[0].method().getDeclaringClass();
            String sig = c2.getName() + '.' + this.getFunctionName() + '(' + NativeJavaMethod.scriptSignature(args2) + ')';
            throw Context.reportRuntimeError1("msg.java.no_such_method", sig);
        }
        MemberBox meth = this.methods[index];
        Class<?>[] argTypes = meth.argTypes;
        if (meth.vararg) {
            Object varArgs;
            Object[] newArgs = new Object[argTypes.length];
            for (int i2 = 0; i2 < argTypes.length - 1; ++i2) {
                newArgs[i2] = Context.jsToJava(args2[i2], argTypes[i2]);
            }
            if (args2.length == argTypes.length && (args2[args2.length - 1] == null || args2[args2.length - 1] instanceof NativeArray || args2[args2.length - 1] instanceof NativeJavaArray)) {
                varArgs = Context.jsToJava(args2[args2.length - 1], argTypes[argTypes.length - 1]);
            } else {
                Class<?> componentType = argTypes[argTypes.length - 1].getComponentType();
                varArgs = Array.newInstance(componentType, args2.length - argTypes.length + 1);
                for (int i3 = 0; i3 < Array.getLength(varArgs); ++i3) {
                    Object value2 = Context.jsToJava(args2[argTypes.length - 1 + i3], componentType);
                    Array.set(varArgs, i3, value2);
                }
            }
            newArgs[argTypes.length - 1] = varArgs;
            args2 = newArgs;
        } else {
            Object[] origArgs = args2;
            for (int i4 = 0; i4 < args2.length; ++i4) {
                Object arg = args2[i4];
                Object coerced = Context.jsToJava(arg, argTypes[i4]);
                if (coerced == arg) continue;
                if (origArgs == args2) {
                    args2 = (Object[])args2.clone();
                }
                args2[i4] = coerced;
            }
        }
        if (meth.isStatic()) {
            javaObject = null;
        } else {
            Scriptable o = thisObj;
            Class<?> c3 = meth.getDeclaringClass();
            while (true) {
                if (o == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(thisObj), c3.getName());
                }
                if (o instanceof Wrapper && c3.isInstance(javaObject = ((Wrapper)((Object)o)).unwrap())) break;
                o = o.getPrototype();
            }
        }
        Object retval = meth.invoke(javaObject, args2);
        Class<?> staticType = meth.method().getReturnType();
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, retval, staticType);
        if (wrapped == null && staticType == Void.TYPE) {
            wrapped = Undefined.instance;
        }
        return wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findCachedFunction(Context cx, Object[] args2) {
        if (this.methods.length > 1) {
            if (this.overloadCache != null) {
                for (ResolvedOverload ovl : this.overloadCache) {
                    if (!ovl.matches(args2)) continue;
                    return ovl.index;
                }
            } else {
                this.overloadCache = new CopyOnWriteArrayList();
            }
            int index = NativeJavaMethod.findFunction(cx, this.methods, args2);
            if (this.overloadCache.size() < this.methods.length * 2) {
                CopyOnWriteArrayList<ResolvedOverload> copyOnWriteArrayList = this.overloadCache;
                synchronized (copyOnWriteArrayList) {
                    ResolvedOverload ovl = new ResolvedOverload(args2, index);
                    if (!this.overloadCache.contains(ovl)) {
                        this.overloadCache.add(0, ovl);
                    }
                }
            }
            return index;
        }
        return NativeJavaMethod.findFunction(cx, this.methods, args2);
    }

    static int findFunction(Context cx, MemberBox[] methodsOrCtors, Object[] args2) {
        if (methodsOrCtors.length == 0) {
            return -1;
        }
        if (methodsOrCtors.length == 1) {
            MemberBox member = methodsOrCtors[0];
            Class<?>[] argTypes = member.argTypes;
            int alength = argTypes.length;
            if (member.vararg ? --alength > args2.length : alength != args2.length) {
                return -1;
            }
            for (int j2 = 0; j2 != alength; ++j2) {
                if (NativeJavaObject.canConvert(args2[j2], argTypes[j2])) continue;
                return -1;
            }
            return 0;
        }
        int firstBestFit = -1;
        int[] extraBestFits = null;
        int extraBestFitsCount = 0;
        block1: for (int i2 = 0; i2 < methodsOrCtors.length; ++i2) {
            MemberBox member = methodsOrCtors[i2];
            Class<?>[] argTypes = member.argTypes;
            int alength = argTypes.length;
            if (member.vararg ? --alength > args2.length : alength != args2.length) continue;
            for (int j3 = 0; j3 < alength; ++j3) {
                if (!NativeJavaObject.canConvert(args2[j3], argTypes[j3])) continue block1;
            }
            if (firstBestFit < 0) {
                firstBestFit = i2;
                continue;
            }
            int betterCount = 0;
            int worseCount = 0;
            for (int j4 = -1; j4 != extraBestFitsCount; ++j4) {
                int bestFitIndex = j4 == -1 ? firstBestFit : extraBestFits[j4];
                MemberBox bestFit = methodsOrCtors[bestFitIndex];
                if (cx.hasFeature(13) && (bestFit.member().getModifiers() & 1) != (member.member().getModifiers() & 1)) {
                    if ((bestFit.member().getModifiers() & 1) == 0) {
                        ++betterCount;
                        continue;
                    }
                    ++worseCount;
                    continue;
                }
                int preference = NativeJavaMethod.preferSignature(args2, argTypes, member.vararg, bestFit.argTypes, bestFit.vararg);
                if (preference == 3) break;
                if (preference == 1) {
                    ++betterCount;
                    continue;
                }
                if (preference == 2) {
                    ++worseCount;
                    continue;
                }
                if (preference != 0) {
                    Kit.codeBug();
                }
                if (!bestFit.isStatic() || !bestFit.getDeclaringClass().isAssignableFrom(member.getDeclaringClass())) continue block1;
                if (j4 == -1) {
                    firstBestFit = i2;
                    continue block1;
                }
                extraBestFits[j4] = i2;
                continue block1;
            }
            if (betterCount == 1 + extraBestFitsCount) {
                firstBestFit = i2;
                extraBestFitsCount = 0;
                continue;
            }
            if (worseCount == 1 + extraBestFitsCount) continue;
            if (extraBestFits == null) {
                extraBestFits = new int[methodsOrCtors.length - 1];
            }
            extraBestFits[extraBestFitsCount] = i2;
            ++extraBestFitsCount;
        }
        if (firstBestFit < 0) {
            return -1;
        }
        if (extraBestFitsCount == 0) {
            return firstBestFit;
        }
        StringBuilder buf = new StringBuilder();
        for (int j5 = -1; j5 != extraBestFitsCount; ++j5) {
            int bestFitIndex = j5 == -1 ? firstBestFit : extraBestFits[j5];
            buf.append("\n    ");
            buf.append(methodsOrCtors[bestFitIndex].toJavaDeclaration());
        }
        MemberBox firstFitMember = methodsOrCtors[firstBestFit];
        String memberName = firstFitMember.getName();
        String memberClass = firstFitMember.getDeclaringClass().getName();
        if (methodsOrCtors[0].isCtor()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", memberName, NativeJavaMethod.scriptSignature(args2), buf.toString());
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", memberClass, memberName, NativeJavaMethod.scriptSignature(args2), buf.toString());
    }

    private static int preferSignature(Object[] args2, Class<?>[] sig1, boolean vararg1, Class<?>[] sig2, boolean vararg2) {
        int totalPreference = 0;
        for (int j2 = 0; j2 < args2.length; ++j2) {
            int rank2;
            Class<?> type2;
            Class<?> type1 = vararg1 && j2 >= sig1.length ? sig1[sig1.length - 1] : sig1[j2];
            Class<?> clazz = type2 = vararg2 && j2 >= sig2.length ? sig2[sig2.length - 1] : sig2[j2];
            if (type1 == type2) continue;
            Object arg = args2[j2];
            int rank1 = NativeJavaObject.getConversionWeight(arg, type1);
            int preference = rank1 < (rank2 = NativeJavaObject.getConversionWeight(arg, type2)) ? 1 : (rank1 > rank2 ? 2 : (rank1 == 0 ? (type1.isAssignableFrom(type2) ? 2 : (type2.isAssignableFrom(type1) ? 1 : 3)) : 3));
            if ((totalPreference |= preference) == 3) break;
        }
        return totalPreference;
    }

    private static void printDebug(String msg, MemberBox member, Object[] args2) {
    }
}

