/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.InterfaceAdapter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaObject
implements Scriptable,
Wrapper,
Serializable {
    static final long serialVersionUID = -6948590651130498591L;
    private static final int JSTYPE_UNDEFINED = 0;
    private static final int JSTYPE_NULL = 1;
    private static final int JSTYPE_BOOLEAN = 2;
    private static final int JSTYPE_NUMBER = 3;
    private static final int JSTYPE_STRING = 4;
    private static final int JSTYPE_JAVA_CLASS = 5;
    private static final int JSTYPE_JAVA_OBJECT = 6;
    private static final int JSTYPE_JAVA_ARRAY = 7;
    private static final int JSTYPE_OBJECT = 8;
    static final byte CONVERSION_TRIVIAL = 1;
    static final byte CONVERSION_NONTRIVIAL = 0;
    static final byte CONVERSION_NONE = 99;
    protected Scriptable prototype;
    protected Scriptable parent;
    protected transient Object javaObject;
    protected transient Class<?> staticType;
    protected transient JavaMembers members;
    private transient Map<String, FieldAndMethods> fieldAndMethods;
    protected transient boolean isAdapter;
    private static final Object COERCED_INTERFACE_KEY = "Coerced Interface";
    private static Method adapter_writeAdapterObject;
    private static Method adapter_readAdapterObject;

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType) {
        this(scope, javaObject, staticType, false);
    }

    public NativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType, boolean isAdapter) {
        this.parent = scope;
        this.javaObject = javaObject;
        this.staticType = staticType;
        this.isAdapter = isAdapter;
        this.initMembers();
    }

    protected void initMembers() {
        Class<?> dynamicType = this.javaObject != null ? this.javaObject.getClass() : this.staticType;
        this.members = JavaMembers.lookupClass(this.parent, dynamicType, this.staticType, this.isAdapter);
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, false);
    }

    @Override
    public boolean has(String name, Scriptable start2) {
        return this.members.has(name, false);
    }

    @Override
    public boolean has(int index, Scriptable start2) {
        return false;
    }

    @Override
    public Object get(String name, Scriptable start2) {
        FieldAndMethods result2;
        if (this.fieldAndMethods != null && (result2 = this.fieldAndMethods.get(name)) != null) {
            return result2;
        }
        return this.members.get(this, name, this.javaObject, false);
    }

    @Override
    public Object get(int index, Scriptable start2) {
        throw this.members.reportMemberNotFound(Integer.toString(index));
    }

    @Override
    public void put(String name, Scriptable start2, Object value2) {
        if (this.prototype == null || this.members.has(name, false)) {
            this.members.put(this, name, this.javaObject, value2, false);
        } else {
            this.prototype.put(name, this.prototype, value2);
        }
    }

    @Override
    public void put(int index, Scriptable start2, Object value2) {
        throw this.members.reportMemberNotFound(Integer.toString(index));
    }

    @Override
    public boolean hasInstance(Scriptable value2) {
        return false;
    }

    @Override
    public void delete(String name) {
    }

    @Override
    public void delete(int index) {
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null && this.javaObject instanceof String) {
            return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(this.parent), TopLevel.Builtins.String);
        }
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable m4) {
        this.prototype = m4;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable m4) {
        this.parent = m4;
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(false);
    }

    @Deprecated
    public static Object wrap(Scriptable scope, Object obj, Class<?> staticType) {
        Context cx = Context.getContext();
        return cx.getWrapFactory().wrap(cx, scope, obj, staticType);
    }

    @Override
    public Object unwrap() {
        return this.javaObject;
    }

    @Override
    public String getClassName() {
        return "JavaObject";
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        Object value2;
        if (hint == null && this.javaObject instanceof Boolean) {
            hint = ScriptRuntime.BooleanClass;
        }
        if (hint == null || hint == ScriptRuntime.StringClass) {
            value2 = this.javaObject.toString();
        } else {
            String converterName;
            if (hint == ScriptRuntime.BooleanClass) {
                converterName = "booleanValue";
            } else if (hint == ScriptRuntime.NumberClass) {
                converterName = "doubleValue";
            } else {
                throw Context.reportRuntimeError0("msg.default.value");
            }
            Object converterObject = this.get(converterName, (Scriptable)this);
            if (converterObject instanceof Function) {
                Function f2 = (Function)converterObject;
                value2 = f2.call(Context.getContext(), f2.getParentScope(), this, ScriptRuntime.emptyArgs);
            } else {
                boolean b2;
                value2 = hint == ScriptRuntime.NumberClass && this.javaObject instanceof Boolean ? ScriptRuntime.wrapNumber((b2 = ((Boolean)this.javaObject).booleanValue()) ? 1.0 : 0.0) : this.javaObject.toString();
            }
        }
        return value2;
    }

    public static boolean canConvert(Object fromObj, Class<?> to) {
        int weight = NativeJavaObject.getConversionWeight(fromObj, to);
        return weight < 99;
    }

    static int getConversionWeight(Object fromObj, Class<?> to) {
        int fromCode = NativeJavaObject.getJSTypeCode(fromObj);
        switch (fromCode) {
            case 0: {
                if (to != ScriptRuntime.StringClass && to != ScriptRuntime.ObjectClass) break;
                return 1;
            }
            case 1: {
                if (to.isPrimitive()) break;
                return 1;
            }
            case 2: {
                if (to == Boolean.TYPE) {
                    return 1;
                }
                if (to == ScriptRuntime.BooleanClass) {
                    return 2;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (to != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 3: {
                if (to.isPrimitive()) {
                    if (to == Double.TYPE) {
                        return 1;
                    }
                    if (to == Boolean.TYPE) break;
                    return 1 + NativeJavaObject.getSizeRank(to);
                }
                if (to == ScriptRuntime.StringClass) {
                    return 9;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 10;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(to)) break;
                return 2;
            }
            case 4: {
                if (to == ScriptRuntime.StringClass) {
                    return 1;
                }
                if (to.isInstance(fromObj)) {
                    return 2;
                }
                if (!to.isPrimitive()) break;
                if (to == Character.TYPE) {
                    return 3;
                }
                if (to == Boolean.TYPE) break;
                return 4;
            }
            case 5: {
                if (to == ScriptRuntime.ClassClass) {
                    return 1;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (to != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 6: 
            case 7: {
                Object javaObj = fromObj;
                if (javaObj instanceof Wrapper) {
                    javaObj = ((Wrapper)javaObj).unwrap();
                }
                if (to.isInstance(javaObj)) {
                    return 0;
                }
                if (to == ScriptRuntime.StringClass) {
                    return 2;
                }
                if (!to.isPrimitive() || to == Boolean.TYPE) break;
                return fromCode == 7 ? 99 : 2 + NativeJavaObject.getSizeRank(to);
            }
            case 8: {
                if (to != ScriptRuntime.ObjectClass && to.isInstance(fromObj)) {
                    return 1;
                }
                if (to.isArray()) {
                    if (!(fromObj instanceof NativeArray)) break;
                    return 2;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (to == ScriptRuntime.StringClass) {
                    return 4;
                }
                if (to == ScriptRuntime.DateClass) {
                    if (!(fromObj instanceof NativeDate)) break;
                    return 1;
                }
                if (to.isInterface()) {
                    if (fromObj instanceof NativeFunction) {
                        return 1;
                    }
                    if (fromObj instanceof NativeObject) {
                        return 2;
                    }
                    return 12;
                }
                if (!to.isPrimitive() || to == Boolean.TYPE) break;
                return 4 + NativeJavaObject.getSizeRank(to);
            }
        }
        return 99;
    }

    static int getSizeRank(Class<?> aType) {
        if (aType == Double.TYPE) {
            return 1;
        }
        if (aType == Float.TYPE) {
            return 2;
        }
        if (aType == Long.TYPE) {
            return 3;
        }
        if (aType == Integer.TYPE) {
            return 4;
        }
        if (aType == Short.TYPE) {
            return 5;
        }
        if (aType == Character.TYPE) {
            return 6;
        }
        if (aType == Byte.TYPE) {
            return 7;
        }
        if (aType == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    private static int getJSTypeCode(Object value2) {
        if (value2 == null) {
            return 1;
        }
        if (value2 == Undefined.instance) {
            return 0;
        }
        if (value2 instanceof CharSequence) {
            return 4;
        }
        if (value2 instanceof Number) {
            return 3;
        }
        if (value2 instanceof Boolean) {
            return 2;
        }
        if (value2 instanceof Scriptable) {
            if (value2 instanceof NativeJavaClass) {
                return 5;
            }
            if (value2 instanceof NativeJavaArray) {
                return 7;
            }
            if (value2 instanceof Wrapper) {
                return 6;
            }
            return 8;
        }
        if (value2 instanceof Class) {
            return 5;
        }
        Class<?> valueClass = value2.getClass();
        if (valueClass.isArray()) {
            return 7;
        }
        return 6;
    }

    @Deprecated
    public static Object coerceType(Class<?> type2, Object value2) {
        return NativeJavaObject.coerceTypeImpl(type2, value2);
    }

    static Object coerceTypeImpl(Class<?> type2, Object value2) {
        if (value2 != null && value2.getClass() == type2) {
            return value2;
        }
        switch (NativeJavaObject.getJSTypeCode(value2)) {
            case 1: {
                if (type2.isPrimitive()) {
                    NativeJavaObject.reportConversionError(value2, type2);
                }
                return null;
            }
            case 0: {
                if (type2 == ScriptRuntime.StringClass || type2 == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                NativeJavaObject.reportConversionError("undefined", type2);
                break;
            }
            case 2: {
                if (type2 == Boolean.TYPE || type2 == ScriptRuntime.BooleanClass || type2 == ScriptRuntime.ObjectClass) {
                    return value2;
                }
                if (type2 == ScriptRuntime.StringClass) {
                    return value2.toString();
                }
                NativeJavaObject.reportConversionError(value2, type2);
                break;
            }
            case 3: {
                if (type2 == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(value2);
                }
                if (type2 == ScriptRuntime.ObjectClass) {
                    return NativeJavaObject.coerceToNumber(Double.TYPE, value2);
                }
                if (type2.isPrimitive() && type2 != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(type2)) {
                    return NativeJavaObject.coerceToNumber(type2, value2);
                }
                NativeJavaObject.reportConversionError(value2, type2);
                break;
            }
            case 4: {
                if (type2 == ScriptRuntime.StringClass || type2.isInstance(value2)) {
                    return value2.toString();
                }
                if (type2 == Character.TYPE || type2 == ScriptRuntime.CharacterClass) {
                    if (((CharSequence)value2).length() == 1) {
                        return Character.valueOf(((CharSequence)value2).charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(type2, value2);
                }
                if (type2.isPrimitive() && type2 != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(type2)) {
                    return NativeJavaObject.coerceToNumber(type2, value2);
                }
                NativeJavaObject.reportConversionError(value2, type2);
                break;
            }
            case 5: {
                if (value2 instanceof Wrapper) {
                    value2 = ((Wrapper)value2).unwrap();
                }
                if (type2 == ScriptRuntime.ClassClass || type2 == ScriptRuntime.ObjectClass) {
                    return value2;
                }
                if (type2 == ScriptRuntime.StringClass) {
                    return value2.toString();
                }
                NativeJavaObject.reportConversionError(value2, type2);
                break;
            }
            case 6: 
            case 7: {
                if (value2 instanceof Wrapper) {
                    value2 = ((Wrapper)value2).unwrap();
                }
                if (type2.isPrimitive()) {
                    if (type2 == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(value2, type2);
                    }
                    return NativeJavaObject.coerceToNumber(type2, value2);
                }
                if (type2 == ScriptRuntime.StringClass) {
                    return value2.toString();
                }
                if (type2.isInstance(value2)) {
                    return value2;
                }
                NativeJavaObject.reportConversionError(value2, type2);
                break;
            }
            case 8: {
                if (type2 == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(value2);
                }
                if (type2.isPrimitive()) {
                    if (type2 == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(value2, type2);
                    }
                    return NativeJavaObject.coerceToNumber(type2, value2);
                }
                if (type2.isInstance(value2)) {
                    return value2;
                }
                if (type2 == ScriptRuntime.DateClass && value2 instanceof NativeDate) {
                    double time = ((NativeDate)value2).getJSTimeValue();
                    return new Date((long)time);
                }
                if (type2.isArray() && value2 instanceof NativeArray) {
                    NativeArray array = (NativeArray)value2;
                    long length = array.getLength();
                    Class<?> arrayType = type2.getComponentType();
                    Object Result2 = Array.newInstance(arrayType, (int)length);
                    int i2 = 0;
                    while ((long)i2 < length) {
                        try {
                            Array.set(Result2, i2, NativeJavaObject.coerceTypeImpl(arrayType, array.get(i2, (Scriptable)array)));
                        }
                        catch (EvaluatorException ee) {
                            NativeJavaObject.reportConversionError(value2, type2);
                        }
                        ++i2;
                    }
                    return Result2;
                }
                if (value2 instanceof Wrapper) {
                    if (type2.isInstance(value2 = ((Wrapper)value2).unwrap())) {
                        return value2;
                    }
                    NativeJavaObject.reportConversionError(value2, type2);
                    break;
                }
                if (type2.isInterface() && (value2 instanceof NativeObject || value2 instanceof NativeFunction)) {
                    return NativeJavaObject.createInterfaceAdapter(type2, (ScriptableObject)value2);
                }
                NativeJavaObject.reportConversionError(value2, type2);
            }
        }
        return value2;
    }

    protected static Object createInterfaceAdapter(Class<?> type2, ScriptableObject so) {
        Object key2 = Kit.makeHashKeyFromPair(COERCED_INTERFACE_KEY, type2);
        Object old = so.getAssociatedValue(key2);
        if (old != null) {
            return old;
        }
        Context cx = Context.getContext();
        Object glue = InterfaceAdapter.create(cx, type2, so);
        glue = so.associateValue(key2, glue);
        return glue;
    }

    private static Object coerceToNumber(Class<?> type2, Object value2) {
        Class<?> valueClass = value2.getClass();
        if (type2 == Character.TYPE || type2 == ScriptRuntime.CharacterClass) {
            if (valueClass == ScriptRuntime.CharacterClass) {
                return value2;
            }
            return Character.valueOf((char)NativeJavaObject.toInteger(value2, ScriptRuntime.CharacterClass, 0.0, 65535.0));
        }
        if (type2 == ScriptRuntime.ObjectClass || type2 == ScriptRuntime.DoubleClass || type2 == Double.TYPE) {
            return valueClass == ScriptRuntime.DoubleClass ? value2 : new Double(NativeJavaObject.toDouble(value2));
        }
        if (type2 == ScriptRuntime.FloatClass || type2 == Float.TYPE) {
            if (valueClass == ScriptRuntime.FloatClass) {
                return value2;
            }
            double number = NativeJavaObject.toDouble(value2);
            if (Double.isInfinite(number) || Double.isNaN(number) || number == 0.0) {
                return new Float((float)number);
            }
            double absNumber = Math.abs(number);
            if (absNumber < (double)1.4E-45f) {
                return new Float(number > 0.0 ? 0.0 : -0.0);
            }
            if (absNumber > 3.4028234663852886E38) {
                return new Float(number > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return new Float((float)number);
        }
        if (type2 == ScriptRuntime.IntegerClass || type2 == Integer.TYPE) {
            if (valueClass == ScriptRuntime.IntegerClass) {
                return value2;
            }
            return (int)NativeJavaObject.toInteger(value2, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9);
        }
        if (type2 == ScriptRuntime.LongClass || type2 == Long.TYPE) {
            if (valueClass == ScriptRuntime.LongClass) {
                return value2;
            }
            double max2 = Double.longBitsToDouble(4890909195324358655L);
            double min2 = Double.longBitsToDouble(-4332462841530417152L);
            return NativeJavaObject.toInteger(value2, ScriptRuntime.LongClass, min2, max2);
        }
        if (type2 == ScriptRuntime.ShortClass || type2 == Short.TYPE) {
            if (valueClass == ScriptRuntime.ShortClass) {
                return value2;
            }
            return (short)NativeJavaObject.toInteger(value2, ScriptRuntime.ShortClass, -32768.0, 32767.0);
        }
        if (type2 == ScriptRuntime.ByteClass || type2 == Byte.TYPE) {
            if (valueClass == ScriptRuntime.ByteClass) {
                return value2;
            }
            return (byte)NativeJavaObject.toInteger(value2, ScriptRuntime.ByteClass, -128.0, 127.0);
        }
        return new Double(NativeJavaObject.toDouble(value2));
    }

    private static double toDouble(Object value2) {
        Method meth;
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        if (value2 instanceof String) {
            return ScriptRuntime.toNumber((String)value2);
        }
        if (value2 instanceof Scriptable) {
            if (value2 instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)value2).unwrap());
            }
            return ScriptRuntime.toNumber(value2);
        }
        try {
            meth = value2.getClass().getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException e2) {
            meth = null;
        }
        catch (SecurityException e3) {
            meth = null;
        }
        if (meth != null) {
            try {
                return ((Number)meth.invoke(value2, (Object[])null)).doubleValue();
            }
            catch (IllegalAccessException e4) {
                NativeJavaObject.reportConversionError(value2, Double.TYPE);
            }
            catch (InvocationTargetException e5) {
                NativeJavaObject.reportConversionError(value2, Double.TYPE);
            }
        }
        return ScriptRuntime.toNumber(value2.toString());
    }

    private static long toInteger(Object value2, Class<?> type2, double min2, double max2) {
        double d2 = NativeJavaObject.toDouble(value2);
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(value2), type2);
        }
        if ((d2 = d2 > 0.0 ? Math.floor(d2) : Math.ceil(d2)) < min2 || d2 > max2) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(value2), type2);
        }
        return (long)d2;
    }

    static void reportConversionError(Object value2, Class<?> type2) {
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", String.valueOf(value2), JavaMembers.javaSignature(type2));
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.defaultWriteObject();
        out2.writeBoolean(this.isAdapter);
        if (this.isAdapter) {
            if (adapter_writeAdapterObject == null) {
                throw new IOException();
            }
            Object[] args2 = new Object[]{this.javaObject, out2};
            try {
                adapter_writeAdapterObject.invoke(null, args2);
            }
            catch (Exception ex) {
                throw new IOException();
            }
        } else {
            out2.writeObject(this.javaObject);
        }
        if (this.staticType != null) {
            out2.writeObject(this.staticType.getClass().getName());
        } else {
            out2.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String className;
        in.defaultReadObject();
        this.isAdapter = in.readBoolean();
        if (this.isAdapter) {
            if (adapter_readAdapterObject == null) {
                throw new ClassNotFoundException();
            }
            Object[] args2 = new Object[]{this, in};
            try {
                this.javaObject = adapter_readAdapterObject.invoke(null, args2);
            }
            catch (Exception ex) {
                throw new IOException();
            }
        } else {
            this.javaObject = in.readObject();
        }
        this.staticType = (className = (String)in.readObject()) != null ? Class.forName(className) : null;
        this.initMembers();
    }

    static {
        Class[] sig2 = new Class[2];
        Class<?> cl = Kit.classOrNull("org.mozilla.javascript.JavaAdapter");
        if (cl != null) {
            try {
                sig2[0] = ScriptRuntime.ObjectClass;
                sig2[1] = Kit.classOrNull("java.io.ObjectOutputStream");
                adapter_writeAdapterObject = cl.getMethod("writeAdapterObject", sig2);
                sig2[0] = ScriptRuntime.ScriptableClass;
                sig2[1] = Kit.classOrNull("java.io.ObjectInputStream");
                adapter_readAdapterObject = cl.getMethod("readAdapterObject", sig2);
            }
            catch (NoSuchMethodException e2) {
                adapter_writeAdapterObject = null;
                adapter_readAdapterObject = null;
            }
        }
    }
}

