/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.Collator;
import java.text.Normalizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeStringIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;

final class NativeString
extends IdScriptableObject {
    static final long serialVersionUID = 920268368584188687L;
    private static final Object STRING_TAG = "String";
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int ConstructorId_fromCharCode = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_charAt = 5;
    private static final int Id_charCodeAt = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_split = 9;
    private static final int Id_substring = 10;
    private static final int Id_toLowerCase = 11;
    private static final int Id_toUpperCase = 12;
    private static final int Id_substr = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int Id_bold = 16;
    private static final int Id_italics = 17;
    private static final int Id_fixed = 18;
    private static final int Id_strike = 19;
    private static final int Id_small = 20;
    private static final int Id_big = 21;
    private static final int Id_blink = 22;
    private static final int Id_sup = 23;
    private static final int Id_sub = 24;
    private static final int Id_fontsize = 25;
    private static final int Id_fontcolor = 26;
    private static final int Id_link = 27;
    private static final int Id_anchor = 28;
    private static final int Id_equals = 29;
    private static final int Id_equalsIgnoreCase = 30;
    private static final int Id_match = 31;
    private static final int Id_search = 32;
    private static final int Id_replace = 33;
    private static final int Id_localeCompare = 34;
    private static final int Id_toLocaleLowerCase = 35;
    private static final int Id_toLocaleUpperCase = 36;
    private static final int Id_trim = 37;
    private static final int Id_trimLeft = 38;
    private static final int Id_trimRight = 39;
    private static final int Id_includes = 40;
    private static final int Id_startsWith = 41;
    private static final int Id_endsWith = 42;
    private static final int Id_normalize = 43;
    private static final int Id_repeat = 44;
    private static final int Id_codePointAt = 45;
    private static final int SymbolId_iterator = 46;
    private static final int MAX_PROTOTYPE_ID = 46;
    private static final int ConstructorId_charAt = -5;
    private static final int ConstructorId_charCodeAt = -6;
    private static final int ConstructorId_indexOf = -7;
    private static final int ConstructorId_lastIndexOf = -8;
    private static final int ConstructorId_split = -9;
    private static final int ConstructorId_substring = -10;
    private static final int ConstructorId_toLowerCase = -11;
    private static final int ConstructorId_toUpperCase = -12;
    private static final int ConstructorId_substr = -13;
    private static final int ConstructorId_concat = -14;
    private static final int ConstructorId_slice = -15;
    private static final int ConstructorId_equalsIgnoreCase = -30;
    private static final int ConstructorId_match = -31;
    private static final int ConstructorId_search = -32;
    private static final int ConstructorId_replace = -33;
    private static final int ConstructorId_localeCompare = -34;
    private static final int ConstructorId_toLocaleLowerCase = -35;
    private CharSequence string;

    static void init(Scriptable scope, boolean sealed) {
        NativeString obj = new NativeString("");
        obj.exportAsJSClass(46, scope, sealed);
    }

    NativeString(CharSequence s2) {
        this.string = s2;
    }

    @Override
    public String getClassName() {
        return "String";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected int findInstanceIdInfo(String s2) {
        if (s2.equals("length")) {
            return NativeString.instanceIdInfo(7, 1);
        }
        return super.findInstanceIdInfo(s2);
    }

    @Override
    protected String getInstanceIdName(int id) {
        if (id == 1) {
            return "length";
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        if (id == 1) {
            return ScriptRuntime.wrapInt(this.string.length());
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, STRING_TAG, -1, "fromCharCode", 1);
        this.addIdFunctionProperty(ctor, STRING_TAG, -5, "charAt", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -6, "charCodeAt", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -7, "indexOf", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -8, "lastIndexOf", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -9, "split", 3);
        this.addIdFunctionProperty(ctor, STRING_TAG, -10, "substring", 3);
        this.addIdFunctionProperty(ctor, STRING_TAG, -11, "toLowerCase", 1);
        this.addIdFunctionProperty(ctor, STRING_TAG, -12, "toUpperCase", 1);
        this.addIdFunctionProperty(ctor, STRING_TAG, -13, "substr", 3);
        this.addIdFunctionProperty(ctor, STRING_TAG, -14, "concat", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -15, "slice", 3);
        this.addIdFunctionProperty(ctor, STRING_TAG, -30, "equalsIgnoreCase", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -31, "match", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -32, "search", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -33, "replace", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -34, "localeCompare", 2);
        this.addIdFunctionProperty(ctor, STRING_TAG, -35, "toLocaleLowerCase", 1);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        if (id == 46) {
            this.initPrototypeMethod(STRING_TAG, id, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 1;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s2 = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s2 = "toSource";
                break;
            }
            case 4: {
                arity = 0;
                s2 = "valueOf";
                break;
            }
            case 5: {
                arity = 1;
                s2 = "charAt";
                break;
            }
            case 6: {
                arity = 1;
                s2 = "charCodeAt";
                break;
            }
            case 7: {
                arity = 1;
                s2 = "indexOf";
                break;
            }
            case 8: {
                arity = 1;
                s2 = "lastIndexOf";
                break;
            }
            case 9: {
                arity = 2;
                s2 = "split";
                break;
            }
            case 10: {
                arity = 2;
                s2 = "substring";
                break;
            }
            case 11: {
                arity = 0;
                s2 = "toLowerCase";
                break;
            }
            case 12: {
                arity = 0;
                s2 = "toUpperCase";
                break;
            }
            case 13: {
                arity = 2;
                s2 = "substr";
                break;
            }
            case 14: {
                arity = 1;
                s2 = "concat";
                break;
            }
            case 15: {
                arity = 2;
                s2 = "slice";
                break;
            }
            case 16: {
                arity = 0;
                s2 = "bold";
                break;
            }
            case 17: {
                arity = 0;
                s2 = "italics";
                break;
            }
            case 18: {
                arity = 0;
                s2 = "fixed";
                break;
            }
            case 19: {
                arity = 0;
                s2 = "strike";
                break;
            }
            case 20: {
                arity = 0;
                s2 = "small";
                break;
            }
            case 21: {
                arity = 0;
                s2 = "big";
                break;
            }
            case 22: {
                arity = 0;
                s2 = "blink";
                break;
            }
            case 23: {
                arity = 0;
                s2 = "sup";
                break;
            }
            case 24: {
                arity = 0;
                s2 = "sub";
                break;
            }
            case 25: {
                arity = 0;
                s2 = "fontsize";
                break;
            }
            case 26: {
                arity = 0;
                s2 = "fontcolor";
                break;
            }
            case 27: {
                arity = 0;
                s2 = "link";
                break;
            }
            case 28: {
                arity = 0;
                s2 = "anchor";
                break;
            }
            case 29: {
                arity = 1;
                s2 = "equals";
                break;
            }
            case 30: {
                arity = 1;
                s2 = "equalsIgnoreCase";
                break;
            }
            case 31: {
                arity = 1;
                s2 = "match";
                break;
            }
            case 32: {
                arity = 1;
                s2 = "search";
                break;
            }
            case 33: {
                arity = 2;
                s2 = "replace";
                break;
            }
            case 34: {
                arity = 1;
                s2 = "localeCompare";
                break;
            }
            case 35: {
                arity = 0;
                s2 = "toLocaleLowerCase";
                break;
            }
            case 36: {
                arity = 0;
                s2 = "toLocaleUpperCase";
                break;
            }
            case 37: {
                arity = 0;
                s2 = "trim";
                break;
            }
            case 38: {
                arity = 0;
                s2 = "trimLeft";
                break;
            }
            case 39: {
                arity = 0;
                s2 = "trimRight";
                break;
            }
            case 40: {
                arity = 1;
                s2 = "includes";
                break;
            }
            case 41: {
                arity = 1;
                s2 = "startsWith";
                break;
            }
            case 42: {
                arity = 1;
                s2 = "endsWith";
                break;
            }
            case 43: {
                arity = 0;
                s2 = "normalize";
                break;
            }
            case 44: {
                arity = 1;
                s2 = "repeat";
                break;
            }
            case 45: {
                arity = 1;
                s2 = "codePointAt";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(STRING_TAG, id, s2, fnName, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(STRING_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        block43: while (true) {
            switch (id) {
                case -35: 
                case -34: 
                case -33: 
                case -32: 
                case -31: 
                case -30: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    if (args2.length > 0) {
                        thisObj = ScriptRuntime.toObject(cx, scope, ScriptRuntime.toCharSequence(args2[0]));
                        Object[] newArgs = new Object[args2.length - 1];
                        for (int i2 = 0; i2 < newArgs.length; ++i2) {
                            newArgs[i2] = args2[i2 + 1];
                        }
                        args2 = newArgs;
                    } else {
                        thisObj = ScriptRuntime.toObject(cx, scope, ScriptRuntime.toCharSequence(thisObj));
                    }
                    id = -id;
                    continue block43;
                }
                case -1: {
                    int N2 = args2.length;
                    if (N2 < 1) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder(N2);
                    for (int i3 = 0; i3 != N2; ++i3) {
                        sb.append(ScriptRuntime.toUint16(args2[i3]));
                    }
                    return sb.toString();
                }
                case 1: {
                    CharSequence s2 = args2.length == 0 ? "" : (ScriptRuntime.isSymbol(args2[0]) && thisObj != null ? args2[0].toString() : ScriptRuntime.toCharSequence(args2[0]));
                    if (thisObj == null) {
                        return new NativeString(s2);
                    }
                    return s2 instanceof String ? s2 : s2.toString();
                }
                case 2: 
                case 4: {
                    CharSequence cs = NativeString.realThis((Scriptable)thisObj, (IdFunctionObject)f2).string;
                    return cs instanceof String ? cs : cs.toString();
                }
                case 3: {
                    CharSequence s3 = NativeString.realThis((Scriptable)thisObj, (IdFunctionObject)f2).string;
                    return "(new String(\"" + ScriptRuntime.escapeString(s3.toString()) + "\"))";
                }
                case 5: 
                case 6: {
                    CharSequence target = ScriptRuntime.toCharSequence(thisObj);
                    double pos = ScriptRuntime.toInteger(args2, 0);
                    if (pos < 0.0 || pos >= (double)target.length()) {
                        if (id == 5) {
                            return "";
                        }
                        return ScriptRuntime.NaNobj;
                    }
                    char c2 = target.charAt((int)pos);
                    if (id == 5) {
                        return String.valueOf(c2);
                    }
                    return ScriptRuntime.wrapInt(c2);
                }
                case 7: {
                    return ScriptRuntime.wrapInt(NativeString.js_indexOf(7, ScriptRuntime.toString(thisObj), args2));
                }
                case 40: 
                case 41: 
                case 42: {
                    String s4 = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, f2));
                    if (args2.length > 0 && args2[0] instanceof NativeRegExp) {
                        throw ScriptRuntime.typeError2("msg.first.arg.not.regexp", String.class.getSimpleName(), f2.getFunctionName());
                    }
                    int idx = NativeString.js_indexOf(id, s4, args2);
                    if (id == 40) {
                        return idx != -1;
                    }
                    if (id == 41) {
                        return idx == 0;
                    }
                    if (id == 42) {
                        return idx != -1;
                    }
                }
                case 8: {
                    return ScriptRuntime.wrapInt(NativeString.js_lastIndexOf(ScriptRuntime.toString(thisObj), args2));
                }
                case 9: {
                    return ScriptRuntime.checkRegExpProxy(cx).js_split(cx, scope, ScriptRuntime.toString(thisObj), args2);
                }
                case 10: {
                    return NativeString.js_substring(cx, ScriptRuntime.toCharSequence(thisObj), args2);
                }
                case 11: {
                    return ScriptRuntime.toString(thisObj).toLowerCase(ScriptRuntime.ROOT_LOCALE);
                }
                case 12: {
                    return ScriptRuntime.toString(thisObj).toUpperCase(ScriptRuntime.ROOT_LOCALE);
                }
                case 13: {
                    return NativeString.js_substr(ScriptRuntime.toCharSequence(thisObj), args2);
                }
                case 14: {
                    return NativeString.js_concat(ScriptRuntime.toString(thisObj), args2);
                }
                case 15: {
                    return NativeString.js_slice(ScriptRuntime.toCharSequence(thisObj), args2);
                }
                case 16: {
                    return NativeString.tagify(thisObj, "b", null, null);
                }
                case 17: {
                    return NativeString.tagify(thisObj, "i", null, null);
                }
                case 18: {
                    return NativeString.tagify(thisObj, "tt", null, null);
                }
                case 19: {
                    return NativeString.tagify(thisObj, "strike", null, null);
                }
                case 20: {
                    return NativeString.tagify(thisObj, "small", null, null);
                }
                case 21: {
                    return NativeString.tagify(thisObj, "big", null, null);
                }
                case 22: {
                    return NativeString.tagify(thisObj, "blink", null, null);
                }
                case 23: {
                    return NativeString.tagify(thisObj, "sup", null, null);
                }
                case 24: {
                    return NativeString.tagify(thisObj, "sub", null, null);
                }
                case 25: {
                    return NativeString.tagify(thisObj, "font", "size", args2);
                }
                case 26: {
                    return NativeString.tagify(thisObj, "font", "color", args2);
                }
                case 27: {
                    return NativeString.tagify(thisObj, "a", "href", args2);
                }
                case 28: {
                    return NativeString.tagify(thisObj, "a", "name", args2);
                }
                case 29: 
                case 30: {
                    String s1 = ScriptRuntime.toString(thisObj);
                    String s2 = ScriptRuntime.toString(args2, 0);
                    return ScriptRuntime.wrapBoolean(id == 29 ? s1.equals(s2) : s1.equalsIgnoreCase(s2));
                }
                case 31: 
                case 32: 
                case 33: {
                    int actionType = id == 31 ? 1 : (id == 32 ? 3 : 2);
                    return ScriptRuntime.checkRegExpProxy(cx).action(cx, scope, thisObj, args2, actionType);
                }
                case 34: {
                    Collator collator = Collator.getInstance(cx.getLocale());
                    collator.setStrength(3);
                    collator.setDecomposition(1);
                    return ScriptRuntime.wrapNumber(collator.compare(ScriptRuntime.toString(thisObj), ScriptRuntime.toString(args2, 0)));
                }
                case 35: {
                    return ScriptRuntime.toString(thisObj).toLowerCase(cx.getLocale());
                }
                case 36: {
                    return ScriptRuntime.toString(thisObj).toUpperCase(cx.getLocale());
                }
                case 37: {
                    int end2;
                    int start2;
                    String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, f2));
                    char[] chars = str.toCharArray();
                    for (start2 = 0; start2 < chars.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[start2]); ++start2) {
                    }
                    for (end2 = chars.length; end2 > start2 && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[end2 - 1]); --end2) {
                    }
                    return str.substring(start2, end2);
                }
                case 38: {
                    int start3;
                    String str = ScriptRuntime.toString(thisObj);
                    char[] chars = str.toCharArray();
                    for (start3 = 0; start3 < chars.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[start3]); ++start3) {
                    }
                    int end3 = chars.length;
                    return str.substring(start3, end3);
                }
                case 39: {
                    int end4;
                    String str = ScriptRuntime.toString(thisObj);
                    char[] chars = str.toCharArray();
                    int start4 = 0;
                    for (end4 = chars.length; end4 > start4 && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[end4 - 1]); --end4) {
                    }
                    return str.substring(start4, end4);
                }
                case 43: {
                    Normalizer.Form form;
                    String formStr = ScriptRuntime.toString(args2, 0);
                    if (Normalizer.Form.NFD.name().equals(formStr)) {
                        form = Normalizer.Form.NFD;
                    } else if (Normalizer.Form.NFKC.name().equals(formStr)) {
                        form = Normalizer.Form.NFKC;
                    } else if (Normalizer.Form.NFKD.name().equals(formStr)) {
                        form = Normalizer.Form.NFKD;
                    } else if (Normalizer.Form.NFC.name().equals(formStr) || args2.length == 0) {
                        form = Normalizer.Form.NFC;
                    } else {
                        throw ScriptRuntime.rangeError("The normalization form should be one of NFC, NFD, NFKC, NFKD");
                    }
                    return Normalizer.normalize(ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, f2)), form);
                }
                case 44: {
                    return NativeString.js_repeat(cx, thisObj, f2, args2);
                }
                case 45: {
                    String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, f2));
                    double cnt = ScriptRuntime.toInteger(args2, 0);
                    return cnt < 0.0 || cnt >= (double)str.length() ? Undefined.instance : Integer.valueOf(str.codePointAt((int)cnt));
                }
                case 46: {
                    return new NativeStringIterator(scope, thisObj);
                }
            }
            break;
        }
        throw new IllegalArgumentException("String.prototype has no method: " + f2.getFunctionName());
    }

    private static NativeString realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof NativeString)) {
            throw NativeString.incompatibleCallError(f2);
        }
        return (NativeString)thisObj;
    }

    private static String tagify(Object thisObj, String tag, String attribute, Object[] args2) {
        String str = ScriptRuntime.toString(thisObj);
        StringBuilder result2 = new StringBuilder();
        result2.append('<');
        result2.append(tag);
        if (attribute != null) {
            result2.append(' ');
            result2.append(attribute);
            result2.append("=\"");
            result2.append(ScriptRuntime.toString(args2, 0));
            result2.append('\"');
        }
        result2.append('>');
        result2.append(str);
        result2.append("</");
        result2.append(tag);
        result2.append('>');
        return result2.toString();
    }

    public CharSequence toCharSequence() {
        return this.string;
    }

    public String toString() {
        return this.string instanceof String ? (String)this.string : this.string.toString();
    }

    @Override
    public Object get(int index, Scriptable start2) {
        if (0 <= index && index < this.string.length()) {
            return String.valueOf(this.string.charAt(index));
        }
        return super.get(index, start2);
    }

    @Override
    public void put(int index, Scriptable start2, Object value2) {
        if (0 <= index && index < this.string.length()) {
            return;
        }
        super.put(index, start2, value2);
    }

    @Override
    public boolean has(int index, Scriptable start2) {
        if (0 <= index && index < this.string.length()) {
            return true;
        }
        return super.has(index, start2);
    }

    @Override
    protected Object[] getIds(boolean nonEnumerable, boolean getSymbols) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.getLanguageVersion() >= 200) {
            int i2;
            Object[] sids = super.getIds(nonEnumerable, getSymbols);
            Object[] a2 = new Object[sids.length + this.string.length()];
            for (i2 = 0; i2 < this.string.length(); ++i2) {
                a2[i2] = i2;
            }
            System.arraycopy(sids, 0, a2, i2, sids.length);
            return a2;
        }
        return super.getIds(nonEnumerable, getSymbols);
    }

    private static int js_indexOf(int methodId, String target, Object[] args2) {
        String searchStr = ScriptRuntime.toString(args2, 0);
        double position = ScriptRuntime.toInteger(args2, 1);
        if (position > (double)target.length() && methodId != 41 && methodId != 42) {
            return -1;
        }
        if (position < 0.0) {
            position = 0.0;
        } else if (position > (double)target.length()) {
            position = target.length();
        } else if (methodId == 42 && (position != position || position > (double)target.length())) {
            position = target.length();
        }
        if (42 == methodId) {
            if (args2.length == 0 || args2.length == 1 || args2.length == 2 && args2[1] == Undefined.instance) {
                position = target.length();
            }
            return target.substring(0, (int)position).endsWith(searchStr) ? 0 : -1;
        }
        return methodId == 41 ? (target.startsWith(searchStr, (int)position) ? 0 : -1) : target.indexOf(searchStr, (int)position);
    }

    private static int js_lastIndexOf(String target, Object[] args2) {
        String search = ScriptRuntime.toString(args2, 0);
        double end2 = ScriptRuntime.toNumber(args2, 1);
        if (end2 != end2 || end2 > (double)target.length()) {
            end2 = target.length();
        } else if (end2 < 0.0) {
            end2 = 0.0;
        }
        return target.lastIndexOf(search, (int)end2);
    }

    private static CharSequence js_substring(Context cx, CharSequence target, Object[] args2) {
        double end2;
        int length = target.length();
        double start2 = ScriptRuntime.toInteger(args2, 0);
        if (start2 < 0.0) {
            start2 = 0.0;
        } else if (start2 > (double)length) {
            start2 = length;
        }
        if (args2.length <= 1 || args2[1] == Undefined.instance) {
            end2 = length;
        } else {
            end2 = ScriptRuntime.toInteger(args2[1]);
            if (end2 < 0.0) {
                end2 = 0.0;
            } else if (end2 > (double)length) {
                end2 = length;
            }
            if (end2 < start2) {
                if (cx.getLanguageVersion() != 120) {
                    double temp = start2;
                    start2 = end2;
                    end2 = temp;
                } else {
                    end2 = start2;
                }
            }
        }
        return target.subSequence((int)start2, (int)end2);
    }

    int getLength() {
        return this.string.length();
    }

    private static CharSequence js_substr(CharSequence target, Object[] args2) {
        double end2;
        if (args2.length < 1) {
            return target;
        }
        double begin = ScriptRuntime.toInteger(args2[0]);
        int length = target.length();
        if (begin < 0.0) {
            if ((begin += (double)length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > (double)length) {
            begin = length;
        }
        if (args2.length == 1) {
            end2 = length;
        } else {
            end2 = ScriptRuntime.toInteger(args2[1]);
            if (end2 < 0.0) {
                end2 = 0.0;
            }
            if ((end2 += begin) > (double)length) {
                end2 = length;
            }
        }
        return target.subSequence((int)begin, (int)end2);
    }

    private static String js_concat(String target, Object[] args2) {
        int N2 = args2.length;
        if (N2 == 0) {
            return target;
        }
        if (N2 == 1) {
            String arg = ScriptRuntime.toString(args2[0]);
            return target.concat(arg);
        }
        int size2 = target.length();
        String[] argsAsStrings = new String[N2];
        for (int i2 = 0; i2 != N2; ++i2) {
            String s2;
            argsAsStrings[i2] = s2 = ScriptRuntime.toString(args2[i2]);
            size2 += s2.length();
        }
        StringBuilder result2 = new StringBuilder(size2);
        result2.append(target);
        for (int i3 = 0; i3 != N2; ++i3) {
            result2.append(argsAsStrings[i3]);
        }
        return result2.toString();
    }

    private static CharSequence js_slice(CharSequence target, Object[] args2) {
        double end2;
        double begin = args2.length < 1 ? 0.0 : ScriptRuntime.toInteger(args2[0]);
        int length = target.length();
        if (begin < 0.0) {
            if ((begin += (double)length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > (double)length) {
            begin = length;
        }
        if (args2.length < 2 || args2[1] == Undefined.instance) {
            end2 = length;
        } else {
            end2 = ScriptRuntime.toInteger(args2[1]);
            if (end2 < 0.0) {
                if ((end2 += (double)length) < 0.0) {
                    end2 = 0.0;
                }
            } else if (end2 > (double)length) {
                end2 = length;
            }
            if (end2 < begin) {
                end2 = begin;
            }
        }
        return target.subSequence((int)begin, (int)end2);
    }

    private static String js_repeat(Context cx, Scriptable thisObj, IdFunctionObject f2, Object[] args2) {
        int i2;
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, f2));
        double cnt = ScriptRuntime.toInteger(args2, 0);
        if (cnt < 0.0 || cnt == Double.POSITIVE_INFINITY) {
            throw ScriptRuntime.rangeError("Invalid count value");
        }
        if (cnt == 0.0 || str.length() == 0) {
            return "";
        }
        long size2 = (long)str.length() * (long)cnt;
        if (cnt > 2.147483647E9 || size2 > Integer.MAX_VALUE) {
            throw ScriptRuntime.rangeError("Invalid size or count value");
        }
        StringBuilder retval = new StringBuilder((int)size2);
        retval.append(str);
        int icnt = (int)cnt;
        for (i2 = 1; i2 <= icnt / 2; i2 *= 2) {
            retval.append((CharSequence)retval);
        }
        if (i2 < icnt) {
            retval.append(retval.substring(0, str.length() * (icnt - i2)));
        }
        return retval.toString();
    }

    @Override
    protected int findPrototypeId(Symbol k2) {
        if (SymbolKey.ITERATOR.equals(k2)) {
            return 46;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String s2) {
        int id = 0;
        String X = null;
        block0 : switch (s2.length()) {
            case 3: {
                char c2 = s2.charAt(2);
                if (c2 == 'b') {
                    if (s2.charAt(0) != 's' || s2.charAt(1) != 'u') break;
                    return 24;
                }
                if (c2 == 'g') {
                    if (s2.charAt(0) != 'b' || s2.charAt(1) != 'i') break;
                    return 21;
                }
                if (c2 != 'p' || s2.charAt(0) != 's' || s2.charAt(1) != 'u') break;
                return 23;
            }
            case 4: {
                char c3 = s2.charAt(0);
                if (c3 == 'b') {
                    X = "bold";
                    id = 16;
                    break;
                }
                if (c3 == 'l') {
                    X = "link";
                    id = 27;
                    break;
                }
                if (c3 != 't') break;
                X = "trim";
                id = 37;
                break;
            }
            case 5: {
                switch (s2.charAt(4)) {
                    case 'd': {
                        X = "fixed";
                        id = 18;
                        break block0;
                    }
                    case 'e': {
                        X = "slice";
                        id = 15;
                        break block0;
                    }
                    case 'h': {
                        X = "match";
                        id = 31;
                        break block0;
                    }
                    case 'k': {
                        X = "blink";
                        id = 22;
                        break block0;
                    }
                    case 'l': {
                        X = "small";
                        id = 20;
                        break block0;
                    }
                    case 't': {
                        X = "split";
                        id = 9;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s2.charAt(1)) {
                    case 'e': {
                        char c4 = s2.charAt(0);
                        if (c4 == 'r') {
                            X = "repeat";
                            id = 44;
                            break;
                        }
                        if (c4 != 's') break;
                        X = "search";
                        id = 32;
                        break;
                    }
                    case 'h': {
                        X = "charAt";
                        id = 5;
                        break;
                    }
                    case 'n': {
                        X = "anchor";
                        id = 28;
                        break;
                    }
                    case 'o': {
                        X = "concat";
                        id = 14;
                        break;
                    }
                    case 'q': {
                        X = "equals";
                        id = 29;
                        break;
                    }
                    case 't': {
                        X = "strike";
                        id = 19;
                        break;
                    }
                    case 'u': {
                        X = "substr";
                        id = 13;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s2.charAt(1)) {
                    case 'a': {
                        X = "valueOf";
                        id = 4;
                        break block0;
                    }
                    case 'e': {
                        X = "replace";
                        id = 33;
                        break block0;
                    }
                    case 'n': {
                        X = "indexOf";
                        id = 7;
                        break block0;
                    }
                    case 't': {
                        X = "italics";
                        id = 17;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (s2.charAt(6)) {
                    case 'c': {
                        X = "toSource";
                        id = 3;
                        break block0;
                    }
                    case 'e': {
                        X = "includes";
                        id = 40;
                        break block0;
                    }
                    case 'f': {
                        X = "trimLeft";
                        id = 38;
                        break block0;
                    }
                    case 'n': {
                        X = "toString";
                        id = 2;
                        break block0;
                    }
                    case 't': {
                        X = "endsWith";
                        id = 42;
                        break block0;
                    }
                    case 'z': {
                        X = "fontsize";
                        id = 25;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                switch (s2.charAt(0)) {
                    case 'f': {
                        X = "fontcolor";
                        id = 26;
                        break block0;
                    }
                    case 'n': {
                        X = "normalize";
                        id = 43;
                        break block0;
                    }
                    case 's': {
                        X = "substring";
                        id = 10;
                        break block0;
                    }
                    case 't': {
                        X = "trimRight";
                        id = 39;
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                char c5 = s2.charAt(0);
                if (c5 == 'c') {
                    X = "charCodeAt";
                    id = 6;
                    break;
                }
                if (c5 != 's') break;
                X = "startsWith";
                id = 41;
                break;
            }
            case 11: {
                switch (s2.charAt(2)) {
                    case 'L': {
                        X = "toLowerCase";
                        id = 11;
                        break block0;
                    }
                    case 'U': {
                        X = "toUpperCase";
                        id = 12;
                        break block0;
                    }
                    case 'd': {
                        X = "codePointAt";
                        id = 45;
                        break block0;
                    }
                    case 'n': {
                        X = "constructor";
                        id = 1;
                        break block0;
                    }
                    case 's': {
                        X = "lastIndexOf";
                        id = 8;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                X = "localeCompare";
                id = 34;
                break;
            }
            case 16: {
                X = "equalsIgnoreCase";
                id = 30;
                break;
            }
            case 17: {
                char c6 = s2.charAt(8);
                if (c6 == 'L') {
                    X = "toLocaleLowerCase";
                    id = 35;
                    break;
                }
                if (c6 != 'U') break;
                X = "toLocaleUpperCase";
                id = 36;
            }
        }
        if (X == null) return id;
        if (X == s2) return id;
        if (X.equals(s2)) return id;
        return 0;
    }
}

