/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeSymbol
extends IdScriptableObject
implements Symbol {
    private static final long serialVersionUID = -589539749749830003L;
    public static final String CLASS_NAME = "Symbol";
    public static final String TYPE_NAME = "symbol";
    private static final Object GLOBAL_TABLE_KEY = new Object();
    private static final Object CONSTRUCTOR_SLOT = new Object();
    private final SymbolKey key;
    private final NativeSymbol symbolData;
    private static final int ConstructorId_keyFor = -2;
    private static final int ConstructorId_for = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 4;
    private static final int SymbolId_toStringTag = 3;
    private static final int SymbolId_toPrimitive = 5;
    private static final int MAX_PROTOTYPE_ID = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeSymbol obj = new NativeSymbol("");
        IdFunctionObject ctor = obj.exportAsJSClass(5, scope, sealed);
        cx.putThreadLocal(CONSTRUCTOR_SLOT, Boolean.TRUE);
        try {
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "iterator", SymbolKey.ITERATOR);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "species", SymbolKey.SPECIES);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "toStringTag", SymbolKey.TO_STRING_TAG);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "hasInstance", SymbolKey.HAS_INSTANCE);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "isConcatSpreadable", SymbolKey.IS_CONCAT_SPREADABLE);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "isRegExp", SymbolKey.IS_REGEXP);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "toPrimitive", SymbolKey.TO_PRIMITIVE);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "match", SymbolKey.MATCH);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "replace", SymbolKey.REPLACE);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "search", SymbolKey.SEARCH);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "split", SymbolKey.SPLIT);
            NativeSymbol.createStandardSymbol(cx, scope, ctor, "unscopables", SymbolKey.UNSCOPABLES);
        }
        finally {
            cx.removeThreadLocal(CONSTRUCTOR_SLOT);
        }
    }

    private NativeSymbol(String desc) {
        this.key = new SymbolKey(desc);
        this.symbolData = this;
    }

    private NativeSymbol(SymbolKey key2) {
        this.key = key2;
        this.symbolData = this;
    }

    public NativeSymbol(NativeSymbol s2) {
        this.key = s2.key;
        this.symbolData = s2.symbolData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeSymbol construct(Context cx, Scriptable scope, Object[] args2) {
        cx.putThreadLocal(CONSTRUCTOR_SLOT, Boolean.TRUE);
        try {
            NativeSymbol nativeSymbol = (NativeSymbol)cx.newObject(scope, CLASS_NAME, args2);
            return nativeSymbol;
        }
        finally {
            cx.removeThreadLocal(CONSTRUCTOR_SLOT);
        }
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        super.fillConstructorProperties(ctor);
        this.addIdFunctionProperty(ctor, CLASS_NAME, -1, "for", 1);
        this.addIdFunctionProperty(ctor, CLASS_NAME, -2, "keyFor", 1);
    }

    private static void createStandardSymbol(Context cx, Scriptable scope, ScriptableObject ctor, String name, SymbolKey key2) {
        Scriptable sym = cx.newObject(scope, CLASS_NAME, new Object[]{name, key2});
        ctor.defineProperty(name, (Object)sym, 7);
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block5: {
            id = 0;
            id = 0;
            String X = null;
            int s_length = s2.length();
            if (s_length == 7) {
                X = "valueOf";
                id = 4;
            } else if (s_length == 8) {
                X = "toString";
                id = 2;
            } else if (s_length == 11) {
                X = "constructor";
                id = 1;
            }
            if (X == null || X == s2 || X.equals(s2)) break block5;
            id = 0;
        }
        return id;
    }

    @Override
    protected int findPrototypeId(Symbol key2) {
        if (SymbolKey.TO_STRING_TAG.equals(key2)) {
            return 3;
        }
        if (SymbolKey.TO_PRIMITIVE.equals(key2)) {
            return 5;
        }
        return 0;
    }

    @Override
    protected void initPrototypeId(int id) {
        Object s2 = null;
        int arity = -1;
        switch (id) {
            case 1: {
                this.initPrototypeMethod(CLASS_NAME, id, "constructor", 1);
                break;
            }
            case 2: {
                this.initPrototypeMethod(CLASS_NAME, id, "toString", 0);
                break;
            }
            case 4: {
                this.initPrototypeMethod(CLASS_NAME, id, "valueOf", 0);
                break;
            }
            case 3: {
                this.initPrototypeValue(id, SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
                break;
            }
            case 5: {
                this.initPrototypeMethod((Object)CLASS_NAME, id, SymbolKey.TO_PRIMITIVE, "Symbol.toPrimitive", 1);
                break;
            }
            default: {
                super.initPrototypeId(id);
            }
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(CLASS_NAME)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case -1: {
                return this.js_for(cx, scope, args2);
            }
            case -2: {
                return this.js_keyFor(cx, scope, args2);
            }
            case 1: {
                if (thisObj == null) {
                    if (cx.getThreadLocal(CONSTRUCTOR_SLOT) == null) {
                        throw ScriptRuntime.typeError0("msg.no.symbol.new");
                    }
                    return NativeSymbol.js_constructor(args2);
                }
                return NativeSymbol.construct(cx, scope, args2);
            }
            case 2: {
                return this.getSelf(thisObj).toString();
            }
            case 4: 
            case 5: {
                return this.getSelf(thisObj).js_valueOf();
            }
        }
        return super.execIdCall(f2, cx, scope, thisObj, args2);
    }

    private NativeSymbol getSelf(Object thisObj) {
        try {
            return (NativeSymbol)thisObj;
        }
        catch (ClassCastException cce) {
            throw ScriptRuntime.typeError1("msg.invalid.type", thisObj.getClass().getName());
        }
    }

    private static NativeSymbol js_constructor(Object[] args2) {
        String desc = args2.length > 0 ? (Undefined.instance.equals(args2[0]) ? "" : ScriptRuntime.toString(args2[0])) : "";
        if (args2.length > 1) {
            return new NativeSymbol((SymbolKey)args2[1]);
        }
        return new NativeSymbol(desc);
    }

    private Object js_valueOf() {
        return this.symbolData;
    }

    private Object js_for(Context cx, Scriptable scope, Object[] args2) {
        String name = args2.length > 0 ? ScriptRuntime.toString(args2[0]) : ScriptRuntime.toString(Undefined.instance);
        Map<String, NativeSymbol> table = this.getGlobalMap();
        NativeSymbol ret = table.get(name);
        if (ret == null) {
            ret = NativeSymbol.construct(cx, scope, new Object[]{name});
            table.put(name, ret);
        }
        return ret;
    }

    private Object js_keyFor(Context cx, Scriptable scope, Object[] args2) {
        Object s2;
        Object object = s2 = args2.length > 0 ? args2[0] : Undefined.instance;
        if (!(s2 instanceof NativeSymbol)) {
            throw ScriptRuntime.throwCustomError(cx, scope, "TypeError", "Not a Symbol");
        }
        NativeSymbol sym = (NativeSymbol)s2;
        Map<String, NativeSymbol> table = this.getGlobalMap();
        for (Map.Entry<String, NativeSymbol> e2 : table.entrySet()) {
            if (e2.getValue().key != sym.key) continue;
            return e2.getKey();
        }
        return Undefined.instance;
    }

    public String toString() {
        return this.key.toString();
    }

    @Override
    public void put(String name, Scriptable start2, Object value2) {
        if (!this.isSymbol()) {
            super.put(name, start2, value2);
        } else if (Context.getCurrentContext().isStrictMode()) {
            throw ScriptRuntime.typeError0("msg.no.assign.symbol.strict");
        }
    }

    @Override
    public void put(int index, Scriptable start2, Object value2) {
        if (!this.isSymbol()) {
            super.put(index, start2, value2);
        } else if (Context.getCurrentContext().isStrictMode()) {
            throw ScriptRuntime.typeError0("msg.no.assign.symbol.strict");
        }
    }

    @Override
    public void put(Symbol key2, Scriptable start2, Object value2) {
        if (!this.isSymbol()) {
            super.put(key2, start2, value2);
        } else if (Context.getCurrentContext().isStrictMode()) {
            throw ScriptRuntime.typeError0("msg.no.assign.symbol.strict");
        }
    }

    public boolean isSymbol() {
        return this.symbolData == this;
    }

    @Override
    public String getTypeOf() {
        return this.isSymbol() ? TYPE_NAME : super.getTypeOf();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object x) {
        return this.key.equals(x);
    }

    SymbolKey getKey() {
        return this.key;
    }

    private Map<String, NativeSymbol> getGlobalMap() {
        ScriptableObject top = (ScriptableObject)NativeSymbol.getTopLevelScope(this);
        HashMap map2 = (HashMap)top.getAssociatedValue(GLOBAL_TABLE_KEY);
        if (map2 == null) {
            map2 = new HashMap();
            top.associateValue(GLOBAL_TABLE_KEY, map2);
        }
        return map2;
    }
}

