/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeWith
implements Scriptable,
IdFunctionCall,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object FTAG = "With";
    private static final int Id_constructor = 1;
    protected Scriptable prototype;
    protected Scriptable parent;

    static void init(Scriptable scope, boolean sealed) {
        NativeWith obj = new NativeWith();
        obj.setParentScope(scope);
        obj.setPrototype(ScriptableObject.getObjectPrototype(scope));
        IdFunctionObject ctor = new IdFunctionObject(obj, FTAG, 1, "With", 0, scope);
        ctor.markAsConstructor(obj);
        if (sealed) {
            ctor.sealObject();
        }
        ctor.exportAsScopeProperty();
    }

    private NativeWith() {
    }

    protected NativeWith(Scriptable parent, Scriptable prototype) {
        this.parent = parent;
        this.prototype = prototype;
    }

    @Override
    public String getClassName() {
        return "With";
    }

    @Override
    public boolean has(String id, Scriptable start2) {
        return this.prototype.has(id, this.prototype);
    }

    @Override
    public boolean has(int index, Scriptable start2) {
        return this.prototype.has(index, this.prototype);
    }

    @Override
    public Object get(String id, Scriptable start2) {
        if (start2 == this) {
            start2 = this.prototype;
        }
        return this.prototype.get(id, start2);
    }

    @Override
    public Object get(int index, Scriptable start2) {
        if (start2 == this) {
            start2 = this.prototype;
        }
        return this.prototype.get(index, start2);
    }

    @Override
    public void put(String id, Scriptable start2, Object value2) {
        if (start2 == this) {
            start2 = this.prototype;
        }
        this.prototype.put(id, start2, value2);
    }

    @Override
    public void put(int index, Scriptable start2, Object value2) {
        if (start2 == this) {
            start2 = this.prototype;
        }
        this.prototype.put(index, start2, value2);
    }

    @Override
    public void delete(String id) {
        this.prototype.delete(id);
    }

    @Override
    public void delete(int index) {
        this.prototype.delete(index);
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    @Override
    public Object[] getIds() {
        return this.prototype.getIds();
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return this.prototype.getDefaultValue(typeHint);
    }

    @Override
    public boolean hasInstance(Scriptable value2) {
        return this.prototype.hasInstance(value2);
    }

    protected Object updateDotQuery(boolean value2) {
        throw new IllegalStateException();
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (f2.hasTag(FTAG) && f2.methodId() == 1) {
            throw Context.reportRuntimeError1("msg.cant.call.indirect", "With");
        }
        throw f2.unknown();
    }

    static boolean isWithFunction(Object functionObj) {
        if (functionObj instanceof IdFunctionObject) {
            IdFunctionObject f2 = (IdFunctionObject)functionObj;
            return f2.hasTag(FTAG) && f2.methodId() == 1;
        }
        return false;
    }

    static Object newWithSpecial(Context cx, Scriptable scope, Object[] args2) {
        ScriptRuntime.checkDeprecated(cx, "With");
        scope = ScriptableObject.getTopLevelScope(scope);
        NativeWith thisObj = new NativeWith();
        thisObj.setPrototype(args2.length == 0 ? ScriptableObject.getObjectPrototype(scope) : ScriptRuntime.toObject(cx, scope, args2[0]));
        thisObj.setParentScope(scope);
        return thisObj;
    }
}

