/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.UniqueTag;

public class ObjToIntMap
implements Serializable {
    static final long serialVersionUID = -1542220580748809402L;
    private static final int A = -1640531527;
    private static final Object DELETED = new Object();
    private transient Object[] keys;
    private transient int[] values;
    private int power;
    private int keyCount;
    private transient int occupiedCount;
    private static final boolean check = false;

    public ObjToIntMap() {
        this(4);
    }

    public ObjToIntMap(int keyCountHint) {
        if (keyCountHint < 0) {
            Kit.codeBug();
        }
        int minimalCapacity = keyCountHint * 4 / 3;
        int i2 = 2;
        while (1 << i2 < minimalCapacity) {
            ++i2;
        }
        this.power = i2;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(Object key2) {
        if (key2 == null) {
            key2 = UniqueTag.NULL_VALUE;
        }
        return 0 <= this.findIndex(key2);
    }

    public int get(Object key2, int defaultValue) {
        int index;
        if (key2 == null) {
            key2 = UniqueTag.NULL_VALUE;
        }
        if (0 <= (index = this.findIndex(key2))) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getExisting(Object key2) {
        int index;
        if (key2 == null) {
            key2 = UniqueTag.NULL_VALUE;
        }
        if (0 <= (index = this.findIndex(key2))) {
            return this.values[index];
        }
        Kit.codeBug();
        return 0;
    }

    public void put(Object key2, int value2) {
        if (key2 == null) {
            key2 = UniqueTag.NULL_VALUE;
        }
        int index = this.ensureIndex(key2);
        this.values[index] = value2;
    }

    public Object intern(Object keyArg) {
        boolean nullKey = false;
        if (keyArg == null) {
            nullKey = true;
            keyArg = UniqueTag.NULL_VALUE;
        }
        int index = this.ensureIndex(keyArg);
        this.values[index] = 0;
        return nullKey ? null : this.keys[index];
    }

    public void remove(Object key2) {
        int index;
        if (key2 == null) {
            key2 = UniqueTag.NULL_VALUE;
        }
        if (0 <= (index = this.findIndex(key2))) {
            this.keys[index] = DELETED;
            --this.keyCount;
        }
    }

    public void clear() {
        int i2 = this.keys.length;
        while (i2 != 0) {
            this.keys[--i2] = null;
        }
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public Iterator newIterator() {
        return new Iterator(this);
    }

    final void initIterator(Iterator i2) {
        i2.init(this.keys, this.values, this.keyCount);
    }

    public Object[] getKeys() {
        Object[] array = new Object[this.keyCount];
        this.getKeys(array, 0);
        return array;
    }

    public void getKeys(Object[] array, int offset) {
        int count2 = this.keyCount;
        int i2 = 0;
        while (count2 != 0) {
            Object key2 = this.keys[i2];
            if (key2 != null && key2 != DELETED) {
                if (key2 == UniqueTag.NULL_VALUE) {
                    key2 = null;
                }
                array[offset] = key2;
                ++offset;
                --count2;
            }
            ++i2;
        }
    }

    private static int tableLookupStep(int fraction, int mask, int power) {
        int shift = 32 - 2 * power;
        if (shift >= 0) {
            return fraction >>> shift & mask | 1;
        }
        return fraction & mask >>> -shift | 1;
    }

    private int findIndex(Object key2) {
        int hash;
        int fraction;
        int index;
        Object test;
        if (this.keys != null && (test = this.keys[index = (fraction = (hash = key2.hashCode()) * -1640531527) >>> 32 - this.power]) != null) {
            int N2 = 1 << this.power;
            if (test == key2 || this.values[N2 + index] == hash && test.equals(key2)) {
                return index;
            }
            int mask = N2 - 1;
            int step = ObjToIntMap.tableLookupStep(fraction, mask, this.power);
            boolean n = false;
            while ((test = this.keys[index = index + step & mask]) != null) {
                if (test != key2 && (this.values[N2 + index] != hash || !test.equals(key2))) continue;
                return index;
            }
        }
        return -1;
    }

    private int insertNewKey(Object key2, int hash) {
        int fraction = hash * -1640531527;
        int index = fraction >>> 32 - this.power;
        int N2 = 1 << this.power;
        if (this.keys[index] != null) {
            int mask = N2 - 1;
            int step = ObjToIntMap.tableLookupStep(fraction, mask, this.power);
            int firstIndex = index;
            while (this.keys[index = index + step & mask] != null) {
            }
        }
        this.keys[index] = key2;
        this.values[N2 + index] = hash;
        ++this.occupiedCount;
        ++this.keyCount;
        return index;
    }

    private void rehashTable() {
        if (this.keys == null) {
            int N2 = 1 << this.power;
            this.keys = new Object[N2];
            this.values = new int[2 * N2];
        } else {
            if (this.keyCount * 2 >= this.occupiedCount) {
                ++this.power;
            }
            int N3 = 1 << this.power;
            Object[] oldKeys = this.keys;
            int[] oldValues = this.values;
            int oldN = oldKeys.length;
            this.keys = new Object[N3];
            this.values = new int[2 * N3];
            int remaining = this.keyCount;
            this.keyCount = 0;
            this.occupiedCount = 0;
            int i2 = 0;
            while (remaining != 0) {
                Object key2 = oldKeys[i2];
                if (key2 != null && key2 != DELETED) {
                    int keyHash = oldValues[oldN + i2];
                    int index = this.insertNewKey(key2, keyHash);
                    this.values[index] = oldValues[i2];
                    --remaining;
                }
                ++i2;
            }
        }
    }

    private int ensureIndex(Object key2) {
        int fraction;
        Object test;
        int hash = key2.hashCode();
        int index = -1;
        int firstDeleted = -1;
        if (this.keys != null && (test = this.keys[index = (fraction = hash * -1640531527) >>> 32 - this.power]) != null) {
            int N2 = 1 << this.power;
            if (test == key2 || this.values[N2 + index] == hash && test.equals(key2)) {
                return index;
            }
            if (test == DELETED) {
                firstDeleted = index;
            }
            int mask = N2 - 1;
            int step = ObjToIntMap.tableLookupStep(fraction, mask, this.power);
            boolean n = false;
            while ((test = this.keys[index = index + step & mask]) != null) {
                if (test == key2 || this.values[N2 + index] == hash && test.equals(key2)) {
                    return index;
                }
                if (test != DELETED || firstDeleted >= 0) continue;
                firstDeleted = index;
            }
        }
        if (firstDeleted >= 0) {
            index = firstDeleted;
        } else {
            if (this.keys == null || this.occupiedCount * 4 >= (1 << this.power) * 3) {
                this.rehashTable();
                return this.insertNewKey(key2, hash);
            }
            ++this.occupiedCount;
        }
        this.keys[index] = key2;
        this.values[(1 << this.power) + index] = hash;
        ++this.keyCount;
        return index;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.defaultWriteObject();
        int count2 = this.keyCount;
        int i2 = 0;
        while (count2 != 0) {
            Object key2 = this.keys[i2];
            if (key2 != null && key2 != DELETED) {
                --count2;
                out2.writeObject(key2);
                out2.writeInt(this.values[i2]);
            }
            ++i2;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int writtenKeyCount = this.keyCount;
        if (writtenKeyCount != 0) {
            this.keyCount = 0;
            int N2 = 1 << this.power;
            this.keys = new Object[N2];
            this.values = new int[2 * N2];
            for (int i2 = 0; i2 != writtenKeyCount; ++i2) {
                Object key2 = in.readObject();
                int hash = key2.hashCode();
                int index = this.insertNewKey(key2, hash);
                this.values[index] = in.readInt();
            }
        }
    }

    public static class Iterator {
        ObjToIntMap master;
        private int cursor;
        private int remaining;
        private Object[] keys;
        private int[] values;

        Iterator(ObjToIntMap master) {
            this.master = master;
        }

        final void init(Object[] keys2, int[] values2, int keyCount) {
            this.keys = keys2;
            this.values = values2;
            this.cursor = -1;
            this.remaining = keyCount;
        }

        public void start() {
            this.master.initIterator(this);
            this.next();
        }

        public boolean done() {
            return this.remaining < 0;
        }

        public void next() {
            if (this.remaining == -1) {
                Kit.codeBug();
            }
            if (this.remaining == 0) {
                this.remaining = -1;
                this.cursor = -1;
            } else {
                ++this.cursor;
                while (true) {
                    Object key2;
                    if ((key2 = this.keys[this.cursor]) != null && key2 != DELETED) {
                        --this.remaining;
                        break;
                    }
                    ++this.cursor;
                }
            }
        }

        public Object getKey() {
            Object key2 = this.keys[this.cursor];
            if (key2 == UniqueTag.NULL_VALUE) {
                key2 = null;
            }
            return key2;
        }

        public int getValue() {
            return this.values[this.cursor];
        }

        public void setValue(int value2) {
            this.values[this.cursor] = value2;
        }
    }
}

