/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
SymbolScriptable,
Serializable,
DebuggableObject,
ConstProperties {
    static final long serialVersionUID = 2829861078851942586L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private transient Slot[] slots;
    private int count;
    private transient ExternalArrayData externalData;
    private transient Slot firstAdded;
    private transient Slot lastAdded;
    private volatile Map<Object, Object> associatedValues;
    private static final int SLOT_QUERY = 1;
    private static final int SLOT_MODIFY = 2;
    private static final int SLOT_MODIFY_CONST = 3;
    private static final int SLOT_MODIFY_GETTER_SETTER = 4;
    private static final int SLOT_CONVERT_ACCESSOR_TO_DATA = 5;
    private static final int INITIAL_SLOT_SIZE = 4;
    private boolean isExtensible = true;
    private static final Method GET_ARRAY_LENGTH;
    private static final Comparator<Object> KEY_COMPARATOR;

    protected static ScriptableObject buildDataDescriptor(Scriptable scope, Object value2, int attributes2) {
        NativeObject desc = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(desc, scope, TopLevel.Builtins.Object);
        desc.defineProperty("value", value2, 0);
        desc.defineProperty("writable", (Object)((attributes2 & 1) == 0 ? 1 : 0), 0);
        desc.defineProperty("enumerable", (Object)((attributes2 & 2) == 0 ? 1 : 0), 0);
        desc.defineProperty("configurable", (Object)((attributes2 & 4) == 0 ? 1 : 0), 0);
        return desc;
    }

    static void checkValidAttributes(int attributes2) {
        int mask = 15;
        if ((attributes2 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(attributes2));
        }
    }

    public ScriptableObject() {
    }

    public ScriptableObject(Scriptable scope, Scriptable prototype) {
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scope;
        this.prototypeObject = prototype;
    }

    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "object";
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String name, Scriptable start2) {
        return null != this.getSlot(name, 0, 1);
    }

    @Override
    public boolean has(int index, Scriptable start2) {
        if (this.externalData != null) {
            return index < this.externalData.getArrayLength();
        }
        return null != this.getSlot((Object)null, index, 1);
    }

    @Override
    public boolean has(Symbol key2, Scriptable start2) {
        return null != this.getSlot(key2, 0, 1);
    }

    @Override
    public Object get(String name, Scriptable start2) {
        Slot slot = this.getSlot(name, 0, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start2);
    }

    @Override
    public Object get(int index, Scriptable start2) {
        if (this.externalData != null) {
            if (index < this.externalData.getArrayLength()) {
                return this.externalData.getArrayElement(index);
            }
            return Scriptable.NOT_FOUND;
        }
        Slot slot = this.getSlot((Object)null, index, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start2);
    }

    @Override
    public Object get(Symbol key2, Scriptable start2) {
        Slot slot = this.getSlot(key2, 0, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start2);
    }

    @Override
    public void put(String name, Scriptable start2, Object value2) {
        if (this.putImpl(name, 0, start2, value2)) {
            return;
        }
        if (start2 == this) {
            throw Kit.codeBug();
        }
        start2.put(name, start2, value2);
    }

    @Override
    public void put(int index, Scriptable start2, Object value2) {
        if (this.externalData != null) {
            if (index >= this.externalData.getArrayLength()) {
                throw new JavaScriptException(ScriptRuntime.newNativeError(Context.getCurrentContext(), this, TopLevel.NativeErrors.RangeError, new Object[]{"External array index out of bounds "}), null, 0);
            }
            this.externalData.setArrayElement(index, value2);
            return;
        }
        if (this.putImpl(null, index, start2, value2)) {
            return;
        }
        if (start2 == this) {
            throw Kit.codeBug();
        }
        start2.put(index, start2, value2);
    }

    @Override
    public void put(Symbol key2, Scriptable start2, Object value2) {
        if (this.putImpl(key2, 0, start2, value2)) {
            return;
        }
        if (start2 == this) {
            throw Kit.codeBug();
        }
        ScriptableObject.ensureSymbolScriptable(start2).put(key2, start2, value2);
    }

    @Override
    public void delete(String name) {
        this.checkNotSealed(name, 0);
        this.removeSlot(name, 0);
    }

    @Override
    public void delete(int index) {
        this.checkNotSealed(null, index);
        this.removeSlot(null, index);
    }

    @Override
    public void delete(Symbol key2) {
        this.checkNotSealed(key2, 0);
        this.removeSlot(key2, 0);
    }

    @Override
    public void putConst(String name, Scriptable start2, Object value2) {
        if (this.putConstImpl(name, 0, start2, value2, 1)) {
            return;
        }
        if (start2 == this) {
            throw Kit.codeBug();
        }
        if (start2 instanceof ConstProperties) {
            ((ConstProperties)((Object)start2)).putConst(name, start2, value2);
        } else {
            start2.put(name, start2, value2);
        }
    }

    @Override
    public void defineConst(String name, Scriptable start2) {
        if (this.putConstImpl(name, 0, start2, Undefined.instance, 8)) {
            return;
        }
        if (start2 == this) {
            throw Kit.codeBug();
        }
        if (start2 instanceof ConstProperties) {
            ((ConstProperties)((Object)start2)).defineConst(name, start2);
        }
    }

    @Override
    public boolean isConst(String name) {
        Slot slot = this.getSlot(name, 0, 1);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    @Deprecated
    public final int getAttributes(String name, Scriptable start2) {
        return this.getAttributes(name);
    }

    @Deprecated
    public final int getAttributes(int index, Scriptable start2) {
        return this.getAttributes(index);
    }

    @Deprecated
    public final void setAttributes(String name, Scriptable start2, int attributes2) {
        this.setAttributes(name, attributes2);
    }

    @Deprecated
    public void setAttributes(int index, Scriptable start2, int attributes2) {
        this.setAttributes(index, attributes2);
    }

    public int getAttributes(String name) {
        return this.findAttributeSlot(name, 0, 1).getAttributes();
    }

    public int getAttributes(int index) {
        return this.findAttributeSlot(null, index, 1).getAttributes();
    }

    public int getAttributes(Symbol sym) {
        return this.findAttributeSlot(sym, 1).getAttributes();
    }

    public void setAttributes(String name, int attributes2) {
        this.checkNotSealed(name, 0);
        this.findAttributeSlot(name, 0, 2).setAttributes(attributes2);
    }

    public void setAttributes(int index, int attributes2) {
        this.checkNotSealed(null, index);
        this.findAttributeSlot(null, index, 2).setAttributes(attributes2);
    }

    public void setAttributes(Symbol key2, int attributes2) {
        this.checkNotSealed(key2, 0);
        this.findAttributeSlot(key2, 2).setAttributes(attributes2);
    }

    public void setGetterOrSetter(String name, int index, Callable getterOrSetter, boolean isSetter) {
        this.setGetterOrSetter(name, index, getterOrSetter, isSetter, false);
    }

    private void setGetterOrSetter(String name, int index, Callable getterOrSetter, boolean isSetter, boolean force) {
        int attributes2;
        GetterSlot gslot;
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        if (!force) {
            this.checkNotSealed(name, index);
        }
        if (this.isExtensible()) {
            gslot = (GetterSlot)this.getSlot(name, index, 4);
        } else {
            Slot slot = ScriptableObject.unwrapSlot(this.getSlot(name, index, 1));
            if (!(slot instanceof GetterSlot)) {
                return;
            }
            gslot = (GetterSlot)slot;
        }
        if (!force && ((attributes2 = gslot.getAttributes()) & 1) != 0) {
            throw Context.reportRuntimeError1("msg.modify.readonly", name);
        }
        if (isSetter) {
            gslot.setter = getterOrSetter;
        } else {
            gslot.getter = getterOrSetter;
        }
        gslot.value = Undefined.instance;
    }

    public Object getGetterOrSetter(String name, int index, boolean isSetter) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        Slot slot = ScriptableObject.unwrapSlot(this.getSlot(name, index, 1));
        if (slot == null) {
            return null;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot gslot = (GetterSlot)slot;
            Object result2 = isSetter ? gslot.setter : gslot.getter;
            return result2 != null ? result2 : Undefined.instance;
        }
        return Undefined.instance;
    }

    protected boolean isGetterOrSetter(String name, int index, boolean setter) {
        Slot slot = ScriptableObject.unwrapSlot(this.getSlot(name, index, 1));
        if (slot instanceof GetterSlot) {
            if (setter && ((GetterSlot)slot).setter != null) {
                return true;
            }
            if (!setter && ((GetterSlot)slot).getter != null) {
                return true;
            }
        }
        return false;
    }

    void addLazilyInitializedValue(String name, int index, LazilyLoadedCtor init, int attributes2) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        this.checkNotSealed(name, index);
        GetterSlot gslot = (GetterSlot)this.getSlot(name, index, 4);
        gslot.setAttributes(attributes2);
        gslot.getter = null;
        gslot.setter = null;
        gslot.value = init;
    }

    public void setExternalArrayData(ExternalArrayData array) {
        this.externalData = array;
        if (array == null) {
            this.delete("length");
        } else {
            this.defineProperty("length", null, GET_ARRAY_LENGTH, null, 3);
        }
    }

    public ExternalArrayData getExternalArrayData() {
        return this.externalData;
    }

    public Object getExternalArrayLength() {
        return this.externalData == null ? 0 : this.externalData.getArrayLength();
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable m4) {
        this.prototypeObject = m4;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable m4) {
        this.parentScopeObject = m4;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false, false);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true, false);
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return ScriptableObject.getDefaultValue(this, typeHint);
    }

    public static Object getDefaultValue(Scriptable object, Class<?> typeHint) {
        Context cx = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            Object u;
            Object[] args2;
            String methodName;
            boolean tryToString;
            if (typeHint == ScriptRuntime.StringClass) {
                tryToString = i2 == 0;
            } else {
                boolean bl = tryToString = i2 == 1;
            }
            if (tryToString) {
                methodName = "toString";
                args2 = ScriptRuntime.emptyArgs;
            } else {
                String hint;
                methodName = "valueOf";
                args2 = new Object[1];
                if (typeHint == null) {
                    hint = "undefined";
                } else if (typeHint == ScriptRuntime.StringClass) {
                    hint = "string";
                } else if (typeHint == ScriptRuntime.ScriptableClass) {
                    hint = "object";
                } else if (typeHint == ScriptRuntime.FunctionClass) {
                    hint = "function";
                } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                    hint = "boolean";
                } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                    hint = "number";
                } else {
                    throw Context.reportRuntimeError1("msg.invalid.type", typeHint.toString());
                }
                args2[0] = hint;
            }
            Object v = ScriptableObject.getProperty(object, methodName);
            if (!(v instanceof Function)) continue;
            Function fun = (Function)v;
            if (cx == null) {
                cx = Context.getContext();
            }
            if ((v = fun.call(cx, fun.getParentScope(), object, args2)) == null) continue;
            if (!(v instanceof Scriptable)) {
                return v;
            }
            if (typeHint == ScriptRuntime.ScriptableClass || typeHint == ScriptRuntime.FunctionClass) {
                return v;
            }
            if (!tryToString || !(v instanceof Wrapper) || !((u = ((Wrapper)v).unwrap()) instanceof String)) continue;
            return u;
        }
        String arg = typeHint == null ? "undefined" : typeHint.getName();
        throw ScriptRuntime.typeError1("msg.default.value", arg);
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object value2) {
        return this == value2 ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz, boolean sealed) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, sealed, false);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction ctor = ScriptableObject.buildClassCtor(scope, clazz, sealed, mapInheritance);
        if (ctor == null) {
            return null;
        }
        String name = ctor.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scope, name, ctor, 2);
        return name;
    }

    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject ctor;
        Class<T> superScriptable;
        String name;
        Class<T> superClass;
        Object existingProto;
        AccessibleObject[] methods2 = FunctionObject.getMethodList(clazz);
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            Method method2 = methods2[i2];
            if (!method2.getName().equals("init")) continue;
            Class<?>[] parmTypes = method2.getParameterTypes();
            if (parmTypes.length == 3 && parmTypes[0] == ScriptRuntime.ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method2.getModifiers())) {
                Object[] args2 = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                method2.invoke(null, args2);
                return null;
            }
            if (parmTypes.length != 1 || parmTypes[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(method2.getModifiers())) continue;
            Object[] args3 = new Object[]{scope};
            method2.invoke(null, args3);
            return null;
        }
        AccessibleObject[] ctors = clazz.getConstructors();
        Constructor<?> protoCtor = null;
        for (int i3 = 0; i3 < ctors.length; ++i3) {
            if (ctors[i3].getParameterTypes().length != 0) continue;
            protoCtor = ctors[i3];
            break;
        }
        if (protoCtor == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
        String className = proto.getClassName();
        Object existing = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(scope), className);
        if (existing instanceof BaseFunction && (existingProto = ((BaseFunction)existing).getPrototypeProperty()) != null && clazz.equals(existingProto.getClass())) {
            return (BaseFunction)existing;
        }
        Scriptable superProto = null;
        if (mapInheritance && ScriptRuntime.ScriptableClass.isAssignableFrom(superClass = clazz.getSuperclass()) && !Modifier.isAbstract(superClass.getModifiers()) && (name = ScriptableObject.defineClass(scope, superScriptable = ScriptableObject.extendsScriptable(superClass), sealed, mapInheritance)) != null) {
            superProto = ScriptableObject.getClassPrototype(scope, name);
        }
        if (superProto == null) {
            superProto = ScriptableObject.getObjectPrototype(scope);
        }
        proto.setPrototype(superProto);
        String functionPrefix = "jsFunction_";
        String staticFunctionPrefix = "jsStaticFunction_";
        String getterPrefix = "jsGet_";
        String setterPrefix = "jsSet_";
        String ctorName = "jsConstructor";
        Object ctorMember = ScriptableObject.findAnnotatedMember(methods2, JSConstructor.class);
        if (ctorMember == null) {
            ctorMember = ScriptableObject.findAnnotatedMember(ctors, JSConstructor.class);
        }
        if (ctorMember == null) {
            ctorMember = FunctionObject.findSingleMethod((Method[])methods2, "jsConstructor");
        }
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (((Constructor)ctors[0]).getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (((Constructor)ctors[1]).getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((ctor = new FunctionObject(className, (Member)ctorMember, scope)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName());
        }
        ctor.initAsConstructor(scope, proto);
        AccessibleObject finishInit = null;
        HashSet<String> staticNames = new HashSet<String>();
        HashSet instanceNames = new HashSet();
        for (AccessibleObject method3 : methods2) {
            String propName;
            boolean isStatic;
            HashSet<String> names2;
            Class<?>[] parmTypes;
            if (method3 == ctorMember) continue;
            String name2 = ((Method)method3).getName();
            if (name2.equals("finishInit") && (parmTypes = ((Method)method3).getParameterTypes()).length == 3 && parmTypes[0] == ScriptRuntime.ScriptableClass && parmTypes[1] == FunctionObject.class && parmTypes[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)method3).getModifiers())) {
                finishInit = method3;
                continue;
            }
            if (name2.indexOf(36) != -1 || name2.equals("jsConstructor")) continue;
            Annotation annotation = null;
            String prefix2 = null;
            if (method3.isAnnotationPresent(JSFunction.class)) {
                annotation = ((Method)method3).getAnnotation(JSFunction.class);
            } else if (method3.isAnnotationPresent(JSStaticFunction.class)) {
                annotation = ((Method)method3).getAnnotation(JSStaticFunction.class);
            } else if (method3.isAnnotationPresent(JSGetter.class)) {
                annotation = ((Method)method3).getAnnotation(JSGetter.class);
            } else if (method3.isAnnotationPresent(JSSetter.class)) continue;
            if (annotation == null) {
                if (name2.startsWith("jsFunction_")) {
                    prefix2 = "jsFunction_";
                } else if (name2.startsWith("jsStaticFunction_")) {
                    prefix2 = "jsStaticFunction_";
                } else if (name2.startsWith("jsGet_")) {
                    prefix2 = "jsGet_";
                } else if (annotation == null) continue;
            }
            if ((names2 = (isStatic = annotation instanceof JSStaticFunction || prefix2 == "jsStaticFunction_") ? staticNames : instanceNames).contains(propName = ScriptableObject.getPropertyName(name2, prefix2, annotation))) {
                throw Context.reportRuntimeError2("duplicate.defineClass.name", name2, propName);
            }
            names2.add(propName);
            name2 = propName;
            if (annotation instanceof JSGetter || prefix2 == "jsGet_") {
                if (!(proto instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", proto.getClass().toString(), name2);
                }
                Method setter = ScriptableObject.findSetterMethod((Method[])methods2, name2, "jsSet_");
                int attr = 6 | (setter != null ? 0 : 1);
                ((ScriptableObject)proto).defineProperty(name2, null, (Method)method3, setter, attr);
                continue;
            }
            if (isStatic && !Modifier.isStatic(((Method)method3).getModifiers())) {
                throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
            }
            FunctionObject f2 = new FunctionObject(name2, (Member)((Object)method3), proto);
            if (f2.isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName());
            }
            ScriptableObject.defineProperty(isStatic ? ctor : proto, name2, f2, 2);
            if (!sealed) continue;
            f2.sealObject();
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject();
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
            }
        }
        return ctor;
    }

    private static Member findAnnotatedMember(AccessibleObject[] members, Class<? extends Annotation> annotation) {
        for (AccessibleObject member : members) {
            if (!member.isAnnotationPresent(annotation)) continue;
            return (Member)((Object)member);
        }
        return null;
    }

    private static Method findSetterMethod(Method[] methods2, String name, String prefix2) {
        String newStyleName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method2 : methods2) {
            JSSetter annotation = method2.getAnnotation(JSSetter.class);
            if (annotation == null || !name.equals(annotation.value()) && (!"".equals(annotation.value()) || !newStyleName.equals(method2.getName()))) continue;
            return method2;
        }
        String oldStyleName = prefix2 + name;
        for (Method method3 : methods2) {
            if (!oldStyleName.equals(method3.getName())) continue;
            return method3;
        }
        return null;
    }

    private static String getPropertyName(String methodName, String prefix2, Annotation annotation) {
        if (prefix2 != null) {
            return methodName.substring(prefix2.length());
        }
        String propName = null;
        if (annotation instanceof JSGetter) {
            propName = ((JSGetter)annotation).value();
            if ((propName == null || propName.length() == 0) && methodName.length() > 3 && methodName.startsWith("get") && Character.isUpperCase((propName = methodName.substring(3)).charAt(0))) {
                if (propName.length() == 1) {
                    propName = propName.toLowerCase();
                } else if (!Character.isUpperCase(propName.charAt(1))) {
                    propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                }
            }
        } else if (annotation instanceof JSFunction) {
            propName = ((JSFunction)annotation).value();
        } else if (annotation instanceof JSStaticFunction) {
            propName = ((JSStaticFunction)annotation).value();
        }
        if (propName == null || propName.length() == 0) {
            propName = methodName;
        }
        return propName;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> c2) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(c2)) {
            return c2;
        }
        return null;
    }

    public void defineProperty(String propertyName, Object value2, int attributes2) {
        this.checkNotSealed(propertyName, 0);
        this.put(propertyName, (Scriptable)this, value2);
        this.setAttributes(propertyName, attributes2);
    }

    public void defineProperty(Symbol key2, Object value2, int attributes2) {
        this.checkNotSealed(key2, 0);
        this.put(key2, (Scriptable)this, value2);
        this.setAttributes(key2, attributes2);
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value2, int attributes2) {
        if (!(destination instanceof ScriptableObject)) {
            destination.put(propertyName, destination, value2);
            return;
        }
        ScriptableObject so = (ScriptableObject)destination;
        so.defineProperty(propertyName, value2, attributes2);
    }

    public static void defineConstProperty(Scriptable destination, String propertyName) {
        if (destination instanceof ConstProperties) {
            ConstProperties cp = (ConstProperties)((Object)destination);
            cp.defineConst(propertyName, destination);
        } else {
            ScriptableObject.defineProperty(destination, propertyName, Undefined.instance, 13);
        }
    }

    public void defineProperty(String propertyName, Class<?> clazz, int attributes2) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods2 = FunctionObject.getMethodList(clazz);
        Method getter = FunctionObject.findSingleMethod(methods2, getterName);
        Method setter = FunctionObject.findSingleMethod(methods2, setterName);
        if (setter == null) {
            attributes2 |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter == null ? null : setter, attributes2);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes2) {
        MemberBox getterBox = null;
        if (getter != null) {
            boolean delegatedForm;
            getterBox = new MemberBox(getter);
            if (!Modifier.isStatic(getter.getModifiers())) {
                delegatedForm = delegateTo != null;
                getterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                getterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = getter.getParameterTypes();
            if (parmTypes.length == 0) {
                if (delegatedForm) {
                    errorId = "msg.obj.getter.parms";
                }
            } else if (parmTypes.length == 1) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.bad.getter.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.bad.getter.parms";
                }
            } else {
                errorId = "msg.bad.getter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeError1(errorId, getter.toString());
            }
        }
        MemberBox setterBox = null;
        if (setter != null) {
            boolean delegatedForm;
            if (setter.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeError1("msg.setter.return", setter.toString());
            }
            setterBox = new MemberBox(setter);
            if (!Modifier.isStatic(setter.getModifiers())) {
                delegatedForm = delegateTo != null;
                setterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                setterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = setter.getParameterTypes();
            if (parmTypes.length == 1) {
                if (delegatedForm) {
                    errorId = "msg.setter2.expected";
                }
            } else if (parmTypes.length == 2) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.setter2.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.setter1.parms";
                }
            } else {
                errorId = "msg.setter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeError1(errorId, setter.toString());
            }
        }
        GetterSlot gslot = (GetterSlot)this.getSlot(propertyName, 0, 4);
        gslot.setAttributes(attributes2);
        gslot.getter = getterBox;
        gslot.setter = setterBox;
    }

    public void defineOwnProperties(Context cx, ScriptableObject props) {
        int i2;
        Object[] ids = props.getIds(false, true);
        ScriptableObject[] descs = new ScriptableObject[ids.length];
        int len2 = ids.length;
        for (i2 = 0; i2 < len2; ++i2) {
            Object descObj = ScriptRuntime.getObjectElem(props, ids[i2], cx);
            ScriptableObject desc = ScriptableObject.ensureScriptableObject(descObj);
            this.checkPropertyDefinition(desc);
            descs[i2] = desc;
        }
        len2 = ids.length;
        for (i2 = 0; i2 < len2; ++i2) {
            this.defineOwnProperty(cx, ids[i2], descs[i2]);
        }
    }

    public void defineOwnProperty(Context cx, Object id, ScriptableObject desc) {
        this.checkPropertyDefinition(desc);
        this.defineOwnProperty(cx, id, desc, true);
    }

    protected void defineOwnProperty(Context cx, Object id, ScriptableObject desc, boolean checkValid) {
        int attributes2;
        boolean isNew;
        Slot slot = this.getSlot(cx, id, 1);
        boolean bl = isNew = slot == null;
        if (checkValid) {
            ScriptableObject current = slot == null ? null : slot.getPropertyDescriptor(cx, this);
            this.checkPropertyChange(id, current, desc);
        }
        boolean isAccessor = this.isAccessorDescriptor(desc);
        if (slot == null) {
            slot = this.getSlot(cx, id, isAccessor ? 4 : 2);
            attributes2 = this.applyDescriptorToAttributeBitset(7, desc);
        } else {
            attributes2 = this.applyDescriptorToAttributeBitset(slot.getAttributes(), desc);
        }
        slot = ScriptableObject.unwrapSlot(slot);
        if (isAccessor) {
            Object setter;
            if (!(slot instanceof GetterSlot)) {
                slot = this.getSlot(cx, id, 4);
            }
            GetterSlot gslot = (GetterSlot)slot;
            Object getter = ScriptableObject.getProperty((Scriptable)desc, "get");
            if (getter != NOT_FOUND) {
                gslot.getter = getter;
            }
            if ((setter = ScriptableObject.getProperty((Scriptable)desc, "set")) != NOT_FOUND) {
                gslot.setter = setter;
            }
            gslot.value = Undefined.instance;
            gslot.setAttributes(attributes2);
        } else {
            Object value2;
            if (slot instanceof GetterSlot && this.isDataDescriptor(desc)) {
                slot = this.getSlot(cx, id, 5);
            }
            if ((value2 = ScriptableObject.getProperty((Scriptable)desc, "value")) != NOT_FOUND) {
                slot.value = value2;
            } else if (isNew) {
                slot.value = Undefined.instance;
            }
            slot.setAttributes(attributes2);
        }
    }

    protected void checkPropertyDefinition(ScriptableObject desc) {
        Object getter = ScriptableObject.getProperty((Scriptable)desc, "get");
        if (getter != NOT_FOUND && getter != Undefined.instance && !(getter instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(getter);
        }
        Object setter = ScriptableObject.getProperty((Scriptable)desc, "set");
        if (setter != NOT_FOUND && setter != Undefined.instance && !(setter instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(setter);
        }
        if (this.isDataDescriptor(desc) && this.isAccessorDescriptor(desc)) {
            throw ScriptRuntime.typeError0("msg.both.data.and.accessor.desc");
        }
    }

    protected void checkPropertyChange(Object id, ScriptableObject current, ScriptableObject desc) {
        if (current == null) {
            if (!this.isExtensible()) {
                throw ScriptRuntime.typeError0("msg.not.extensible");
            }
        } else if (ScriptableObject.isFalse(current.get("configurable", (Scriptable)current))) {
            if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "configurable"))) {
                throw ScriptRuntime.typeError1("msg.change.configurable.false.to.true", id);
            }
            if (ScriptableObject.isTrue(current.get("enumerable", (Scriptable)current)) != ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "enumerable"))) {
                throw ScriptRuntime.typeError1("msg.change.enumerable.with.configurable.false", id);
            }
            boolean isData = this.isDataDescriptor(desc);
            boolean isAccessor = this.isAccessorDescriptor(desc);
            if (isData || isAccessor) {
                if (isData && this.isDataDescriptor(current)) {
                    if (ScriptableObject.isFalse(current.get("writable", (Scriptable)current))) {
                        if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "writable"))) {
                            throw ScriptRuntime.typeError1("msg.change.writable.false.to.true.with.configurable.false", id);
                        }
                        if (!this.sameValue(ScriptableObject.getProperty((Scriptable)desc, "value"), current.get("value", (Scriptable)current))) {
                            throw ScriptRuntime.typeError1("msg.change.value.with.writable.false", id);
                        }
                    }
                } else if (isAccessor && this.isAccessorDescriptor(current)) {
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)desc, "set"), current.get("set", (Scriptable)current))) {
                        throw ScriptRuntime.typeError1("msg.change.setter.with.configurable.false", id);
                    }
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)desc, "get"), current.get("get", (Scriptable)current))) {
                        throw ScriptRuntime.typeError1("msg.change.getter.with.configurable.false", id);
                    }
                } else {
                    if (this.isDataDescriptor(current)) {
                        throw ScriptRuntime.typeError1("msg.change.property.data.to.accessor.with.configurable.false", id);
                    }
                    throw ScriptRuntime.typeError1("msg.change.property.accessor.to.data.with.configurable.false", id);
                }
            }
        }
    }

    protected static boolean isTrue(Object value2) {
        return value2 != NOT_FOUND && ScriptRuntime.toBoolean(value2);
    }

    protected static boolean isFalse(Object value2) {
        return !ScriptableObject.isTrue(value2);
    }

    protected boolean sameValue(Object newValue, Object currentValue) {
        if (newValue == NOT_FOUND) {
            return true;
        }
        if (currentValue == NOT_FOUND) {
            currentValue = Undefined.instance;
        }
        if (currentValue instanceof Number && newValue instanceof Number) {
            double d1 = ((Number)currentValue).doubleValue();
            double d2 = ((Number)newValue).doubleValue();
            if (Double.isNaN(d1) && Double.isNaN(d2)) {
                return true;
            }
            if (d1 == 0.0 && Double.doubleToLongBits(d1) != Double.doubleToLongBits(d2)) {
                return false;
            }
        }
        return ScriptRuntime.shallowEq(currentValue, newValue);
    }

    protected int applyDescriptorToAttributeBitset(int attributes2, ScriptableObject desc) {
        Object configurable;
        Object writable;
        Object enumerable = ScriptableObject.getProperty((Scriptable)desc, "enumerable");
        if (enumerable != NOT_FOUND) {
            int n = attributes2 = ScriptRuntime.toBoolean(enumerable) ? attributes2 & 0xFFFFFFFD : attributes2 | 2;
        }
        if ((writable = ScriptableObject.getProperty((Scriptable)desc, "writable")) != NOT_FOUND) {
            int n = attributes2 = ScriptRuntime.toBoolean(writable) ? attributes2 & 0xFFFFFFFE : attributes2 | 1;
        }
        if ((configurable = ScriptableObject.getProperty((Scriptable)desc, "configurable")) != NOT_FOUND) {
            attributes2 = ScriptRuntime.toBoolean(configurable) ? attributes2 & 0xFFFFFFFB : attributes2 | 4;
        }
        return attributes2;
    }

    protected boolean isDataDescriptor(ScriptableObject desc) {
        return ScriptableObject.hasProperty((Scriptable)desc, "value") || ScriptableObject.hasProperty((Scriptable)desc, "writable");
    }

    protected boolean isAccessorDescriptor(ScriptableObject desc) {
        return ScriptableObject.hasProperty((Scriptable)desc, "get") || ScriptableObject.hasProperty((Scriptable)desc, "set");
    }

    protected boolean isGenericDescriptor(ScriptableObject desc) {
        return !this.isDataDescriptor(desc) && !this.isAccessorDescriptor(desc);
    }

    protected static Scriptable ensureScriptable(Object arg) {
        if (!(arg instanceof Scriptable)) {
            throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(arg));
        }
        return (Scriptable)arg;
    }

    protected static SymbolScriptable ensureSymbolScriptable(Object arg) {
        if (!(arg instanceof SymbolScriptable)) {
            throw ScriptRuntime.typeError1("msg.object.not.symbolscriptable", ScriptRuntime.typeof(arg));
        }
        return (SymbolScriptable)arg;
    }

    protected static ScriptableObject ensureScriptableObject(Object arg) {
        if (!(arg instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(arg));
        }
        return (ScriptableObject)arg;
    }

    public void defineFunctionProperties(String[] names2, Class<?> clazz, int attributes2) {
        Method[] methods2 = FunctionObject.getMethodList(clazz);
        for (int i2 = 0; i2 < names2.length; ++i2) {
            String name = names2[i2];
            Method m4 = FunctionObject.findSingleMethod(methods2, name);
            if (m4 == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", name, clazz.getName());
            }
            FunctionObject f2 = new FunctionObject(name, m4, this);
            this.defineProperty(name, (Object)f2, attributes2);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Object);
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Function);
    }

    public static Scriptable getArrayPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Array);
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object proto;
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor instanceof BaseFunction) {
            proto = ((BaseFunction)ctor).getPrototypeProperty();
        } else if (ctor instanceof Scriptable) {
            Scriptable ctorObj = (Scriptable)ctor;
            proto = ctorObj.get("prototype", ctorObj);
        } else {
            return null;
        }
        if (proto instanceof Scriptable) {
            return (Scriptable)proto;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable parent;
        while ((parent = obj.getParentScope()) != null) {
            obj = parent;
        }
        return obj;
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public void preventExtensions() {
        this.isExtensible = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sealObject() {
        if (this.count >= 0) {
            Slot slot = this.firstAdded;
            while (slot != null) {
                Object value2 = slot.value;
                if (value2 instanceof LazilyLoadedCtor) {
                    LazilyLoadedCtor initializer2 = (LazilyLoadedCtor)value2;
                    try {
                        initializer2.init();
                    }
                    finally {
                        slot.value = initializer2.getValue();
                    }
                }
                slot = slot.orderedNext;
            }
            this.count ^= 0xFFFFFFFF;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    private void checkNotSealed(Object key2, int index) {
        if (!this.isSealed()) {
            return;
        }
        String str = key2 != null ? key2.toString() : Integer.toString(index);
        throw Context.reportRuntimeError1("msg.modify.sealed", str);
    }

    public static Object getProperty(Scriptable obj, String name) {
        Object result2;
        Scriptable start2 = obj;
        while ((result2 = obj.get(name, start2)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result2;
    }

    public static Object getProperty(Scriptable obj, Symbol key2) {
        Object result2;
        Scriptable start2 = obj;
        while ((result2 = ScriptableObject.ensureSymbolScriptable(obj).get(key2, start2)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result2;
    }

    public static <T> T getTypedProperty(Scriptable s2, int index, Class<T> type2) {
        Object val = ScriptableObject.getProperty(s2, index);
        if (val == Scriptable.NOT_FOUND) {
            val = null;
        }
        return type2.cast(Context.jsToJava(val, type2));
    }

    public static Object getProperty(Scriptable obj, int index) {
        Object result2;
        Scriptable start2 = obj;
        while ((result2 = obj.get(index, start2)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result2;
    }

    public static <T> T getTypedProperty(Scriptable s2, String name, Class<T> type2) {
        Object val = ScriptableObject.getProperty(s2, name);
        if (val == Scriptable.NOT_FOUND) {
            val = null;
        }
        return type2.cast(Context.jsToJava(val, type2));
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        return null != ScriptableObject.getBase(obj, name);
    }

    public static void redefineProperty(Scriptable obj, String name, boolean isConst) {
        ConstProperties cp;
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return;
        }
        if (base instanceof ConstProperties && (cp = (ConstProperties)((Object)base)).isConst(name)) {
            throw ScriptRuntime.typeError1("msg.const.redecl", name);
        }
        if (isConst) {
            throw ScriptRuntime.typeError1("msg.var.redecl", name);
        }
    }

    public static boolean hasProperty(Scriptable obj, int index) {
        return null != ScriptableObject.getBase(obj, index);
    }

    public static boolean hasProperty(Scriptable obj, Symbol key2) {
        return null != ScriptableObject.getBase(obj, key2);
    }

    public static void putProperty(Scriptable obj, String name, Object value2) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value2);
    }

    public static void putProperty(Scriptable obj, Symbol key2, Object value2) {
        Scriptable base = ScriptableObject.getBase(obj, key2);
        if (base == null) {
            base = obj;
        }
        ScriptableObject.ensureSymbolScriptable(base).put(key2, obj, value2);
    }

    public static void putConstProperty(Scriptable obj, String name, Object value2) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        if (base instanceof ConstProperties) {
            ((ConstProperties)((Object)base)).putConst(name, obj, value2);
        }
    }

    public static void putProperty(Scriptable obj, int index, Object value2) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(index, obj, value2);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return !base.has(name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            return true;
        }
        base.delete(index);
        return !base.has(index, obj);
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        if (obj == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result2 = obj.getIds();
        ObjToIntMap map2 = null;
        while ((obj = obj.getPrototype()) != null) {
            int i2;
            Object[] ids = obj.getIds();
            if (ids.length == 0) continue;
            if (map2 == null) {
                if (result2.length == 0) {
                    result2 = ids;
                    continue;
                }
                map2 = new ObjToIntMap(result2.length + ids.length);
                for (i2 = 0; i2 != result2.length; ++i2) {
                    map2.intern(result2[i2]);
                }
                result2 = null;
            }
            for (i2 = 0; i2 != ids.length; ++i2) {
                map2.intern(ids[i2]);
            }
        }
        if (map2 != null) {
            result2 = map2.getKeys();
        }
        return result2;
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args2) {
        return ScriptableObject.callMethod(null, obj, methodName, args2);
    }

    public static Object callMethod(Context cx, Scriptable obj, String methodName, Object[] args2) {
        Object funObj = ScriptableObject.getProperty(obj, methodName);
        if (!(funObj instanceof Function)) {
            throw ScriptRuntime.notFunctionError(obj, methodName);
        }
        Function fun = (Function)funObj;
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        if (cx != null) {
            return fun.call(cx, scope, obj, args2);
        }
        return Context.call(null, fun, scope, obj, args2);
    }

    private static Scriptable getBase(Scriptable obj, String name) {
        while (!obj.has(name, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Scriptable obj, int index) {
        while (!obj.has(index, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Scriptable obj, Symbol key2) {
        while (!ScriptableObject.ensureSymbolScriptable(obj).has(key2, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    public final Object getAssociatedValue(Object key2) {
        Map<Object, Object> h2 = this.associatedValues;
        if (h2 == null) {
            return null;
        }
        return h2.get(key2);
    }

    public static Object getTopScopeValue(Scriptable scope, Object key2) {
        scope = ScriptableObject.getTopLevelScope(scope);
        do {
            ScriptableObject so;
            Object value2;
            if (!(scope instanceof ScriptableObject) || (value2 = (so = (ScriptableObject)scope).getAssociatedValue(key2)) == null) continue;
            return value2;
        } while ((scope = scope.getPrototype()) != null);
        return null;
    }

    public final synchronized Object associateValue(Object key2, Object value2) {
        if (value2 == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> h2 = this.associatedValues;
        if (h2 == null) {
            this.associatedValues = h2 = new HashMap<Object, Object>();
        }
        return Kit.initHash(h2, key2, value2);
    }

    private boolean putImpl(Object key2, int index, Scriptable start2, Object value2) {
        Slot slot;
        Context cx;
        if (!this.isExtensible && (cx = Context.getContext()).isStrictMode()) {
            throw ScriptRuntime.typeError0("msg.not.extensible");
        }
        if (this != start2) {
            slot = this.getSlot(key2, index, 1);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible) {
            slot = this.getSlot(key2, index, 1);
            if (slot == null) {
                return true;
            }
        } else {
            if (this.count < 0) {
                this.checkNotSealed(key2, index);
            }
            slot = this.getSlot(key2, index, 2);
        }
        return slot.setValue(value2, this, start2);
    }

    private boolean putConstImpl(String name, int index, Scriptable start2, Object value2, int constFlag) {
        Slot slot;
        Context cx;
        assert (constFlag != 0);
        if (!this.isExtensible && (cx = Context.getContext()).isStrictMode()) {
            throw ScriptRuntime.typeError0("msg.not.extensible");
        }
        if (this != start2) {
            slot = this.getSlot(name, index, 1);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible()) {
            slot = this.getSlot(name, index, 1);
            if (slot == null) {
                return true;
            }
        } else {
            this.checkNotSealed(name, index);
            slot = ScriptableObject.unwrapSlot(this.getSlot(name, index, 3));
            int attr = slot.getAttributes();
            if ((attr & 1) == 0) {
                throw Context.reportRuntimeError1("msg.var.redecl", name);
            }
            if ((attr & 8) != 0) {
                slot.value = value2;
                if (constFlag != 8) {
                    slot.setAttributes(attr & 0xFFFFFFF7);
                }
            }
            return true;
        }
        return slot.setValue(value2, this, start2);
    }

    private Slot findAttributeSlot(String name, int index, int accessType) {
        Slot slot = this.getSlot(name, index, accessType);
        if (slot == null) {
            String str = name != null ? name : Integer.toString(index);
            throw Context.reportRuntimeError1("msg.prop.not.found", str);
        }
        return slot;
    }

    private Slot findAttributeSlot(Symbol key2, int accessType) {
        Slot slot = this.getSlot(key2, 0, accessType);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", key2);
        }
        return slot;
    }

    private static Slot unwrapSlot(Slot slot) {
        return slot instanceof RelinkedSlot ? ((RelinkedSlot)slot).slot : slot;
    }

    private Slot getSlot(Object key2, int index, int accessType) {
        int indexOrHash;
        Slot[] slotsLocalRef = this.slots;
        if (slotsLocalRef == null && accessType == 1) {
            return null;
        }
        int n = indexOrHash = key2 != null ? key2.hashCode() : index;
        if (slotsLocalRef != null) {
            int slotIndex = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
            Slot slot = slotsLocalRef[slotIndex];
            while (slot != null) {
                Object skey = slot.name;
                if (indexOrHash == slot.indexOrHash && (skey == key2 || key2 != null && key2.equals(skey))) break;
                slot = slot.next;
            }
            switch (accessType) {
                case 1: {
                    return slot;
                }
                case 2: 
                case 3: {
                    if (slot == null) break;
                    return slot;
                }
                case 4: {
                    slot = ScriptableObject.unwrapSlot(slot);
                    if (!(slot instanceof GetterSlot)) break;
                    return slot;
                }
                case 5: {
                    slot = ScriptableObject.unwrapSlot(slot);
                    if (slot instanceof GetterSlot) break;
                    return slot;
                }
            }
        }
        return this.createSlot(key2, indexOrHash, accessType);
    }

    private synchronized Slot createSlot(Object key2, int indexOrHash, int accessType) {
        Slot newSlot;
        int insertPos;
        Slot[] slotsLocalRef = this.slots;
        if (this.count == 0) {
            slotsLocalRef = new Slot[4];
            this.slots = slotsLocalRef;
            insertPos = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
        } else {
            Slot prev;
            int tableSize = slotsLocalRef.length;
            insertPos = ScriptableObject.getSlotIndex(tableSize, indexOrHash);
            Slot slot = prev = slotsLocalRef[insertPos];
            while (!(slot == null || slot.indexOrHash == indexOrHash && (slot.name == key2 || key2 != null && key2.equals(slot.name)))) {
                prev = slot;
                slot = slot.next;
            }
            if (slot != null) {
                Slot newSlot2;
                Slot inner = ScriptableObject.unwrapSlot(slot);
                if (accessType == 4 && !(inner instanceof GetterSlot)) {
                    newSlot2 = new GetterSlot(key2, indexOrHash, inner.getAttributes());
                } else if (accessType == 5 && inner instanceof GetterSlot) {
                    newSlot2 = new Slot(key2, indexOrHash, inner.getAttributes());
                } else {
                    if (accessType == 3) {
                        return null;
                    }
                    return inner;
                }
                newSlot2.value = inner.value;
                newSlot2.next = slot.next;
                if (this.lastAdded != null) {
                    this.lastAdded.orderedNext = newSlot2;
                }
                if (this.firstAdded == null) {
                    this.firstAdded = newSlot2;
                }
                this.lastAdded = newSlot2;
                if (prev == slot) {
                    slotsLocalRef[insertPos] = newSlot2;
                } else {
                    prev.next = newSlot2;
                }
                slot.markDeleted();
                return newSlot2;
            }
            if (4 * (this.count + 1) > 3 * slotsLocalRef.length) {
                slotsLocalRef = new Slot[slotsLocalRef.length * 2];
                ScriptableObject.copyTable(this.slots, slotsLocalRef, this.count);
                this.slots = slotsLocalRef;
                insertPos = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
            }
        }
        Slot slot = newSlot = accessType == 4 ? new GetterSlot(key2, indexOrHash, 0) : new Slot(key2, indexOrHash, 0);
        if (accessType == 3) {
            newSlot.setAttributes(13);
        }
        ++this.count;
        if (this.lastAdded != null) {
            this.lastAdded.orderedNext = newSlot;
        }
        if (this.firstAdded == null) {
            this.firstAdded = newSlot;
        }
        this.lastAdded = newSlot;
        ScriptableObject.addKnownAbsentSlot(slotsLocalRef, newSlot, insertPos);
        return newSlot;
    }

    private synchronized void removeSlot(Object key2, int index) {
        int indexOrHash = key2 != null ? key2.hashCode() : index;
        Slot[] slotsLocalRef = this.slots;
        if (this.count != 0) {
            Slot prev;
            int tableSize = slotsLocalRef.length;
            int slotIndex = ScriptableObject.getSlotIndex(tableSize, indexOrHash);
            Slot slot = prev = slotsLocalRef[slotIndex];
            while (!(slot == null || slot.indexOrHash == indexOrHash && (slot.name == key2 || key2 != null && key2.equals(slot.name)))) {
                prev = slot;
                slot = slot.next;
            }
            if (slot != null) {
                if ((slot.getAttributes() & 4) != 0) {
                    Context cx = Context.getContext();
                    if (cx.isStrictMode()) {
                        throw ScriptRuntime.typeError1("msg.delete.property.with.configurable.false", key2);
                    }
                    return;
                }
                --this.count;
                if (prev == slot) {
                    slotsLocalRef[slotIndex] = slot.next;
                } else {
                    prev.next = slot.next;
                }
                Slot deleted = ScriptableObject.unwrapSlot(slot);
                if (deleted == this.firstAdded) {
                    prev = null;
                    this.firstAdded = deleted.orderedNext;
                } else {
                    prev = this.firstAdded;
                    while (prev.orderedNext != deleted) {
                        prev = prev.orderedNext;
                    }
                    prev.orderedNext = deleted.orderedNext;
                }
                if (deleted == this.lastAdded) {
                    this.lastAdded = prev;
                }
                slot.markDeleted();
            }
        }
    }

    private static int getSlotIndex(int tableSize, int indexOrHash) {
        return indexOrHash & tableSize - 1;
    }

    private static void copyTable(Slot[] oldSlots, Slot[] newSlots, int count2) {
        if (count2 == 0) {
            throw Kit.codeBug();
        }
        int tableSize = newSlots.length;
        int i2 = oldSlots.length;
        block0: while (true) {
            Slot slot = oldSlots[--i2];
            do {
                if (slot == null) continue block0;
                int insertPos = ScriptableObject.getSlotIndex(tableSize, slot.indexOrHash);
                Slot insSlot = slot.next == null ? slot : new RelinkedSlot(slot);
                ScriptableObject.addKnownAbsentSlot(newSlots, insSlot, insertPos);
                slot = slot.next;
            } while (--count2 != 0);
            break;
        }
    }

    private static void addKnownAbsentSlot(Slot[] slots, Slot slot, int insertPos) {
        if (slots[insertPos] == null) {
            slots[insertPos] = slot;
        } else {
            Slot prev = slots[insertPos];
            Slot next2 = prev.next;
            while (next2 != null) {
                prev = next2;
                next2 = prev.next;
            }
            prev.next = slot;
        }
    }

    Object[] getIds(boolean getNonEnumerable, boolean getSymbols) {
        Object[] a2;
        int externalLen;
        Slot[] s2 = this.slots;
        int n = externalLen = this.externalData == null ? 0 : this.externalData.getArrayLength();
        if (externalLen == 0) {
            a2 = ScriptRuntime.emptyArgs;
        } else {
            a2 = new Object[externalLen];
            for (int i2 = 0; i2 < externalLen; ++i2) {
                a2[i2] = i2;
            }
        }
        if (s2 == null) {
            return a2;
        }
        int c2 = externalLen;
        Slot slot = this.firstAdded;
        while (slot != null && slot.wasDeleted) {
            slot = slot.orderedNext;
        }
        while (slot != null) {
            if (!(!getNonEnumerable && (slot.getAttributes() & 2) != 0 || !getSymbols && slot.name instanceof Symbol)) {
                if (c2 == externalLen) {
                    Object[] oldA = a2;
                    a2 = new Object[s2.length + externalLen];
                    if (oldA != null) {
                        System.arraycopy(oldA, 0, a2, 0, externalLen);
                    }
                }
                a2[c2++] = slot.name != null ? slot.name : Integer.valueOf(slot.indexOrHash);
            }
            slot = slot.orderedNext;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
        }
        if (c2 == a2.length + externalLen) {
            return a2;
        }
        Object[] result2 = new Object[c2];
        System.arraycopy(a2, 0, result2, 0, c2);
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(16)) {
            Arrays.sort(result2, KEY_COMPARATOR);
        }
        return result2;
    }

    private synchronized void writeObject(ObjectOutputStream out2) throws IOException {
        out2.defaultWriteObject();
        int objectsCount = this.count;
        if (objectsCount < 0) {
            objectsCount ^= 0xFFFFFFFF;
        }
        if (objectsCount == 0) {
            out2.writeInt(0);
        } else {
            out2.writeInt(this.slots.length);
            Slot slot = this.firstAdded;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
            this.firstAdded = slot;
            while (slot != null) {
                out2.writeObject(slot);
                Slot next2 = slot.orderedNext;
                while (next2 != null && next2.wasDeleted) {
                    next2 = next2.orderedNext;
                }
                slot.orderedNext = next2;
                slot = next2;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int tableSize = in.readInt();
        if (tableSize != 0) {
            if ((tableSize & tableSize - 1) != 0) {
                int newSize;
                if (tableSize > 0x40000000) {
                    throw new RuntimeException("Property table overflow");
                }
                for (newSize = 4; newSize < tableSize; newSize <<= 1) {
                }
                tableSize = newSize;
            }
            this.slots = new Slot[tableSize];
            int objectsCount = this.count;
            if (objectsCount < 0) {
                objectsCount ^= 0xFFFFFFFF;
            }
            Slot prev = null;
            for (int i2 = 0; i2 != objectsCount; ++i2) {
                this.lastAdded = (Slot)in.readObject();
                if (i2 == 0) {
                    this.firstAdded = this.lastAdded;
                } else {
                    prev.orderedNext = this.lastAdded;
                }
                int slotIndex = ScriptableObject.getSlotIndex(tableSize, this.lastAdded.indexOrHash);
                ScriptableObject.addKnownAbsentSlot(this.slots, this.lastAdded, slotIndex);
                prev = this.lastAdded;
            }
        }
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        Slot slot = this.getSlot(cx, id, 1);
        if (slot == null) {
            return null;
        }
        Scriptable scope = this.getParentScope();
        return slot.getPropertyDescriptor(cx, scope == null ? this : scope);
    }

    protected Slot getSlot(Context cx, Object id, int accessType) {
        if (id instanceof Symbol) {
            return this.getSlot(id, 0, accessType);
        }
        String name = ScriptRuntime.toStringIdOrIndex(cx, id);
        if (name == null) {
            return this.getSlot((Object)null, ScriptRuntime.lastIndexResult(cx), accessType);
        }
        return this.getSlot(name, 0, accessType);
    }

    public int size() {
        return this.count < 0 ? ~this.count : this.count;
    }

    public boolean isEmpty() {
        return this.count == 0 || this.count == -1;
    }

    public Object get(Object key2) {
        Object value2 = null;
        if (key2 instanceof String) {
            value2 = this.get((String)key2, (Scriptable)this);
        } else if (key2 instanceof Symbol) {
            value2 = this.get((Symbol)key2, (Scriptable)this);
        } else if (key2 instanceof Number) {
            value2 = this.get(((Number)key2).intValue(), (Scriptable)this);
        }
        if (value2 == Scriptable.NOT_FOUND || value2 == Undefined.instance) {
            return null;
        }
        if (value2 instanceof Wrapper) {
            return ((Wrapper)value2).unwrap();
        }
        return value2;
    }

    static {
        try {
            GET_ARRAY_LENGTH = ScriptableObject.class.getMethod("getExternalArrayLength", new Class[0]);
        }
        catch (NoSuchMethodException nsm) {
            throw new RuntimeException(nsm);
        }
        KEY_COMPARATOR = new KeyComparator();
    }

    public static final class KeyComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                if (o2 instanceof Integer) {
                    int i2;
                    int i1 = (Integer)o1;
                    if (i1 < (i2 = ((Integer)o2).intValue())) {
                        return -1;
                    }
                    if (i1 > i2) {
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            if (o2 instanceof Integer) {
                return 1;
            }
            return 0;
        }
    }

    private static class RelinkedSlot
    extends Slot {
        final Slot slot;

        RelinkedSlot(Slot slot) {
            super(slot.name, slot.indexOrHash, slot.attributes);
            this.slot = ScriptableObject.unwrapSlot(slot);
        }

        @Override
        boolean setValue(Object value2, Scriptable owner, Scriptable start2) {
            return this.slot.setValue(value2, owner, start2);
        }

        @Override
        Object getValue(Scriptable start2) {
            return this.slot.getValue(start2);
        }

        @Override
        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            return this.slot.getPropertyDescriptor(cx, scope);
        }

        @Override
        int getAttributes() {
            return this.slot.getAttributes();
        }

        @Override
        void setAttributes(int value2) {
            this.slot.setAttributes(value2);
        }

        @Override
        void markDeleted() {
            super.markDeleted();
            this.slot.markDeleted();
        }

        private void writeObject(ObjectOutputStream out2) throws IOException {
            out2.writeObject(this.slot);
        }
    }

    private static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object getter;
        Object setter;

        GetterSlot(Object name, int indexOrHash, int attributes2) {
            super(name, indexOrHash, attributes2);
        }

        @Override
        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            int attr = this.getAttributes();
            NativeObject desc = new NativeObject();
            ScriptRuntime.setBuiltinProtoAndParent(desc, scope, TopLevel.Builtins.Object);
            desc.defineProperty("enumerable", (Object)((attr & 2) == 0 ? 1 : 0), 0);
            desc.defineProperty("configurable", (Object)((attr & 4) == 0 ? 1 : 0), 0);
            if (this.getter == null && this.setter == null) {
                desc.defineProperty("writable", (Object)((attr & 1) == 0 ? 1 : 0), 0);
            }
            if (this.getter != null) {
                desc.defineProperty("get", this.getter, 0);
            }
            if (this.setter != null) {
                desc.defineProperty("set", this.setter, 0);
            }
            return desc;
        }

        @Override
        boolean setValue(Object value2, Scriptable owner, Scriptable start2) {
            if (this.setter == null) {
                if (this.getter != null) {
                    Context cx = Context.getContext();
                    if (cx.isStrictMode() || cx.hasFeature(11)) {
                        throw ScriptRuntime.typeError1("msg.set.prop.no.setter", this.name);
                    }
                    return true;
                }
            } else {
                Context cx = Context.getContext();
                if (this.setter instanceof MemberBox) {
                    Object[] args2;
                    Object setterThis;
                    MemberBox nativeSetter = (MemberBox)this.setter;
                    Class<?>[] pTypes = nativeSetter.argTypes;
                    Class<?> valueType = pTypes[pTypes.length - 1];
                    int tag = FunctionObject.getTypeTag(valueType);
                    Object actualArg = FunctionObject.convertArg(cx, start2, value2, tag);
                    if (nativeSetter.delegateTo == null) {
                        setterThis = start2;
                        args2 = new Object[]{actualArg};
                    } else {
                        setterThis = nativeSetter.delegateTo;
                        args2 = new Object[]{start2, actualArg};
                    }
                    nativeSetter.invoke(setterThis, args2);
                } else if (this.setter instanceof Function) {
                    Function f2 = (Function)this.setter;
                    f2.call(cx, f2.getParentScope(), start2, new Object[]{value2});
                }
                return true;
            }
            return super.setValue(value2, owner, start2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object getValue(Scriptable start2) {
            Object val;
            if (this.getter != null) {
                if (this.getter instanceof MemberBox) {
                    Object[] args2;
                    Object getterThis;
                    MemberBox nativeGetter = (MemberBox)this.getter;
                    if (nativeGetter.delegateTo == null) {
                        getterThis = start2;
                        args2 = ScriptRuntime.emptyArgs;
                    } else {
                        getterThis = nativeGetter.delegateTo;
                        args2 = new Object[]{start2};
                    }
                    return nativeGetter.invoke(getterThis, args2);
                }
                if (this.getter instanceof Function) {
                    Function f2 = (Function)this.getter;
                    Context cx = Context.getContext();
                    return f2.call(cx, f2.getParentScope(), start2, ScriptRuntime.emptyArgs);
                }
            }
            if ((val = this.value) instanceof LazilyLoadedCtor) {
                LazilyLoadedCtor initializer2 = (LazilyLoadedCtor)val;
                try {
                    initializer2.init();
                }
                finally {
                    this.value = val = initializer2.getValue();
                }
            }
            return val;
        }

        @Override
        void markDeleted() {
            super.markDeleted();
            this.getter = null;
            this.setter = null;
        }
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = -6090581677123995491L;
        Object name;
        int indexOrHash;
        private volatile short attributes;
        volatile transient boolean wasDeleted;
        volatile Object value;
        transient Slot next;
        volatile transient Slot orderedNext;

        Slot(Object name, int indexOrHash, int attributes2) {
            this.name = name;
            this.indexOrHash = indexOrHash;
            this.attributes = (short)attributes2;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.name != null) {
                this.indexOrHash = this.name.hashCode();
            }
        }

        boolean setValue(Object value2, Scriptable owner, Scriptable start2) {
            if ((this.attributes & 1) != 0) {
                Context cx = Context.getContext();
                if (cx.isStrictMode()) {
                    throw ScriptRuntime.typeError1("msg.modify.readonly", this.name);
                }
                return true;
            }
            if (owner == start2) {
                this.value = value2;
                return true;
            }
            return false;
        }

        Object getValue(Scriptable start2) {
            return this.value;
        }

        int getAttributes() {
            return this.attributes;
        }

        synchronized void setAttributes(int value2) {
            ScriptableObject.checkValidAttributes(value2);
            this.attributes = (short)value2;
        }

        void markDeleted() {
            this.wasDeleted = true;
            this.value = null;
            this.name = null;
        }

        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            return ScriptableObject.buildDataDescriptor(scope, this.value, this.attributes);
        }
    }
}

