/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import java.util.Comparator;

public final class Sorting {
    private static final int SMALLSORT = 16;

    public static void insertionSort(Object[] a2, Comparator<Object> cmp) {
        Sorting.insertionSort(a2, 0, a2.length - 1, cmp);
    }

    public static void insertionSort(Object[] a2, int start2, int end2, Comparator<Object> cmp) {
        for (int i2 = start2; i2 <= end2; ++i2) {
            Object x = a2[i2];
            for (int j2 = i2 - 1; j2 >= start2 && cmp.compare(a2[j2], x) > 0; --j2) {
                a2[j2 + 1] = a2[j2];
            }
            a2[j2 + 1] = x;
        }
    }

    public static void hybridSort(Object[] a2, Comparator<Object> cmp) {
        Sorting.hybridSort(a2, 0, a2.length - 1, cmp, Sorting.log2(a2.length) * 2);
    }

    private static void hybridSort(Object[] a2, int start2, int end2, Comparator<Object> cmp, int maxdepth) {
        if (start2 < end2) {
            if (maxdepth == 0 || end2 - start2 <= 16) {
                Sorting.insertionSort(a2, start2, end2, cmp);
            } else {
                int p = Sorting.partition(a2, start2, end2, cmp);
                Sorting.hybridSort(a2, start2, p, cmp, maxdepth - 1);
                Sorting.hybridSort(a2, p + 1, end2, cmp, maxdepth - 1);
            }
        }
    }

    private static int partition(Object[] a2, int start2, int end2, Comparator<Object> cmp) {
        Object pivot = a2[Sorting.median(start2, end2, start2 + (end2 - start2) / 2)];
        int i2 = start2 - 1;
        int j2 = end2 + 1;
        while (true) {
            if (cmp.compare(a2[++i2], pivot) < 0) {
                continue;
            }
            while (cmp.compare(a2[--j2], pivot) > 0) {
            }
            if (i2 >= j2) {
                return j2;
            }
            Sorting.swap(a2, i2, j2);
        }
    }

    private static void swap(Object[] a2, int l, int h2) {
        Object tmp = a2[l];
        a2[l] = a2[h2];
        a2[h2] = tmp;
    }

    private static int log2(int n) {
        return (int)(Math.log10(n) / Math.log10(2.0));
    }

    private static int median(int n1, int n2, int n3) {
        int[] a2 = new int[]{n1, n2, n3};
        Arrays.sort(a2);
        return a2[1];
    }
}

