/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.EnumMap;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TopLevel
extends IdScriptableObject {
    static final long serialVersionUID = -4648046356662472260L;
    private EnumMap<Builtins, BaseFunction> ctors;
    private EnumMap<NativeErrors, BaseFunction> errors;

    @Override
    public String getClassName() {
        return "global";
    }

    public void cacheBuiltins() {
        this.ctors = new EnumMap(Builtins.class);
        for (Builtins builtins : Builtins.values()) {
            Object value2 = ScriptableObject.getProperty((Scriptable)this, builtins.name());
            if (!(value2 instanceof BaseFunction)) continue;
            this.ctors.put(builtins, (BaseFunction)value2);
        }
        this.errors = new EnumMap(NativeErrors.class);
        for (Enum enum_ : NativeErrors.values()) {
            Object value2 = ScriptableObject.getProperty((Scriptable)this, enum_.name());
            if (!(value2 instanceof BaseFunction)) continue;
            this.errors.put((NativeErrors)enum_, (BaseFunction)value2);
        }
    }

    public static Function getBuiltinCtor(Context cx, Scriptable scope, Builtins type2) {
        BaseFunction result2;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result2 = ((TopLevel)scope).getBuiltinCtor(type2)) != null) {
            return result2;
        }
        return ScriptRuntime.getExistingCtor(cx, scope, type2.name());
    }

    static Function getNativeErrorCtor(Context cx, Scriptable scope, NativeErrors type2) {
        BaseFunction result2;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result2 = ((TopLevel)scope).getNativeErrorCtor(type2)) != null) {
            return result2;
        }
        return ScriptRuntime.getExistingCtor(cx, scope, type2.name());
    }

    public static Scriptable getBuiltinPrototype(Scriptable scope, Builtins type2) {
        Scriptable result2;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result2 = ((TopLevel)scope).getBuiltinPrototype(type2)) != null) {
            return result2;
        }
        return ScriptableObject.getClassPrototype(scope, type2.name());
    }

    public BaseFunction getBuiltinCtor(Builtins type2) {
        return this.ctors != null ? this.ctors.get((Object)type2) : null;
    }

    BaseFunction getNativeErrorCtor(NativeErrors type2) {
        return this.errors != null ? this.errors.get((Object)type2) : null;
    }

    public Scriptable getBuiltinPrototype(Builtins type2) {
        BaseFunction func = this.getBuiltinCtor(type2);
        Object proto = func != null ? func.getPrototypeProperty() : null;
        return proto instanceof Scriptable ? (Scriptable)proto : null;
    }

    static enum NativeErrors {
        Error,
        EvalError,
        RangeError,
        ReferenceError,
        SyntaxError,
        TypeError,
        URIError,
        InternalError,
        JavaException;

    }

    public static enum Builtins {
        Object,
        Array,
        Function,
        String,
        Number,
        Boolean,
        RegExp,
        Error,
        Symbol;

    }
}

