/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Kit;

public class UintMap
implements Serializable {
    static final long serialVersionUID = 4242698212885848444L;
    private static final int A = -1640531527;
    private static final int EMPTY = -1;
    private static final int DELETED = -2;
    private transient int[] keys;
    private transient Object[] values;
    private int power;
    private int keyCount;
    private transient int occupiedCount;
    private transient int ivaluesShift;
    private static final boolean check = false;

    public UintMap() {
        this(4);
    }

    public UintMap(int initialCapacity) {
        if (initialCapacity < 0) {
            Kit.codeBug();
        }
        int minimalCapacity = initialCapacity * 4 / 3;
        int i2 = 2;
        while (1 << i2 < minimalCapacity) {
            ++i2;
        }
        this.power = i2;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(int key2) {
        if (key2 < 0) {
            Kit.codeBug();
        }
        return 0 <= this.findIndex(key2);
    }

    public Object getObject(int key2) {
        int index;
        if (key2 < 0) {
            Kit.codeBug();
        }
        if (this.values != null && 0 <= (index = this.findIndex(key2))) {
            return this.values[index];
        }
        return null;
    }

    public int getInt(int key2, int defaultValue) {
        int index;
        if (key2 < 0) {
            Kit.codeBug();
        }
        if (0 <= (index = this.findIndex(key2))) {
            if (this.ivaluesShift != 0) {
                return this.keys[this.ivaluesShift + index];
            }
            return 0;
        }
        return defaultValue;
    }

    public int getExistingInt(int key2) {
        int index;
        if (key2 < 0) {
            Kit.codeBug();
        }
        if (0 <= (index = this.findIndex(key2))) {
            if (this.ivaluesShift != 0) {
                return this.keys[this.ivaluesShift + index];
            }
            return 0;
        }
        Kit.codeBug();
        return 0;
    }

    public void put(int key2, Object value2) {
        if (key2 < 0) {
            Kit.codeBug();
        }
        int index = this.ensureIndex(key2, false);
        if (this.values == null) {
            this.values = new Object[1 << this.power];
        }
        this.values[index] = value2;
    }

    public void put(int key2, int value2) {
        if (key2 < 0) {
            Kit.codeBug();
        }
        int index = this.ensureIndex(key2, true);
        if (this.ivaluesShift == 0) {
            int N2 = 1 << this.power;
            if (this.keys.length != N2 * 2) {
                int[] tmp = new int[N2 * 2];
                System.arraycopy(this.keys, 0, tmp, 0, N2);
                this.keys = tmp;
            }
            this.ivaluesShift = N2;
        }
        this.keys[this.ivaluesShift + index] = value2;
    }

    public void remove(int key2) {
        int index;
        if (key2 < 0) {
            Kit.codeBug();
        }
        if (0 <= (index = this.findIndex(key2))) {
            this.keys[index] = -2;
            --this.keyCount;
            if (this.values != null) {
                this.values[index] = null;
            }
            if (this.ivaluesShift != 0) {
                this.keys[this.ivaluesShift + index] = 0;
            }
        }
    }

    public void clear() {
        int N2 = 1 << this.power;
        if (this.keys != null) {
            int i2;
            for (i2 = 0; i2 != N2; ++i2) {
                this.keys[i2] = -1;
            }
            if (this.values != null) {
                for (i2 = 0; i2 != N2; ++i2) {
                    this.values[i2] = null;
                }
            }
        }
        this.ivaluesShift = 0;
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public int[] getKeys() {
        int[] keys2 = this.keys;
        int n = this.keyCount;
        int[] result2 = new int[n];
        int i2 = 0;
        while (n != 0) {
            int entry = keys2[i2];
            if (entry != -1 && entry != -2) {
                result2[--n] = entry;
            }
            ++i2;
        }
        return result2;
    }

    private static int tableLookupStep(int fraction, int mask, int power) {
        int shift = 32 - 2 * power;
        if (shift >= 0) {
            return fraction >>> shift & mask | 1;
        }
        return fraction & mask >>> -shift | 1;
    }

    private int findIndex(int key2) {
        int[] keys2 = this.keys;
        if (keys2 != null) {
            int fraction = key2 * -1640531527;
            int index = fraction >>> 32 - this.power;
            int entry = keys2[index];
            if (entry == key2) {
                return index;
            }
            if (entry != -1) {
                int mask = (1 << this.power) - 1;
                int step = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys2[index = index + step & mask]) != key2) continue;
                    return index;
                } while (entry != -1);
            }
        }
        return -1;
    }

    private int insertNewKey(int key2) {
        int[] keys2 = this.keys;
        int fraction = key2 * -1640531527;
        int index = fraction >>> 32 - this.power;
        if (keys2[index] != -1) {
            int mask = (1 << this.power) - 1;
            int step = UintMap.tableLookupStep(fraction, mask, this.power);
            int firstIndex = index;
            while (keys2[index = index + step & mask] != -1) {
            }
        }
        keys2[index] = key2;
        ++this.occupiedCount;
        ++this.keyCount;
        return index;
    }

    private void rehashTable(boolean ensureIntSpace) {
        if (this.keys != null && this.keyCount * 2 >= this.occupiedCount) {
            ++this.power;
        }
        int N2 = 1 << this.power;
        int[] old = this.keys;
        int oldShift = this.ivaluesShift;
        if (oldShift == 0 && !ensureIntSpace) {
            this.keys = new int[N2];
        } else {
            this.ivaluesShift = N2;
            this.keys = new int[N2 * 2];
        }
        for (int i2 = 0; i2 != N2; ++i2) {
            this.keys[i2] = -1;
        }
        Object[] oldValues = this.values;
        if (oldValues != null) {
            this.values = new Object[N2];
        }
        int oldCount = this.keyCount;
        this.occupiedCount = 0;
        if (oldCount != 0) {
            this.keyCount = 0;
            int i3 = 0;
            int remaining = oldCount;
            while (remaining != 0) {
                int key2 = old[i3];
                if (key2 != -1 && key2 != -2) {
                    int index = this.insertNewKey(key2);
                    if (oldValues != null) {
                        this.values[index] = oldValues[i3];
                    }
                    if (oldShift != 0) {
                        this.keys[this.ivaluesShift + index] = old[oldShift + i3];
                    }
                    --remaining;
                }
                ++i3;
            }
        }
    }

    private int ensureIndex(int key2, boolean intType) {
        int index = -1;
        int firstDeleted = -1;
        int[] keys2 = this.keys;
        if (keys2 != null) {
            int fraction = key2 * -1640531527;
            index = fraction >>> 32 - this.power;
            int entry = keys2[index];
            if (entry == key2) {
                return index;
            }
            if (entry != -1) {
                if (entry == -2) {
                    firstDeleted = index;
                }
                int mask = (1 << this.power) - 1;
                int step = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys2[index = index + step & mask]) == key2) {
                        return index;
                    }
                    if (entry != -2 || firstDeleted >= 0) continue;
                    firstDeleted = index;
                } while (entry != -1);
            }
        }
        if (firstDeleted >= 0) {
            index = firstDeleted;
        } else {
            if (keys2 == null || this.occupiedCount * 4 >= (1 << this.power) * 3) {
                this.rehashTable(intType);
                return this.insertNewKey(key2);
            }
            ++this.occupiedCount;
        }
        keys2[index] = key2;
        ++this.keyCount;
        return index;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.defaultWriteObject();
        int count2 = this.keyCount;
        if (count2 != 0) {
            boolean hasIntValues = this.ivaluesShift != 0;
            boolean hasObjectValues = this.values != null;
            out2.writeBoolean(hasIntValues);
            out2.writeBoolean(hasObjectValues);
            int i2 = 0;
            while (count2 != 0) {
                int key2 = this.keys[i2];
                if (key2 != -1 && key2 != -2) {
                    --count2;
                    out2.writeInt(key2);
                    if (hasIntValues) {
                        out2.writeInt(this.keys[this.ivaluesShift + i2]);
                    }
                    if (hasObjectValues) {
                        out2.writeObject(this.values[i2]);
                    }
                }
                ++i2;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int writtenKeyCount = this.keyCount;
        if (writtenKeyCount != 0) {
            int i2;
            this.keyCount = 0;
            boolean hasIntValues = in.readBoolean();
            boolean hasObjectValues = in.readBoolean();
            int N2 = 1 << this.power;
            if (hasIntValues) {
                this.keys = new int[2 * N2];
                this.ivaluesShift = N2;
            } else {
                this.keys = new int[N2];
            }
            for (i2 = 0; i2 != N2; ++i2) {
                this.keys[i2] = -1;
            }
            if (hasObjectValues) {
                this.values = new Object[N2];
            }
            for (i2 = 0; i2 != writtenKeyCount; ++i2) {
                int key2 = in.readInt();
                int index = this.insertNewKey(key2);
                if (hasIntValues) {
                    int ivalue;
                    this.keys[this.ivaluesShift + index] = ivalue = in.readInt();
                }
                if (!hasObjectValues) continue;
                this.values[index] = in.readObject();
            }
        }
    }
}

