/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.javascript.Scriptable;

public class Undefined
implements Serializable {
    static final long serialVersionUID = 9195680630202616767L;
    public static final Object instance = new Undefined();
    public static final Scriptable SCRIPTABLE_UNDEFINED = (Scriptable)Proxy.newProxyInstance(Undefined.class.getClassLoader(), new Class[]{Scriptable.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method2, Object[] args2) throws Throwable {
            if (method2.getName().equals("toString")) {
                return "undefined";
            }
            if (method2.getName().equals("equals")) {
                return args2.length > 0 && Undefined.isUndefined(args2[0]);
            }
            throw new UnsupportedOperationException("undefined doesn't support " + method2.getName());
        }
    });

    private Undefined() {
    }

    public Object readResolve() {
        return instance;
    }

    public boolean equals(Object obj) {
        return Undefined.isUndefined(obj) || super.equals(obj);
    }

    public int hashCode() {
        return 0;
    }

    public static boolean isUndefined(Object obj) {
        return instance == obj || SCRIPTABLE_UNDEFINED == obj;
    }
}

