/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class NumberLiteral
extends AstNode {
    private String value;
    private double number;

    public NumberLiteral() {
        this.type = 40;
    }

    public NumberLiteral(int pos) {
        super(pos);
        this.type = 40;
    }

    public NumberLiteral(int pos, int len2) {
        super(pos, len2);
        this.type = 40;
    }

    public NumberLiteral(int pos, String value2) {
        super(pos);
        this.type = 40;
        this.setValue(value2);
        this.setLength(value2.length());
    }

    public NumberLiteral(int pos, String value2, double number) {
        this(pos, value2);
        this.setDouble(number);
    }

    public NumberLiteral(double number) {
        this.type = 40;
        this.setDouble(number);
        this.setValue(Double.toString(number));
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.assertNotNull(value2);
        this.value = value2;
    }

    public double getNumber() {
        return this.number;
    }

    public void setNumber(double value2) {
        this.number = value2;
    }

    @Override
    public String toSource(int depth) {
        return this.makeIndent(depth) + (this.value == null ? "<null>" : this.value);
    }

    @Override
    public void visit(NodeVisitor v) {
        v.visit(this);
    }
}

