/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ReturnStatement
extends AstNode {
    private AstNode returnValue;

    public ReturnStatement() {
        this.type = 4;
    }

    public ReturnStatement(int pos) {
        super(pos);
        this.type = 4;
    }

    public ReturnStatement(int pos, int len2) {
        super(pos, len2);
        this.type = 4;
    }

    public ReturnStatement(int pos, int len2, AstNode returnValue2) {
        super(pos, len2);
        this.type = 4;
        this.setReturnValue(returnValue2);
    }

    public AstNode getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(AstNode returnValue2) {
        this.returnValue = returnValue2;
        if (returnValue2 != null) {
            returnValue2.setParent(this);
        }
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append("return");
        if (this.returnValue != null) {
            sb.append(" ");
            sb.append(this.returnValue.toSource(0));
        }
        sb.append(";\n");
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this) && this.returnValue != null) {
            this.returnValue.visit(v);
        }
    }
}

