/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class WithStatement
extends AstNode {
    private AstNode expression;
    private AstNode statement;
    private int lp = -1;
    private int rp = -1;

    public WithStatement() {
        this.type = 124;
    }

    public WithStatement(int pos) {
        super(pos);
        this.type = 124;
    }

    public WithStatement(int pos, int len2) {
        super(pos, len2);
        this.type = 124;
    }

    public AstNode getExpression() {
        return this.expression;
    }

    public void setExpression(AstNode expression) {
        this.assertNotNull(expression);
        this.expression = expression;
        expression.setParent(this);
    }

    public AstNode getStatement() {
        return this.statement;
    }

    public void setStatement(AstNode statement2) {
        this.assertNotNull(statement2);
        this.statement = statement2;
        statement2.setParent(this);
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int lp) {
        this.lp = lp;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int rp) {
        this.rp = rp;
    }

    public void setParens(int lp, int rp) {
        this.lp = lp;
        this.rp = rp;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append("with (");
        sb.append(this.expression.toSource(0));
        sb.append(") ");
        if (this.statement.getType() == 130) {
            sb.append(this.statement.toSource(depth).trim());
            sb.append("\n");
        } else {
            sb.append("\n").append(this.statement.toSource(depth + 1));
        }
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            this.expression.visit(v);
            this.statement.visit(v);
        }
    }
}

