/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.REBackTrackData;
import org.mozilla.javascript.regexp.RECharSet;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.REGlobalData;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.REProgState;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptableObject
implements Function {
    static final long serialVersionUID = 4965263491464903264L;
    private static final Object REGEXP_TAG = new Object();
    public static final int JSREG_GLOB = 1;
    public static final int JSREG_FOLD = 2;
    public static final int JSREG_MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    private static final byte REOP_SIMPLE_START = 1;
    private static final byte REOP_EMPTY = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_DOT = 6;
    private static final byte REOP_DIGIT = 7;
    private static final byte REOP_NONDIGIT = 8;
    private static final byte REOP_ALNUM = 9;
    private static final byte REOP_NONALNUM = 10;
    private static final byte REOP_SPACE = 11;
    private static final byte REOP_NONSPACE = 12;
    private static final byte REOP_BACKREF = 13;
    private static final byte REOP_FLAT = 14;
    private static final byte REOP_FLAT1 = 15;
    private static final byte REOP_FLATi = 16;
    private static final byte REOP_FLAT1i = 17;
    private static final byte REOP_UCFLAT1 = 18;
    private static final byte REOP_UCFLAT1i = 19;
    private static final byte REOP_CLASS = 22;
    private static final byte REOP_NCLASS = 23;
    private static final byte REOP_SIMPLE_END = 23;
    private static final byte REOP_QUANT = 25;
    private static final byte REOP_STAR = 26;
    private static final byte REOP_PLUS = 27;
    private static final byte REOP_OPT = 28;
    private static final byte REOP_LPAREN = 29;
    private static final byte REOP_RPAREN = 30;
    private static final byte REOP_ALT = 31;
    private static final byte REOP_JUMP = 32;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_ASSERTTEST = 43;
    private static final byte REOP_ASSERTNOTTEST = 44;
    private static final byte REOP_MINIMALSTAR = 45;
    private static final byte REOP_MINIMALPLUS = 46;
    private static final byte REOP_MINIMALOPT = 47;
    private static final byte REOP_MINIMALQUANT = 48;
    private static final byte REOP_ENDCHILD = 49;
    private static final byte REOP_REPEAT = 51;
    private static final byte REOP_MINIMALREPEAT = 52;
    private static final byte REOP_ALTPREREQ = 53;
    private static final byte REOP_ALTPREREQi = 54;
    private static final byte REOP_ALTPREREQ2 = 55;
    private static final byte REOP_END = 57;
    private static final int ANCHOR_BOL = -2;
    private static final int INDEX_LEN = 2;
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_exec = 4;
    private static final int Id_test = 5;
    private static final int Id_prefix = 6;
    private static final int MAX_PROTOTYPE_ID = 6;
    private RECompiled re;
    Object lastIndex = 0.0;
    private int lastIndexAttr = 6;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeRegExp proto = new NativeRegExp();
        proto.re = NativeRegExp.compileRE(cx, "", null, false);
        proto.activatePrototypeMap(6);
        proto.setParentScope(scope);
        proto.setPrototype(NativeRegExp.getObjectPrototype(scope));
        NativeRegExpCtor ctor = new NativeRegExpCtor();
        proto.defineProperty("constructor", (Object)ctor, 2);
        ScriptRuntime.setFunctionProtoAndParent(ctor, scope);
        ctor.setImmunePrototypeProperty(proto);
        if (sealed) {
            proto.sealObject();
            ctor.sealObject();
        }
        NativeRegExp.defineProperty(scope, "RegExp", ctor, 2);
    }

    NativeRegExp(Scriptable scope, RECompiled regexpCompiled) {
        this.re = regexpCompiled;
        this.lastIndex = 0.0;
        ScriptRuntime.setBuiltinProtoAndParent(this, scope, TopLevel.Builtins.RegExp);
    }

    @Override
    public String getClassName() {
        return "RegExp";
    }

    @Override
    public String getTypeOf() {
        return "object";
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        return this.execSub(cx, scope, args2, 1);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args2) {
        return (Scriptable)this.execSub(cx, scope, args2, 1);
    }

    Scriptable compile(Context cx, Scriptable scope, Object[] args2) {
        if (args2.length > 0 && args2[0] instanceof NativeRegExp) {
            if (args2.length > 1 && args2[1] != Undefined.instance) {
                throw ScriptRuntime.typeError0("msg.bad.regexp.compile");
            }
            NativeRegExp thatObj = (NativeRegExp)args2[0];
            this.re = thatObj.re;
            this.lastIndex = thatObj.lastIndex;
            return this;
        }
        String s2 = args2.length == 0 || args2[0] instanceof Undefined ? "" : NativeRegExp.escapeRegExp(args2[0]);
        String global = args2.length > 1 && args2[1] != Undefined.instance ? ScriptRuntime.toString(args2[1]) : null;
        this.re = NativeRegExp.compileRE(cx, s2, global, false);
        this.lastIndex = 0.0;
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('/');
        if (this.re.source.length != 0) {
            buf.append(this.re.source);
        } else {
            buf.append("(?:)");
        }
        buf.append('/');
        if ((this.re.flags & 1) != 0) {
            buf.append('g');
        }
        if ((this.re.flags & 2) != 0) {
            buf.append('i');
        }
        if ((this.re.flags & 4) != 0) {
            buf.append('m');
        }
        return buf.toString();
    }

    NativeRegExp() {
    }

    private static RegExpImpl getImpl(Context cx) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(cx);
    }

    private static String escapeRegExp(Object src) {
        String s2 = ScriptRuntime.toString(src);
        StringBuilder sb = null;
        int start2 = 0;
        int slash = s2.indexOf(47);
        while (slash > -1) {
            if (slash == start2 || s2.charAt(slash - 1) != '\\') {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(s2, start2, slash);
                sb.append("\\/");
                start2 = slash + 1;
            }
            slash = s2.indexOf(47, slash + 1);
        }
        if (sb != null) {
            sb.append(s2, start2, s2.length());
            s2 = sb.toString();
        }
        return s2;
    }

    private Object execSub(Context cx, Scriptable scopeObj, Object[] args2, int matchType) {
        Object rval;
        String str;
        RegExpImpl reImpl = NativeRegExp.getImpl(cx);
        if (args2.length == 0) {
            str = reImpl.input;
            if (str == null) {
                str = ScriptRuntime.toString(Undefined.instance);
            }
        } else {
            str = ScriptRuntime.toString(args2[0]);
        }
        double d2 = 0.0;
        if ((this.re.flags & 1) != 0) {
            d2 = ScriptRuntime.toInteger(this.lastIndex);
        }
        if (d2 < 0.0 || (double)str.length() < d2) {
            this.lastIndex = 0.0;
            rval = null;
        } else {
            int[] indexp = new int[]{(int)d2};
            rval = this.executeRegExp(cx, scopeObj, reImpl, str, indexp, matchType);
            if ((this.re.flags & 1) != 0) {
                this.lastIndex = rval == null || rval == Undefined.instance ? 0.0 : (double)indexp[0];
            }
        }
        return rval;
    }

    static RECompiled compileRE(Context cx, String str, String global, boolean flat) {
        RECompiled regexp = new RECompiled(str);
        int length = str.length();
        int flags = 0;
        if (global != null) {
            for (int i2 = 0; i2 < global.length(); ++i2) {
                char c2 = global.charAt(i2);
                int f2 = 0;
                if (c2 == 'g') {
                    f2 = 1;
                } else if (c2 == 'i') {
                    f2 = 2;
                } else if (c2 == 'm') {
                    f2 = 4;
                } else {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf(c2));
                }
                if ((flags & f2) != 0) {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf(c2));
                }
                flags |= f2;
            }
        }
        regexp.flags = flags;
        CompilerState state = new CompilerState(cx, regexp.source, length, flags);
        if (flat && length > 0) {
            state.result = new RENode(14);
            state.result.chr = state.cpbegin[0];
            state.result.length = length;
            state.result.flatIndex = 0;
            state.progLength += 5;
        } else {
            if (!NativeRegExp.parseDisjunction(state)) {
                return null;
            }
            if (state.maxBackReference > state.parenCount) {
                state = new CompilerState(cx, regexp.source, length, flags);
                state.backReferenceLimit = state.parenCount;
                if (!NativeRegExp.parseDisjunction(state)) {
                    return null;
                }
            }
        }
        regexp.program = new byte[state.progLength + 1];
        if (state.classCount != 0) {
            regexp.classList = new RECharSet[state.classCount];
            regexp.classCount = state.classCount;
        }
        int endPC = NativeRegExp.emitREBytecode(state, regexp, 0, state.result);
        regexp.program[endPC++] = 57;
        regexp.parenCount = state.parenCount;
        switch (regexp.program[0]) {
            case 18: 
            case 19: {
                regexp.anchorCh = (char)NativeRegExp.getIndex(regexp.program, 1);
                break;
            }
            case 15: 
            case 17: {
                regexp.anchorCh = (char)(regexp.program[1] & 0xFF);
                break;
            }
            case 14: 
            case 16: {
                int k2 = NativeRegExp.getIndex(regexp.program, 1);
                regexp.anchorCh = regexp.source[k2];
                break;
            }
            case 2: {
                regexp.anchorCh = -2;
                break;
            }
            case 31: {
                RENode n = state.result;
                if (n.kid.op != 2 || n.kid2.op != 2) break;
                regexp.anchorCh = -2;
            }
        }
        return regexp;
    }

    static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private static boolean isWord(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || NativeRegExp.isDigit(c2) || c2 == '_';
    }

    private static boolean isControlLetter(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z';
    }

    private static boolean isLineTerm(char c2) {
        return ScriptRuntime.isJSLineTerminator(c2);
    }

    private static boolean isREWhiteSpace(int c2) {
        return ScriptRuntime.isJSWhitespaceOrLineTerminator(c2);
    }

    private static char upcase(char ch) {
        if (ch < '\u0080') {
            if ('a' <= ch && ch <= 'z') {
                return (char)(ch + -32);
            }
            return ch;
        }
        char cu = Character.toUpperCase(ch);
        return cu < '\u0080' ? ch : cu;
    }

    private static char downcase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        char cl = Character.toLowerCase(ch);
        return cl < '\u0080' ? ch : cl;
    }

    private static int toASCIIHexDigit(int c2) {
        if (c2 < 48) {
            return -1;
        }
        if (c2 <= 57) {
            return c2 - 48;
        }
        if (97 <= (c2 |= 0x20) && c2 <= 102) {
            return c2 - 97 + 10;
        }
        return -1;
    }

    private static boolean parseDisjunction(CompilerState state) {
        int index;
        if (!NativeRegExp.parseAlternative(state)) {
            return false;
        }
        char[] source2 = state.cpbegin;
        if ((index = state.cp++) != source2.length && source2[index] == '|') {
            RENode result2 = new RENode(31);
            result2.kid = state.result;
            if (!NativeRegExp.parseDisjunction(state)) {
                return false;
            }
            result2.kid2 = state.result;
            state.result = result2;
            if (result2.kid.op == 14 && result2.kid2.op == 14) {
                result2.op = (byte)((state.flags & 2) == 0 ? 53 : 54);
                result2.chr = result2.kid.chr;
                result2.index = result2.kid2.chr;
                state.progLength += 13;
            } else if (result2.kid.op == 22 && result2.kid.index < 256 && result2.kid2.op == 14 && (state.flags & 2) == 0) {
                result2.op = (byte)55;
                result2.chr = result2.kid2.chr;
                result2.index = result2.kid.index;
                state.progLength += 13;
            } else if (result2.kid.op == 14 && result2.kid2.op == 22 && result2.kid2.index < 256 && (state.flags & 2) == 0) {
                result2.op = (byte)55;
                result2.chr = result2.kid.chr;
                result2.index = result2.kid2.index;
                state.progLength += 13;
            } else {
                state.progLength += 9;
            }
        }
        return true;
    }

    private static boolean parseAlternative(CompilerState state) {
        RENode headTerm = null;
        RENode tailTerm = null;
        char[] source2 = state.cpbegin;
        block0: while (true) {
            if (state.cp == state.cpend || source2[state.cp] == '|' || state.parenNesting != 0 && source2[state.cp] == ')') {
                state.result = headTerm == null ? new RENode(1) : headTerm;
                return true;
            }
            if (!NativeRegExp.parseTerm(state)) {
                return false;
            }
            if (headTerm == null) {
                tailTerm = headTerm = state.result;
            } else {
                tailTerm.next = state.result;
            }
            while (true) {
                if (tailTerm.next == null) continue block0;
                tailTerm = tailTerm.next;
            }
            break;
        }
    }

    private static boolean calculateBitmapSize(CompilerState state, RENode target, char[] src, int index, int end2) {
        int rangeStart = 0;
        int max2 = 0;
        boolean inRange = false;
        target.bmsize = 0;
        target.sense = true;
        if (index == end2) {
            return true;
        }
        if (src[index] == '^') {
            ++index;
            target.sense = false;
        }
        while (index != end2) {
            int localMax = 0;
            int nDigits = 2;
            block0 : switch (src[index]) {
                case '\\': {
                    int n = ++index;
                    ++index;
                    int c2 = src[n];
                    switch (c2) {
                        case 98: {
                            localMax = 8;
                            break block0;
                        }
                        case 102: {
                            localMax = 12;
                            break block0;
                        }
                        case 110: {
                            localMax = 10;
                            break block0;
                        }
                        case 114: {
                            localMax = 13;
                            break block0;
                        }
                        case 116: {
                            localMax = 9;
                            break block0;
                        }
                        case 118: {
                            localMax = 11;
                            break block0;
                        }
                        case 99: {
                            if (index < end2 && NativeRegExp.isControlLetter(src[index])) {
                                localMax = (char)(src[index++] & 0x1F);
                            } else {
                                --index;
                            }
                            localMax = 92;
                            break block0;
                        }
                        case 117: {
                            nDigits += 2;
                        }
                        case 120: {
                            int i2;
                            int n2 = 0;
                            for (i2 = 0; i2 < nDigits && index < end2; ++i2) {
                                if ((n2 = Kit.xDigitToInt(c2 = src[index++], n2)) >= 0) continue;
                                index -= i2 + 1;
                                n2 = 92;
                                break;
                            }
                            localMax = n2;
                            break block0;
                        }
                        case 100: {
                            if (inRange) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            localMax = 57;
                            break block0;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 115: 
                        case 119: {
                            if (inRange) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            target.bmsize = 65536;
                            return true;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int i2;
                            int n2 = c2 - 48;
                            c2 = src[index];
                            if (48 <= c2 && c2 <= 55) {
                                n2 = 8 * n2 + (c2 - 48);
                                if (48 <= (c2 = src[++index]) && c2 <= 55) {
                                    ++index;
                                    i2 = 8 * n2 + (c2 - 48);
                                    if (i2 <= 255) {
                                        n2 = i2;
                                    } else {
                                        --index;
                                    }
                                }
                            }
                            localMax = n2;
                            break block0;
                        }
                    }
                    localMax = c2;
                    break;
                }
                default: {
                    localMax = src[index++];
                }
            }
            if (inRange) {
                if (rangeStart > localMax) {
                    NativeRegExp.reportError("msg.bad.range", "");
                    return false;
                }
                inRange = false;
            } else if (index < end2 - 1 && src[index] == '-') {
                ++index;
                inRange = true;
                rangeStart = (char)localMax;
                continue;
            }
            if ((state.flags & 2) != 0) {
                char cd2;
                char cu = NativeRegExp.upcase((char)localMax);
                localMax = cu >= (cd2 = NativeRegExp.downcase((char)localMax)) ? cu : cd2;
            }
            if (localMax <= max2) continue;
            max2 = localMax;
        }
        target.bmsize = max2 + 1;
        return true;
    }

    private static void doFlat(CompilerState state, char c2) {
        state.result = new RENode(14);
        state.result.chr = c2;
        state.result.length = 1;
        state.result.flatIndex = -1;
        state.progLength += 3;
    }

    private static int getDecimalValue(char c2, CompilerState state, int maxValue, String overflowMessageId) {
        boolean overflow = false;
        int start2 = state.cp;
        char[] src = state.cpbegin;
        int value2 = c2 - 48;
        while (state.cp != state.cpend && NativeRegExp.isDigit(c2 = src[state.cp])) {
            if (!overflow) {
                int v = value2 * 10 + (c2 - 48);
                if (v < maxValue) {
                    value2 = v;
                } else {
                    overflow = true;
                    value2 = maxValue;
                }
            }
            ++state.cp;
        }
        if (overflow) {
            NativeRegExp.reportError(overflowMessageId, String.valueOf(src, start2, state.cp - start2));
        }
        return value2;
    }

    private static boolean parseTerm(CompilerState state) {
        char[] src = state.cpbegin;
        char c2 = src[state.cp++];
        int nDigits = 2;
        int parenBaseCount = state.parenCount;
        block0 : switch (c2) {
            case '^': {
                state.result = new RENode(2);
                ++state.progLength;
                return true;
            }
            case '$': {
                state.result = new RENode(3);
                ++state.progLength;
                return true;
            }
            case '\\': {
                if (state.cp < state.cpend) {
                    c2 = src[state.cp++];
                    switch (c2) {
                        case 'b': {
                            state.result = new RENode(4);
                            ++state.progLength;
                            return true;
                        }
                        case 'B': {
                            state.result = new RENode(5);
                            ++state.progLength;
                            return true;
                        }
                        case '0': {
                            NativeRegExp.reportWarning(state.cx, "msg.bad.backref", "");
                            int num = 0;
                            while (num < 32 && state.cp < state.cpend && (c2 = src[state.cp]) >= '0' && c2 <= '7') {
                                ++state.cp;
                                num = 8 * num + (c2 - 48);
                            }
                            c2 = (char)num;
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int termStart = state.cp - 1;
                            int num = NativeRegExp.getDecimalValue(c2, state, 65535, "msg.overlarge.backref");
                            if (num > state.backReferenceLimit) {
                                NativeRegExp.reportWarning(state.cx, "msg.bad.backref", "");
                            }
                            if (num > state.backReferenceLimit) {
                                state.cp = termStart;
                                if (c2 >= '8') {
                                    c2 = '\\';
                                    NativeRegExp.doFlat(state, c2);
                                    break;
                                }
                                ++state.cp;
                                num = c2 - 48;
                                while (num < 32 && state.cp < state.cpend && (c2 = src[state.cp]) >= '0' && c2 <= '7') {
                                    ++state.cp;
                                    num = 8 * num + (c2 - 48);
                                }
                                c2 = (char)num;
                                NativeRegExp.doFlat(state, c2);
                                break;
                            }
                            state.result = new RENode(13);
                            state.result.parenIndex = num - 1;
                            state.progLength += 3;
                            if (state.maxBackReference >= num) break block0;
                            state.maxBackReference = num;
                            break;
                        }
                        case 'f': {
                            c2 = '\f';
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case 'n': {
                            c2 = '\n';
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case 'r': {
                            c2 = '\r';
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case 't': {
                            c2 = '\t';
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case 'v': {
                            c2 = '\u000b';
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case 'c': {
                            if (state.cp < state.cpend && NativeRegExp.isControlLetter(src[state.cp])) {
                                c2 = (char)(src[state.cp++] & 0x1F);
                            } else {
                                --state.cp;
                                c2 = '\\';
                            }
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case 'u': {
                            nDigits += 2;
                        }
                        case 'x': {
                            int n = 0;
                            for (int i2 = 0; i2 < nDigits && state.cp < state.cpend; ++i2) {
                                if ((n = Kit.xDigitToInt(c2 = src[state.cp++], n)) >= 0) continue;
                                state.cp -= i2 + 2;
                                n = src[state.cp++];
                                break;
                            }
                            c2 = (char)n;
                            NativeRegExp.doFlat(state, c2);
                            break;
                        }
                        case 'd': {
                            state.result = new RENode(7);
                            ++state.progLength;
                            break;
                        }
                        case 'D': {
                            state.result = new RENode(8);
                            ++state.progLength;
                            break;
                        }
                        case 's': {
                            state.result = new RENode(11);
                            ++state.progLength;
                            break;
                        }
                        case 'S': {
                            state.result = new RENode(12);
                            ++state.progLength;
                            break;
                        }
                        case 'w': {
                            state.result = new RENode(9);
                            ++state.progLength;
                            break;
                        }
                        case 'W': {
                            state.result = new RENode(10);
                            ++state.progLength;
                            break;
                        }
                        default: {
                            state.result = new RENode(14);
                            state.result.chr = c2;
                            state.result.length = 1;
                            state.result.flatIndex = state.cp - 1;
                            state.progLength += 3;
                            break;
                        }
                    }
                    break;
                }
                NativeRegExp.reportError("msg.trail.backslash", "");
                return false;
            }
            case '(': {
                RENode result2 = null;
                int termStart = state.cp;
                if (state.cp + 1 < state.cpend && src[state.cp] == '?' && ((c2 = src[state.cp + 1]) == '=' || c2 == '!' || c2 == ':')) {
                    state.cp += 2;
                    if (c2 == '=') {
                        result2 = new RENode(41);
                        state.progLength += 4;
                    } else if (c2 == '!') {
                        result2 = new RENode(42);
                        state.progLength += 4;
                    }
                } else {
                    result2 = new RENode(29);
                    state.progLength += 6;
                    result2.parenIndex = state.parenCount++;
                }
                ++state.parenNesting;
                if (!NativeRegExp.parseDisjunction(state)) {
                    return false;
                }
                if (state.cp == state.cpend || src[state.cp] != ')') {
                    NativeRegExp.reportError("msg.unterm.paren", "");
                    return false;
                }
                ++state.cp;
                --state.parenNesting;
                if (result2 == null) break;
                result2.kid = state.result;
                state.result = result2;
                break;
            }
            case ')': {
                NativeRegExp.reportError("msg.re.unmatched.right.paren", "");
                return false;
            }
            case '[': {
                int termStart;
                state.result = new RENode(22);
                state.result.startIndex = termStart = state.cp;
                while (true) {
                    if (state.cp == state.cpend) {
                        NativeRegExp.reportError("msg.unterm.class", "");
                        return false;
                    }
                    if (src[state.cp] == '\\') {
                        ++state.cp;
                    } else if (src[state.cp] == ']') break;
                    ++state.cp;
                }
                state.result.kidlen = state.cp - termStart;
                state.result.index = state.classCount++;
                if (!NativeRegExp.calculateBitmapSize(state, state.result, src, termStart, state.cp++)) {
                    return false;
                }
                state.progLength += 3;
                break;
            }
            case '.': {
                state.result = new RENode(6);
                ++state.progLength;
                break;
            }
            case '*': 
            case '+': 
            case '?': {
                NativeRegExp.reportError("msg.bad.quant", String.valueOf(src[state.cp - 1]));
                return false;
            }
            default: {
                state.result = new RENode(14);
                state.result.chr = c2;
                state.result.length = 1;
                state.result.flatIndex = state.cp - 1;
                state.progLength += 3;
            }
        }
        RENode term = state.result;
        if (state.cp == state.cpend) {
            return true;
        }
        boolean hasQ = false;
        switch (src[state.cp]) {
            case '+': {
                state.result = new RENode(25);
                state.result.min = 1;
                state.result.max = -1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '*': {
                state.result = new RENode(25);
                state.result.min = 0;
                state.result.max = -1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '?': {
                state.result = new RENode(25);
                state.result.min = 0;
                state.result.max = 1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '{': {
                int min2 = 0;
                int max2 = -1;
                int leftCurl = state.cp++;
                if (state.cp < src.length && NativeRegExp.isDigit(c2 = src[state.cp])) {
                    ++state.cp;
                    min2 = NativeRegExp.getDecimalValue(c2, state, 65535, "msg.overlarge.min");
                    c2 = src[state.cp];
                    if (c2 == ',') {
                        if (NativeRegExp.isDigit(c2 = src[++state.cp])) {
                            ++state.cp;
                            max2 = NativeRegExp.getDecimalValue(c2, state, 65535, "msg.overlarge.max");
                            c2 = src[state.cp];
                            if (min2 > max2) {
                                NativeRegExp.reportError("msg.max.lt.min", String.valueOf(src[state.cp]));
                                return false;
                            }
                        }
                    } else {
                        max2 = min2;
                    }
                    if (c2 == '}') {
                        state.result = new RENode(25);
                        state.result.min = min2;
                        state.result.max = max2;
                        state.progLength += 12;
                        hasQ = true;
                    }
                }
                if (hasQ) break;
                state.cp = leftCurl;
                break;
            }
        }
        if (!hasQ) {
            return true;
        }
        ++state.cp;
        state.result.kid = term;
        state.result.parenIndex = parenBaseCount;
        state.result.parenCount = state.parenCount - parenBaseCount;
        if (state.cp < state.cpend && src[state.cp] == '?') {
            ++state.cp;
            state.result.greedy = false;
        } else {
            state.result.greedy = true;
        }
        return true;
    }

    private static void resolveForwardJump(byte[] array, int from2, int pc) {
        if (from2 > pc) {
            throw Kit.codeBug();
        }
        NativeRegExp.addIndex(array, from2, pc - from2);
    }

    private static int getOffset(byte[] array, int pc) {
        return NativeRegExp.getIndex(array, pc);
    }

    private static int addIndex(byte[] array, int pc, int index) {
        if (index < 0) {
            throw Kit.codeBug();
        }
        if (index > 65535) {
            throw Context.reportRuntimeError("Too complex regexp");
        }
        array[pc] = (byte)(index >> 8);
        array[pc + 1] = (byte)index;
        return pc + 2;
    }

    private static int getIndex(byte[] array, int pc) {
        return (array[pc] & 0xFF) << 8 | array[pc + 1] & 0xFF;
    }

    private static int emitREBytecode(CompilerState state, RECompiled re, int pc, RENode t2) {
        byte[] program = re.program;
        while (t2 != null) {
            program[pc++] = t2.op;
            switch (t2.op) {
                case 1: {
                    --pc;
                    break;
                }
                case 53: 
                case 54: 
                case 55: {
                    boolean ignoreCase = t2.op == 54;
                    NativeRegExp.addIndex(program, pc, ignoreCase ? NativeRegExp.upcase(t2.chr) : t2.chr);
                    NativeRegExp.addIndex(program, pc += 2, ignoreCase ? (int)NativeRegExp.upcase((char)t2.index) : t2.index);
                    pc += 2;
                }
                case 31: {
                    RENode nextAlt = t2.kid2;
                    int nextAltFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t2.kid);
                    program[pc++] = 32;
                    int nextTermFixup = pc;
                    NativeRegExp.resolveForwardJump(program, nextAltFixup, pc += 2);
                    pc = NativeRegExp.emitREBytecode(state, re, pc, nextAlt);
                    program[pc++] = 32;
                    nextAltFixup = pc;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc += 2);
                    NativeRegExp.resolveForwardJump(program, nextAltFixup, pc);
                    break;
                }
                case 14: {
                    if (t2.flatIndex != -1) {
                        while (t2.next != null && t2.next.op == 14 && t2.flatIndex + t2.length == t2.next.flatIndex) {
                            t2.length += t2.next.length;
                            t2.next = t2.next.next;
                        }
                    }
                    if (t2.flatIndex != -1 && t2.length > 1) {
                        program[pc - 1] = (state.flags & 2) != 0 ? 16 : 14;
                        pc = NativeRegExp.addIndex(program, pc, t2.flatIndex);
                        pc = NativeRegExp.addIndex(program, pc, t2.length);
                        break;
                    }
                    if (t2.chr < '\u0100') {
                        program[pc - 1] = (state.flags & 2) != 0 ? 17 : 15;
                        program[pc++] = (byte)t2.chr;
                        break;
                    }
                    program[pc - 1] = (state.flags & 2) != 0 ? 19 : 18;
                    pc = NativeRegExp.addIndex(program, pc, t2.chr);
                    break;
                }
                case 29: {
                    pc = NativeRegExp.addIndex(program, pc, t2.parenIndex);
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t2.kid);
                    program[pc++] = 30;
                    pc = NativeRegExp.addIndex(program, pc, t2.parenIndex);
                    break;
                }
                case 13: {
                    pc = NativeRegExp.addIndex(program, pc, t2.parenIndex);
                    break;
                }
                case 41: {
                    int nextTermFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t2.kid);
                    program[pc++] = 43;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc);
                    break;
                }
                case 42: {
                    int nextTermFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t2.kid);
                    program[pc++] = 44;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc);
                    break;
                }
                case 25: {
                    if (t2.min == 0 && t2.max == -1) {
                        program[pc - 1] = t2.greedy ? 26 : 45;
                    } else if (t2.min == 0 && t2.max == 1) {
                        program[pc - 1] = t2.greedy ? 28 : 47;
                    } else if (t2.min == 1 && t2.max == -1) {
                        program[pc - 1] = t2.greedy ? 27 : 46;
                    } else {
                        if (!t2.greedy) {
                            program[pc - 1] = 48;
                        }
                        pc = NativeRegExp.addIndex(program, pc, t2.min);
                        pc = NativeRegExp.addIndex(program, pc, t2.max + 1);
                    }
                    pc = NativeRegExp.addIndex(program, pc, t2.parenCount);
                    int nextTermFixup = pc = NativeRegExp.addIndex(program, pc, t2.parenIndex);
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t2.kid);
                    program[pc++] = 49;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc);
                    break;
                }
                case 22: {
                    if (!t2.sense) {
                        program[pc - 1] = 23;
                    }
                    pc = NativeRegExp.addIndex(program, pc, t2.index);
                    re.classList[t2.index] = new RECharSet(t2.bmsize, t2.startIndex, t2.kidlen, t2.sense);
                    break;
                }
            }
            t2 = t2.next;
        }
        return pc;
    }

    private static void pushProgState(REGlobalData gData, int min2, int max2, int cp, REBackTrackData backTrackLastToSave, int continuationOp, int continuationPc) {
        gData.stateStackTop = new REProgState(gData.stateStackTop, min2, max2, cp, backTrackLastToSave, continuationOp, continuationPc);
    }

    private static REProgState popProgState(REGlobalData gData) {
        REProgState state = gData.stateStackTop;
        gData.stateStackTop = state.previous;
        return state;
    }

    private static void pushBackTrackState(REGlobalData gData, byte op, int pc) {
        REProgState state = gData.stateStackTop;
        gData.backTrackStackTop = new REBackTrackData(gData, op, pc, gData.cp, state.continuationOp, state.continuationPc);
    }

    private static void pushBackTrackState(REGlobalData gData, byte op, int pc, int cp, int continuationOp, int continuationPc) {
        gData.backTrackStackTop = new REBackTrackData(gData, op, pc, cp, continuationOp, continuationPc);
    }

    private static boolean flatNMatcher(REGlobalData gData, int matchChars, int length, String input, int end2) {
        if (gData.cp + length > end2) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (gData.regexp.source[matchChars + i2] == input.charAt(gData.cp + i2)) continue;
            return false;
        }
        gData.cp += length;
        return true;
    }

    private static boolean flatNIMatcher(REGlobalData gData, int matchChars, int length, String input, int end2) {
        if (gData.cp + length > end2) {
            return false;
        }
        char[] source2 = gData.regexp.source;
        for (int i2 = 0; i2 < length; ++i2) {
            char c1 = source2[matchChars + i2];
            char c2 = input.charAt(gData.cp + i2);
            if (c1 == c2 || NativeRegExp.upcase(c1) == NativeRegExp.upcase(c2)) continue;
            return false;
        }
        gData.cp += length;
        return true;
    }

    private static boolean backrefMatcher(REGlobalData gData, int parenIndex, String input, int end2) {
        if (gData.parens == null || parenIndex >= gData.parens.length) {
            return false;
        }
        int parenContent = gData.parensIndex(parenIndex);
        if (parenContent == -1) {
            return true;
        }
        int len2 = gData.parensLength(parenIndex);
        if (gData.cp + len2 > end2) {
            return false;
        }
        if ((gData.regexp.flags & 2) != 0) {
            for (int i2 = 0; i2 < len2; ++i2) {
                char c2;
                char c1 = input.charAt(parenContent + i2);
                if (c1 == (c2 = input.charAt(gData.cp + i2)) || NativeRegExp.upcase(c1) == NativeRegExp.upcase(c2)) continue;
                return false;
            }
        } else if (!input.regionMatches(parenContent, input, gData.cp, len2)) {
            return false;
        }
        gData.cp += len2;
        return true;
    }

    private static void addCharacterToCharSet(RECharSet cs, char c2) {
        int byteIndex = c2 / 8;
        if (c2 >= cs.length) {
            throw ScriptRuntime.constructError("SyntaxError", "invalid range in character class");
        }
        int n = byteIndex;
        cs.bits[n] = (byte)(cs.bits[n] | 1 << (c2 & 7));
    }

    private static void addCharacterRangeToCharSet(RECharSet cs, char c1, char c2) {
        int byteIndex1 = c1 / 8;
        int byteIndex2 = c2 / 8;
        if (c2 >= cs.length || c1 > c2) {
            throw ScriptRuntime.constructError("SyntaxError", "invalid range in character class");
        }
        c1 = (char)(c1 & 7);
        c2 = (char)(c2 & 7);
        if (byteIndex1 == byteIndex2) {
            int n = byteIndex1;
            cs.bits[n] = (byte)(cs.bits[n] | 255 >> 7 - (c2 - c1) << c1);
        } else {
            int n = byteIndex1;
            cs.bits[n] = (byte)(cs.bits[n] | 255 << c1);
            for (int i2 = byteIndex1 + 1; i2 < byteIndex2; ++i2) {
                cs.bits[i2] = -1;
            }
            int n2 = byteIndex2;
            cs.bits[n2] = (byte)(cs.bits[n2] | 255 >> 7 - c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCharSet(REGlobalData gData, RECharSet charSet) {
        RECharSet rECharSet = charSet;
        synchronized (rECharSet) {
            if (!charSet.converted) {
                NativeRegExp.processCharSetImpl(gData, charSet);
                charSet.converted = true;
            }
        }
    }

    private static void processCharSetImpl(REGlobalData gData, RECharSet charSet) {
        int src = charSet.startIndex;
        int end2 = src + charSet.strlength;
        char rangeStart = '\u0000';
        boolean inRange = false;
        int byteLength = (charSet.length + 7) / 8;
        charSet.bits = new byte[byteLength];
        if (src == end2) {
            return;
        }
        if (gData.regexp.source[src] == '^') {
            assert (!charSet.sense);
            ++src;
        } else assert (charSet.sense);
        block21: while (src != end2) {
            char thisCh;
            char c2;
            int nDigits = 2;
            block0 : switch (gData.regexp.source[src]) {
                case '\\': {
                    int n = ++src;
                    ++src;
                    c2 = gData.regexp.source[n];
                    switch (c2) {
                        case 'b': {
                            thisCh = '\b';
                            break block0;
                        }
                        case 'f': {
                            thisCh = '\f';
                            break block0;
                        }
                        case 'n': {
                            thisCh = '\n';
                            break block0;
                        }
                        case 'r': {
                            thisCh = '\r';
                            break block0;
                        }
                        case 't': {
                            thisCh = '\t';
                            break block0;
                        }
                        case 'v': {
                            thisCh = '\u000b';
                            break block0;
                        }
                        case 'c': {
                            if (src < end2 && NativeRegExp.isControlLetter(gData.regexp.source[src])) {
                                thisCh = (char)(gData.regexp.source[src++] & 0x1F);
                                break block0;
                            }
                            --src;
                            thisCh = '\\';
                            break block0;
                        }
                        case 'u': {
                            nDigits += 2;
                        }
                        case 'x': {
                            int i2;
                            int n2 = 0;
                            for (i2 = 0; i2 < nDigits && src < end2; ++i2) {
                                int digit;
                                if ((digit = NativeRegExp.toASCIIHexDigit(c2 = gData.regexp.source[src++])) < 0) {
                                    src -= i2 + 1;
                                    n2 = 92;
                                    break;
                                }
                                n2 = n2 << 4 | digit;
                            }
                            thisCh = (char)n2;
                            break block0;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int i2;
                            int n2 = c2 - 48;
                            c2 = gData.regexp.source[src];
                            if ('0' <= c2 && c2 <= '7') {
                                n2 = 8 * n2 + (c2 - 48);
                                if ('0' <= (c2 = gData.regexp.source[++src]) && c2 <= '7') {
                                    ++src;
                                    i2 = 8 * n2 + (c2 - 48);
                                    if (i2 <= 255) {
                                        n2 = i2;
                                    } else {
                                        --src;
                                    }
                                }
                            }
                            thisCh = (char)n2;
                            break block0;
                        }
                        case 'd': {
                            NativeRegExp.addCharacterRangeToCharSet(charSet, '0', '9');
                            continue block21;
                        }
                        case 'D': {
                            NativeRegExp.addCharacterRangeToCharSet(charSet, '\u0000', '/');
                            NativeRegExp.addCharacterRangeToCharSet(charSet, ':', (char)(charSet.length - 1));
                            continue block21;
                        }
                        case 's': {
                            int i2;
                            for (i2 = charSet.length - 1; i2 >= 0; --i2) {
                                if (!NativeRegExp.isREWhiteSpace(i2)) continue;
                                NativeRegExp.addCharacterToCharSet(charSet, (char)i2);
                            }
                            continue block21;
                        }
                        case 'S': {
                            int i2;
                            for (i2 = charSet.length - 1; i2 >= 0; --i2) {
                                if (NativeRegExp.isREWhiteSpace(i2)) continue;
                                NativeRegExp.addCharacterToCharSet(charSet, (char)i2);
                            }
                            continue block21;
                        }
                        case 'w': {
                            int i2;
                            for (i2 = charSet.length - 1; i2 >= 0; --i2) {
                                if (!NativeRegExp.isWord((char)i2)) continue;
                                NativeRegExp.addCharacterToCharSet(charSet, (char)i2);
                            }
                            continue block21;
                        }
                        case 'W': {
                            int i2;
                            for (i2 = charSet.length - 1; i2 >= 0; --i2) {
                                if (NativeRegExp.isWord((char)i2)) continue;
                                NativeRegExp.addCharacterToCharSet(charSet, (char)i2);
                            }
                            continue block21;
                        }
                    }
                    thisCh = c2;
                    break;
                }
                default: {
                    thisCh = gData.regexp.source[src++];
                }
            }
            if (inRange) {
                if ((gData.regexp.flags & 2) != 0) {
                    assert (rangeStart <= thisCh);
                    c2 = rangeStart;
                    while (c2 <= thisCh) {
                        NativeRegExp.addCharacterToCharSet(charSet, c2);
                        char uch = NativeRegExp.upcase(c2);
                        char dch = NativeRegExp.downcase(c2);
                        if (c2 != uch) {
                            NativeRegExp.addCharacterToCharSet(charSet, uch);
                        }
                        if (c2 != dch) {
                            NativeRegExp.addCharacterToCharSet(charSet, dch);
                        }
                        if ((c2 = (char)(c2 + '\u0001')) != '\u0000') continue;
                        break;
                    }
                } else {
                    NativeRegExp.addCharacterRangeToCharSet(charSet, rangeStart, thisCh);
                }
                inRange = false;
                continue;
            }
            if ((gData.regexp.flags & 2) != 0) {
                NativeRegExp.addCharacterToCharSet(charSet, NativeRegExp.upcase(thisCh));
                NativeRegExp.addCharacterToCharSet(charSet, NativeRegExp.downcase(thisCh));
            } else {
                NativeRegExp.addCharacterToCharSet(charSet, thisCh);
            }
            if (src >= end2 - 1 || gData.regexp.source[src] != '-') continue;
            ++src;
            inRange = true;
            rangeStart = thisCh;
        }
    }

    private static boolean classMatcher(REGlobalData gData, RECharSet charSet, char ch) {
        if (!charSet.converted) {
            NativeRegExp.processCharSet(gData, charSet);
        }
        int byteIndex = ch >> 3;
        return (charSet.length == 0 || ch >= charSet.length || (charSet.bits[byteIndex] & 1 << (ch & 7)) == 0) ^ charSet.sense;
    }

    private static boolean reopIsSimple(int op) {
        return op >= 1 && op <= 23;
    }

    private static int simpleMatch(REGlobalData gData, String input, int op, byte[] program, int pc, int end2, boolean updatecp) {
        boolean result2 = false;
        int startcp = gData.cp;
        switch (op) {
            case 1: {
                result2 = true;
                break;
            }
            case 2: {
                if (gData.cp != 0 && (!gData.multiline || !NativeRegExp.isLineTerm(input.charAt(gData.cp - 1)))) break;
                result2 = true;
                break;
            }
            case 3: {
                if (gData.cp != end2 && (!gData.multiline || !NativeRegExp.isLineTerm(input.charAt(gData.cp)))) break;
                result2 = true;
                break;
            }
            case 4: {
                result2 = (gData.cp == 0 || !NativeRegExp.isWord(input.charAt(gData.cp - 1))) ^ (gData.cp >= end2 || !NativeRegExp.isWord(input.charAt(gData.cp)));
                break;
            }
            case 5: {
                result2 = (gData.cp == 0 || !NativeRegExp.isWord(input.charAt(gData.cp - 1))) ^ (gData.cp < end2 && NativeRegExp.isWord(input.charAt(gData.cp)));
                break;
            }
            case 6: {
                if (gData.cp == end2 || NativeRegExp.isLineTerm(input.charAt(gData.cp))) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 7: {
                if (gData.cp == end2 || !NativeRegExp.isDigit(input.charAt(gData.cp))) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 8: {
                if (gData.cp == end2 || NativeRegExp.isDigit(input.charAt(gData.cp))) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 9: {
                if (gData.cp == end2 || !NativeRegExp.isWord(input.charAt(gData.cp))) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 10: {
                if (gData.cp == end2 || NativeRegExp.isWord(input.charAt(gData.cp))) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 11: {
                if (gData.cp == end2 || !NativeRegExp.isREWhiteSpace(input.charAt(gData.cp))) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 12: {
                if (gData.cp == end2 || NativeRegExp.isREWhiteSpace(input.charAt(gData.cp))) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 13: {
                int parenIndex = NativeRegExp.getIndex(program, pc);
                pc += 2;
                result2 = NativeRegExp.backrefMatcher(gData, parenIndex, input, end2);
                break;
            }
            case 14: {
                int offset = NativeRegExp.getIndex(program, pc);
                int length = NativeRegExp.getIndex(program, pc += 2);
                pc += 2;
                result2 = NativeRegExp.flatNMatcher(gData, offset, length, input, end2);
                break;
            }
            case 15: {
                char matchCh = (char)(program[pc++] & 0xFF);
                if (gData.cp == end2 || input.charAt(gData.cp) != matchCh) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 16: {
                int offset = NativeRegExp.getIndex(program, pc);
                int length = NativeRegExp.getIndex(program, pc += 2);
                pc += 2;
                result2 = NativeRegExp.flatNIMatcher(gData, offset, length, input, end2);
                break;
            }
            case 17: {
                char c2;
                char matchCh = (char)(program[pc++] & 0xFF);
                if (gData.cp == end2 || matchCh != (c2 = input.charAt(gData.cp)) && NativeRegExp.upcase(matchCh) != NativeRegExp.upcase(c2)) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 18: {
                char matchCh = (char)NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (gData.cp == end2 || input.charAt(gData.cp) != matchCh) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 19: {
                char c3;
                char matchCh = (char)NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (gData.cp == end2 || matchCh != (c3 = input.charAt(gData.cp)) && NativeRegExp.upcase(matchCh) != NativeRegExp.upcase(c3)) break;
                result2 = true;
                ++gData.cp;
                break;
            }
            case 22: 
            case 23: {
                int index = NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (gData.cp == end2 || !NativeRegExp.classMatcher(gData, gData.regexp.classList[index], input.charAt(gData.cp))) break;
                ++gData.cp;
                result2 = true;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        if (result2) {
            if (!updatecp) {
                gData.cp = startcp;
            }
            return pc;
        }
        gData.cp = startcp;
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean executeREBytecode(REGlobalData gData, String input, int end) {
        pc = 0;
        program = gData.regexp.program;
        continuationOp = 57;
        continuationPc = 0;
        result = false;
        op = program[pc++];
        if (gData.regexp.anchorCh < 0 && NativeRegExp.reopIsSimple(op)) {
            anchor = false;
            while (gData.cp <= end) {
                match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, true);
                if (match >= 0) {
                    anchor = true;
                    pc = match;
                    op = program[pc++];
                    break;
                }
                ++gData.skipped;
                ++gData.cp;
            }
            if (!anchor) {
                return false;
            }
        }
        block26: while (true) {
            block62: {
                block61: {
                    if (!NativeRegExp.reopIsSimple(op)) break block61;
                    match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, true);
                    v0 = result = match >= 0;
                    if (result) {
                        pc = match;
                    }
                    break block62;
                }
                block0 : switch (op) {
                    case 53: 
                    case 54: 
                    case 55: {
                        matchCh1 = (char)NativeRegExp.getIndex(program, pc);
                        matchCh2 = (char)NativeRegExp.getIndex(program, pc += 2);
                        pc += 2;
                        if (gData.cp == end) {
                            result = false;
                            break;
                        }
                        c = input.charAt(gData.cp);
                        if (op != 55) ** GOTO lbl43
                        if (c != matchCh1 && !NativeRegExp.classMatcher(gData, gData.regexp.classList[matchCh2], c)) {
                            result = false;
                            break;
                        }
                        ** GOTO lbl48
lbl43:
                        // 1 sources

                        if (op == 54) {
                            c = NativeRegExp.upcase(c);
                        }
                        if (c != matchCh1 && c != matchCh2) {
                            result = false;
                            break;
                        }
                    }
lbl48:
                    // 4 sources

                    case 31: {
                        nextpc = pc + NativeRegExp.getOffset(program, pc);
                        pc += 2;
                        op = program[pc++];
                        startcp = gData.cp;
                        if (NativeRegExp.reopIsSimple(op)) {
                            match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, true);
                            if (match < 0) {
                                op = program[nextpc++];
                                pc = nextpc;
                                continue block26;
                            }
                            result = true;
                            pc = match;
                            op = program[pc++];
                        }
                        nextop = program[nextpc++];
                        NativeRegExp.pushBackTrackState(gData, nextop, nextpc, startcp, continuationOp, continuationPc);
                        continue block26;
                    }
                    case 32: {
                        offset = NativeRegExp.getOffset(program, pc);
                        pc += offset;
                        op = program[pc++];
                        continue block26;
                    }
                    case 29: {
                        parenIndex = NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        gData.setParens(parenIndex, gData.cp, 0);
                        op = program[pc++];
                        continue block26;
                    }
                    case 30: {
                        parenIndex = NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        cap_index = gData.parensIndex(parenIndex);
                        gData.setParens(parenIndex, cap_index, gData.cp - cap_index);
                        op = program[pc++];
                        continue block26;
                    }
                    case 41: {
                        nextpc = pc + NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        op = program[pc++];
                        if (NativeRegExp.reopIsSimple(op) && NativeRegExp.simpleMatch(gData, input, op, program, pc, end, false) < 0) {
                            result = false;
                            break;
                        }
                        NativeRegExp.pushProgState(gData, 0, 0, gData.cp, gData.backTrackStackTop, continuationOp, continuationPc);
                        NativeRegExp.pushBackTrackState(gData, (byte)43, nextpc);
                        continue block26;
                    }
                    case 42: {
                        nextpc = pc + NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        op = program[pc++];
                        if (NativeRegExp.reopIsSimple(op) && (match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, false)) >= 0 && program[match] == 44) {
                            result = false;
                            break;
                        }
                        NativeRegExp.pushProgState(gData, 0, 0, gData.cp, gData.backTrackStackTop, continuationOp, continuationPc);
                        NativeRegExp.pushBackTrackState(gData, (byte)44, nextpc);
                        continue block26;
                    }
                    case 43: 
                    case 44: {
                        state = NativeRegExp.popProgState(gData);
                        gData.cp = state.index;
                        gData.backTrackStackTop = state.backTrack;
                        continuationPc = state.continuationPc;
                        continuationOp = state.continuationOp;
                        if (op != 44) break;
                        result = result == false;
                        break;
                    }
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        greedy = false;
                        switch (op) {
                            case 26: {
                                greedy = true;
                            }
                            case 45: {
                                min = 0;
                                max = -1;
                                break;
                            }
                            case 27: {
                                greedy = true;
                            }
                            case 46: {
                                min = 1;
                                max = -1;
                                break;
                            }
                            case 28: {
                                greedy = true;
                            }
                            case 47: {
                                min = 0;
                                max = 1;
                                break;
                            }
                            case 25: {
                                greedy = true;
                            }
                            case 48: {
                                min = NativeRegExp.getOffset(program, pc);
                                max = NativeRegExp.getOffset(program, pc += 2) - 1;
                                pc += 2;
                                break;
                            }
                            default: {
                                throw Kit.codeBug();
                            }
                        }
                        NativeRegExp.pushProgState(gData, min, max, gData.cp, null, continuationOp, continuationPc);
                        if (greedy) {
                            NativeRegExp.pushBackTrackState(gData, (byte)51, pc);
                            continuationOp = 51;
                            continuationPc = pc;
                            pc += 6;
                            op = program[pc++];
                            continue block26;
                        }
                        if (min != 0) {
                            continuationOp = 52;
                            continuationPc = pc;
                            pc += 6;
                            op = program[pc++];
                            continue block26;
                        }
                        NativeRegExp.pushBackTrackState(gData, (byte)52, pc);
                        NativeRegExp.popProgState(gData);
                        pc += 4;
                        pc += NativeRegExp.getOffset(program, pc);
                        op = program[pc++];
                        continue block26;
                    }
                    case 49: {
                        result = true;
                        pc = continuationPc;
                        op = continuationOp;
                        continue block26;
                    }
                    case 51: {
                        do {
                            state = NativeRegExp.popProgState(gData);
                            if (!result) {
                                if (state.min == 0) {
                                    result = true;
                                }
                                continuationPc = state.continuationPc;
                                continuationOp = state.continuationOp;
                                pc += 4;
                                pc += NativeRegExp.getOffset(program, pc);
                                break block0;
                            }
                            if (state.min == 0 && gData.cp == state.index) {
                                result = false;
                                continuationPc = state.continuationPc;
                                continuationOp = state.continuationOp;
                                pc += 4;
                                pc += NativeRegExp.getOffset(program, pc);
                                break block0;
                            }
                            new_min = state.min;
                            new_max = state.max;
                            if (new_min != 0) {
                                --new_min;
                            }
                            if (new_max != -1) {
                                --new_max;
                            }
                            if (new_max == 0) {
                                result = true;
                                continuationPc = state.continuationPc;
                                continuationOp = state.continuationOp;
                                pc += 4;
                                pc += NativeRegExp.getOffset(program, pc);
                                break block0;
                            }
                            nextpc = pc + 6;
                            nextop = program[nextpc];
                            startcp = gData.cp;
                            if (NativeRegExp.reopIsSimple(nextop)) {
                                if ((match = NativeRegExp.simpleMatch(gData, input, nextop, program, ++nextpc, end, true)) < 0) {
                                    result = new_min == 0;
                                    continuationPc = state.continuationPc;
                                    continuationOp = state.continuationOp;
                                    pc += 4;
                                    pc += NativeRegExp.getOffset(program, pc);
                                    break block0;
                                }
                                result = true;
                                nextpc = match;
                            }
                            continuationOp = 51;
                            continuationPc = pc;
                            NativeRegExp.pushProgState(gData, new_min, new_max, startcp, null, state.continuationOp, state.continuationPc);
                            if (new_min != 0) continue;
                            NativeRegExp.pushBackTrackState(gData, (byte)51, pc, startcp, state.continuationOp, state.continuationPc);
                            parenCount = NativeRegExp.getIndex(program, pc);
                            parenIndex = NativeRegExp.getIndex(program, pc + 2);
                            for (k = 0; k < parenCount; ++k) {
                                gData.setParens(parenIndex + k, -1, 0);
                            }
                        } while (program[nextpc] == 49);
                        pc = nextpc;
                        op = program[pc++];
                        continue block26;
                    }
                    case 52: {
                        state = NativeRegExp.popProgState(gData);
                        if (!result) {
                            if (state.max == -1 || state.max > 0) {
                                NativeRegExp.pushProgState(gData, state.min, state.max, gData.cp, null, state.continuationOp, state.continuationPc);
                                continuationOp = 52;
                                continuationPc = pc;
                                parenCount = NativeRegExp.getIndex(program, pc);
                                parenIndex = NativeRegExp.getIndex(program, pc += 2);
                                pc += 4;
                                for (k = 0; k < parenCount; ++k) {
                                    gData.setParens(parenIndex + k, -1, 0);
                                }
                                op = program[pc++];
                                continue block26;
                            }
                            continuationPc = state.continuationPc;
                            continuationOp = state.continuationOp;
                            break;
                        }
                        if (state.min == 0 && gData.cp == state.index) {
                            result = false;
                            continuationPc = state.continuationPc;
                            continuationOp = state.continuationOp;
                            break;
                        }
                        new_min = state.min;
                        new_max = state.max;
                        if (new_min != 0) {
                            --new_min;
                        }
                        if (new_max != -1) {
                            --new_max;
                        }
                        NativeRegExp.pushProgState(gData, new_min, new_max, gData.cp, null, state.continuationOp, state.continuationPc);
                        if (new_min != 0) {
                            continuationOp = 52;
                            continuationPc = pc;
                            parenCount = NativeRegExp.getIndex(program, pc);
                            parenIndex = NativeRegExp.getIndex(program, pc += 2);
                            pc += 4;
                            for (k = 0; k < parenCount; ++k) {
                                gData.setParens(parenIndex + k, -1, 0);
                            }
                            op = program[pc++];
                            continue block26;
                        }
                        continuationPc = state.continuationPc;
                        continuationOp = state.continuationOp;
                        NativeRegExp.pushBackTrackState(gData, (byte)52, pc);
                        NativeRegExp.popProgState(gData);
                        pc += 4;
                        pc += NativeRegExp.getOffset(program, pc);
                        op = program[pc++];
                        continue block26;
                    }
                    case 57: {
                        return true;
                    }
                    default: {
                        throw Kit.codeBug("invalid bytecode");
                    }
                }
            }
            if (!result) {
                backTrackData = gData.backTrackStackTop;
                if (backTrackData != null) {
                    gData.backTrackStackTop = backTrackData.previous;
                    gData.parens = backTrackData.parens;
                    gData.cp = backTrackData.cp;
                    gData.stateStackTop = backTrackData.stateStackTop;
                    continuationOp = backTrackData.continuationOp;
                    continuationPc = backTrackData.continuationPc;
                    pc = backTrackData.pc;
                    op = backTrackData.op;
                    continue;
                }
                return false;
            }
            op = program[pc++];
        }
    }

    private static boolean matchRegExp(REGlobalData gData, RECompiled re, String input, int start2, int end2, boolean multiline) {
        gData.parens = (long[])(re.parenCount != 0 ? new long[re.parenCount] : null);
        gData.backTrackStackTop = null;
        gData.stateStackTop = null;
        gData.multiline = multiline || (re.flags & 4) != 0;
        gData.regexp = re;
        int anchorCh = gData.regexp.anchorCh;
        for (int i2 = start2; i2 <= end2; ++i2) {
            if (anchorCh >= 0) {
                while (true) {
                    if (i2 == end2) {
                        return false;
                    }
                    char matchCh = input.charAt(i2);
                    if (matchCh == anchorCh || (gData.regexp.flags & 2) != 0 && NativeRegExp.upcase(matchCh) == NativeRegExp.upcase((char)anchorCh)) break;
                    ++i2;
                }
            }
            gData.cp = i2;
            gData.skipped = i2 - start2;
            for (int j2 = 0; j2 < re.parenCount; ++j2) {
                gData.parens[j2] = -1L;
            }
            boolean result2 = NativeRegExp.executeREBytecode(gData, input, end2);
            gData.backTrackStackTop = null;
            gData.stateStackTop = null;
            if (result2) {
                return true;
            }
            if (anchorCh == -2 && !gData.multiline) {
                gData.skipped = end2;
                return false;
            }
            i2 = start2 + gData.skipped;
        }
        return false;
    }

    Object executeRegExp(Context cx, Scriptable scope, RegExpImpl res, String str, int[] indexp, int matchType) {
        Scriptable obj;
        Object result2;
        int index;
        boolean matches2;
        REGlobalData gData = new REGlobalData();
        int start2 = indexp[0];
        int end2 = str.length();
        if (start2 > end2) {
            start2 = end2;
        }
        if (!(matches2 = NativeRegExp.matchRegExp(gData, this.re, str, start2, end2, res.multiline))) {
            if (matchType != 2) {
                return null;
            }
            return Undefined.instance;
        }
        int ep = indexp[0] = (index = gData.cp);
        int matchlen = ep - (start2 + gData.skipped);
        index -= matchlen;
        if (matchType == 0) {
            result2 = Boolean.TRUE;
            obj = null;
        } else {
            result2 = cx.newArray(scope, 0);
            obj = (Scriptable)result2;
            String matchstr = str.substring(index, index + matchlen);
            obj.put(0, obj, (Object)matchstr);
        }
        if (this.re.parenCount == 0) {
            res.parens = null;
            res.lastParen = SubString.emptySubString;
        } else {
            SubString parsub = null;
            res.parens = new SubString[this.re.parenCount];
            for (int num = 0; num < this.re.parenCount; ++num) {
                int cap_index = gData.parensIndex(num);
                if (cap_index != -1) {
                    int cap_length = gData.parensLength(num);
                    res.parens[num] = parsub = new SubString(str, cap_index, cap_length);
                    if (matchType == 0) continue;
                    obj.put(num + 1, obj, (Object)parsub.toString());
                    continue;
                }
                if (matchType == 0) continue;
                obj.put(num + 1, obj, Undefined.instance);
            }
            res.lastParen = parsub;
        }
        if (matchType != 0) {
            obj.put("index", obj, (Object)(start2 + gData.skipped));
            obj.put("input", obj, (Object)str);
        }
        if (res.lastMatch == null) {
            res.lastMatch = new SubString();
            res.leftContext = new SubString();
            res.rightContext = new SubString();
        }
        res.lastMatch.str = str;
        res.lastMatch.index = index;
        res.lastMatch.length = matchlen;
        res.leftContext.str = str;
        if (cx.getLanguageVersion() == 120) {
            res.leftContext.index = start2;
            res.leftContext.length = gData.skipped;
        } else {
            res.leftContext.index = 0;
            res.leftContext.length = start2 + gData.skipped;
        }
        res.rightContext.str = str;
        res.rightContext.index = ep;
        res.rightContext.length = end2 - ep;
        return result2;
    }

    int getFlags() {
        return this.re.flags;
    }

    private static void reportWarning(Context cx, String messageId, String arg) {
        if (cx.hasFeature(11)) {
            String msg = ScriptRuntime.getMessage1(messageId, arg);
            Context.reportWarning(msg);
        }
    }

    private static void reportError(String messageId, String arg) {
        String msg = ScriptRuntime.getMessage1(messageId, arg);
        throw ScriptRuntime.constructError("SyntaxError", msg);
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected int findInstanceIdInfo(String s2) {
        int attr;
        int id = 0;
        String X = null;
        int s_length = s2.length();
        if (s_length == 6) {
            char c2 = s2.charAt(0);
            if (c2 == 'g') {
                X = "global";
                id = 3;
            } else if (c2 == 's') {
                X = "source";
                id = 2;
            }
        } else if (s_length == 9) {
            char c3 = s2.charAt(0);
            if (c3 == 'l') {
                X = "lastIndex";
                id = 1;
            } else if (c3 == 'm') {
                X = "multiline";
                id = 5;
            }
        } else if (s_length == 10) {
            X = "ignoreCase";
            id = 4;
        }
        if (X != null && X != s2 && !X.equals(s2)) {
            id = 0;
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s2);
        }
        switch (id) {
            case 1: {
                attr = this.lastIndexAttr;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                attr = 7;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return NativeRegExp.instanceIdInfo(attr, id);
    }

    @Override
    protected String getInstanceIdName(int id) {
        switch (id) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        switch (id) {
            case 1: {
                return this.lastIndex;
            }
            case 2: {
                return new String(this.re.source);
            }
            case 3: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 1) != 0);
            }
            case 4: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 2) != 0);
            }
            case 5: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 4) != 0);
            }
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected void setInstanceIdValue(int id, Object value2) {
        switch (id) {
            case 1: {
                this.lastIndex = value2;
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return;
            }
        }
        super.setInstanceIdValue(id, value2);
    }

    @Override
    protected void setInstanceIdAttributes(int id, int attr) {
        switch (id) {
            case 1: {
                this.lastIndexAttr = attr;
                return;
            }
        }
        super.setInstanceIdAttributes(id, attr);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 2;
                s2 = "compile";
                break;
            }
            case 2: {
                arity = 0;
                s2 = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s2 = "toSource";
                break;
            }
            case 4: {
                arity = 1;
                s2 = "exec";
                break;
            }
            case 5: {
                arity = 1;
                s2 = "test";
                break;
            }
            case 6: {
                arity = 1;
                s2 = "prefix";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(REGEXP_TAG, id, s2, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(REGEXP_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case 1: {
                return NativeRegExp.realThis(thisObj, f2).compile(cx, scope, args2);
            }
            case 2: 
            case 3: {
                return NativeRegExp.realThis(thisObj, f2).toString();
            }
            case 4: {
                return NativeRegExp.realThis(thisObj, f2).execSub(cx, scope, args2, 1);
            }
            case 5: {
                Object x = NativeRegExp.realThis(thisObj, f2).execSub(cx, scope, args2, 0);
                return Boolean.TRUE.equals(x) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return NativeRegExp.realThis(thisObj, f2).execSub(cx, scope, args2, 2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    private static NativeRegExp realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof NativeRegExp)) {
            throw NativeRegExp.incompatibleCallError(f2);
        }
        return (NativeRegExp)thisObj;
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block8: {
            id = 0;
            String X = null;
            switch (s2.length()) {
                case 4: {
                    char c2 = s2.charAt(0);
                    if (c2 == 'e') {
                        X = "exec";
                        id = 4;
                        break;
                    }
                    if (c2 != 't') break;
                    X = "test";
                    id = 5;
                    break;
                }
                case 6: {
                    X = "prefix";
                    id = 6;
                    break;
                }
                case 7: {
                    X = "compile";
                    id = 1;
                    break;
                }
                case 8: {
                    char c3 = s2.charAt(3);
                    if (c3 == 'o') {
                        X = "toSource";
                        id = 3;
                        break;
                    }
                    if (c3 != 't') break;
                    X = "toString";
                    id = 2;
                    break;
                }
            }
            if (X == null || X == s2 || X.equals(s2)) break block8;
            id = 0;
        }
        return id;
    }
}

