/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    protected String input;
    protected boolean multiline;
    protected SubString[] parens;
    protected SubString lastMatch;
    protected SubString lastParen;
    protected SubString leftContext;
    protected SubString rightContext;

    @Override
    public boolean isRegExp(Scriptable obj) {
        return obj instanceof NativeRegExp;
    }

    @Override
    public Object compileRegExp(Context cx, String source2, String flags) {
        return NativeRegExp.compileRE(cx, source2, flags, false);
    }

    @Override
    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return new NativeRegExp(scope, (RECompiled)compiled);
    }

    @Override
    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2, int actionType) {
        GlobData data2 = new GlobData();
        data2.mode = actionType;
        data2.str = ScriptRuntime.toString(thisObj);
        switch (actionType) {
            case 1: {
                NativeRegExp re = RegExpImpl.createRegExp(cx, scope, args2, 1, false);
                Object rval = RegExpImpl.matchOrReplace(cx, scope, thisObj, args2, this, data2, re);
                return data2.arrayobj == null ? rval : data2.arrayobj;
            }
            case 3: {
                NativeRegExp re = RegExpImpl.createRegExp(cx, scope, args2, 1, false);
                return RegExpImpl.matchOrReplace(cx, scope, thisObj, args2, this, data2, re);
            }
            case 2: {
                Object val;
                boolean useRE = args2.length > 0 && args2[0] instanceof NativeRegExp || args2.length > 2;
                NativeRegExp re = null;
                String search = null;
                if (useRE) {
                    re = RegExpImpl.createRegExp(cx, scope, args2, 2, true);
                } else {
                    Object arg0 = args2.length < 1 ? Undefined.instance : args2[0];
                    search = ScriptRuntime.toString(arg0);
                }
                Object arg1 = args2.length < 2 ? Undefined.instance : args2[1];
                String repstr = null;
                Function lambda = null;
                if (arg1 instanceof Function) {
                    lambda = (Function)arg1;
                } else {
                    repstr = ScriptRuntime.toString(arg1);
                }
                data2.lambda = lambda;
                data2.repstr = repstr;
                data2.dollar = repstr == null ? -1 : repstr.indexOf(36);
                data2.charBuf = null;
                data2.leftIndex = 0;
                if (useRE) {
                    val = RegExpImpl.matchOrReplace(cx, scope, thisObj, args2, this, data2, re);
                } else {
                    String str = data2.str;
                    int index = str.indexOf(search);
                    if (index >= 0) {
                        int slen = search.length();
                        this.lastParen = null;
                        this.leftContext = new SubString(str, 0, index);
                        this.lastMatch = new SubString(str, index, slen);
                        this.rightContext = new SubString(str, index + slen, str.length() - index - slen);
                        val = Boolean.TRUE;
                    } else {
                        val = Boolean.FALSE;
                    }
                }
                if (data2.charBuf == null) {
                    if (data2.global || val == null || !val.equals(Boolean.TRUE)) {
                        return data2.str;
                    }
                    SubString lc = this.leftContext;
                    RegExpImpl.replace_glob(data2, cx, scope, this, lc.index, lc.length);
                }
                SubString rc2 = this.rightContext;
                data2.charBuf.append(rc2.str, rc2.index, rc2.index + rc2.length);
                return data2.charBuf.toString();
            }
        }
        throw Kit.codeBug();
    }

    private static NativeRegExp createRegExp(Context cx, Scriptable scope, Object[] args2, int optarg, boolean forceFlat) {
        NativeRegExp re;
        Scriptable topScope = ScriptableObject.getTopLevelScope(scope);
        if (args2.length == 0 || args2[0] == Undefined.instance) {
            RECompiled compiled = NativeRegExp.compileRE(cx, "", "", false);
            re = new NativeRegExp(topScope, compiled);
        } else if (args2[0] instanceof NativeRegExp) {
            re = (NativeRegExp)args2[0];
        } else {
            String opt;
            String src = ScriptRuntime.toString(args2[0]);
            if (optarg < args2.length) {
                args2[0] = src;
                opt = ScriptRuntime.toString(args2[optarg]);
            } else {
                opt = null;
            }
            RECompiled compiled = NativeRegExp.compileRE(cx, src, opt, forceFlat);
            re = new NativeRegExp(topScope, compiled);
        }
        return re;
    }

    private static Object matchOrReplace(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2, RegExpImpl reImpl, GlobData data2, NativeRegExp re) {
        String str = data2.str;
        data2.global = (re.getFlags() & 1) != 0;
        int[] indexp = new int[]{0};
        Object result2 = null;
        if (data2.mode == 3) {
            result2 = re.executeRegExp(cx, scope, reImpl, str, indexp, 0);
            result2 = result2 != null && result2.equals(Boolean.TRUE) ? Integer.valueOf(reImpl.leftContext.length) : Integer.valueOf(-1);
        } else if (data2.global) {
            re.lastIndex = 0.0;
            int count2 = 0;
            while (indexp[0] <= str.length() && (result2 = re.executeRegExp(cx, scope, reImpl, str, indexp, 0)) != null && result2.equals(Boolean.TRUE)) {
                if (data2.mode == 1) {
                    RegExpImpl.match_glob(data2, cx, scope, count2, reImpl);
                } else {
                    if (data2.mode != 2) {
                        Kit.codeBug();
                    }
                    SubString lastMatch = reImpl.lastMatch;
                    int leftIndex = data2.leftIndex;
                    int leftlen = lastMatch.index - leftIndex;
                    data2.leftIndex = lastMatch.index + lastMatch.length;
                    RegExpImpl.replace_glob(data2, cx, scope, reImpl, leftIndex, leftlen);
                }
                if (reImpl.lastMatch.length == 0) {
                    if (indexp[0] == str.length()) break;
                    indexp[0] = indexp[0] + 1;
                }
                ++count2;
            }
        } else {
            result2 = re.executeRegExp(cx, scope, reImpl, str, indexp, data2.mode == 2 ? 0 : 1);
        }
        return result2;
    }

    @Override
    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable reObj, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int result2;
        block5: {
            int i2 = ip[0];
            int length = target.length();
            int version2 = cx.getLanguageVersion();
            NativeRegExp re = (NativeRegExp)reObj;
            while (true) {
                int ipsave = ip[0];
                ip[0] = ++i2;
                Object ret = re.executeRegExp(cx, scope, this, target, ip, 0);
                if (ret != Boolean.TRUE) {
                    ip[0] = ipsave;
                    matchlen[0] = 1;
                    matched[0] = false;
                    return length;
                }
                i2 = ip[0];
                ip[0] = ipsave;
                matched[0] = true;
                SubString sep = this.lastMatch;
                matchlen[0] = sep.length;
                if (matchlen[0] != 0 || i2 != ip[0]) break;
                if (i2 != length) continue;
                if (version2 == 120) {
                    matchlen[0] = 1;
                    result2 = i2;
                } else {
                    result2 = -1;
                }
                break block5;
            }
            result2 = i2 - matchlen[0];
        }
        int size2 = this.parens == null ? 0 : this.parens.length;
        parensp[0] = new String[size2];
        for (int num = 0; num < size2; ++num) {
            SubString parsub = this.getParenSubString(num);
            parensp[0][num] = parsub.toString();
        }
        return result2;
    }

    SubString getParenSubString(int i2) {
        SubString parsub;
        if (this.parens != null && i2 < this.parens.length && (parsub = this.parens[i2]) != null) {
            return parsub;
        }
        return SubString.emptySubString;
    }

    private static void match_glob(GlobData mdata, Context cx, Scriptable scope, int count2, RegExpImpl reImpl) {
        if (mdata.arrayobj == null) {
            mdata.arrayobj = cx.newArray(scope, 0);
        }
        SubString matchsub = reImpl.lastMatch;
        String matchstr = matchsub.toString();
        mdata.arrayobj.put(count2, mdata.arrayobj, (Object)matchstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replace_glob(GlobData rdata, Context cx, Scriptable scope, RegExpImpl reImpl, int leftIndex, int leftlen) {
        int replen;
        String lambdaStr;
        if (rdata.lambda != null) {
            SubString[] parens = reImpl.parens;
            int parenCount = parens == null ? 0 : parens.length;
            Object[] args2 = new Object[parenCount + 3];
            args2[0] = reImpl.lastMatch.toString();
            for (int i2 = 0; i2 < parenCount; ++i2) {
                SubString sub2 = parens[i2];
                args2[i2 + 1] = sub2 != null ? sub2.toString() : Undefined.instance;
            }
            args2[parenCount + 1] = reImpl.leftContext.length;
            args2[parenCount + 2] = rdata.str;
            if (reImpl != ScriptRuntime.getRegExpProxy(cx)) {
                Kit.codeBug();
            }
            RegExpImpl re2 = new RegExpImpl();
            re2.multiline = reImpl.multiline;
            re2.input = reImpl.input;
            ScriptRuntime.setRegExpProxy(cx, re2);
            try {
                Scriptable parent = ScriptableObject.getTopLevelScope(scope);
                Object result2 = rdata.lambda.call(cx, parent, parent, args2);
                lambdaStr = ScriptRuntime.toString(result2);
            }
            finally {
                ScriptRuntime.setRegExpProxy(cx, reImpl);
            }
            replen = lambdaStr.length();
        } else {
            lambdaStr = null;
            replen = rdata.repstr.length();
            if (rdata.dollar >= 0) {
                int[] skip = new int[1];
                int dp = rdata.dollar;
                do {
                    SubString sub3;
                    if ((sub3 = RegExpImpl.interpretDollar(cx, reImpl, rdata.repstr, dp, skip)) != null) {
                        replen += sub3.length - skip[0];
                        dp += skip[0];
                        continue;
                    }
                    ++dp;
                } while ((dp = rdata.repstr.indexOf(36, dp)) >= 0);
            }
        }
        int growth = leftlen + replen + reImpl.rightContext.length;
        StringBuilder charBuf = rdata.charBuf;
        if (charBuf == null) {
            rdata.charBuf = charBuf = new StringBuilder(growth);
        } else {
            charBuf.ensureCapacity(rdata.charBuf.length() + growth);
        }
        charBuf.append(reImpl.leftContext.str, leftIndex, leftIndex + leftlen);
        if (rdata.lambda != null) {
            charBuf.append(lambdaStr);
        } else {
            RegExpImpl.do_replace(rdata, cx, reImpl);
        }
    }

    private static SubString interpretDollar(Context cx, RegExpImpl res, String da, int dp, int[] skip) {
        int version2;
        if (da.charAt(dp) != '$') {
            Kit.codeBug();
        }
        if ((version2 = cx.getLanguageVersion()) != 0 && version2 <= 140 && dp > 0 && da.charAt(dp - 1) == '\\') {
            return null;
        }
        int daL = da.length();
        if (dp + 1 >= daL) {
            return null;
        }
        char dc = da.charAt(dp + 1);
        if (NativeRegExp.isDigit(dc)) {
            int tmp;
            int cp;
            int num;
            if (version2 != 0 && version2 <= 140) {
                if (dc == '0') {
                    return null;
                }
                num = 0;
                cp = dp;
                while (++cp < daL && NativeRegExp.isDigit(dc = da.charAt(cp)) && (tmp = 10 * num + (dc - 48)) >= num) {
                    num = tmp;
                }
            } else {
                num = dc - 48;
                int parenCount = res.parens == null ? 0 : res.parens.length;
                if (num > parenCount) {
                    return null;
                }
                cp = dp + 2;
                if (dp + 2 < daL && NativeRegExp.isDigit(dc = da.charAt(dp + 2)) && (tmp = 10 * num + (dc - 48)) <= parenCount) {
                    ++cp;
                    num = tmp;
                }
                if (num == 0) {
                    return null;
                }
            }
            skip[0] = cp - dp;
            return res.getParenSubString(--num);
        }
        skip[0] = 2;
        switch (dc) {
            case '$': {
                return new SubString("$");
            }
            case '&': {
                return res.lastMatch;
            }
            case '+': {
                return res.lastParen;
            }
            case '`': {
                if (version2 == 120) {
                    res.leftContext.index = 0;
                    res.leftContext.length = res.lastMatch.index;
                }
                return res.leftContext;
            }
            case '\'': {
                return res.rightContext;
            }
        }
        return null;
    }

    private static void do_replace(GlobData rdata, Context cx, RegExpImpl regExpImpl) {
        int daL;
        StringBuilder charBuf = rdata.charBuf;
        int cp = 0;
        String da = rdata.repstr;
        int dp = rdata.dollar;
        if (dp != -1) {
            int[] skip = new int[1];
            do {
                int len2 = dp - cp;
                charBuf.append(da.substring(cp, dp));
                cp = dp;
                SubString sub2 = RegExpImpl.interpretDollar(cx, regExpImpl, da, dp, skip);
                if (sub2 != null) {
                    len2 = sub2.length;
                    if (len2 > 0) {
                        charBuf.append(sub2.str, sub2.index, sub2.index + len2);
                    }
                    cp += skip[0];
                    dp += skip[0];
                    continue;
                }
                ++dp;
            } while ((dp = da.indexOf(36, dp)) >= 0);
        }
        if ((daL = da.length()) > cp) {
            charBuf.append(da.substring(cp, daL));
        }
    }

    @Override
    public Object js_split(Context cx, Scriptable scope, String target, Object[] args2) {
        int match2;
        Scriptable test;
        Scriptable result2 = cx.newArray(scope, 0);
        boolean limited = args2.length > 1 && args2[1] != Undefined.instance;
        long limit = 0L;
        if (limited && (limit = ScriptRuntime.toUint32(args2[1])) > (long)target.length()) {
            limit = 1 + target.length();
        }
        if (args2.length < 1 || args2[0] == Undefined.instance) {
            result2.put(0, result2, (Object)target);
            return result2;
        }
        String separator = null;
        int[] matchlen = new int[1];
        Scriptable re = null;
        RegExpProxy reProxy = null;
        if (args2[0] instanceof Scriptable && (reProxy = ScriptRuntime.getRegExpProxy(cx)) != null && reProxy.isRegExp(test = (Scriptable)args2[0])) {
            re = test;
        }
        if (re == null) {
            separator = ScriptRuntime.toString(args2[0]);
            matchlen[0] = separator.length();
        }
        int[] ip = new int[]{0};
        int len2 = 0;
        boolean[] matched = new boolean[]{false};
        String[][] parens = new String[][]{null};
        int version2 = cx.getLanguageVersion();
        while (!((match2 = RegExpImpl.find_split(cx, scope, target, separator, version2, reProxy, re, ip, matchlen, matched, parens)) < 0 || limited && (long)len2 >= limit || match2 > target.length())) {
            String substr = target.length() == 0 ? target : target.substring(ip[0], match2);
            result2.put(len2, result2, (Object)substr);
            ++len2;
            if (re != null && matched[0]) {
                int size2 = parens[0].length;
                for (int num = 0; !(num >= size2 || limited && (long)len2 >= limit); ++num) {
                    result2.put(len2, result2, (Object)parens[0][num]);
                    ++len2;
                }
                matched[0] = false;
            }
            ip[0] = match2 + matchlen[0];
            if (version2 >= 130 || version2 == 0 || limited || ip[0] != target.length()) continue;
            break;
        }
        return result2;
    }

    private static int find_split(Context cx, Scriptable scope, String target, String separator, int version2, RegExpProxy reProxy, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int i2;
        int length = target.length();
        if (version2 == 120 && re == null && separator.length() == 1 && separator.charAt(0) == ' ') {
            int j2;
            if (i2 == 0) {
                for (i2 = ip[0]; i2 < length && Character.isWhitespace(target.charAt(i2)); ++i2) {
                }
                ip[0] = i2;
            }
            if (i2 == length) {
                return -1;
            }
            while (i2 < length && !Character.isWhitespace(target.charAt(i2))) {
                ++i2;
            }
            for (j2 = i2; j2 < length && Character.isWhitespace(target.charAt(j2)); ++j2) {
            }
            matchlen[0] = j2 - i2;
            return i2;
        }
        if (i2 > length) {
            return -1;
        }
        if (re != null) {
            return reProxy.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
        }
        if (version2 != 0 && version2 < 130 && length == 0) {
            return -1;
        }
        if (separator.length() == 0) {
            if (version2 == 120) {
                if (i2 == length) {
                    matchlen[0] = 1;
                    return i2;
                }
                return i2 + 1;
            }
            return i2 == length ? -1 : i2 + 1;
        }
        if (ip[0] >= length) {
            return length;
        }
        i2 = target.indexOf(separator, ip[0]);
        return i2 != -1 ? i2 : length;
    }
}

