/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.commonjs.module.provider.ParsedContentType;

public class SourceReader {
    public static URL toUrl(String path2) {
        if (path2.indexOf(58) >= 2) {
            try {
                return new URL(path2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readFileOrUrl(String path2, boolean convertToString, String defaultEncoding) throws IOException {
        Object result2;
        byte[] data2;
        String contentType2;
        String encoding;
        URL url2 = SourceReader.toUrl(path2);
        InputStream is = null;
        int capacityHint = 0;
        try {
            if (url2 == null) {
                File file2 = new File(path2);
                encoding = null;
                contentType2 = null;
                capacityHint = (int)file2.length();
                is = new FileInputStream(file2);
            } else {
                URLConnection uc = url2.openConnection();
                is = uc.getInputStream();
                if (convertToString) {
                    ParsedContentType pct = new ParsedContentType(uc.getContentType());
                    contentType2 = pct.getContentType();
                    encoding = pct.getEncoding();
                } else {
                    encoding = null;
                    contentType2 = null;
                }
                capacityHint = uc.getContentLength();
                if (capacityHint > 0x100000) {
                    capacityHint = -1;
                }
            }
            if (capacityHint <= 0) {
                capacityHint = 4096;
            }
            data2 = Kit.readStream(is, capacityHint);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (!convertToString) {
            result2 = data2;
        } else {
            String strResult;
            if (encoding == null) {
                if (data2.length > 3 && data2[0] == -1 && data2[1] == -2 && data2[2] == 0 && data2[3] == 0) {
                    encoding = "UTF-32LE";
                } else if (data2.length > 3 && data2[0] == 0 && data2[1] == 0 && data2[2] == -2 && data2[3] == -1) {
                    encoding = "UTF-32BE";
                } else if (data2.length > 2 && data2[0] == -17 && data2[1] == -69 && data2[2] == -65) {
                    encoding = "UTF-8";
                } else if (data2.length > 1 && data2[0] == -1 && data2[1] == -2) {
                    encoding = "UTF-16LE";
                } else if (data2.length > 1 && data2[0] == -2 && data2[1] == -1) {
                    encoding = "UTF-16BE";
                } else {
                    encoding = defaultEncoding;
                    if (encoding == null) {
                        encoding = url2 == null ? System.getProperty("file.encoding") : (contentType2 != null && contentType2.startsWith("application/") ? "UTF-8" : "US-ASCII");
                    }
                }
            }
            if ((strResult = new String(data2, encoding)).length() > 0 && strResult.charAt(0) == '\ufeff') {
                strResult = strResult.substring(1);
            }
            result2 = strResult;
        }
        return result2;
    }
}

