/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.mozilla.javascript.tools.debugger.SwingGui;

class EvalTextArea
extends JTextArea
implements KeyListener,
DocumentListener {
    private static final long serialVersionUID = -3918033649601064194L;
    private SwingGui debugGui;
    private List<String> history;
    private int historyIndex = -1;
    private int outputMark;

    public EvalTextArea(SwingGui debugGui) {
        this.debugGui = debugGui;
        this.history = Collections.synchronizedList(new ArrayList());
        Document doc = this.getDocument();
        doc.addDocumentListener(this);
        this.addKeyListener(this);
        this.setLineWrap(true);
        this.setFont(new Font("Monospaced", 0, 12));
        this.append("% ");
        this.outputMark = doc.getLength();
    }

    @Override
    public void select(int start2, int end2) {
        super.select(start2, end2);
    }

    private synchronized void returnPressed() {
        Document doc = this.getDocument();
        int len2 = doc.getLength();
        Segment segment = new Segment();
        try {
            doc.getText(this.outputMark, len2 - this.outputMark, segment);
        }
        catch (BadLocationException ignored) {
            ignored.printStackTrace();
        }
        String text = segment.toString();
        if (this.debugGui.dim.stringIsCompilableUnit(text)) {
            if (text.trim().length() > 0) {
                this.history.add(text);
                this.historyIndex = this.history.size();
            }
            this.append("\n");
            String result2 = this.debugGui.dim.eval(text);
            if (result2.length() > 0) {
                this.append(result2);
                this.append("\n");
            }
            this.append("% ");
            this.outputMark = doc.getLength();
        } else {
            this.append("\n");
        }
    }

    public synchronized void write(String str) {
        this.insert(str, this.outputMark);
        int len2 = str.length();
        this.outputMark += len2;
        this.select(this.outputMark, this.outputMark);
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        int code = e2.getKeyCode();
        if (code == 8 || code == 37) {
            if (this.outputMark == this.getCaretPosition()) {
                e2.consume();
            }
        } else if (code == 36) {
            int caretPos = this.getCaretPosition();
            if (caretPos == this.outputMark) {
                e2.consume();
            } else if (caretPos > this.outputMark && !e2.isControlDown()) {
                if (e2.isShiftDown()) {
                    this.moveCaretPosition(this.outputMark);
                } else {
                    this.setCaretPosition(this.outputMark);
                }
                e2.consume();
            }
        } else if (code == 10) {
            this.returnPressed();
            e2.consume();
        } else if (code == 38) {
            --this.historyIndex;
            if (this.historyIndex >= 0) {
                if (this.historyIndex >= this.history.size()) {
                    this.historyIndex = this.history.size() - 1;
                }
                if (this.historyIndex >= 0) {
                    String str = this.history.get(this.historyIndex);
                    int len2 = this.getDocument().getLength();
                    this.replaceRange(str, this.outputMark, len2);
                    int caretPos = this.outputMark + str.length();
                    this.select(caretPos, caretPos);
                } else {
                    ++this.historyIndex;
                }
            } else {
                ++this.historyIndex;
            }
            e2.consume();
        } else if (code == 40) {
            int caretPos = this.outputMark;
            if (this.history.size() > 0) {
                ++this.historyIndex;
                if (this.historyIndex < 0) {
                    this.historyIndex = 0;
                }
                int len3 = this.getDocument().getLength();
                if (this.historyIndex < this.history.size()) {
                    String str = this.history.get(this.historyIndex);
                    this.replaceRange(str, this.outputMark, len3);
                    caretPos = this.outputMark + str.length();
                } else {
                    this.historyIndex = this.history.size();
                    this.replaceRange("", this.outputMark, len3);
                }
            }
            this.select(caretPos, caretPos);
            e2.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        char keyChar = e2.getKeyChar();
        if (keyChar == '\b') {
            if (this.outputMark == this.getCaretPosition()) {
                e2.consume();
            }
        } else if (this.getCaretPosition() < this.outputMark) {
            this.setCaretPosition(this.outputMark);
        }
    }

    @Override
    public synchronized void keyReleased(KeyEvent e2) {
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e2) {
        int len2 = e2.getLength();
        int off = e2.getOffset();
        if (this.outputMark > off) {
            this.outputMark += len2;
        }
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e2) {
        int len2 = e2.getLength();
        int off = e2.getOffset();
        if (this.outputMark > off) {
            this.outputMark = this.outputMark >= off + len2 ? (this.outputMark -= len2) : off;
        }
    }

    public synchronized void postUpdateUI() {
        this.setCaret(this.getCaret());
        this.select(this.outputMark, this.outputMark);
    }

    @Override
    public synchronized void changedUpdate(DocumentEvent e2) {
    }
}

