/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;

class FileHeader
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -2858905404778259127L;
    private int pressLine = -1;
    private FileWindow fileWindow;

    public FileHeader(FileWindow fileWindow) {
        this.fileWindow = fileWindow;
        this.addMouseListener(this);
        this.update();
    }

    public void update() {
        FileTextArea textArea = this.fileWindow.textArea;
        Font font = textArea.getFont();
        this.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        int h2 = metrics.getHeight();
        int lineCount = textArea.getLineCount() + 1;
        String dummy = Integer.toString(lineCount);
        if (dummy.length() < 2) {
            dummy = "99";
        }
        Dimension d2 = new Dimension();
        d2.width = metrics.stringWidth(dummy) + 16;
        d2.height = lineCount * h2 + 100;
        this.setPreferredSize(d2);
        this.setSize(d2);
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        FileTextArea textArea = this.fileWindow.textArea;
        Font font = textArea.getFont();
        g2.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        Rectangle clip = g2.getClipBounds();
        g2.setColor(this.getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        int ascent = metrics.getMaxAscent();
        int h2 = metrics.getHeight();
        int lineCount = textArea.getLineCount() + 1;
        String dummy = Integer.toString(lineCount);
        if (dummy.length() < 2) {
            dummy = "99";
        }
        int startLine = clip.y / h2;
        int endLine = (clip.y + clip.height) / h2 + 1;
        int width = this.getWidth();
        if (endLine > lineCount) {
            endLine = lineCount;
        }
        for (int i2 = startLine; i2 < endLine; ++i2) {
            int pos = -2;
            try {
                pos = textArea.getLineStartOffset(i2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            boolean isBreakPoint = this.fileWindow.isBreakPoint(i2 + 1);
            String text = Integer.toString(i2 + 1) + " ";
            int y = i2 * h2;
            g2.setColor(Color.blue);
            g2.drawString(text, 0, y + ascent);
            int x = width - ascent;
            if (isBreakPoint) {
                g2.setColor(new Color(128, 0, 0));
                int dy = y + ascent - 9;
                g2.fillOval(x, dy, 9, 9);
                g2.drawOval(x, dy, 8, 8);
                g2.drawOval(x, dy, 9, 9);
            }
            if (pos != this.fileWindow.currentPos) continue;
            Polygon arrow = new Polygon();
            int dx = x;
            int dy = y += ascent - 10;
            arrow.addPoint(dx, dy + 3);
            arrow.addPoint(dx + 5, dy + 3);
            x = dx + 5;
            while (x <= dx + 10) {
                arrow.addPoint(x, y);
                ++x;
                ++y;
            }
            x = dx + 9;
            while (x >= dx + 5) {
                arrow.addPoint(x, y);
                --x;
                ++y;
            }
            arrow.addPoint(dx + 5, dy + 7);
            arrow.addPoint(dx, dy + 7);
            g2.setColor(Color.yellow);
            g2.fillPolygon(arrow);
            g2.setColor(Color.black);
            g2.drawPolygon(arrow);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        Font font = this.fileWindow.textArea.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int h2 = metrics.getHeight();
        this.pressLine = e2.getY() / h2;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (e2.getComponent() == this && (e2.getModifiers() & 0x10) != 0) {
            Font font;
            FontMetrics metrics;
            int h2;
            int y = e2.getY();
            int line = y / (h2 = (metrics = this.getFontMetrics(font = this.fileWindow.textArea.getFont())).getHeight());
            if (line == this.pressLine) {
                this.fileWindow.toggleBreakPoint(line + 1);
            } else {
                this.pressLine = -1;
            }
        }
    }
}

