/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Dimension;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SourceProvider;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.shell.Global;

public class Main {
    private Dim dim = new Dim();
    private SwingGui debugGui;

    public Main(String title) {
        this.debugGui = new SwingGui(this.dim, title);
    }

    public JFrame getDebugFrame() {
        return this.debugGui;
    }

    public void doBreak() {
        this.dim.setBreak();
    }

    public void setBreakOnExceptions(boolean value2) {
        this.dim.setBreakOnExceptions(value2);
        this.debugGui.getMenubar().getBreakOnExceptions().setSelected(value2);
    }

    public void setBreakOnEnter(boolean value2) {
        this.dim.setBreakOnEnter(value2);
        this.debugGui.getMenubar().getBreakOnEnter().setSelected(value2);
    }

    public void setBreakOnReturn(boolean value2) {
        this.dim.setBreakOnReturn(value2);
        this.debugGui.getMenubar().getBreakOnReturn().setSelected(value2);
    }

    public void clearAllBreakpoints() {
        this.dim.clearAllBreakpoints();
    }

    public void go() {
        this.dim.go();
    }

    public void setScope(Scriptable scope) {
        this.setScopeProvider(IProxy.newScopeProvider(scope));
    }

    public void setScopeProvider(ScopeProvider p) {
        this.dim.setScopeProvider(p);
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        this.dim.setSourceProvider(sourceProvider);
    }

    public void setExitAction(Runnable r) {
        this.debugGui.setExitAction(r);
    }

    public InputStream getIn() {
        return this.debugGui.getConsole().getIn();
    }

    public PrintStream getOut() {
        return this.debugGui.getConsole().getOut();
    }

    public PrintStream getErr() {
        return this.debugGui.getConsole().getErr();
    }

    public void pack() {
        this.debugGui.pack();
    }

    public void setSize(int w, int h2) {
        this.debugGui.setSize(w, h2);
    }

    public void setVisible(boolean flag) {
        this.debugGui.setVisible(flag);
    }

    public boolean isVisible() {
        return this.debugGui.isVisible();
    }

    public void dispose() {
        this.clearAllBreakpoints();
        this.dim.go();
        this.debugGui.dispose();
        this.dim = null;
    }

    public void attachTo(ContextFactory factory2) {
        this.dim.attachTo(factory2);
    }

    public void detach() {
        this.dim.detach();
    }

    public static void main(String[] args2) {
        Main main2 = new Main("Rhino JavaScript Debugger");
        main2.doBreak();
        main2.setExitAction(new IProxy(1));
        System.setIn(main2.getIn());
        System.setOut(main2.getOut());
        System.setErr(main2.getErr());
        Global global = org.mozilla.javascript.tools.shell.Main.getGlobal();
        global.setIn(main2.getIn());
        global.setOut(main2.getOut());
        global.setErr(main2.getErr());
        main2.attachTo(org.mozilla.javascript.tools.shell.Main.shellContextFactory);
        main2.setScope(global);
        main2.pack();
        main2.setSize(600, 460);
        main2.setVisible(true);
        org.mozilla.javascript.tools.shell.Main.exec(args2);
    }

    public static Main mainEmbedded(String title) {
        ContextFactory factory2 = ContextFactory.getGlobal();
        Global global = new Global();
        global.init(factory2);
        return Main.mainEmbedded(factory2, global, title);
    }

    public static Main mainEmbedded(ContextFactory factory2, Scriptable scope, String title) {
        return Main.mainEmbeddedImpl(factory2, scope, title);
    }

    public static Main mainEmbedded(ContextFactory factory2, ScopeProvider scopeProvider, String title) {
        return Main.mainEmbeddedImpl(factory2, scopeProvider, title);
    }

    private static Main mainEmbeddedImpl(ContextFactory factory2, Object scopeProvider, String title) {
        if (title == null) {
            title = "Rhino JavaScript Debugger (embedded usage)";
        }
        Main main2 = new Main(title);
        main2.doBreak();
        main2.setExitAction(new IProxy(1));
        main2.attachTo(factory2);
        if (scopeProvider instanceof ScopeProvider) {
            main2.setScopeProvider((ScopeProvider)scopeProvider);
        } else {
            Scriptable scope = (Scriptable)scopeProvider;
            if (scope instanceof Global) {
                Global global = (Global)scope;
                global.setIn(main2.getIn());
                global.setOut(main2.getOut());
                global.setErr(main2.getErr());
            }
            main2.setScope(scope);
        }
        main2.pack();
        main2.setSize(600, 460);
        main2.setVisible(true);
        return main2;
    }

    @Deprecated
    public void setSize(Dimension dimension) {
        this.debugGui.setSize(dimension.width, dimension.height);
    }

    @Deprecated
    public void setOptimizationLevel(int level) {
    }

    @Deprecated
    public void contextEntered(Context cx) {
        throw new IllegalStateException();
    }

    @Deprecated
    public void contextExited(Context cx) {
        throw new IllegalStateException();
    }

    @Deprecated
    public void contextCreated(Context cx) {
        throw new IllegalStateException();
    }

    @Deprecated
    public void contextReleased(Context cx) {
        throw new IllegalStateException();
    }

    private static class IProxy
    implements Runnable,
    ScopeProvider {
        public static final int EXIT_ACTION = 1;
        public static final int SCOPE_PROVIDER = 2;
        private final int type;
        private Scriptable scope;

        public IProxy(int type2) {
            this.type = type2;
        }

        public static ScopeProvider newScopeProvider(Scriptable scope) {
            IProxy scopeProvider = new IProxy(2);
            scopeProvider.scope = scope;
            return scopeProvider;
        }

        @Override
        public void run() {
            if (this.type != 1) {
                Kit.codeBug();
            }
            System.exit(0);
        }

        @Override
        public Scriptable getScope() {
            if (this.type != 2) {
                Kit.codeBug();
            }
            if (this.scope == null) {
                Kit.codeBug();
            }
            return this.scope;
        }
    }
}

